/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.export;

import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.io.ByteStreams;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.deployit.plumbing.ConfigurationItemReaderWriter;
import com.xebialabs.deployit.plumbing.CurrentVersion;
import com.xebialabs.deployit.plumbing.ExtendedRepositoryService;
import com.xebialabs.xlrelease.domain.Attachment;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.repository.CiHelper;
import com.xebialabs.xltype.serialization.json.JsonWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import org.jboss.resteasy.core.Headers;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TemplateExporter {
    public static final String RELEASE_TEMPLATE_JSON_FILE = "release-template.json";
    public static final String MANIFEST_JSON_FILE = "manifest.json";
    public static final String VERSION_FIELD_NAME = "xlr-version";
    private ConfigurationItemReaderWriter configurationItemReaderWriter;
    private ExtendedRepositoryService extendedRepositoryService;

    @Autowired
    public TemplateExporter(ConfigurationItemReaderWriter configurationItemReaderWriter, ExtendedRepositoryService extendedRepositoryService) {
        this.configurationItemReaderWriter = configurationItemReaderWriter;
        this.extendedRepositoryService = extendedRepositoryService;
    }

    public void exportTemplate(Release template, OutputStream outputStream) {
        this.stripUnwantedItems(template);
        TemplateExporter.removeTokens(Lists.newArrayList((Object[])new Release[]{template}));
        try (ZipOutputStream zipOutputStream = new ZipOutputStream(outputStream);){
            this.addAttachments(template, zipOutputStream);
            this.addReleaseTemplate(template, zipOutputStream);
            this.addManifestFile(zipOutputStream);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private void addAttachments(Release template, ZipOutputStream zipOutputStream) throws IOException {
        for (Attachment attachment : template.getAttachments()) {
            String exportFilename = attachment.buildExportFileName();
            zipOutputStream.putNextEntry(new ZipEntry(exportFilename));
            attachment.setExportFilename(exportFilename);
            try (InputStream inputStream = attachment.getFile().getInputStream();){
                ByteStreams.copy((InputStream)inputStream, (OutputStream)zipOutputStream);
            }
            zipOutputStream.closeEntry();
        }
    }

    private void addReleaseTemplate(Release template, ZipOutputStream zipOutputStream) throws IOException {
        zipOutputStream.putNextEntry(new ZipEntry(RELEASE_TEMPLATE_JSON_FILE));
        this.extendedRepositoryService.setCiRefsFromLevel(null);
        this.configurationItemReaderWriter.writeTo((ConfigurationItem)template, (Class<?>)Release.class, (Type)((Object)Release.class), new Annotation[0], MediaType.APPLICATION_JSON_TYPE, (MultivaluedMap<String, Object>)new Headers(), (OutputStream)zipOutputStream);
        zipOutputStream.closeEntry();
    }

    private void addManifestFile(ZipOutputStream zipOutputStream) throws IOException {
        zipOutputStream.putNextEntry(new ZipEntry(MANIFEST_JSON_FILE));
        StringWriter stringWriter = new StringWriter();
        JsonWriter writer = new JsonWriter((Writer)stringWriter);
        writer.object();
        writer.key(VERSION_FIELD_NAME).value((Object)CurrentVersion.get());
        writer.endObject();
        String formattedJson = stringWriter.toString();
        zipOutputStream.write(formattedJson.getBytes());
        zipOutputStream.closeEntry();
    }

    private static <T extends Collection<? extends ConfigurationItem>> T removeTokens(T cis) {
        List<ConfigurationItem> nestedCis = CiHelper.getNestedCis(cis);
        for (ConfigurationItem ci : nestedCis) {
            TemplateExporter.removeToken(ci);
        }
        return cis;
    }

    private static void removeToken(ConfigurationItem ci) {
        if (ci instanceof BaseConfigurationItem) {
            ((BaseConfigurationItem)ci).set$token(null);
        }
    }

    private void stripUnwantedItems(Release release) {
        release.getActivityLogEntries().clear();
    }
}

