/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.export;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class TemplateJsonHelper {
    public static List<JSONObject> getTasksFromRelease(JSONObject releaseJson) throws JSONException {
        ArrayList allTasks = Lists.newArrayList();
        if (!releaseJson.has("phases")) {
            return allTasks;
        }
        JSONArray phases = releaseJson.getJSONArray("phases");
        for (int i = 0; i < phases.length(); ++i) {
            JSONObject phaseJSon = phases.getJSONObject(i);
            allTasks.addAll(TemplateJsonHelper.getAllTasks(phaseJSon));
        }
        return allTasks;
    }

    private static List<JSONObject> getAllTasks(JSONObject containerJSon) throws JSONException {
        ArrayList allTasks = Lists.newArrayList();
        if (!containerJSon.has("tasks")) {
            return allTasks;
        }
        JSONArray tasks = containerJSon.getJSONArray("tasks");
        for (int j = 0; j < tasks.length(); ++j) {
            JSONObject taskJson = tasks.getJSONObject(j);
            allTasks.add(taskJson);
            allTasks.addAll(TemplateJsonHelper.getAllTasks(taskJson));
        }
        return allTasks;
    }

    public static JSONObject getPhase(JSONObject taskJSon, JSONObject releaseJson) throws JSONException {
        if (!releaseJson.has("phases")) {
            return null;
        }
        JSONArray phases = releaseJson.getJSONArray("phases");
        for (int i = 0; i < phases.length(); ++i) {
            JSONObject phaseJSon = phases.getJSONObject(i);
            if (!TemplateJsonHelper.containsTask(phaseJSon, taskJSon)) continue;
            return phaseJSon;
        }
        return null;
    }

    private static boolean containsTask(JSONObject containerJSon, JSONObject taskToFind) throws JSONException {
        if (!containerJSon.has("tasks")) {
            return false;
        }
        JSONArray tasks = containerJSon.getJSONArray("tasks");
        for (int j = 0; j < tasks.length(); ++j) {
            JSONObject taskJson = tasks.getJSONObject(j);
            if (taskToFind == taskJson) {
                return true;
            }
            if (!TemplateJsonHelper.containsTask(taskJson, taskToFind)) continue;
            return true;
        }
        return false;
    }
}

