/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.filters;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.filters.DateFilter;
import java.util.Date;
import java.util.List;

public class ReleaseFilter {
    private String searchFilter;
    private boolean onlyFlagged;
    private DateFilter dateFilter;
    private Predicate<Release> matchesTitle = new Predicate<Release>(){

        public boolean apply(Release release) {
            return Strings.nullToEmpty((String)release.getTitle()).toLowerCase().contains(ReleaseFilter.this.searchFilter.toLowerCase());
        }
    };
    private Predicate<Release> matchesTags = new Predicate<Release>(){

        public boolean apply(Release release) {
            for (String tag : release.getTags()) {
                if (!tag.toLowerCase().equals(ReleaseFilter.this.searchFilter.toLowerCase())) continue;
                return true;
            }
            return false;
        }
    };
    private Predicate<Release> isFlagged = new Predicate<Release>(){

        public boolean apply(Release release) {
            return release.isFlagged();
        }
    };

    public ReleaseFilter(String searchFilter, boolean onlyFlagged) {
        this(searchFilter, onlyFlagged, null, null);
    }

    public ReleaseFilter(String searchFilter, boolean onlyFlagged, Date from, Date to) {
        this.searchFilter = searchFilter;
        this.onlyFlagged = onlyFlagged;
        this.dateFilter = new DateFilter(from, to);
    }

    @VisibleForTesting
    public ReleaseFilter(Date from, Date to) {
        this("", false, from, to);
    }

    public List<Release> filter(List<Release> releases) {
        if (Strings.isNullOrEmpty((String)this.searchFilter) && !this.onlyFlagged && !this.dateFilter.hasDates()) {
            return releases;
        }
        Predicate predicate = Predicates.alwaysTrue();
        if (!Strings.isNullOrEmpty((String)this.searchFilter)) {
            predicate = Predicates.or(this.matchesTitle, this.matchesTags);
        }
        if (this.onlyFlagged) {
            predicate = Predicates.and((Predicate)predicate, this.isFlagged);
        }
        if (this.dateFilter.hasDates()) {
            predicate = Predicates.and((Predicate)predicate, this.dateFilter.getPredicate());
        }
        return Lists.newArrayList((Iterable)Collections2.filter(releases, (Predicate)predicate));
    }
}

