/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.license;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.xebialabs.license.service.LicenseServiceImpl;
import com.xebialabs.license.v1.License;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="licenseService")
public class XLReleaseLicenseService {
    private static final Logger log = LoggerFactory.getLogger(XLReleaseLicenseService.class);
    private String licenseFile = "conf/xl-release-license.lic";
    private String storedRepositoryId;
    private LicenseServiceImpl licenseService;

    public void checkLicenseAtSetup() {
        this.checkLicenseValid();
    }

    public void checkLicenseAtStartup(String storedRepositoryId) {
        this.storedRepositoryId = storedRepositoryId;
        this.checkLicenseValid();
        if (!this.hasValidRepositoryId()) {
            throw new RuntimeException("Your repository does not match your license.");
        }
    }

    public boolean isLicenseValid() {
        return !this.licenseService.isLicenseExpired() && this.hasValidRepositoryId();
    }

    private void checkLicenseValid() {
        try {
            this.licenseService = new LicenseServiceImpl(this.licenseFile, "XL Release");
            if (this.licenseService.getLicense() == null || this.licenseService.isLicenseExpired()) {
                throw new RuntimeException("You must provide a valid license.");
            }
        }
        catch (IOException e) {
            throw new RuntimeException("You must provide a valid license.", e);
        }
    }

    private boolean hasValidRepositoryId() {
        boolean hasValidRepositoryId = true;
        License license = this.getLicense();
        if (license.getRepositoryId() != null) {
            if (this.storedRepositoryId == null) {
                hasValidRepositoryId = false;
                log.warn("Your repository has no ID.");
            } else if (!license.getRepositoryId().equals(this.storedRepositoryId)) {
                hasValidRepositoryId = false;
                log.warn("Your repository ID is : {}.", (Object)this.storedRepositoryId);
            }
        }
        return hasValidRepositoryId;
    }

    public String getRepositoryId() {
        Preconditions.checkNotNull((Object)this.licenseService, (Object)"You must check license before getting the repository ID");
        return this.licenseService.getLicense().getRepositoryId();
    }

    public License getLicense() {
        Preconditions.checkNotNull((Object)this.licenseService, (Object)"You must check license before getting it");
        return this.licenseService.getLicense();
    }

    @VisibleForTesting
    void setLicenseFile(String licenseFile) {
        this.licenseFile = licenseFile;
    }
}

