/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.mbeans;

import com.xebialabs.xlrelease.repository.UserProfiles;
import com.xebialabs.xlrelease.service.ReportServiceCache;
import com.xebialabs.xlrelease.userdata.LdapUserDataProviderCache;
import com.xebialabs.xlrelease.userdata.UserDataProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jmx.export.annotation.ManagedOperation;
import org.springframework.jmx.export.annotation.ManagedResource;
import org.springframework.stereotype.Component;

@Component
@ManagedResource(objectName="com.xebialabs.xlrelease:name=CacheControl", description="Cache control")
public class CacheControl {
    private UserProfiles userProfiles;
    private UserDataProvider userDataProvider;
    private ReportServiceCache reportServiceCache;

    @Autowired
    public CacheControl(UserProfiles userProfiles, UserDataProvider userDataProvider, ReportServiceCache reportServiceCache) {
        this.userProfiles = userProfiles;
        this.userDataProvider = userDataProvider;
        this.reportServiceCache = reportServiceCache;
    }

    @ManagedOperation(description="Clear user profiles cache")
    public void clearUserProfilesCache() {
        this.userProfiles.clearCache();
    }

    @ManagedOperation(description="Clear user data cache")
    public void clearUserDataCache() {
        if (this.userDataProvider instanceof LdapUserDataProviderCache) {
            ((LdapUserDataProviderCache)this.userDataProvider).clearCache();
        }
    }

    @ManagedOperation(description="Clear reports cache")
    public void clearReportsCache() {
        this.reportServiceCache.clearCache();
    }
}

