/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.notification;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.ServerConfiguration;
import com.xebialabs.deployit.security.Role;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.xlrelease.domain.Comment;
import com.xebialabs.xlrelease.domain.FlagStatus;
import com.xebialabs.xlrelease.domain.NotificationTask;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.Team;
import com.xebialabs.xlrelease.notification.EmailSender;
import com.xebialabs.xlrelease.notification.Templater;
import com.xebialabs.xlrelease.repository.UserProfiles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class Notifications {
    static final String SUBJECT_PREFIX = "[XL Release]";
    static final String TASK_ASSIGNED_TO_OWNER_TEMPLATE = "task-assigned-to-owner.mustache";
    static final String TASK_PICKED_TEMPLATE = "task-picked.mustache";
    static final String TASK_UNASSIGNED_TEMPLATE = "task-unassigned.mustache";
    static final String TASK_FAILED_TEMPLATE = "task-failed.mustache";
    static final String TASK_STARTED_TEMPLATE = "task-started.mustache";
    static final String TASK_OVERDUE_TEMPLATE = "task-overdue.mustache";
    static final String UNASSIGNED_TASK_STARTED_TEMPLATE = "task-started-unassigned.mustache";
    static final String TASK_COMMENT_ADDED_TEMPLATE = "task-comment-added.mustache";
    static final String RELEASE_FLAGGED_TEMPLATE = "release-flagged.mustache";
    static final String RELEASE_STARTED_TEMPLATE = "release-started.mustache";
    static final String RELEASE_ABORTED_TEMPLATE = "release-aborted.mustache";
    static final String RELEASE_COMPLETED_TEMPLATE = "release-completed.mustache";
    static final String NOTIFICATION_TASK_BODY_TEMPLATE = "notification-task-body.mustache";
    private final UserProfiles userProfiles;
    private final Templater templater;
    private final EmailSender emailSender;
    private final ServerConfiguration serverConfiguration;
    private RoleService roleService;
    private static final Logger logger = LoggerFactory.getLogger(Notifications.class);

    @Autowired
    public Notifications(UserProfiles userProfiles, Templater templater, EmailSender emailSender, ServerConfiguration serverConfiguration, RoleService roleService) {
        this.userProfiles = userProfiles;
        this.templater = templater;
        this.emailSender = emailSender;
        this.serverConfiguration = serverConfiguration;
        this.roleService = roleService;
    }

    public void notifyAssignedToOwner(Task task) {
        this.sendEmail(task.getOwner(), Notifications.getSubject(task), TASK_ASSIGNED_TO_OWNER_TEMPLATE, this.taskContext(task));
    }

    public void notifyTaskPicked(Task task) {
        HashSet users = Sets.newHashSet();
        if (task.hasTeamCi()) {
            users.addAll(this.getAllMembers(task.getTeamCi()));
        }
        users.remove(task.getOwner());
        this.sendEmail(users, Notifications.getSubject(task), TASK_PICKED_TEMPLATE, this.taskContext(task));
    }

    public void notifyTaskReassigned(Task task, String previousOwner) {
        this.sendEmail(previousOwner, Notifications.getSubject(task), TASK_PICKED_TEMPLATE, this.taskContext(task));
    }

    public void notifyTaskUnassigned(Task task, String previousOwner) {
        HashSet users = Sets.newHashSet((Object[])new String[]{previousOwner});
        if (task.hasTeamCi()) {
            users.addAll(this.getAllMembers(task.getTeamCi()));
        }
        this.sendEmail(users, Notifications.getSubject(task), TASK_UNASSIGNED_TEMPLATE, this.taskContext(task));
    }

    public void notifyTaskFailed(Release release, Task task) {
        if (release.getAdminTeam() != null) {
            this.sendEmail(this.getAllMembers(release.getAdminTeam()), Notifications.getSubject(task), TASK_FAILED_TEMPLATE, this.taskContext(task));
        }
    }

    public void notifyTaskStarted(Task task) {
        boolean sendNotificationWhenStarted = (Boolean)task.getProperty("sendNotificationWhenStarted");
        if (task.hasOwner()) {
            this.sendEmail(task.getOwner(), Notifications.getSubject(task), TASK_STARTED_TEMPLATE, this.taskContext(task));
        } else if (task.hasTeamCi()) {
            this.sendEmail(this.getAllMembers(task.getTeamCi()), Notifications.getSubject(task), TASK_STARTED_TEMPLATE, this.taskContext(task));
        } else {
            Release release = task.getPhase().getRelease();
            if (sendNotificationWhenStarted && release.getAdminTeam() != null) {
                this.sendEmail(this.getAllMembers(release.getAdminTeam()), Notifications.getSubject(task), UNASSIGNED_TASK_STARTED_TEMPLATE, this.taskContext(task));
            }
        }
    }

    public void notifyCommentAdded(Task task, Comment comment) {
        Release release = task.getPhase().getRelease();
        HashSet users = Sets.newHashSet((Object[])new String[]{task.getOwner()});
        if (release.getAdminTeam() != null) {
            users.addAll(this.getAllMembers(release.getAdminTeam()));
        }
        if (task.hasTeam()) {
            users.addAll(this.getAllMembers(task.getTeamCi()));
        }
        users.remove(comment.getAuthor());
        this.sendEmail(users, Notifications.getSubject(task), TASK_COMMENT_ADDED_TEMPLATE, this.commentContext(task, comment));
    }

    public void notifyReleaseFlagged(Release release, FlagStatus newStatus, String comment) {
        this.sendEmail(this.getAllMembers(release.getAdminTeam()), Notifications.getSubject(release), RELEASE_FLAGGED_TEMPLATE, this.releaseFlagContext(release, newStatus, comment));
    }

    public void notifyReleaseStarted(Release release) {
        this.sendEmail(this.getAllMembers(release.getAdminTeam()), Notifications.getSubject(release), RELEASE_STARTED_TEMPLATE, this.releaseContext(release));
    }

    public void notifyReleaseAborted(Release release) {
        this.sendEmail(this.getAllMembers(release.getAdminTeam()), Notifications.getSubject(release), RELEASE_ABORTED_TEMPLATE, this.releaseContext(release));
    }

    public void notifyReleaseCompleted(Release release) {
        this.sendEmail(this.getAllMembers(release.getAdminTeam()), Notifications.getSubject(release), RELEASE_COMPLETED_TEMPLATE, this.releaseContext(release));
    }

    public void notifyTaskOverdue(Task task) {
        HashSet users = Sets.newHashSet((Object[])new String[]{task.getReleaseOwner()});
        if (task.hasOwner()) {
            users.add(task.getOwner());
        } else if (task.hasTeam()) {
            users.addAll(this.getAllMembers(task.getTeamCi()));
        }
        this.sendEmail(users, Notifications.getSubject(task), TASK_OVERDUE_TEMPLATE, this.taskContext(task));
    }

    public void executeNotificationTask(NotificationTask task, Runnable onSuccess, Runnable onException) {
        String bodyText = task.getBody();
        Map<String, Object> context = this.taskContext(task);
        context.put("body", bodyText);
        String body = this.templater.processTemplate(context, NOTIFICATION_TASK_BODY_TEMPLATE);
        this.emailSender.scheduleEmail(task.getAddresses(), task.getSubject(), body, onSuccess, onException);
    }

    private static String getSubject(Release release) {
        return String.format("%s %s", SUBJECT_PREFIX, release.getTitle());
    }

    private static String getSubject(Task task) {
        return String.format("%s %s: %s", SUBJECT_PREFIX, task.getRelease().getTitle(), task.getTitle());
    }

    private void sendEmail(String user, String subject, String template, Map<String, Object> context) {
        this.sendEmail(Collections.singleton(user), subject, template, context);
    }

    private void sendEmail(Collection<String> users, String subject, String template, Map<String, Object> context) {
        ArrayList<String> recipients = new ArrayList<String>();
        for (String user : users) {
            String recipient = this.userProfiles.getNotificationEmail(user);
            if (recipient == null) {
                logger.warn("Email address not found for {}; not sending email with subject '{}' for task {}", new Object[]{user, subject, context.get("displayPath")});
                continue;
            }
            recipients.add(recipient);
        }
        if (recipients.isEmpty()) {
            return;
        }
        try {
            String body = this.templater.processTemplate(context, template);
            this.emailSender.scheduleEmail(recipients, subject, body);
        }
        catch (Exception e) {
            logger.error("Could not schedule email ", (Throwable)e);
        }
    }

    Map<String, Object> taskContext(Task task) {
        HashMap context = Maps.newHashMap();
        context.put("title", task.getTitle());
        context.put("displayPath", task.getDisplayPath());
        context.put("owner", this.userProfiles.getFullNameOrUsername(task.getOwner()));
        context.put("description", task.getDescription());
        context.put("release", task.getRelease().getTitle());
        context.put("releaseIsFailed", task.getRelease().isFailed());
        context.put("releaseIsFailing", task.getRelease().isFailing());
        context.put("url", this.serverConfiguration.getServerUrl());
        return context;
    }

    Map<String, Object> commentContext(Task task, Comment comment) {
        Map<String, Object> context = this.taskContext(task);
        context.put("commentAuthor", this.userProfiles.getFullNameOrUsername(comment.getAuthor()));
        context.put("commentText", comment.getText());
        return context;
    }

    Map<String, Object> releaseContext(Release release) {
        HashMap context = Maps.newHashMap();
        context.put("displayPath", release.getDisplayPath());
        context.put("id", release.getName());
        context.put("release", release.getTitle());
        context.put("url", this.serverConfiguration.getServerUrl());
        return context;
    }

    Map<String, Object> releaseFlagContext(Release release, FlagStatus flagStatus, String comment) {
        Map<String, Object> context = this.releaseContext(release);
        context.put("flagStatus", (Object)flagStatus);
        context.put("flagComment", comment);
        return context;
    }

    private Set<String> getAllMembers(Team team) {
        if (team == null) {
            return Collections.emptySet();
        }
        HashSet members = Sets.newHashSet(team.getMembers());
        List assignments = this.roleService.readRoleAssignments();
        for (String roleName : team.getRoles()) {
            Role role = Notifications.find(assignments, roleName);
            if (role == null) continue;
            List principals = role.getPrincipalsAssigned();
            for (String principal : principals) {
                this.userProfiles.ensureCreated(principal);
            }
            members.addAll(principals);
        }
        return members;
    }

    private static Role find(List<Role> roles, String roleName) {
        for (Role role : roles) {
            if (!role.getName().equals(roleName)) continue;
            return role;
        }
        return null;
    }
}

