/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.notification;

import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.Mustache;
import com.github.mustachejava.MustacheFactory;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class Templater {
    private static final String TEMPLATE_LOCATION = "emails/";
    private final MustacheFactory mustacheFactory = new DefaultMustacheFactory();
    private static final Logger logger = LoggerFactory.getLogger(Templater.class);

    public String processTemplate(Object context, String templateName) {
        Mustache mustache = this.mustacheFactory.compile(TEMPLATE_LOCATION + templateName);
        StringWriter stringWriter = new StringWriter();
        try {
            mustache.execute((Writer)stringWriter, context).flush();
        }
        catch (IOException e) {
            logger.warn("Can't generate body from mustache template", (Throwable)e);
        }
        return stringWriter.toString();
    }
}

