/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.xlrelease.domain.ActivityLogEntry;
import com.xebialabs.xlrelease.repository.AbstractRepository;
import com.xebialabs.xlrelease.user.User;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class ActivityLog
extends AbstractRepository {
    @Autowired
    public ActivityLog(RepositoryService repositoryService) {
        super(repositoryService);
    }

    @Override
    protected String getEntityPrefix() {
        return "ActivityLog";
    }

    public void log(String releaseId, ActivityLogEntry activityLogEntry) {
        this.log(releaseId, activityLogEntry, User.AUTHENTICATED_USER);
    }

    public void log(String releaseId, ActivityLogEntry activityLogEntry, User user) {
        activityLogEntry.setUsername(user.getName());
        activityLogEntry.setId(this.getUniqueId(releaseId));
        this.repositoryService.create((ConfigurationItem[])new ActivityLogEntry[]{activityLogEntry});
    }

    public void log(String releaseId, List<ActivityLogEntry> activityLogEntries, User user) {
        String username = user.getName();
        for (ActivityLogEntry activityLogEntry : activityLogEntries) {
            activityLogEntry.setId(this.getUniqueId(releaseId));
            activityLogEntry.setUsername(username);
        }
        this.repositoryService.create((ConfigurationItem[])activityLogEntries.toArray(new ActivityLogEntry[activityLogEntries.size()]));
    }

    public void delete(List<ActivityLogEntry> logEntries) {
        List ids = Lists.transform(logEntries, (Function)new Function<ActivityLogEntry, String>(){

            public String apply(ActivityLogEntry logEntry) {
                return logEntry.getId();
            }
        });
        this.repositoryService.delete(ids.toArray(new String[ids.size()]));
    }
}

