/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CiHelper {
    public static List<ConfigurationItem> getNestedCis(Collection<? extends ConfigurationItem> cis) {
        ArrayList listWithNested = Lists.newArrayList();
        for (ConfigurationItem configurationItem : cis) {
            listWithNested.addAll(CiHelper.getNestedCis(configurationItem));
        }
        return listWithNested;
    }

    public static List<ConfigurationItem> getNestedCis(ConfigurationItem ci) {
        ArrayList listWithNested = Lists.newArrayList((Object[])new ConfigurationItem[]{ci});
        for (PropertyDescriptor property : ci.getType().getDescriptor().getPropertyDescriptors()) {
            ConfigurationItem child;
            PropertyKind kind = property.getKind();
            if (kind == PropertyKind.SET_OF_CI || kind == PropertyKind.LIST_OF_CI) {
                Collection<ConfigurationItem> children = CiHelper.getChildren(ci, property);
                listWithNested.addAll(CiHelper.getNestedCis(children));
            }
            if (kind != PropertyKind.CI || (child = (ConfigurationItem)property.get(ci)) == null || !CiHelper.isChild(child, ci)) continue;
            listWithNested.addAll(CiHelper.getNestedCis(child));
        }
        return listWithNested;
    }

    private static Collection<ConfigurationItem> getChildren(ConfigurationItem parent, PropertyDescriptor property) {
        Collection references = (Collection)property.get(parent);
        if (property.isAsContainment()) {
            return references;
        }
        ArrayList<ConfigurationItem> children = new ArrayList<ConfigurationItem>();
        for (ConfigurationItem ci : references) {
            if (!CiHelper.isChild(ci, parent)) continue;
            children.add(ci);
        }
        return children;
    }

    private static boolean isChild(ConfigurationItem ci, ConfigurationItem parent) {
        for (PropertyDescriptor property : ci.getType().getDescriptor().getPropertyDescriptors()) {
            PropertyKind kind = property.getKind();
            if (kind != PropertyKind.CI || !property.isAsContainment() || !parent.equals(property.get(ci))) continue;
            return true;
        }
        return false;
    }
}

