/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.SearchParameters;
import com.xebialabs.deployit.repository.core.Directory;
import com.xebialabs.xlrelease.domain.Configuration;
import com.xebialabs.xlrelease.repository.AbstractRepository;
import com.xebialabs.xlrelease.views.ConfigurationView;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class Configurations
extends AbstractRepository {
    public static final String CUSTOM_CONFIGURATION_ROOT = Metadata.ConfigurationItemRoot.CONFIGURATION.getRootNodeName() + "/Custom";

    @Autowired
    public Configurations(RepositoryService repositoryService) {
        super(repositoryService);
    }

    @Override
    protected String getEntityPrefix() {
        return "Configuration";
    }

    public Configuration findById(String configurationInstanceId) {
        return (Configuration)this.repositoryService.read(configurationInstanceId);
    }

    public List<Configuration> findAll() {
        SearchParameters query = new SearchParameters().setType(Type.valueOf(Configuration.class));
        return this.repositoryService.listEntities(query);
    }

    public List<Descriptor> findAllConfigurationDescriptors() {
        Type configurationType = Type.valueOf(Configuration.class);
        Collection allTypes = DescriptorRegistry.getSubtypes((Type)configurationType);
        ArrayList result = Lists.newArrayList();
        for (Type type : allTypes) {
            if (type.getDescriptor().isVirtual()) continue;
            result.add(type.getDescriptor());
        }
        return result;
    }

    public Configuration updateWith(String configurationInstanceId, ConfigurationView configurationView) {
        Configuration instance = this.findById(configurationInstanceId);
        Collection propertyDescriptors = instance.getType().getDescriptor().getPropertyDescriptors();
        for (PropertyDescriptor propertyDescriptor : propertyDescriptors) {
            instance.setProperty(propertyDescriptor.getName(), configurationView.getProperty(propertyDescriptor.getName()));
        }
        this.repositoryService.update((ConfigurationItem[])new Configuration[]{instance});
        return instance;
    }

    public Configuration create(ConfigurationView configurationView) {
        if (!this.repositoryService.exists(CUSTOM_CONFIGURATION_ROOT)) {
            Directory directory = new Directory();
            directory.setId(CUSTOM_CONFIGURATION_ROOT);
            this.repositoryService.create((ConfigurationItem[])new Directory[]{directory});
        }
        String id = this.getUniqueId(CUSTOM_CONFIGURATION_ROOT);
        Type type = Type.valueOf((String)configurationView.getType());
        Configuration newConfiguration = (Configuration)type.getDescriptor().newInstance(id);
        Collection propertyDescriptors = type.getDescriptor().getPropertyDescriptors();
        for (PropertyDescriptor propertyDescriptor : propertyDescriptors) {
            newConfiguration.setProperty(propertyDescriptor.getName(), configurationView.getProperty(propertyDescriptor.getName()));
        }
        this.repositoryService.create((ConfigurationItem[])new Configuration[]{newConfiguration});
        return newConfiguration;
    }

    public void delete(String configurationInstanceId) {
        this.repositoryService.delete(new String[]{configurationInstanceId});
    }
}

