/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository;

import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.xlrelease.domain.Dependency;
import com.xebialabs.xlrelease.domain.GateTask;
import com.xebialabs.xlrelease.domain.PlanItem;
import com.xebialabs.xlrelease.domain.ReleaseActivity;
import com.xebialabs.xlrelease.repository.AbstractRepository;
import com.xebialabs.xlrelease.repository.ActivityLog;
import com.xebialabs.xlrelease.repository.Ids;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class Dependencies
extends AbstractRepository {
    private ActivityLog activityLog;

    @Autowired
    public Dependencies(RepositoryService repositoryService, ActivityLog activityLog) {
        super(repositoryService);
        this.activityLog = activityLog;
    }

    @Override
    protected String getEntityPrefix() {
        return "Dependency";
    }

    public Dependency create(String gateId, String targetId) {
        PlanItem target = (PlanItem)this.repositoryService.read(targetId);
        Dependency dependency = new Dependency();
        dependency.setId(this.getUniqueId(gateId));
        dependency.setTarget(target);
        this.repositoryService.create((ConfigurationItem[])new Dependency[]{dependency});
        GateTask gate = (GateTask)this.repositoryService.read(gateId);
        this.activityLog.log(Ids.releaseIdFrom(gateId), ReleaseActivity.DEPENDENCY_CREATED.create(gate.getTitle(), target.getDisplayPath()));
        return dependency;
    }

    public Dependency update(String dependencyId, String targetId) {
        PlanItem newTarget = (PlanItem)this.repositoryService.read(targetId);
        Dependency dependency = (Dependency)this.repositoryService.read(dependencyId);
        Object previousTarget = dependency.getTarget();
        dependency.setTarget(newTarget);
        this.repositoryService.update((ConfigurationItem[])new Dependency[]{dependency});
        String gateId = Ids.getParentId(dependencyId);
        GateTask gate = (GateTask)this.repositoryService.read(gateId);
        this.activityLog.log(Ids.releaseIdFrom(gateId), ReleaseActivity.DEPENDENCY_UPDATED.create(gate.getTitle(), ((PlanItem)((Object)previousTarget)).getDisplayPath(), newTarget.getDisplayPath()));
        return dependency;
    }

    public void delete(String dependencyId) {
        Dependency dependency = (Dependency)this.repositoryService.read(dependencyId);
        this.repositoryService.delete(new String[]{dependencyId});
        String gateId = Ids.getParentId(dependencyId);
        GateTask gate = (GateTask)this.repositoryService.read(gateId);
        this.activityLog.log(Ids.releaseIdFrom(gateId), ReleaseActivity.DEPENDENCY_DELETED.create(gate.getTitle(), ((PlanItem)((Object)dependency.getTarget())).getDisplayPath()));
    }
}

