/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository;

import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.core.StringValue;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.repository.StringValueConverter;
import com.xebialabs.deployit.util.PasswordEncrypter;
import java.util.ArrayList;

public class JcrPredicate {
    private static final Joiner WITH_AND = Joiner.on((String)" AND ").skipNulls();
    private static final Joiner WITH_OR = Joiner.on((String)" OR ").skipNulls();

    public static String equal(String field, String value) {
        StringBuilder predicate = new StringBuilder();
        predicate.append(field).append(" = '").append(value).append('\'');
        return predicate.toString();
    }

    public static String lowerThan(String field, long date) {
        return field + " < CAST(" + date + " AS DATE)";
    }

    public static String greaterThan(String field, long date) {
        return field + " > CAST(" + date + " AS DATE)";
    }

    public static String and(String ... predicates) {
        return "(" + WITH_AND.join((Object[])predicates) + ")";
    }

    public static String or(String ... predicates) {
        return "(" + WITH_OR.join((Object[])predicates) + ")";
    }

    public static String as(String selector, Class clazz) {
        ArrayList predicates = Lists.newArrayList();
        predicates.add(JcrPredicate.getTypePredicate(selector, Type.valueOf((Class)clazz)));
        for (Type subtype : DescriptorRegistry.getSubtypes((Type)Type.valueOf((Class)clazz))) {
            predicates.add(JcrPredicate.getTypePredicate(selector, subtype));
        }
        return JcrPredicate.or(predicates.toArray(new String[predicates.size() - 1]));
    }

    public static String getTypePredicate(String selector, Type type) {
        StringBuilder predicate = new StringBuilder();
        predicate.append(selector).append(".[").append("$configuration.item.type").append("] = '").append(type).append('\'');
        return predicate.toString();
    }

    public static String isDescendantNode(String childSelector, String parentSelector) {
        StringBuilder predicate = new StringBuilder();
        predicate.append("ISDESCENDANTNODE(").append(childSelector).append(", ").append(parentSelector).append(")");
        return predicate.toString();
    }

    public static String isInPath(String selector, String path) {
        String pathSelector = "'" + path + "'";
        return JcrPredicate.isDescendantNode(selector, pathSelector);
    }

    public static String notNull(String field) {
        return field + " IS NOT NULL";
    }

    public static String containsAtLeastOne(String field, Iterable<String> options) {
        if (Iterables.isEmpty(options)) {
            return null;
        }
        ArrayList<String> predicates = new ArrayList<String>();
        StringValueConverter converter = new StringValueConverter(PasswordEncrypter.getInstance());
        for (String option : options) {
            String convertedOption = converter.convert(new StringValue(option), false);
            predicates.add(JcrPredicate.equal("LOWER(" + field + ")", convertedOption));
        }
        return "(" + WITH_OR.join(predicates) + ")";
    }
}

