/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.io.StreamWrappingOverthereFile;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.ChangeSet;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.SearchParameters;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.xlrelease.domain.Attachment;
import com.xebialabs.xlrelease.domain.Changes;
import com.xebialabs.xlrelease.domain.PlanItem;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.ReleaseActivity;
import com.xebialabs.xlrelease.domain.ReleaseStatus;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.filters.ReleaseFilter;
import com.xebialabs.xlrelease.repository.AbstractRepository;
import com.xebialabs.xlrelease.repository.ActivityLog;
import com.xebialabs.xlrelease.repository.Attachments;
import com.xebialabs.xlrelease.repository.CiHelper;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.views.ReleaseSecurity;
import com.xebialabs.xlrelease.views.ReleasesFilters;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.Seconds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class Releases
extends AbstractRepository {
    private static final Logger logger = LoggerFactory.getLogger(Releases.class);
    public static final String ROOT = "Applications";
    protected static final String RELEASE_PREFIX = "Release";
    private ActivityLog activityLog;
    private RoleService roleService;
    private Attachments attachments;

    @Autowired
    public Releases(RepositoryService repositoryService, ActivityLog activityLog, RoleService roleService, Attachments attachments) {
        super(repositoryService);
        this.activityLog = activityLog;
        this.roleService = roleService;
        this.attachments = attachments;
    }

    @Override
    protected String getEntityPrefix() {
        return RELEASE_PREFIX;
    }

    public Release createWithoutTemplate(Release release) {
        String releaseId = this.getUniqueId(ROOT);
        release.setId(releaseId);
        release.setStatus(ReleaseStatus.PLANNED);
        this.initReleaseCalendar(release);
        logger.info("Creating empty release " + releaseId);
        this.repositoryService.create((ConfigurationItem[])new Release[]{release});
        this.activityLog.log(releaseId, ReleaseActivity.RELEASE_CREATED.create(release.getTitle()));
        return this.findById(releaseId);
    }

    public Release createFromTemplate(String templateId, Release releaseMetadata) {
        String releaseId = this.getUniqueId(ROOT);
        Release template = (Release)this.repositoryService.read(templateId);
        logger.info("Creating new release " + releaseId + " from template " + templateId);
        this.repositoryService.copy(templateId, releaseId);
        Release release = this.fillReleaseWithMetadata(releaseId, releaseMetadata);
        Date referenceDate = template.getScheduledStartDate();
        if (referenceDate == null) {
            referenceDate = this.findFirstStartDate(template);
        }
        if (referenceDate != null) {
            int offsetSeconds = Seconds.secondsBetween((ReadableInstant)new DateTime((Object)referenceDate), (ReadableInstant)new DateTime((Object)release.getScheduledStartDate())).getSeconds();
            Changes changes = release.moveChildren(offsetSeconds);
            ChangeSet changeSet = new ChangeSet();
            for (ConfigurationItem configurationItem : changes.getUpdatedItems()) {
                changeSet.update(configurationItem);
            }
            this.repositoryService.execute(changeSet);
            release = (Release)this.repositoryService.read(release.getId(), false);
        }
        this.activityLog.delete(release.getActivityLogEntries());
        this.activityLog.log(releaseId, ReleaseActivity.RELEASE_CREATED_FROM_TEMPLATE.create(release.getTitle(), template.getTitle()));
        return this.decoreWithUserPermissions(release);
    }

    private Date findFirstStartDate(Release template) {
        Date result = null;
        List<PlanItem> children = template.getChildren();
        for (PlanItem item : children) {
            Date itemStartDate = item.getScheduledStartDate();
            if (result != null && (itemStartDate == null || !itemStartDate.before(result))) continue;
            result = itemStartDate;
        }
        return result;
    }

    public Release createTemplate(Release template) {
        template.setId(this.getUniqueId(ROOT));
        template.setStatus(ReleaseStatus.TEMPLATE);
        this.repositoryService.create((ConfigurationItem[])new Release[]{template});
        this.activityLog.log(template.getId(), ReleaseActivity.TEMPLATE_CREATED.create(new Object[0]));
        return this.decoreWithUserPermissions(template);
    }

    public Release copyTemplate(String templateId, Release template) {
        String newTemplateId = this.getUniqueId(ROOT);
        this.repositoryService.copy(templateId, newTemplateId);
        Release newTemplate = (Release)this.repositoryService.read(newTemplateId);
        newTemplate.setTitle(template.getTitle());
        newTemplate.setDescription(template.getDescription());
        this.repositoryService.update((ConfigurationItem[])new Release[]{newTemplate});
        this.activityLog.log(newTemplateId, ReleaseActivity.TEMPLATE_DUPLICATED.create(newTemplate.getTitle()));
        return this.decoreWithUserPermissions(newTemplate);
    }

    private Release fillReleaseWithMetadata(String releaseId, Release releaseMetadata) {
        Release newRelease = (Release)this.repositoryService.read(releaseId);
        newRelease.setStatus(ReleaseStatus.PLANNED);
        newRelease.setDescription(releaseMetadata.getDescription());
        newRelease.setTitle(releaseMetadata.getTitle());
        newRelease.setScheduledStartDate(releaseMetadata.getScheduledStartDate());
        newRelease.setDueDate(releaseMetadata.getDueDate());
        newRelease.setPlannedDuration(releaseMetadata.getPlannedDuration());
        newRelease.setOwner(releaseMetadata.hasOwner() ? releaseMetadata.getOwner() : Permissions.getAuthenticatedUserName());
        newRelease.addVariableValues(releaseMetadata.getVariableValues());
        newRelease.setTags(releaseMetadata.getTags());
        newRelease.setFlagStatus(releaseMetadata.getFlagStatus());
        newRelease.setFlagComment(releaseMetadata.getFlagComment());
        this.initReleaseCalendar(newRelease);
        this.repositoryService.update((ConfigurationItem[])new Release[]{newRelease});
        return this.decoreWithUserPermissions(newRelease);
    }

    private void initReleaseCalendar(Release newRelease) {
        Long token = UUID.randomUUID().getMostSignificantBits();
        newRelease.setCalendarLinkToken(token.toString());
        newRelease.setCalendarPublished(false);
    }

    public List<Release> findAll(ReleasesFilters releasesFilters) {
        ArrayList statuses = Lists.newArrayList();
        if (releasesFilters.withPlanned()) {
            statuses.add(ReleaseStatus.PLANNED.name());
        }
        if (releasesFilters.withActive()) {
            statuses.add(ReleaseStatus.IN_PROGRESS.name());
            statuses.add(ReleaseStatus.FAILED.name());
            statuses.add(ReleaseStatus.FAILING.name());
            statuses.add(ReleaseStatus.PAUSED.name());
        }
        if (releasesFilters.withCompleted()) {
            statuses.add(ReleaseStatus.COMPLETED.name());
            statuses.add(ReleaseStatus.ABORTED.name());
        }
        SearchParameters query = new SearchParameters().setType(Type.valueOf(Release.class));
        if (!statuses.isEmpty()) {
            String statusClause = Joiner.on((String)" OR ").join((Iterable)statuses);
            query.addTextSearch("status", statusClause);
        }
        if (releasesFilters.withOnlyMine()) {
            query.addProperty("owner", Permissions.getAuthenticatedUserName());
        }
        if (statuses.isEmpty() && !releasesFilters.withOnlyMine()) {
            return Lists.newArrayList();
        }
        List<Release> releases = this.repositoryService.listEntities(query);
        Date from = releasesFilters.getFrom();
        Date to = releasesFilters.getTo();
        if (releasesFilters.getTimeFrame() != null) {
            from = new Date(releasesFilters.getTimeFrame().getStartDate(from));
            to = new Date(releasesFilters.getTimeFrame().getEndDate(to));
        }
        releases = new ReleaseFilter(releasesFilters.getFilter(), releasesFilters.withOnlyFlagged(), from, to).filter(releases);
        return this.decoreWithUserPermissions(releases);
    }

    public List<Release> findAllTemplates(String searchFilter) {
        SearchParameters query = new SearchParameters().setType(Type.valueOf(Release.class));
        query.addTextSearch("status", ReleaseStatus.TEMPLATE.name());
        List<Release> templates = this.repositoryService.listEntities(query);
        templates = new ReleaseFilter(searchFilter, false).filter(templates);
        return this.decoreWithUserPermissions(templates);
    }

    public List<Release> active() {
        return this.withStatus(ReleaseStatus.ACTIVE_STATUSES);
    }

    public List<Release> withStatus(ReleaseStatus ... statuses) {
        ArrayList statusNames = Lists.newArrayList();
        for (ReleaseStatus status : statuses) {
            statusNames.add(status.name());
        }
        String statusClause = Joiner.on((String)" OR ").join((Iterable)statusNames);
        SearchParameters query = new SearchParameters().setType(Type.valueOf(Release.class)).addTextSearch("status", statusClause);
        List releases = this.repositoryService.listEntities(query);
        return this.decoreWithUserPermissions(releases);
    }

    public Release containingTask(String taskId) {
        return this.findById(Ids.releaseIdFrom(taskId));
    }

    public Release containingTeam(String teamId) {
        return this.findById(Ids.releaseIdFrom(teamId));
    }

    public Release findById(String releaseId) {
        return this.findById(releaseId, true);
    }

    public Release findById(String releaseId, boolean useCache) {
        Release release = (Release)this.repositoryService.read(releaseId, useCache);
        return this.decoreWithUserPermissions(release);
    }

    public ReleaseSecurity getMyLocalSecurity(Release release) {
        ReleaseSecurity releaseSecurity = new ReleaseSecurity();
        releaseSecurity.setPermissions(this.getMyGrantedPermissions(release));
        releaseSecurity.setTeams(this.getMyTeams(release));
        return releaseSecurity;
    }

    private Set<String> getMyGrantedPermissions(Release release) {
        String user = Permissions.getAuthenticatedUserName();
        if (user != null) {
            List userRoles = this.roleService.getRolesFor(user);
            return release.getPermissions(user, userRoles);
        }
        return Sets.newHashSet();
    }

    private Set<String> getMyTeams(Release release) {
        String user = Permissions.getAuthenticatedUserName();
        if (user != null) {
            List userRoles = this.roleService.getRolesFor(user);
            return release.getTeamsOf(user, userRoles);
        }
        return Sets.newHashSet();
    }

    public Release findByCalendarToken(String calendarToken) {
        SearchParameters query = new SearchParameters().addProperty("calendarLinkToken", calendarToken);
        List releases = this.repositoryService.listEntities(query);
        if (releases == null || releases.isEmpty()) {
            return null;
        }
        return (Release)((Object)releases.get(0));
    }

    public List<Release> findTemplatesByTitle(String title) {
        SearchParameters query = new SearchParameters().addProperty("title", title).addProperty("status", ReleaseStatus.TEMPLATE.name());
        return this.repositoryService.listEntities(query);
    }

    public void importTemplate(Release template) {
        String oldTemplateId = template.getId();
        String newTemplateId = this.getUniqueId(ROOT);
        List<ConfigurationItem> nestedCis = CiHelper.getNestedCis((ConfigurationItem)template);
        for (ConfigurationItem configurationItem : nestedCis) {
            this.rewriteId(configurationItem, oldTemplateId, newTemplateId);
        }
        List<ConfigurationItem> cisToCreate = CiHelper.getNestedCis((ConfigurationItem)template);
        this.repositoryService.create(cisToCreate.toArray(new ConfigurationItem[cisToCreate.size()]));
        this.activityLog.log(template.getId(), ReleaseActivity.TEMPLATE_IMPORTED.create(new Object[0]));
    }

    public Attachment attach(String ciId, String filename, String contentType, InputStream bytes) {
        if (Ids.isReleaseId(ciId)) {
            Attachment attachment = this.saveAttachment(ciId, filename, contentType, bytes);
            this.activityLog.log(ciId, ReleaseActivity.ATTACHMENT_ADDED.create(filename, contentType));
            return attachment;
        }
        String releaseId = Ids.releaseIdFrom(ciId);
        Attachment attachment = this.saveAttachment(releaseId, filename, contentType, bytes);
        Task task = (Task)this.repositoryService.read(ciId);
        task.getAttachments().add(attachment);
        this.repositoryService.update((ConfigurationItem[])new Task[]{task});
        this.activityLog.log(releaseId, ReleaseActivity.ATTACHMENT_ADDED_ON_TASK.create(filename, contentType, task.getTitle()));
        return attachment;
    }

    private Attachment saveAttachment(String ciId, String filename, String contentType, InputStream bytes) {
        Release release = this.findById(ciId);
        StreamWrappingOverthereFile file = new StreamWrappingOverthereFile(filename, bytes);
        Attachment attachment = new Attachment(file, contentType);
        attachment = this.attachments.create(release, attachment);
        release.getAttachments().add(attachment);
        this.repositoryService.update((ConfigurationItem[])new Release[]{release});
        return attachment;
    }

    public void deleteAttachment(String releaseId, String attachmentId) {
        Release release = this.findById(releaseId);
        String filename = this.attachments.findById(attachmentId).getFile().getName();
        Set<Task> tasksUsingAttachment = release.getTasksUsingAttachment(attachmentId);
        Preconditions.checkState((boolean)tasksUsingAttachment.isEmpty(), (Object)String.format("Attachment '%s' is used by tasks : %s", attachmentId, tasksUsingAttachment.toString()));
        logger.info("Deleting attachment reference '{}' from release '{}'", (Object)attachmentId, (Object)releaseId);
        release.deleteAttachment(attachmentId);
        this.repositoryService.delete(new String[]{attachmentId});
        this.repositoryService.update((ConfigurationItem[])new Release[]{release});
        this.activityLog.log(release.getId(), ReleaseActivity.ATTACHMENT_DELETED.create(filename));
    }

    public void deleteAttachmentFromTask(String releaseId, String taskId, String attachmentId) {
        Release release = this.findById(releaseId);
        Task task = (Task)this.repositoryService.read(taskId);
        String filename = this.attachments.findById(attachmentId).getFile().getName();
        Preconditions.checkState((!task.isInProgress() ? 1 : 0) != 0, (Object)"Can't delete a dependency on a running task.");
        Set<Task> tasksUsingAttachment = release.getTasksUsingAttachment(attachmentId);
        Preconditions.checkState((boolean)tasksUsingAttachment.contains((Object)task), (Object)String.format("Attachment '%s' found on release, but not found on task '%s'", attachmentId, taskId));
        if (tasksUsingAttachment.size() == 1) {
            logger.info("Deleting attachment reference '{}' from release '{}'", (Object)attachmentId, (Object)releaseId);
            release.deleteAttachment(attachmentId);
            task.deleteAttachment(attachmentId);
            this.repositoryService.update((ConfigurationItem[])new Task[]{task});
            this.repositoryService.delete(new String[]{attachmentId});
            this.repositoryService.update((ConfigurationItem[])new Release[]{release});
        } else {
            logger.info("Deleting attachment reference '{}' from task '{}'", (Object)attachmentId, (Object)taskId);
            task.deleteAttachment(attachmentId);
            this.repositoryService.update((ConfigurationItem[])new Task[]{task});
        }
        this.activityLog.log(release.getId(), ReleaseActivity.ATTACHMENT_DELETED_FROM_TASK.create(filename, task.getTitle()));
    }

    private void rewriteId(ConfigurationItem configurationItem, String oldTemplateId, String newTemplateId) {
        String rewrittenId = configurationItem.getId().replace(oldTemplateId, newTemplateId);
        configurationItem.setId(rewrittenId);
    }

    private Release decoreWithUserPermissions(Release release) {
        release.setReleaseSecurity(this.getMyLocalSecurity(release));
        return release;
    }

    private List<Release> decoreWithUserPermissions(List<Release> releases) {
        for (Release release : releases) {
            this.decoreWithUserPermissions(release);
        }
        return releases;
    }
}

