/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository;

import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.deployit.plumbing.id.IdType;
import com.xebialabs.deployit.repository.ConfigurationItemData;
import com.xebialabs.deployit.repository.ConfigurationItemRevision;
import com.xebialabs.deployit.repository.JcrHistoryService;
import com.xebialabs.deployit.repository.JcrQueryTemplate;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.SearchParameters;
import com.xebialabs.xlrelease.activity.ReleaseActivityFormatter;
import com.xebialabs.xlrelease.activity.TaskFieldsComparator;
import com.xebialabs.xlrelease.domain.ActivityLogEntry;
import com.xebialabs.xlrelease.domain.Changes;
import com.xebialabs.xlrelease.domain.Configuration;
import com.xebialabs.xlrelease.domain.CustomScriptTask;
import com.xebialabs.xlrelease.domain.DeployitTask;
import com.xebialabs.xlrelease.domain.GateTask;
import com.xebialabs.xlrelease.domain.Link;
import com.xebialabs.xlrelease.domain.NotificationTask;
import com.xebialabs.xlrelease.domain.ParallelGroup;
import com.xebialabs.xlrelease.domain.Phase;
import com.xebialabs.xlrelease.domain.PythonScript;
import com.xebialabs.xlrelease.domain.ReleaseActivity;
import com.xebialabs.xlrelease.domain.ScriptTask;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.TaskStatus;
import com.xebialabs.xlrelease.domain.Variable;
import com.xebialabs.xlrelease.repository.AbstractRepository;
import com.xebialabs.xlrelease.repository.ActivityLog;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.JcrPredicate;
import com.xebialabs.xlrelease.repository.JcrQueryBuilder;
import com.xebialabs.xlrelease.repository.UserProfiles;
import com.xebialabs.xlrelease.user.User;
import com.xebialabs.xlrelease.views.TaskFullView;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class Tasks
extends AbstractRepository {
    static final String UNSTARTED_REVISION = "UNSTARTED_REVISION";
    private ActivityLog activityLog;
    private JcrHistoryService historyService;
    private UserProfiles userProfiles;
    private static final Logger logger = LoggerFactory.getLogger(Tasks.class);

    @Autowired
    public Tasks(RepositoryService repositoryService, ActivityLog activityLog, JcrHistoryService historyService, UserProfiles userProfiles) {
        super(repositoryService);
        this.activityLog = activityLog;
        this.historyService = historyService;
        this.userProfiles = userProfiles;
    }

    @Override
    protected String getEntityPrefix() {
        return "Task";
    }

    public Task findById(String taskId) {
        return (Task)this.repositoryService.read(taskId);
    }

    public List<Task> findById(List<String> taskIds) {
        ArrayList tasks = Lists.newArrayList();
        for (String taskId : taskIds) {
            tasks.add((Task)this.repositoryService.read(taskId));
        }
        return tasks;
    }

    public List<GateTask> findActiveGates() {
        return this.findGatesWithStatus(TaskStatus.IN_PROGRESS);
    }

    public List<GateTask> findGatesWithStatus(TaskStatus ... statuses) {
        List<GateTask> gates = this.findTasksWithTypeAndStatus(GateTask.class, statuses);
        Iterable releaseGates = Iterables.filter(gates, Task.DOES_NOT_BELONG_TO_TEMPLATE);
        return Lists.newArrayList((Iterable)releaseGates);
    }

    public List<Task> findTasksWithStatus(TaskStatus ... statuses) {
        return this.findTasksWithTypeAndStatus(Task.class, statuses);
    }

    public <T extends ConfigurationItem> List<T> findTasksWithTypeAndStatus(Class<T> type, TaskStatus ... statuses) {
        ArrayList statusNames = Lists.newArrayList();
        for (TaskStatus status : statuses) {
            statusNames.add(status.name());
        }
        String statusClause = Joiner.on((String)" OR ").join((Iterable)statusNames);
        SearchParameters query = new SearchParameters().setType(Type.valueOf(type)).addTextSearch("status", statusClause);
        return this.repositoryService.listEntities(query);
    }

    public List<Task> findPendingTasks() {
        return this.repositoryService.listEntities(new SearchParameters().setType(Type.valueOf(Task.class)).addTextSearch("status", TaskStatus.PENDING.value()));
    }

    public void updateTaskWith(Task task, TaskFullView updatedTask) {
        this.checkTaskIsUpdatable(task);
        Preconditions.checkArgument((boolean)this.isScheduledStartDateUpdatable(task, updatedTask), (String)"Can't update scheduled start date of task '%s' that is neither planned or pending", (Object[])new Object[]{task.getTitle()});
        List<ActivityLogEntry> logEntries = new TaskFieldsComparator(task, updatedTask, this.userProfiles).getLogs();
        Changes changes = new Changes();
        changes.update((ConfigurationItem)task);
        task.setTitle(updatedTask.getTitle());
        task.setDescription(updatedTask.getDescription());
        task.updateDates(updatedTask.getScheduledStartDate(), updatedTask.getDueDate(), updatedTask.getPlannedDuration());
        task.setOverdueNotified(false);
        task.setFlagStatus(updatedTask.getFlag().getStatus());
        task.setFlagComment(updatedTask.getFlag().getComment());
        task.setTeam(updatedTask.getTeam());
        task.setWaitForScheduledStartDate(updatedTask.isWaitForScheduledStartDate());
        if (!Objects.equal((Object)task.getOwner(), (Object)updatedTask.getOwnerUsername())) {
            task.setOwner(updatedTask.getOwnerUsername());
            task.setOverdueNotified(false);
        }
        if (task instanceof DeployitTask) {
            DeployitTask deployitTask = (DeployitTask)task;
            deployitTask.setDeploymentPackage(updatedTask.getDeploymentPackage());
            deployitTask.setEnvironment(updatedTask.getEnvironment());
            deployitTask.setServer(updatedTask.getServer());
            deployitTask.setUsername(updatedTask.getUsername());
            deployitTask.setPassword(updatedTask.getPassword());
        } else if (task instanceof NotificationTask) {
            NotificationTask notificationTask = (NotificationTask)task;
            notificationTask.setAddresses(updatedTask.getAddresses());
            notificationTask.setSubject(updatedTask.getSubject());
            notificationTask.setBody(updatedTask.getBody());
        } else if (task instanceof ScriptTask) {
            ScriptTask scriptTask = (ScriptTask)task;
            scriptTask.setScript(updatedTask.getScript());
        } else if (task instanceof CustomScriptTask) {
            String name;
            CustomScriptTask customScriptTask = (CustomScriptTask)task;
            PythonScript pythonScript = customScriptTask.getPythonScript();
            for (PropertyDescriptor propertyDescriptor : pythonScript.getInputProperties()) {
                name = propertyDescriptor.getName();
                if (propertyDescriptor.getKind() == PropertyKind.CI) {
                    String configurationViewId = (String)updatedTask.getInputProperties().get(name);
                    Configuration configuration = null;
                    if (configurationViewId != null) {
                        configuration = (Configuration)this.repositoryService.read(IdType.CONFIGURATION.convertToJcrId(configurationViewId));
                    }
                    if (configuration != null) {
                        Preconditions.checkArgument((boolean)this.propertyIsAssignableTo(propertyDescriptor, configuration), (Object)("Type of CI must be " + propertyDescriptor.getReferencedType().getName() + " got " + configuration.getType().getName()));
                    }
                    customScriptTask.getPythonScript().setProperty(propertyDescriptor.getName(), (Object)configuration);
                    continue;
                }
                customScriptTask.getPythonScript().setProperty(propertyDescriptor.getName(), updatedTask.getInputProperties().get(name));
            }
            for (PropertyDescriptor propertyDescriptor : pythonScript.getOutputProperties()) {
                name = propertyDescriptor.getName();
                String variableName = this.formatVariableIfNeeded(updatedTask.getOutputProperties().get(name));
                customScriptTask.getPythonScript().setProperty(propertyDescriptor.getName(), variableName);
            }
            changes.update((ConfigurationItem)pythonScript);
        }
        this.repositoryService.update(changes.toUpdatedItemsArray());
        this.activityLog.log(Ids.releaseIdFrom(task.getId()), logEntries, User.AUTHENTICATED_USER);
    }

    private boolean propertyIsAssignableTo(PropertyDescriptor propertyDescriptor, Configuration configuration) {
        Type referencedType = propertyDescriptor.getReferencedType();
        return configuration.getType().instanceOf(referencedType) || referencedType.isSuperTypeOf(configuration.getType());
    }

    public void reassignToOwner(Task task, String newOwner) {
        this.checkTaskIsUpdatable(task);
        ArrayList logEntries = Lists.newArrayList();
        logEntries.add(ReleaseActivity.TASK_OWNER_UPDATED.create(task.getTitle(), ReleaseActivityFormatter.quoteUser(task.getOwner(), this.userProfiles), ReleaseActivityFormatter.quoteUser(newOwner, this.userProfiles)));
        task.setOwner(newOwner);
        task.setOverdueNotified(false);
        Changes changes = new Changes();
        changes.update((ConfigurationItem)task);
        this.repositoryService.update(changes.toUpdatedItemsArray());
        this.activityLog.log(Ids.releaseIdFrom(task.getId()), logEntries, User.AUTHENTICATED_USER);
    }

    public void reassignToTeam(Task task, String newTeam) {
        this.checkTaskIsUpdatable(task);
        ArrayList logEntries = Lists.newArrayList();
        logEntries.add(ReleaseActivity.TASK_TASK_TEAM_UPDATED.create(task.getTitle(), ReleaseActivityFormatter.quoteAssignee(task.getTeam()), ReleaseActivityFormatter.quoteAssignee(newTeam)));
        task.setTeam(newTeam);
        Changes changes = new Changes();
        changes.update((ConfigurationItem)task);
        this.repositoryService.update(changes.toUpdatedItemsArray());
        this.activityLog.log(Ids.releaseIdFrom(task.getId()), logEntries, User.AUTHENTICATED_USER);
    }

    private void checkTaskIsUpdatable(Task task) {
        Preconditions.checkArgument((boolean)task.isUpdatable(), (String)"Can't update task '%s' because it is in state %s", (Object[])new Object[]{task.getTitle(), task.getStatus()});
    }

    private String formatVariableIfNeeded(String variableName) {
        if (!Strings.isNullOrEmpty((String)variableName) && !Variable.containOnlyVariable(variableName)) {
            variableName = "${" + variableName + "}";
        }
        return variableName;
    }

    private boolean isScheduledStartDateUpdatable(Task task, TaskFullView updatedTask) {
        return task.isPlanned() || task.isPending() || Objects.equal((Object)task.getScheduledStartDate(), (Object)updatedTask.getScheduledStartDate());
    }

    public Task create(String containerId, Task task) {
        if (Ids.isPhaseId(containerId)) {
            this.checkPhaseConditionsForAdding(containerId);
        } else {
            this.checkParallelGroupConditionsForAdding(containerId);
        }
        return this.createTask(task, containerId);
    }

    private void checkPhaseConditionsForAdding(String containerId) {
        Phase phase = (Phase)this.repositoryService.read(containerId);
        Preconditions.checkArgument((boolean)phase.isUpdatable(), (String)"Can't add a task to phase '%s' because it is in state %s.", (Object[])new Object[]{phase.getTitle(), phase.getStatus()});
    }

    private void checkParallelGroupConditionsForAdding(String containerId) {
        ParallelGroup group = (ParallelGroup)this.repositoryService.read(containerId);
        Preconditions.checkArgument((boolean)group.getStatus().isOneOf(TaskStatus.PLANNED, TaskStatus.PENDING), (String)"Can't add task to the parallel group '%s' because the group is %s.", (Object[])new Object[]{group.getTitle(), group.getStatus()});
    }

    private Task createTask(Task task, String containerId) {
        String taskType;
        String id = this.getUniqueId(containerId);
        task.setId(id);
        task.setStatus(TaskStatus.PLANNED);
        if (task instanceof CustomScriptTask) {
            PythonScript pythonScript = ((CustomScriptTask)task).getPythonScript();
            pythonScript.setId(task.getId() + "/" + "PythonScript");
            this.populateCIReference(pythonScript);
            this.repositoryService.create((ConfigurationItem[])new BaseConfigurationItem[]{task, pythonScript});
            taskType = pythonScript.getType().toString();
        } else {
            this.repositoryService.create((ConfigurationItem[])new Task[]{task});
            taskType = task.getType().toString();
        }
        Task createdTask = this.findById(task.getId());
        this.activityLog.log(Ids.releaseIdFrom(createdTask.getId()), ReleaseActivity.TASK_CREATED.create(task.getTitle(), taskType));
        return createdTask;
    }

    private void populateCIReference(PythonScript pythonScript) {
        for (PropertyDescriptor propertyDescriptor : pythonScript.getInputProperties()) {
            Type referencedType;
            List configurationItems;
            if (propertyDescriptor.getKind() != PropertyKind.CI || (configurationItems = this.repositoryService.listEntities(new SearchParameters().setType(referencedType = propertyDescriptor.getReferencedType()))).size() <= 0) continue;
            propertyDescriptor.set((ConfigurationItem)pythonScript, configurationItems.get(0));
        }
    }

    public void delete(String taskId) {
        Task task = (Task)this.repositoryService.read(taskId);
        Preconditions.checkArgument((boolean)task.isPlanned(), (String)"Only planned tasks can be deleted. Task '%s' is %s.", (Object[])new Object[]{task.getTitle(), task.getStatus()});
        if (task.getContainer() instanceof ParallelGroup) {
            List<Link> links = ((ParallelGroup)task.getContainer()).getLinksOf(task);
            List linkIds = Lists.transform(links, Link.TO_ID);
            this.repositoryService.delete(linkIds.toArray(new String[linkIds.size()]));
        }
        this.repositoryService.delete(new String[]{taskId});
        this.activityLog.log(Ids.releaseIdFrom(task.getId()), ReleaseActivity.TASK_DELETED.create(task.getTitle()));
    }

    public void labelLastRevisionAsUnstarted(String taskId) {
        List revisions = this.historyService.getVersionRevisions(taskId);
        if (revisions.size() < 2) {
            logger.warn("Attempted to label task '{}' which doesn't have any history", (Object)taskId);
            return;
        }
        this.historyService.labelRevision(taskId, ((ConfigurationItemRevision)revisions.get(revisions.size() - 2)).getRevisionId(), UNSTARTED_REVISION);
    }

    public Task findUnstartedRevision(String taskId) {
        try {
            return (Task)this.historyService.readRevisionByLabel(taskId, UNSTARTED_REVISION);
        }
        catch (JcrHistoryService.UnknownLabelException e) {
            logger.warn("Un-started revision label not found on task '{}'", (Object)taskId);
            return null;
        }
    }

    public List<ConfigurationItemData> findInProgressAutomatedTasks() {
        String taskSelector = "ci";
        ArrayList predicates = Lists.newArrayList();
        for (Type subtype : DescriptorRegistry.getSubtypes((Type)Type.valueOf(Task.class))) {
            if (!subtype.getDescriptor().getPropertyDescriptor("automated").getDefaultValue().toString().equals("true") || subtype.instanceOf(Type.valueOf(DeployitTask.class)) || subtype.instanceOf(Type.valueOf(ParallelGroup.class))) continue;
            predicates.add(JcrPredicate.getTypePredicate(taskSelector, subtype));
        }
        String query = JcrQueryBuilder.select(taskSelector).from(taskSelector).where(JcrPredicate.and(JcrPredicate.or(predicates.toArray(new String[predicates.size() - 1])), JcrPredicate.equal("status", TaskStatus.IN_PROGRESS.name()))).toString();
        return this.repositoryService.list(new JcrQueryTemplate(query));
    }
}

