/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.script;

import com.google.common.collect.Lists;
import com.google.common.io.Resources;
import java.io.FilePermission;
import java.net.NetPermission;
import java.net.URL;
import java.nio.charset.Charset;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.Enumeration;
import java.util.List;
import java.util.PropertyPermission;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.apache.commons.codec.Charsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptExecutor {
    public static final String ENGINE = "python";
    public static final List<String> PYTHON_UTILITIES = Lists.newArrayList((Object[])new String[]{"pythonutil/XLRequest.py", "pythonutil/XLResponse.py", "pythonutil/CredentialsFallback.py"});
    private AccessControlContext accessControlContext;
    private ScriptEngine scriptEngine;
    private static final Logger logger = LoggerFactory.getLogger(ScriptExecutor.class);

    public ScriptExecutor(ScriptContext context, PermissionCollection permissions) {
        this.scriptEngine = this.initScriptEngine(context);
        this.accessControlContext = this.initAccessControlContext(permissions);
        this.loadPythonFiles(PYTHON_UTILITIES);
    }

    public void evalScript(final String script) throws Throwable {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws ScriptException {
                    ScriptExecutor.this.scriptEngine.eval(script);
                    return null;
                }
            }, this.accessControlContext);
        }
        catch (PrivilegedActionException exceptionWrapper) {
            logger.debug("PrivilegedActionException: ", (Throwable)exceptionWrapper);
            throw exceptionWrapper.getCause();
        }
    }

    private ScriptEngine initScriptEngine(ScriptContext context) {
        ScriptEngineManager manager = new ScriptEngineManager();
        ScriptEngine engine = manager.getEngineByName(ENGINE);
        engine.setContext(context);
        return engine;
    }

    private AccessControlContext initAccessControlContext(PermissionCollection permissions) {
        ProtectionDomain domain = new ProtectionDomain(new CodeSource(null, (Certificate[])null), this.extendsMinimalPermissionsWith(permissions));
        return new AccessControlContext(new ProtectionDomain[]{domain});
    }

    private Permissions extendsMinimalPermissionsWith(PermissionCollection permissions) {
        Permissions minimalPermissions = new Permissions();
        minimalPermissions.add(new PropertyPermission("user.dir", "read"));
        minimalPermissions.add(new PropertyPermission("line.separator", "read"));
        minimalPermissions.add(new PropertyPermission("file.encoding", "read"));
        minimalPermissions.add(new RuntimePermission("createClassLoader"));
        minimalPermissions.add(new RuntimePermission("getProtectionDomain"));
        this.addJythonLibrariesReadPermission(minimalPermissions);
        this.addJsonSmartLibraryPermissions(minimalPermissions);
        this.addOvertherePermissions(minimalPermissions);
        if (permissions != null) {
            Enumeration<Permission> permissionEnumeration = permissions.elements();
            while (permissionEnumeration.hasMoreElements()) {
                minimalPermissions.add(permissionEnumeration.nextElement());
            }
        }
        return minimalPermissions;
    }

    private void addOvertherePermissions(Permissions minimalPermissions) {
        minimalPermissions.add(new NetPermission("specifyStreamHandler"));
        minimalPermissions.add(new PropertyPermission("jcifs.properties", "read"));
    }

    private void addJythonLibrariesReadPermission(Permissions minimalPermissions) {
        this.addReadPermissionOnJar("jython-standalone", minimalPermissions);
        minimalPermissions.add(new PropertyPermission("os.name", "read"));
        minimalPermissions.add(new PropertyPermission("os.arch", "read"));
    }

    private void addJsonSmartLibraryPermissions(Permissions minimalPermissions) {
        this.addReadPermissionOnJar("json-smart", minimalPermissions);
        minimalPermissions.add(new PropertyPermission("JSON_SMART_SIMPLE", "read"));
    }

    private void addReadPermissionOnJar(String jarName, Permissions minimalPermissions) {
        String classPath = System.getProperty("java.class.path");
        String classPathSeparator = System.getProperty("path.separator");
        Pattern pattern = Pattern.compile("([^" + classPathSeparator + "]*" + jarName + "[^" + classPathSeparator + "]*)");
        Matcher matcher = pattern.matcher(classPath);
        while (matcher.find()) {
            String group = matcher.group();
            minimalPermissions.add(new FilePermission(group, "read"));
            logger.debug("Minimal permission added on: {}", (Object)group);
        }
    }

    private void loadPythonFiles(List<String> pythonUtilities) {
        for (String pythonFile : pythonUtilities) {
            this.loadPythonFile(pythonFile);
        }
    }

    private void loadPythonFile(String path) {
        try {
            URL url = Resources.getResource((String)path);
            String script = Resources.toString((URL)url, (Charset)Charsets.UTF_8);
            this.evalScript(script);
        }
        catch (Throwable throwable) {
            logger.warn("Unable to load python file '{}'", (Object)path);
        }
    }
}

