/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.script;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.deployit.plumbing.scheduler.Scheduler;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.xlrelease.concurrent.ReleaseIdHolder;
import com.xebialabs.xlrelease.concurrent.Synchronized;
import com.xebialabs.xlrelease.domain.Configuration;
import com.xebialabs.xlrelease.domain.CustomScriptTask;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.ReleaseActivity;
import com.xebialabs.xlrelease.domain.ScriptTask;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.repository.ActivityLog;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.script.ScriptCallback;
import com.xebialabs.xlrelease.script.ScriptExecutor;
import com.xebialabs.xlrelease.script.ScriptLifeCycle;
import com.xebialabs.xlrelease.script.ThreadLocalWriterDecorator;
import com.xebialabs.xlrelease.service.ProxyLookup;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.script.ScriptContext;
import javax.script.ScriptException;
import javax.script.SimpleScriptContext;
import org.python.core.PyException;
import org.python.core.PyType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import sun.security.provider.PolicyFile;

@Service
public class ScriptService {
    public static final String SCRIPT_POLICY_FILE = "script.policy";
    private static final Logger logger = LoggerFactory.getLogger(ScriptService.class);
    private Scheduler scheduler;
    private ActivityLog activityLog;
    private RepositoryService repositoryService;
    private ProxyLookup proxyLookup;
    private ScriptLifeCycle scriptLifeCycle;
    private ThreadLocalWriterDecorator executionLog = new ThreadLocalWriterDecorator();

    @Autowired
    public ScriptService(Scheduler scheduler, ActivityLog activityLog, RepositoryService repositoryService, ProxyLookup proxyLookup, ScriptLifeCycle scriptLifeCycle) {
        this.scheduler = scheduler;
        this.activityLog = activityLog;
        this.repositoryService = repositoryService;
        this.proxyLookup = proxyLookup;
        this.scriptLifeCycle = scriptLifeCycle;
    }

    public ScriptService() {
    }

    public void executeScriptTask(final ScriptTask task, final ScriptCallback onSuccess, final ScriptCallback onFailure) {
        this.scriptLifeCycle.register(task.getExecutionId());
        this.scheduler.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ScriptService.this.executionLog.registerWriter();
                ScriptContext scriptContext = ScriptService.this.makeScriptContext(ScriptService.this.executionLog);
                ScriptService.this.addReleaseAndPhaseToContext(scriptContext, task);
                try {
                    ScriptService.this.executeScript(task.getScript(), scriptContext, task.getExecutionId());
                    ScriptService.this.completeTask(ScriptService.this.executionLog, onSuccess, task.getId());
                }
                catch (ScriptException exception) {
                    if (ScriptService.this.isSystemExit0(exception)) {
                        ScriptService.this.completeTask(ScriptService.this.executionLog, onSuccess, task.getId());
                    } else {
                        ScriptService.this.onScriptException(exception, ScriptService.this.executionLog, onFailure, task.getId());
                    }
                }
                catch (Throwable exception) {
                    ScriptService.this.onException(exception, ScriptService.this.executionLog, onFailure, task.getId(), "Exception during execution:\n", "Unexpected exception during execution of script task '{}':");
                }
                finally {
                    ScriptService.this.executionLog.removeWriter();
                    ScriptService.this.scriptLifeCycle.unregister(task.getExecutionId());
                }
            }
        });
    }

    public void executeCustomScriptTask(final CustomScriptTask task, final ScriptCallback onSuccess, final ScriptCallback onFailure) {
        this.scriptLifeCycle.register(task.getExecutionId());
        this.scheduler.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                String script;
                ScriptService.this.executionLog.registerWriter();
                try {
                    script = task.getPythonScript().getScript();
                }
                catch (IOException exception) {
                    ScriptService.this.onException(exception, ScriptService.this.executionLog, onFailure, task.getId(), "Exception while loading script:\n", "Error while loading script on task '{}':");
                    ScriptService.this.executionLog.removeWriter();
                    ScriptService.this.scriptLifeCycle.unregister(task.getExecutionId());
                    return;
                }
                ScriptContext scriptContext = ScriptService.this.makeCustomScriptContext(ScriptService.this.executionLog, task);
                ScriptService.this.addReleaseAndPhaseToContext(scriptContext, task);
                try {
                    ScriptService.this.executeScript(script, scriptContext, task.getExecutionId());
                    ScriptService.this.proxyLookup.of(ScriptService.this).saveCustomScriptResults(task.getId(), scriptContext, task.getExecutionId());
                    ScriptService.this.completeTask(ScriptService.this.executionLog, onSuccess, task.getId());
                }
                catch (ScriptException exception) {
                    if (ScriptService.this.isSystemExit0(exception)) {
                        ScriptService.this.proxyLookup.of(ScriptService.this).saveCustomScriptResults(task.getId(), scriptContext, task.getExecutionId());
                        ScriptService.this.completeTask(ScriptService.this.executionLog, onSuccess, task.getId());
                    } else {
                        ScriptService.this.onScriptException(exception, ScriptService.this.executionLog, onFailure, task.getId());
                    }
                }
                catch (Throwable exception) {
                    ScriptService.this.onException(exception, ScriptService.this.executionLog, onFailure, task.getId(), "Exception during execution:\n", "Unexpected exception during execution of script task '{}':");
                }
                finally {
                    ScriptService.this.executionLog.removeWriter();
                    ScriptService.this.scriptLifeCycle.unregister(task.getExecutionId());
                }
            }
        });
    }

    private void addReleaseAndPhaseToContext(ScriptContext scriptContext, Task task) {
        scriptContext.setAttribute("release", (Object)task.getRelease(), 100);
        scriptContext.setAttribute("phase", (Object)task.getPhase(), 100);
        scriptContext.setAttribute("task", (Object)task, 100);
    }

    private boolean isSystemExit0(ScriptException exception) {
        if (!(exception.getCause() instanceof PyException)) {
            return false;
        }
        PyException pyE = (PyException)exception.getCause();
        String pyEtoString = pyE.toString();
        PyType pyET = (PyType)pyE.type;
        String pyETName = pyET.getName();
        return pyETName.equals("SystemExit") && pyEtoString.contains("SystemExit: 0");
    }

    private ScriptContext makeScriptContext(Writer output) {
        SimpleScriptContext context = new SimpleScriptContext();
        context.setWriter(output);
        return context;
    }

    private ScriptContext makeCustomScriptContext(StringWriter executionLog, CustomScriptTask task) {
        ScriptContext scriptContext = this.makeScriptContext(executionLog);
        for (PropertyDescriptor propertyDescriptor : task.getPythonScript().getInputProperties()) {
            String propertyName = propertyDescriptor.getName();
            if (propertyDescriptor.getKind() == PropertyKind.CI) {
                scriptContext.setAttribute(propertyName, this.getPropertiesMap(task, propertyName), 100);
                continue;
            }
            scriptContext.setAttribute(propertyName, task.getPythonScript().getProperty(propertyName), 100);
        }
        return scriptContext;
    }

    private Map<String, Object> getPropertiesMap(CustomScriptTask task, String propertyName) {
        Configuration ciProperty = (Configuration)((Object)task.getPythonScript().getProperty(propertyName));
        Descriptor descriptor = ciProperty.getType().getDescriptor();
        HashMap ciProperties = Maps.newHashMap();
        for (PropertyDescriptor ciPropertyDescriptor : descriptor.getPropertyDescriptors()) {
            ciProperties.put(ciPropertyDescriptor.getName(), ciProperty.getProperty(ciPropertyDescriptor.getName()));
        }
        return ciProperties;
    }

    @Synchronized
    public void saveCustomScriptResults(@ReleaseIdHolder String taskId, ScriptContext scriptContext, String scriptExecutionId) {
        CustomScriptTask task = (CustomScriptTask)this.repositoryService.read(taskId);
        if (!task.isStillExecuting(scriptExecutionId)) {
            logger.debug("Will not save script results of task: '{}' : it has been aborted.", (Object)task.getId());
            return;
        }
        Release release = task.getRelease();
        Collection<PropertyDescriptor> outputProperties = task.getPythonScript().getOutputProperties();
        Map<String, String> releaseVariables = release.getVariableValues();
        for (PropertyDescriptor propertyDescriptor : outputProperties) {
            String propertyName = propertyDescriptor.getName();
            String variableName = (String)task.getPythonScript().getProperty(propertyName);
            Object attr = scriptContext.getAttribute(propertyName);
            if (attr == null) {
                logger.warn("Python script task {} did not return a value for property {}", (Object)taskId, (Object)propertyDescriptor.getName());
                continue;
            }
            String value = attr.toString();
            task.getPythonScript().setProperty(propertyName, value);
            if (Strings.isNullOrEmpty((String)variableName)) {
                logger.debug("Missing output variable on Python script task {} for property {}", (Object)taskId, (Object)propertyDescriptor.getName());
                continue;
            }
            releaseVariables.put(variableName, value);
            this.activityLog.log(Ids.releaseIdFrom(taskId), ReleaseActivity.RELEASE_VARIABLE_UPDATED.create(variableName, value));
        }
        if (!outputProperties.isEmpty()) {
            this.repositoryService.update((ConfigurationItem[])new BaseConfigurationItem[]{release, task, task.getPythonScript()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeScript(String script, ScriptContext scriptContext, String executionId) throws Throwable {
        PermissionCollection permissions = this.getScriptPermissions();
        ScriptExecutor executor = new ScriptExecutor(scriptContext, permissions);
        this.scriptLifeCycle.start(executionId);
        try {
            executor.evalScript(script);
        }
        finally {
            this.scriptLifeCycle.end(executionId);
        }
    }

    private PermissionCollection getScriptPermissions() {
        PolicyFile scriptPolicy = new PolicyFile(ClassLoader.getSystemClassLoader().getResource(SCRIPT_POLICY_FILE));
        return scriptPolicy.getPermissions(new ProtectionDomain(new CodeSource(null, (Certificate[])null), null));
    }

    private void completeTask(StringWriter executionLog, ScriptCallback onSuccess, String taskId) {
        try {
            onSuccess.setExecutionLog(executionLog.toString());
            onSuccess.run();
        }
        catch (Exception exception) {
            logger.warn("Unable to update XL Release task: '{}'", (Object)taskId, (Object)exception);
        }
    }

    private void onScriptException(ScriptException exception, StringWriter executionLog, ScriptCallback onFailure, String taskId) {
        logger.debug("Exception during execution", (Throwable)exception);
        try {
            executionLog.append("Exception during execution:\n");
            executionLog.append(exception.getMessage());
            onFailure.setExecutionLog(executionLog.toString());
            onFailure.run();
        }
        catch (Exception e) {
            logger.warn("Unable to update XL Release task: '{}'", (Object)taskId, (Object)exception);
        }
    }

    private void onException(Throwable exception, StringWriter executionLog, ScriptCallback onFailure, String taskId, String executionLogMessage, String logMessage) {
        logger.warn(logMessage, (Object)taskId, (Object)exception);
        executionLog.append(executionLogMessage);
        executionLog.append(exception.toString());
        onFailure.setExecutionLog(executionLog.toString());
        onFailure.run();
    }
}

