/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.security;

import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.security.PermissionDeniedException;
import com.xebialabs.deployit.security.PermissionEnforcer;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.deployit.security.Role;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.Releases;
import com.xebialabs.xlrelease.repository.Tasks;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PermissionChecker {
    private PermissionEnforcer permissionEnforcer;
    private Releases releases;
    private Tasks tasks;
    private RoleService rolesService;

    @Autowired
    public PermissionChecker(PermissionEnforcer permissionEnforcer, Releases releases, Tasks tasks, RoleService rolesService) {
        this.permissionEnforcer = permissionEnforcer;
        this.releases = releases;
        this.tasks = tasks;
        this.rolesService = rolesService;
    }

    public void check(Permission permission) {
        if (!this.hasGlobalPermission(permission)) {
            String configurationItemId = null;
            throw PermissionDeniedException.forPermission((Permission)permission, configurationItemId);
        }
    }

    public void check(Permission permission, String releaseId) {
        if (!this.hasPermission(permission, releaseId)) {
            throw PermissionDeniedException.forPermission((Permission)permission, (String)releaseId);
        }
    }

    public void checkAny(String releaseId, Permission ... permissions) {
        for (Permission permission : permissions) {
            if (!this.hasPermission(permission, releaseId)) continue;
            return;
        }
        throw this.exceptionForPermissions(releaseId, permissions);
    }

    private PermissionDeniedException exceptionForPermissions(String releaseId, Permission[] permissions) {
        PermissionDeniedException exception = new PermissionDeniedException();
        exception.add("Permission %s on %s is not granted to you", new Object[]{Joiner.on((String)" or ").join((Object[])permissions), releaseId});
        return exception;
    }

    public void check(Permission permission, List<String> releaseIds) {
        for (String configurationItemId : releaseIds) {
            this.check(permission, configurationItemId);
        }
    }

    public void checkView(String releaseId) {
        Release release = this.releases.findById(releaseId);
        Permission permissionToCheck = this.getViewPermission(release);
        this.check(permissionToCheck, releaseId);
    }

    public void checkEditPlanItem(String planItemId) {
        if (Ids.isReleaseId(planItemId) || Ids.isPhaseId(planItemId)) {
            this.checkEdit(Ids.releaseIdFrom(planItemId));
        } else {
            this.checkEditTask(Ids.releaseIdFrom(planItemId));
        }
    }

    public void checkEdit(String releaseId) {
        Release release = this.releases.findById(releaseId);
        Permission permissionToCheck = release.isTemplate() ? XLReleasePermissions.EDIT_TEMPLATE : XLReleasePermissions.EDIT_RELEASE;
        this.check(permissionToCheck, releaseId);
    }

    public void checkEditTask(String releaseId) {
        Release release = this.releases.findById(releaseId);
        Permission permissionToCheck = release.isTemplate() ? XLReleasePermissions.EDIT_TEMPLATE : XLReleasePermissions.EDIT_RELEASE_TASK;
        this.check(permissionToCheck, releaseId);
    }

    public void checkReassignTask(String releaseId) {
        Release release = this.releases.findById(releaseId);
        Permission permissionToCheck = release.isTemplate() ? XLReleasePermissions.EDIT_TEMPLATE : XLReleasePermissions.REASSIGN_RELEASE_TASK;
        this.check(permissionToCheck, releaseId);
    }

    public void checkEditOrReassignTask(String releaseId) {
        Release release = this.releases.findById(releaseId);
        Permission edit = release.isTemplate() ? XLReleasePermissions.EDIT_TEMPLATE : XLReleasePermissions.EDIT_RELEASE_TASK;
        Permission reassign = release.isTemplate() ? XLReleasePermissions.EDIT_TEMPLATE : XLReleasePermissions.REASSIGN_RELEASE_TASK;
        this.checkAny(releaseId, edit, reassign);
    }

    public void checkIsReleaseOwner(String releaseId) {
        if (this.hasGlobalPermission(PlatformPermissions.ADMIN)) {
            return;
        }
        String username = Permissions.getAuthenticatedUserName();
        Release release = this.releases.findById(releaseId);
        if (!release.hasOwner(username)) {
            throw PermissionDeniedException.forNodeAndPrivilege((String)releaseId, (String)"Release owner");
        }
    }

    public void checkIsAllowedToWorkOnTask(String taskId) {
        Task task = this.tasks.findById(taskId);
        if (!task.isUpdatable()) {
            throw new IllegalArgumentException("You can not work with a defunct or done in advance task");
        }
        if (this.hasGlobalPermission(PlatformPermissions.ADMIN) || this.hasGlobalPermission(XLReleasePermissions.EDIT_RELEASE_TASK) || this.owns(task)) {
            return;
        }
        Release release = this.releases.findById(Ids.releaseIdFrom(taskId));
        if (this.hasReleasePermission(XLReleasePermissions.EDIT_RELEASE_TASK, release)) {
            return;
        }
        String teamName = task.getTeam();
        if (this.isMemberOf(release, teamName) || this.hasRoleIn(release, teamName)) {
            return;
        }
        throw PermissionDeniedException.forNodeAndPrivilege((String)taskId, (String)"'Task owner', 'Member of task team' or 'edit task'");
    }

    public List<Release> filter(List<Release> items, final Permission permission) {
        Predicate<Release> isGranted = new Predicate<Release>(){

            public boolean apply(Release candidate) {
                return PermissionChecker.this.hasPermission(permission, candidate.getId());
            }
        };
        return Lists.newArrayList((Iterable)Collections2.filter(items, (Predicate)isGranted));
    }

    public List<ConfigurationItem> filterViewables(List<ConfigurationItem> configurationItems) {
        Predicate<ConfigurationItem> isGranted = new Predicate<ConfigurationItem>(){

            public boolean apply(ConfigurationItem configurationItem) {
                if (!(configurationItem instanceof Release)) {
                    return false;
                }
                return PermissionChecker.this.hasPermission(PermissionChecker.this.getViewPermission((Release)configurationItem), configurationItem.getId());
            }
        };
        return Lists.newArrayList((Iterable)Collections2.filter(configurationItems, (Predicate)isGranted));
    }

    public void checkIsAllowedToCreateReleaseFromTemplate(String templateId) {
        boolean isAllowed;
        if (this.hasGlobalPermission(PlatformPermissions.ADMIN)) {
            return;
        }
        Release template = this.releases.findById(templateId);
        boolean bl = isAllowed = this.hasReleasePermission(XLReleasePermissions.VIEW_TEMPLATE, template) && (this.hasGlobalPermission(XLReleasePermissions.CREATE_RELEASE) || this.hasReleasePermission(XLReleasePermissions.CREATE_RELEASE_FROM_TEMPLATE, template));
        if (!isAllowed) {
            throw PermissionDeniedException.forNodeAndPrivilege((String)templateId, (String)"'View template' and ('Create release' or 'Create release from template')");
        }
    }

    public void checkEditSecurity(String releaseId) {
        if (this.hasGlobalPermission(PlatformPermissions.ADMIN) || this.hasGlobalPermission(XLReleasePermissions.EDIT_SECURITY)) {
            return;
        }
        Release release = this.releases.findById(releaseId);
        Permission permissionToCheck = release.isTemplate() ? XLReleasePermissions.EDIT_TEMPLATE_SECURITY : XLReleasePermissions.EDIT_RELEASE_SECURITY;
        this.check(permissionToCheck, releaseId);
    }

    private boolean hasReleasePermission(Permission permission, Release release) {
        String username = Permissions.getAuthenticatedUserName();
        List userRoles = this.rolesService.getRolesFor(username);
        return release.hasPermission(username, (List<Role>)userRoles, permission);
    }

    private boolean hasGlobalPermission(Permission permission) {
        return this.permissionEnforcer.hasLoggedInUserPermission(new Permission[]{permission});
    }

    public boolean hasPermission(Permission permission, String releaseId) {
        return this.hasGlobalPermission(permission) || this.hasReleasePermission(permission, this.releases.findById(releaseId));
    }

    private boolean isMemberOf(Release release, String team) {
        return release.isMemberOfTeam(team, Permissions.getAuthenticatedUserName()) || release.isMemberOfTeam("Release Admin", Permissions.getAuthenticatedUserName());
    }

    private boolean hasRoleIn(Release release, String teamName) {
        String username = Permissions.getAuthenticatedUserName();
        List roles = this.rolesService.getRolesFor(username);
        for (Role role : roles) {
            if (!release.isRoleOfTeam(teamName, role.getName())) continue;
            return true;
        }
        return false;
    }

    private boolean owns(Task task) {
        return task.hasOwner(Permissions.getAuthenticatedUserName());
    }

    private Permission getViewPermission(Release release) {
        return release.isTemplate() ? XLReleasePermissions.VIEW_TEMPLATE : XLReleasePermissions.VIEW_RELEASE;
    }
}

