/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.security;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.deployit.security.permission.PermissionHandler;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import java.util.ArrayList;
import java.util.List;

public class XLReleasePermissions
extends PlatformPermissions {
    public static final Permission CREATE_TEMPLATE = Permission.definePermission((String)"template#create", (PermissionHandler.Level)PermissionHandler.Level.GLOBAL);
    public static final Permission CREATE_RELEASE = Permission.definePermission((String)"release#create", (PermissionHandler.Level)PermissionHandler.Level.GLOBAL);
    public static final Permission VIEW_REPORTS = Permission.definePermission((String)"reports#view", (PermissionHandler.Level)PermissionHandler.Level.GLOBAL);
    public static final Permission CREATE_RELEASE_FROM_TEMPLATE = Permission.definePermission((String)"template#create_release", (PermissionHandler.Level)PermissionHandler.Level.CI, (Metadata.ConfigurationItemRoot)Metadata.ConfigurationItemRoot.APPLICATIONS, (boolean)true);
    public static final Permission VIEW_TEMPLATE = Permission.definePermission((String)"template#view", (PermissionHandler.Level)PermissionHandler.Level.CI, (Metadata.ConfigurationItemRoot)Metadata.ConfigurationItemRoot.APPLICATIONS, (boolean)true);
    public static final Permission EDIT_TEMPLATE = Permission.definePermission((String)"template#edit", (PermissionHandler.Level)PermissionHandler.Level.CI, (Metadata.ConfigurationItemRoot)Metadata.ConfigurationItemRoot.APPLICATIONS, (boolean)true);
    public static final Permission EDIT_TEMPLATE_SECURITY = Permission.definePermission((String)"template#edit_security", (PermissionHandler.Level)PermissionHandler.Level.CI, (Metadata.ConfigurationItemRoot)Metadata.ConfigurationItemRoot.APPLICATIONS, (boolean)true);
    public static final Permission VIEW_RELEASE = Permission.definePermission((String)"release#view", (PermissionHandler.Level)PermissionHandler.Level.CI, (Metadata.ConfigurationItemRoot)Metadata.ConfigurationItemRoot.APPLICATIONS, (boolean)true);
    public static final Permission EDIT_RELEASE = Permission.definePermission((String)"release#edit", (PermissionHandler.Level)PermissionHandler.Level.CI, (Metadata.ConfigurationItemRoot)Metadata.ConfigurationItemRoot.APPLICATIONS, (boolean)true);
    public static final Permission EDIT_RELEASE_SECURITY = Permission.definePermission((String)"release#edit_security", (PermissionHandler.Level)PermissionHandler.Level.CI, (Metadata.ConfigurationItemRoot)Metadata.ConfigurationItemRoot.APPLICATIONS, (boolean)true);
    public static final Permission START_RELEASE = Permission.definePermission((String)"release#start", (PermissionHandler.Level)PermissionHandler.Level.CI, (Metadata.ConfigurationItemRoot)Metadata.ConfigurationItemRoot.APPLICATIONS, (boolean)true);
    public static final Permission ABORT_RELEASE = Permission.definePermission((String)"release#abort", (PermissionHandler.Level)PermissionHandler.Level.CI, (Metadata.ConfigurationItemRoot)Metadata.ConfigurationItemRoot.APPLICATIONS, (boolean)true);
    public static final Permission EDIT_RELEASE_TASK = Permission.definePermission((String)"release#edit_task", (PermissionHandler.Level)PermissionHandler.Level.CI, (Metadata.ConfigurationItemRoot)Metadata.ConfigurationItemRoot.APPLICATIONS, (boolean)true);
    public static final Permission REASSIGN_RELEASE_TASK = Permission.definePermission((String)"release#reassign_task", (PermissionHandler.Level)PermissionHandler.Level.CI, (Metadata.ConfigurationItemRoot)Metadata.ConfigurationItemRoot.APPLICATIONS, (boolean)true);

    public static void init() {
    }

    public static List<String> getGlobalPermissions() {
        ArrayList permissions = Lists.newArrayList();
        for (Permission permission : Permission.getAll()) {
            if (permission.getLevel() != PermissionHandler.Level.GLOBAL || permission.equals((Object)PlatformPermissions.LOGIN)) continue;
            permissions.add(permission.getPermissionName());
        }
        return permissions;
    }

    public static List<String> getTemplatePermissions() {
        return XLReleasePermissions.getLocalPermissions(true, true);
    }

    public static List<String> getReleasePermissions() {
        return XLReleasePermissions.getLocalPermissions(false, true);
    }

    public static List<String> getTemplateOnlyPermissions() {
        return XLReleasePermissions.getLocalPermissions(true, false);
    }

    private static List<String> getLocalPermissions(boolean withTemplatePermissions, boolean withReleasePermissions) {
        ArrayList permissions = Lists.newArrayList();
        for (Permission permission : Permission.getAll()) {
            boolean isATemplatePermission;
            if (permission.getLevel() != PermissionHandler.Level.CI || permission.getRoot() != Metadata.ConfigurationItemRoot.APPLICATIONS || ((isATemplatePermission = XLReleasePermissions.isTemplatePermission(permission)) || !withReleasePermissions) && (!isATemplatePermission || !withTemplatePermissions)) continue;
            permissions.add(permission.getPermissionName());
        }
        return permissions;
    }

    private static boolean isTemplatePermission(Permission permission) {
        return permission.getPermissionName().startsWith("template");
    }
}

