/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.google.common.base.Strings;
import com.xebialabs.deployit.booter.local.utils.Closeables;
import com.xebialabs.deployit.booter.remote.BooterConfig;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.engine.api.dto.Deployment;
import com.xebialabs.deployit.engine.api.execution.TaskExecutionState;
import com.xebialabs.deployit.engine.api.execution.TaskWithSteps;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.DeployedApplication;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plumbing.remote.DeployitConnection;
import com.xebialabs.deployit.plumbing.remote.DeployitConnectionFactory;
import com.xebialabs.deployit.plumbing.scheduler.Scheduler;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.xlrelease.concurrent.ReleaseIdHolder;
import com.xebialabs.xlrelease.concurrent.Synchronized;
import com.xebialabs.xlrelease.configuration.DeployitServerDefinition;
import com.xebialabs.xlrelease.domain.DeployitTask;
import com.xebialabs.xlrelease.repository.Comments;
import com.xebialabs.xlrelease.repository.DeployitServers;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.service.ProxyLookup;
import com.xebialabs.xlrelease.user.User;
import java.io.Closeable;
import java.net.URI;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.MessageFormatter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DeploymentService {
    private static final int DEPLOYIT_POLLING_INTERVAL_IN_SECONDS = 2;
    private static final int FAILED_CONNECTION_RETRY_INTERVAL_IN_SECONDS = 60;
    private DeployitServers servers;
    private RepositoryService repositoryService;
    private DeployitConnectionFactory connections;
    private Scheduler scheduler;
    private Comments comments;
    private ProxyLookup proxyLookup;
    private static final Logger logger = LoggerFactory.getLogger(DeploymentService.class);

    @Autowired
    public DeploymentService(DeployitServers servers, RepositoryService repositoryService, DeployitConnectionFactory connections, Scheduler scheduler, Comments comments, ProxyLookup proxyLookup) {
        this.servers = servers;
        this.repositoryService = repositoryService;
        this.connections = connections;
        this.scheduler = scheduler;
        this.comments = comments;
        this.proxyLookup = proxyLookup;
    }

    public DeploymentService() {
    }

    public void deployAsynchronously(final DeployitTask task, final Runnable onSuccess, final Runnable onFailure, final Runnable onException) {
        this.scheduler.execute(new Runnable(){

            @Override
            public void run() {
                String deployitTaskId;
                DeployitServerDefinition deployitServer;
                DeployitConnection deployit = null;
                try {
                    DeploymentService.this.ensureDeployitPropertiesFilled(task);
                    deployitServer = DeploymentService.this.servers.findById(task.getServer());
                    if (task.getDeployitTaskId() == null) {
                        deployit = DeploymentService.this.connectToDeployit(deployitServer, task);
                        deployitTaskId = DeploymentService.this.prepareOrResumeDeployment(task, deployit);
                    } else {
                        deployitTaskId = task.getDeployitTaskId();
                        DeploymentService.this.proxyLookup.of(DeploymentService.this).logMessage(task.getId(), "Resuming Deployment Task: '{}'", deployitTaskId);
                    }
                }
                catch (Exception e) {
                    DeploymentService.this.handleException(task.getId(), deployit, onException, "Deployment of task: '{}' failed : [{}]", new Object[]{task.getId(), e.getMessage(), e});
                    return;
                }
                PollProcess pollProcess = new PollProcess(task, deployit, deployitServer, deployitTaskId, true, onSuccess, onFailure);
                pollProcess.start();
            }
        });
    }

    public void rollbackAsynchronously(final String taskId) {
        this.scheduler.execute(new Runnable(){

            @Override
            public void run() {
                String rollbackTaskId;
                DeployitServerDefinition deployitServer;
                DeployitTask task;
                DeployitConnection deployit = null;
                try {
                    task = (DeployitTask)DeploymentService.this.repositoryService.read(taskId);
                    DeploymentService.this.proxyLookup.of(DeploymentService.this).logMessage(taskId, "Starting Rollback of Deployit Task: '{}'", task.getDeployitTaskId());
                    deployitServer = DeploymentService.this.servers.findById(task.getServer());
                    deployit = DeploymentService.this.connectToDeployit(deployitServer, task);
                    rollbackTaskId = deployit.getDeploymentService().rollback(task.getDeployitTaskId());
                }
                catch (Exception e) {
                    DeploymentService.this.handleException(taskId, deployit, null, "Rolling back of task: '{}' failed.", new Object[]{taskId, e});
                    return;
                }
                RollbackResultHandler onRollbackSuccess = new RollbackResultHandler(taskId, "Completed Rollback: Deployit Task: '" + rollbackTaskId + "'");
                RollbackResultHandler onRollbackFailure = new RollbackResultHandler(taskId, "Failed Rollback: Deployit Task: '" + rollbackTaskId + "'");
                PollProcess pollProcess = new PollProcess(task, deployit, deployitServer, rollbackTaskId, false, onRollbackSuccess, onRollbackFailure);
                pollProcess.start();
            }
        });
    }

    private void ensureDeployitPropertiesFilled(DeployitTask task) {
        if (Strings.isNullOrEmpty((String)task.getServer()) || Strings.isNullOrEmpty((String)task.getDeploymentPackage()) || Strings.isNullOrEmpty((String)task.getEnvironment())) {
            throw new Checks.MissingArgumentException("Deployment package or environment");
        }
    }

    private DeployitConnection connectToDeployit(DeployitServerDefinition deployitServer, DeployitTask task) {
        BooterConfig booterConfig = this.getBooterConfig(task, deployitServer);
        return this.connections.connect(booterConfig);
    }

    private String prepareOrResumeDeployment(DeployitTask taskDefinition, DeployitConnection deployit) {
        Deployment deployment;
        if (taskDefinition.getDeployitTaskId() != null) {
            return taskDefinition.getDeployitTaskId();
        }
        String environmentId = Metadata.ConfigurationItemRoot.ENVIRONMENTS.getRootNodeName() + "/" + taskDefinition.getEnvironment();
        String packageId = Metadata.ConfigurationItemRoot.APPLICATIONS.getRootNodeName() + "/" + taskDefinition.getDeploymentPackage();
        String applicationName = DeploymentService.getApplicationName(taskDefinition.getDeploymentPackage());
        List deployedApplications = deployit.getRepositoryService().query(Type.valueOf(DeployedApplication.class), environmentId, null, applicationName, null, null, -1L, -1L);
        if (deployedApplications.isEmpty()) {
            deployment = deployit.getDeploymentService().prepareInitial(packageId, environmentId);
            deployment = deployit.getDeploymentService().generateAllDeployeds(deployment);
            this.proxyLookup.of(this).logMessage(taskDefinition.getId(), "Prepared Initial Deployment", new Object[0]);
        } else {
            deployment = deployit.getDeploymentService().prepareUpdate(packageId, environmentId + "/" + applicationName);
            this.proxyLookup.of(this).logMessage(taskDefinition.getId(), "Prepared Update Deployment", new Object[0]);
        }
        String deployitTaskId = deployit.getDeploymentService().createTask(deployment);
        this.proxyLookup.of(this).logMessage(taskDefinition.getId(), "Created Deployment Task: '{}'", deployitTaskId);
        this.proxyLookup.of(this).updateDeployitTaskId(taskDefinition.getId(), deployitTaskId);
        return deployitTaskId;
    }

    @Synchronized
    public void updateDeployitTaskId(@ReleaseIdHolder String taskDefinitionId, String deployitTaskId) {
        DeployitTask task = (DeployitTask)this.repositoryService.read(taskDefinitionId);
        task.setDeployitTaskId(deployitTaskId);
        this.repositoryService.update((ConfigurationItem[])new DeployitTask[]{task});
    }

    private static String getApplicationName(String packageId) {
        return Ids.getName(Ids.getParentId(packageId));
    }

    private void startTaskIfInactive(TaskExecutionState state, DeployitConnection deployit, String deployitTaskId, DeployitTask task) {
        if (state == TaskExecutionState.PENDING) {
            deployit.getTaskService().start(deployitTaskId);
            this.proxyLookup.of(this).logMessage(task.getId(), "Started Deployit Task: '{}'", deployitTaskId);
        }
    }

    private void archiveTaskIfExecuted(TaskWithSteps taskWithSteps, DeployitConnection deployit, String deployitTaskId) {
        if (taskWithSteps.getState() == TaskExecutionState.EXECUTED) {
            deployit.getTaskService().archive(deployitTaskId);
        }
    }

    private void handleException(String deployitTaskId, DeployitConnection deployit, Runnable onException, String logMessage, Object ... params) {
        this.proxyLookup.of(this).logMessage(deployitTaskId, logMessage, params);
        Closeables.closeQuietly((Closeable)deployit);
        if (null != onException) {
            onException.run();
        }
    }

    private BooterConfig getBooterConfig(DeployitTask task, DeployitServerDefinition deployitServer) {
        if (task.hasCredentials()) {
            URI uri = deployitServer.toUri();
            return BooterConfig.builder().withHost(uri.getHost()).withPort(uri.getPort()).withContext(uri.getPath()).withCredentials(task.getUsername(), task.getPassword()).build();
        }
        return deployitServer.getBooterConfig();
    }

    @Synchronized
    public void updateTaskProgress(@ReleaseIdHolder String taskId, TaskWithSteps taskWithSteps) {
        try {
            DeployitTask task = (DeployitTask)this.repositoryService.read(taskId);
            int currentStep = taskWithSteps.getCurrentStepNr();
            int nrSteps = taskWithSteps.getNrSteps();
            if (taskWithSteps.getState() == TaskExecutionState.EXECUTING && (task.getCurrentStep() != currentStep || task.getTotalStep() != nrSteps)) {
                task.setCurrentStep(currentStep);
                task.setTotalStep(nrSteps);
                task.setCurrentStepTitle(taskWithSteps.getStep(currentStep).getDescription());
                this.repositoryService.update((ConfigurationItem[])new DeployitTask[]{task});
            }
        }
        catch (Exception exception) {
            logger.warn(this.prefixWithTaskId(taskId, "Unable to update XL Release task"), (Object)exception.getMessage(), (Object)exception);
        }
    }

    @Synchronized
    public void logMessage(@ReleaseIdHolder String taskId, String format, Object ... params) {
        try {
            logger.info(this.prefixWithTaskId(taskId, format), params);
            String message = MessageFormatter.arrayFormat((String)format, (Object[])params).getMessage();
            this.comments.create(taskId, message, User.LOG_OUTPUT, false);
        }
        catch (Exception exception) {
            logger.warn(this.prefixWithTaskId(taskId, "Unable to add comment on XL Release Task."), (Object)exception.getMessage(), (Object)exception);
        }
    }

    private String prefixWithTaskId(String taskId, String message) {
        return "Task: [" + taskId + "] " + message;
    }

    private class PollProcess
    implements Runnable {
        private final DeployitTask taskDefinition;
        private DeployitConnection deployit;
        private final DeployitServerDefinition deployitServer;
        private final String deployitTaskId;
        private final boolean updateTaskProgress;
        private final Runnable onCompletion;
        private final Runnable onFailure;
        private boolean errorOnAccess = false;

        public PollProcess(DeployitTask taskDefinition, DeployitConnection deployit, DeployitServerDefinition deployitServer, String deployitTaskId, boolean updateTaskProgress, Runnable onCompletion, Runnable onFailure) {
            this.taskDefinition = taskDefinition;
            this.deployit = deployit;
            this.deployitServer = deployitServer;
            this.deployitTaskId = deployitTaskId;
            this.updateTaskProgress = updateTaskProgress;
            this.onCompletion = onCompletion;
            this.onFailure = onFailure;
        }

        public void start() {
            DeploymentService.this.scheduler.scheduleAtFixedRate(this, 0L, 2L, TimeUnit.SECONDS);
        }

        @Override
        public void run() {
            TaskExecutionState state;
            TaskWithSteps taskWithSteps;
            try {
                if (this.deployit == null) {
                    this.deployit = DeploymentService.this.connectToDeployit(this.deployitServer, this.taskDefinition);
                }
                taskWithSteps = this.deployit.getTaskService().getSteps(this.deployitTaskId);
                this.logNoMoreErrorOnAccess(taskWithSteps.getState());
                DeploymentService.this.startTaskIfInactive(taskWithSteps.getState(), this.deployit, this.deployitTaskId, this.taskDefinition);
                DeploymentService.this.archiveTaskIfExecuted(taskWithSteps, this.deployit, this.deployitTaskId);
            }
            catch (Exception exception) {
                this.logErrorOnAccess(exception);
                Closeables.closeQuietly((Closeable)this.deployit);
                this.deployit = null;
                DeploymentService.this.scheduler.cancel(this);
                DeploymentService.this.scheduler.scheduleAtFixedRate(this, 60L, 2L, TimeUnit.SECONDS);
                return;
            }
            if (this.updateTaskProgress) {
                DeploymentService.this.proxyLookup.of(DeploymentService.this).updateTaskProgress(this.taskDefinition.getId(), taskWithSteps);
            }
            if (this.pollingComplete(state = taskWithSteps.getState())) {
                this.stopPolling(state);
            }
        }

        private void logNoMoreErrorOnAccess(TaskExecutionState state) {
            if (this.errorOnAccess) {
                DeploymentService.this.proxyLookup.of(DeploymentService.this).logMessage(this.taskDefinition.getId(), "Connection to Deployit '{}' is back. Deployment State : '{}'", new Object[]{this.deployitServer, state});
            }
            this.errorOnAccess = false;
        }

        private void logErrorOnAccess(Exception exception) {
            String format = "Error when accessing deployit server '{}' : [{}]. Retrying in {} seconds";
            if (this.errorOnAccess) {
                logger.warn(DeploymentService.this.prefixWithTaskId(this.taskDefinition.getId(), format), new Object[]{this.deployitServer, exception.getMessage(), 60, exception});
            } else {
                DeploymentService.this.proxyLookup.of(DeploymentService.this).logMessage(this.taskDefinition.getId(), format, new Object[]{this.deployitServer, exception.getMessage(), 60, exception});
            }
            this.errorOnAccess = true;
        }

        private boolean pollingComplete(TaskExecutionState state) {
            return state == TaskExecutionState.DONE || state == TaskExecutionState.EXECUTED || state == TaskExecutionState.STOPPED || state == TaskExecutionState.CANCELLED;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void stopPolling(TaskExecutionState state) {
            try {
                if (state == TaskExecutionState.EXECUTED || state == TaskExecutionState.DONE) {
                    this.onCompletion.run();
                    DeploymentService.this.proxyLookup.of(DeploymentService.this).logMessage(this.taskDefinition.getId(), "Completed Deployit Task: '{}' State: '{}'", this.deployitTaskId, state);
                }
                if (state == TaskExecutionState.STOPPED || state == TaskExecutionState.CANCELLED) {
                    DeploymentService.this.proxyLookup.of(DeploymentService.this).logMessage(this.taskDefinition.getId(), "Failed Deployit Task: '{}' State: '{}'", this.deployitTaskId, state);
                    this.onFailure.run();
                }
            }
            catch (Exception exception) {
                logger.warn(DeploymentService.this.prefixWithTaskId(this.taskDefinition.getId(), "Unable to update XL Release task on Deployit completion/failure : []"), (Object)exception.getMessage(), (Object)exception);
            }
            finally {
                Closeables.closeQuietly((Closeable)this.deployit);
                DeploymentService.this.scheduler.cancel(this);
            }
        }
    }

    private class RollbackResultHandler
    implements Runnable {
        private String taskId;
        private String logMessage;

        public RollbackResultHandler(String taskId, String logMessage) {
            this.taskId = taskId;
            this.logMessage = logMessage;
        }

        @Override
        public void run() {
            DeploymentService.this.proxyLookup.of(DeploymentService.this).logMessage(this.taskId, this.logMessage, new Object[0]);
        }
    }
}

