/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.jcr.JcrCallback;
import com.xebialabs.deployit.jcr.JcrTemplate;
import com.xebialabs.deployit.security.JcrUserService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Query;
import org.apache.jackrabbit.api.security.user.QueryBuilder;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class JcrUsers {
    private JcrTemplate jcrTemplate;
    private JcrUserService jcrUserService;

    @Autowired
    public JcrUsers(JcrTemplate jcrTemplate, JcrUserService jcrUserService) {
        this.jcrTemplate = jcrTemplate;
        this.jcrUserService = jcrUserService;
    }

    public List<String> getJcrUsernames() {
        return (List)this.jcrTemplate.execute((JcrCallback)new JcrCallback<List<String>>(){

            public List<String> doInJcr(Session session) throws RepositoryException {
                UserManager um = ((JackrabbitSession)session).getUserManager();
                Iterator authorizables = um.findAuthorizables(new Query(){

                    public <T> void build(QueryBuilder<T> builder) {
                        builder.setSelector(User.class);
                    }
                });
                ArrayList<String> names = new ArrayList<String>();
                while (authorizables.hasNext()) {
                    String name = ((Authorizable)authorizables.next()).getPrincipal().getName();
                    if ("anonymous".equals(name)) continue;
                    names.add(name);
                }
                return names;
            }
        });
    }

    public boolean userExistsInJcr(String username) {
        try {
            this.jcrUserService.read(username);
            return true;
        }
        catch (NotFoundException e) {
            return false;
        }
    }
}

