/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Lists;
import com.xebialabs.xlrelease.domain.ActivityCategory;
import com.xebialabs.xlrelease.domain.ActivityLogEntry;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.ReleaseActivity;
import com.xebialabs.xlrelease.repository.Releases;
import com.xebialabs.xlrelease.repository.UserProfiles;
import com.xebialabs.xlrelease.views.LogsFilters;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LogsService {
    private Releases releases;
    private UserProfiles userProfiles;

    @Autowired
    public LogsService(Releases releases, UserProfiles userProfiles) {
        this.releases = releases;
        this.userProfiles = userProfiles;
    }

    public List<ActivityLogEntry> getFilteredLogs(String releaseId, LogsFilters filters) {
        Release release = this.releases.findById(releaseId);
        return FluentIterable.from(release.getActivityLogEntries()).filter(this.matches(filters.getFilter())).filter(this.between(filters.getFrom(), filters.getTo())).filter(this.withCategories(filters)).toSortedList(filters.isDateAsc() ? ActivityLogEntry.BY_EVENT_TIME : Collections.reverseOrder(ActivityLogEntry.BY_EVENT_TIME));
    }

    private Predicate<ActivityLogEntry> matches(final String filter) {
        return new Predicate<ActivityLogEntry>(){

            public boolean apply(ActivityLogEntry logEntry) {
                return filter == null || this.matches(logEntry.getMessage()) || this.matches(logEntry.getUsername()) || this.matches(LogsService.this.userProfiles.getFullName(logEntry.getUsername()));
            }

            private boolean matches(String text) {
                return text != null && text.toLowerCase().contains(filter.toLowerCase());
            }
        };
    }

    private Predicate<ActivityLogEntry> between(final Date from, final Date to) {
        return new Predicate<ActivityLogEntry>(){

            public boolean apply(ActivityLogEntry logEntry) {
                if (from == null && to == null) {
                    return true;
                }
                if (from == null) {
                    return logEntry.getEventTime().before(to) || logEntry.getEventTime().equals(to);
                }
                if (to == null) {
                    return logEntry.getEventTime().after(from) || logEntry.getEventTime().equals(from);
                }
                return !(!logEntry.getEventTime().after(from) && !logEntry.getEventTime().equals(from) || !logEntry.getEventTime().before(to) && !logEntry.getEventTime().equals(to));
            }
        };
    }

    private Predicate<ActivityLogEntry> withCategories(LogsFilters filters) {
        final ArrayList allowedCategories = Lists.newArrayList();
        if (filters.withImportant()) {
            allowedCategories.add(ActivityCategory.IMPORTANT);
        }
        if (filters.withReleaseEdit()) {
            allowedCategories.add(ActivityCategory.RELEASE_EDIT);
        }
        if (filters.withTaskEdit()) {
            allowedCategories.add(ActivityCategory.TASK_EDIT);
        }
        if (filters.withComments()) {
            allowedCategories.add(ActivityCategory.COMMENTS);
        }
        if (filters.withLifecycle()) {
            allowedCategories.add(ActivityCategory.LIFECYCLE);
        }
        if (filters.withReassign()) {
            allowedCategories.add(ActivityCategory.REASSIGN);
        }
        if (filters.withSecurity()) {
            allowedCategories.add(ActivityCategory.SECURITY);
        }
        if (filters.withOther()) {
            allowedCategories.add(ActivityCategory.OTHER);
        }
        return new Predicate<ActivityLogEntry>(){

            public boolean apply(ActivityLogEntry logEntry) {
                Set<ActivityCategory> activityCategories = ReleaseActivity.safeValueOf(logEntry.getActivityType()).getCategories();
                for (ActivityCategory activityCategory : activityCategories) {
                    if (!allowedCategories.contains((Object)activityCategory)) continue;
                    return true;
                }
                return false;
            }
        };
    }
}

