/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xebialabs.xlrelease.reports.Duration;
import com.xebialabs.xlrelease.reports.NumberByMonthComputer;
import com.xebialabs.xlrelease.reports.PhaseDuration;
import com.xebialabs.xlrelease.reports.ReleaseAutomationComputer;
import com.xebialabs.xlrelease.reports.ReleaseAutomationData;
import com.xebialabs.xlrelease.reports.ReleasesAutomation;
import com.xebialabs.xlrelease.reports.ReleasesDuration;
import com.xebialabs.xlrelease.reports.ReleasesDurationComputer;
import com.xebialabs.xlrelease.reports.TaskDuration;
import com.xebialabs.xlrelease.reports.TaskWithReleaseData;
import com.xebialabs.xlrelease.reports.TopSorter;
import com.xebialabs.xlrelease.reports.UserParticipation;
import com.xebialabs.xlrelease.reports.UserTask;
import com.xebialabs.xlrelease.repository.Reports;
import com.xebialabs.xlrelease.views.Point;
import com.xebialabs.xlrelease.views.TimeFrame;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ReportService {
    public static final int TOP_REPORT_SIZE = 100;
    private Reports reports;

    @Autowired
    public ReportService(Reports reports) {
        this.reports = reports;
    }

    public ReleasesDuration getReleaseDuration(TimeFrame timeFrame, Iterable<String> tags, Date from, Date to) {
        return new ReleasesDurationComputer(this.reports.getReleasesDuration(timeFrame, tags, from, to)).get();
    }

    public List<UserParticipation> getTopPeopleMostInvolved(TimeFrame timeFrame, Iterable<String> tags, Date from, Date to) {
        List<UserTask> tasks = this.reports.getUsersTasks(timeFrame, tags, from, to);
        Comparator<UserParticipation> userParticipationComparator = new Comparator<UserParticipation>(){

            @Override
            public int compare(UserParticipation userParticipation1, UserParticipation userParticipation2) {
                return Float.compare(userParticipation2.getTimeSpent(), userParticipation1.getTimeSpent());
            }
        };
        return new TopSorter<UserParticipation>(this.getUserParticipations(tasks), 100).with(userParticipationComparator);
    }

    public List<TaskDuration> getTopLongestTasks(TimeFrame timeFrame, Iterable<String> tags, Date from, Date to) {
        List<TaskDuration> tasks = this.reports.getTasksDuration(timeFrame, tags, from, to);
        Comparator<TaskDuration> taskDurationComparator = new Comparator<TaskDuration>(){

            @Override
            public int compare(TaskDuration taskDuration1, TaskDuration taskDuration2) {
                return Float.compare(taskDuration2.getDuration(), taskDuration1.getDuration());
            }
        };
        return new TopSorter<TaskDuration>(tasks, 100).with(taskDurationComparator);
    }

    public ReleasesAutomation getReleaseAutomationSeries(TimeFrame timeFrame, Iterable<String> tags, Date from, Date to) {
        return new ReleaseAutomationComputer(this.getReleaseAutomation(timeFrame, tags, from, to, null)).get();
    }

    public List<PhaseDuration> getTopLongestPhases(TimeFrame timeFrame, Iterable<String> tags, Date from, Date to) {
        List<PhaseDuration> phases = this.reports.getPhasesDuration(timeFrame, tags, from, to);
        Comparator<PhaseDuration> phaseDurationComparator = new Comparator<PhaseDuration>(){

            @Override
            public int compare(PhaseDuration phaseDuration1, PhaseDuration phaseDuration2) {
                return Float.compare(phaseDuration2.getDuration(), phaseDuration1.getDuration());
            }
        };
        return new TopSorter<PhaseDuration>(phases, 100).with(phaseDurationComparator);
    }

    public List<Point> getNumberOfReleaseByMonth(TimeFrame timeFrame, Iterable<String> tags, Date from, Date to) {
        List<DateTime> releasesEndDate = this.reports.getReleasesEndDate(timeFrame, tags, from, to);
        if (releasesEndDate.isEmpty()) {
            return Lists.newArrayList();
        }
        NumberByMonthComputer releaseByMonthComputer = new NumberByMonthComputer(releasesEndDate.get(0));
        for (DateTime releaseEndDate : releasesEndDate) {
            releaseByMonthComputer.add(releaseEndDate);
        }
        return releaseByMonthComputer.completeSerie(releasesEndDate.get(releasesEndDate.size() - 1));
    }

    public List<ReleaseAutomationData> getReleaseAutomation(TimeFrame timeFrame, Iterable<String> tags, Date from, Date to, Integer limit) {
        List<TaskWithReleaseData> tasksWithReleaseData = this.reports.getReleaseAutomationData(timeFrame, tags, from, to);
        HashMap releasesAutomationById = Maps.newHashMap();
        for (TaskWithReleaseData task : tasksWithReleaseData) {
            ReleaseAutomationData releaseAutomationData = (ReleaseAutomationData)releasesAutomationById.get(task.getReleaseId());
            if (releaseAutomationData == null) {
                releaseAutomationData = new ReleaseAutomationData(task.getReleaseTitle(), task.getReleaseEndDate());
                releasesAutomationById.put(task.getReleaseId(), releaseAutomationData);
            }
            releaseAutomationData.incrementNumberOfTask();
            long taskDuration = new Duration(task.getStartDate(), task.getEndDate()).compute();
            releaseAutomationData.incrementTotalDuration(taskDuration);
            if (!task.isAutomated()) continue;
            releaseAutomationData.incrementNumberAutomatedOfTasks();
            releaseAutomationData.incrementAutomatedDuration(taskDuration);
        }
        List<ReleaseAutomationData> sortedReleaseData = this.sortByReleaseEndDate(Lists.newArrayList(releasesAutomationById.values()));
        if (limit == null) {
            return sortedReleaseData;
        }
        return this.shrinkTo(limit, sortedReleaseData);
    }

    private List<ReleaseAutomationData> shrinkTo(Integer limit, List<ReleaseAutomationData> sortedReleaseData) {
        Collections.reverse(sortedReleaseData);
        int size = sortedReleaseData.size();
        return sortedReleaseData.subList(0, limit < size ? limit : size);
    }

    private List<ReleaseAutomationData> sortByReleaseEndDate(List<ReleaseAutomationData> releasesAutomation) {
        Comparator<ReleaseAutomationData> releasesAutomationComparator = new Comparator<ReleaseAutomationData>(){

            @Override
            public int compare(ReleaseAutomationData releaseAutomation1, ReleaseAutomationData releaseAutomation2) {
                return releaseAutomation1.getEndDate().compareTo((ReadableInstant)releaseAutomation2.getEndDate());
            }
        };
        Collections.sort(releasesAutomation, releasesAutomationComparator);
        return releasesAutomation;
    }

    private List<UserParticipation> getUserParticipations(List<UserTask> tasks) {
        HashMap participationByUser = Maps.newHashMap();
        for (UserTask userTask : tasks) {
            long duration = new Duration(userTask.getStartDate(), userTask.getEndDate()).compute();
            UserParticipation userParticipation = (UserParticipation)participationByUser.get(userTask.getUser().getUsername());
            if (userParticipation == null) {
                userParticipation = new UserParticipation();
                userParticipation.setUser(userTask.getUser());
                participationByUser.put(userTask.getUser().getUsername(), userParticipation);
            }
            userParticipation.incrementTasksHandled();
            userParticipation.addTimeSpent(duration);
        }
        return Lists.newArrayList(participationByUser.values());
    }
}

