/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.google.common.base.Function;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterables;
import com.xebialabs.xlrelease.reports.PhaseDuration;
import com.xebialabs.xlrelease.reports.ReleaseAutomationData;
import com.xebialabs.xlrelease.reports.ReleasesAutomation;
import com.xebialabs.xlrelease.reports.ReleasesDuration;
import com.xebialabs.xlrelease.reports.TaskDuration;
import com.xebialabs.xlrelease.reports.UserParticipation;
import com.xebialabs.xlrelease.service.ReportService;
import com.xebialabs.xlrelease.views.Point;
import com.xebialabs.xlrelease.views.TimeFrame;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ReportServiceCache {
    private ReportService reportService;
    public static final int EXPIRATION_DELAY_IN_HOUR = 1;
    public static final int MAXIMUM_CACHE_SIZE = 1000;
    private LoadingCache<ReportParams, ReleasesDuration> releaseDurationCache = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(1L, TimeUnit.HOURS).build((CacheLoader)new CacheLoader<ReportParams, ReleasesDuration>(){

        public ReleasesDuration load(ReportParams params) throws Exception {
            return ReportServiceCache.this.reportService.getReleaseDuration(params.timeFrame, (Iterable<String>)params.tags, params.from, params.to);
        }
    });
    private LoadingCache<ReportParams, List<UserParticipation>> peopleMostInvolvedCache = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(1L, TimeUnit.HOURS).build((CacheLoader)new CacheLoader<ReportParams, List<UserParticipation>>(){

        public List<UserParticipation> load(ReportParams params) throws Exception {
            return ReportServiceCache.this.reportService.getTopPeopleMostInvolved(params.timeFrame, (Iterable<String>)params.tags, params.from, params.to);
        }
    });
    private LoadingCache<ReportParams, List<TaskDuration>> longestTasksCache = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(1L, TimeUnit.HOURS).build((CacheLoader)new CacheLoader<ReportParams, List<TaskDuration>>(){

        public List<TaskDuration> load(ReportParams params) throws Exception {
            return ReportServiceCache.this.reportService.getTopLongestTasks(params.timeFrame, (Iterable<String>)params.tags, params.from, params.to);
        }
    });
    private LoadingCache<ReportParams, ReleasesAutomation> releaseAutomationCache = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(1L, TimeUnit.HOURS).build((CacheLoader)new CacheLoader<ReportParams, ReleasesAutomation>(){

        public ReleasesAutomation load(ReportParams params) throws Exception {
            return ReportServiceCache.this.reportService.getReleaseAutomationSeries(params.timeFrame, (Iterable<String>)params.tags, params.from, params.to);
        }
    });
    private LoadingCache<ReportParams, List<ReleaseAutomationData>> mostRecentReleasesCache = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(1L, TimeUnit.HOURS).build((CacheLoader)new CacheLoader<ReportParams, List<ReleaseAutomationData>>(){

        public List<ReleaseAutomationData> load(ReportParams params) throws Exception {
            return ReportServiceCache.this.reportService.getReleaseAutomation(params.timeFrame, (Iterable<String>)params.tags, params.from, params.to, params.limit);
        }
    });
    private LoadingCache<ReportParams, List<PhaseDuration>> longestPhasesCache = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(1L, TimeUnit.HOURS).build((CacheLoader)new CacheLoader<ReportParams, List<PhaseDuration>>(){

        public List<PhaseDuration> load(ReportParams params) throws Exception {
            return ReportServiceCache.this.reportService.getTopLongestPhases(params.timeFrame, (Iterable<String>)params.tags, params.from, params.to);
        }
    });
    private LoadingCache<ReportParams, List<Point>> numberOfReleaseCache = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(1L, TimeUnit.HOURS).build((CacheLoader)new CacheLoader<ReportParams, List<Point>>(){

        public List<Point> load(ReportParams params) throws Exception {
            return ReportServiceCache.this.reportService.getNumberOfReleaseByMonth(params.timeFrame, (Iterable<String>)params.tags, params.from, params.to);
        }
    });
    private static final Function<String, String> TO_LOWER_CASE = new Function<String, String>(){

        public String apply(String input) {
            return input.toLowerCase();
        }
    };

    @Autowired
    public ReportServiceCache(ReportService reportService) {
        this.reportService = reportService;
    }

    public ReleasesDuration getReleaseDuration(TimeFrame timeFrame, Iterable<String> tags, Date from, Date to) {
        try {
            return (ReleasesDuration)this.releaseDurationCache.get((Object)new ReportParams(timeFrame, tags, from, to));
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public List<UserParticipation> getTopPeopleMostInvolved(TimeFrame timeFrame, Iterable<String> tags, Date from, Date to) {
        try {
            return (List)this.peopleMostInvolvedCache.get((Object)new ReportParams(timeFrame, tags, from, to));
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public List<TaskDuration> getTopLongestTasks(TimeFrame timeFrame, Iterable<String> tags, Date from, Date to) {
        try {
            return (List)this.longestTasksCache.get((Object)new ReportParams(timeFrame, tags, from, to));
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public ReleasesAutomation getReleaseAutomationSeries(TimeFrame timeFrame, Iterable<String> tags, Date from, Date to) {
        try {
            return (ReleasesAutomation)this.releaseAutomationCache.get((Object)new ReportParams(timeFrame, tags, from, to));
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public List<PhaseDuration> getTopLongestPhases(TimeFrame timeFrame, Iterable<String> tags, Date from, Date to) {
        try {
            return (List)this.longestPhasesCache.get((Object)new ReportParams(timeFrame, tags, from, to));
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public List<Point> getNumberOfReleaseByMonth(TimeFrame timeFrame, Iterable<String> tags, Date from, Date to) {
        try {
            return (List)this.numberOfReleaseCache.get((Object)new ReportParams(timeFrame, tags, from, to));
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public List<ReleaseAutomationData> getMostRecentReleasesData(Iterable<String> tags, Integer limit) {
        try {
            return (List)this.mostRecentReleasesCache.get((Object)new ReportParams(TimeFrame.RANGE, tags, null, null, limit));
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public void clearCache() {
        this.releaseDurationCache.invalidateAll();
        this.peopleMostInvolvedCache.invalidateAll();
        this.longestTasksCache.invalidateAll();
        this.releaseAutomationCache.invalidateAll();
        this.longestPhasesCache.invalidateAll();
        this.numberOfReleaseCache.invalidateAll();
        this.mostRecentReleasesCache.invalidateAll();
    }

    private static class ReportParams {
        final TimeFrame timeFrame;
        final ImmutableSortedSet<String> tags;
        final Date from;
        final Date to;
        final Integer limit;
        final int hashCode;

        ReportParams(TimeFrame timeFrame, Iterable<String> tags, Date from, Date to, Integer limit) {
            this.timeFrame = timeFrame;
            this.tags = ImmutableSortedSet.copyOf((Iterable)Iterables.transform(tags, (Function)TO_LOWER_CASE));
            this.from = timeFrame == TimeFrame.RANGE ? from : null;
            this.to = timeFrame == TimeFrame.RANGE ? to : null;
            this.limit = limit;
            this.hashCode = Objects.hash(new Object[]{this.timeFrame, this.tags, this.from, this.to, this.limit});
        }

        ReportParams(TimeFrame timeFrame, Iterable<String> tags, Date from, Date to) {
            this(timeFrame, tags, from, to, null);
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (other.hashCode() != this.hashCode) {
                return false;
            }
            if (other instanceof ReportParams) {
                ReportParams that = (ReportParams)other;
                return Objects.equals((Object)this.timeFrame, (Object)that.timeFrame) && Objects.equals(this.tags, that.tags) && Objects.equals(this.from, that.from) && Objects.equals(this.to, that.to) && Objects.equals(this.limit, this.limit);
            }
            return false;
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

