/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.notification.Notifications;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TaskService {
    private Notifications notifications;

    @Autowired
    public TaskService(Notifications notifications) {
        this.notifications = notifications;
    }

    public void notifyOwnerReassignment(Task task, String previousOwner) {
        if (task.isActive()) {
            if (task.hasOwner()) {
                this.notifications.notifyAssignedToOwner(task);
                if (previousOwner != null) {
                    this.notifications.notifyTaskReassigned(task, previousOwner);
                } else {
                    this.notifications.notifyTaskPicked(task);
                }
            } else {
                this.notifications.notifyTaskUnassigned(task, previousOwner);
            }
        }
    }
}

