/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.views;

import com.google.common.base.Function;
import com.xebialabs.deployit.plumbing.id.DomainIdDeserializer;
import com.xebialabs.deployit.plumbing.id.DomainIdSerializer;
import com.xebialabs.xlrelease.domain.Comment;
import com.xebialabs.xlrelease.repository.UserProfiles;
import com.xebialabs.xlrelease.views.UserView;
import java.util.Date;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;

public class CommentView {
    @JsonSerialize(using=DomainIdSerializer.class)
    @JsonDeserialize(using=DomainIdDeserializer.class)
    protected String id;
    protected String text;
    protected Date date;
    protected UserView author;

    public static Function<Comment, CommentView> toCommentView(final UserProfiles userProfiles) {
        return new Function<Comment, CommentView>(){

            public CommentView apply(Comment comment) {
                return new CommentView(comment, userProfiles);
            }
        };
    }

    public CommentView() {
    }

    public CommentView(Comment comment, UserProfiles userProfiles) {
        this.id = comment.getId();
        this.text = comment.getText();
        this.date = comment.getDate();
        this.author = new UserView(comment.getAuthor(), userProfiles);
    }

    public String getId() {
        return this.id;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public Date getDate() {
        return this.date;
    }

    public UserView getAuthor() {
        return this.author;
    }
}

