/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.views;

import com.xebialabs.deployit.plumbing.id.DomainIdDeserializer;
import com.xebialabs.deployit.plumbing.id.DomainIdSerializer;
import com.xebialabs.xlrelease.domain.Phase;
import com.xebialabs.xlrelease.domain.PlanItem;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.views.Flag;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;

public class DependencyNode {
    @JsonSerialize(using=DomainIdSerializer.class)
    @JsonDeserialize(using=DomainIdDeserializer.class)
    private String releaseId;
    private String releaseTitle;
    @JsonSerialize(using=DomainIdSerializer.class)
    @JsonDeserialize(using=DomainIdDeserializer.class)
    private String phaseId;
    private String phaseTitle;
    @JsonSerialize(using=DomainIdSerializer.class)
    @JsonDeserialize(using=DomainIdDeserializer.class)
    private String taskId;
    private String taskTitle;
    private boolean inConflict;
    private Flag flag;

    public DependencyNode() {
    }

    public DependencyNode(PlanItem item) {
        String itemId = item.getId();
        if (item instanceof Release) {
            this.releaseId = itemId;
            this.releaseTitle = item.getTitle();
        } else if (item instanceof Phase) {
            Release release = item.getRelease();
            this.releaseId = Ids.releaseIdFrom(itemId);
            this.releaseTitle = release.getTitle();
            this.phaseId = itemId;
            this.phaseTitle = item.replaceAll(item.getTitle(), release.getVariableValues());
        } else if (item instanceof Task) {
            Release release = item.getRelease();
            Phase phase = ((Task)item).getPhase();
            this.releaseId = Ids.releaseIdFrom(itemId);
            this.releaseTitle = release.getTitle();
            this.phaseId = Ids.phaseIdFrom(itemId);
            this.phaseTitle = item.replaceAll(phase.getTitle(), release.getVariableValues());
            this.taskId = itemId;
            this.taskTitle = item.replaceAll(item.getTitle(), release.getVariableValues());
        }
        this.flag = Flag.toFlag(item.getRelease());
    }

    public String getReleaseId() {
        return this.releaseId;
    }

    public void setReleaseId(String releaseId) {
        this.releaseId = releaseId;
    }

    public String getReleaseTitle() {
        return this.releaseTitle;
    }

    public void setReleaseTitle(String releaseTitle) {
        this.releaseTitle = releaseTitle;
    }

    public String getPhaseId() {
        return this.phaseId;
    }

    public void setPhaseId(String phaseId) {
        this.phaseId = phaseId;
    }

    public String getPhaseTitle() {
        return this.phaseTitle;
    }

    public void setPhaseTitle(String phaseTitle) {
        this.phaseTitle = phaseTitle;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public String getTaskTitle() {
        return this.taskTitle;
    }

    public void setTaskTitle(String taskTitle) {
        this.taskTitle = taskTitle;
    }

    public Flag getFlag() {
        return this.flag;
    }

    public void setFlag(Flag flag) {
        this.flag = flag;
    }

    public String toNodeId() {
        if (this.phaseId == null) {
            return this.releaseId;
        }
        if (this.taskId == null) {
            return this.phaseId;
        }
        return this.taskId;
    }

    public boolean isInConflict() {
        return this.inConflict;
    }

    public void setInConflict(boolean inConflict) {
        this.inConflict = inConflict;
    }
}

