/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.views;

import com.xebialabs.license.v1.License;
import java.util.Date;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LicenseView {
    private static final Logger logger = LoggerFactory.getLogger(LicenseView.class);
    private String version;
    private String licensedTo;
    private String contact;
    private Date expiresAfter;
    private String product;
    private String repositoryId;

    public LicenseView(License license) {
        this.version = license.getLicenseVersion();
        this.licensedTo = license.getLicensedTo();
        try {
            InternetAddress address = new InternetAddress(license.getContact());
            this.contact = address.getAddress();
        }
        catch (AddressException e) {
            logger.warn("License email address invalid {}", (Object)license.getContact(), (Object)e);
        }
        this.expiresAfter = license.getExpiresAfter().toDate();
        this.product = license.getProduct();
        this.repositoryId = license.getRepositoryId();
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getLicensedTo() {
        return this.licensedTo;
    }

    public void setLicensedTo(String licensedTo) {
        this.licensedTo = licensedTo;
    }

    public String getContact() {
        return this.contact;
    }

    public void setContact(String contact) {
        this.contact = contact;
    }

    public String getProduct() {
        return this.product;
    }

    public void setProduct(String product) {
        this.product = product;
    }

    public Date getExpiresAfter() {
        return this.expiresAfter;
    }

    public void setExpiresAfter(Date expiresAfter) {
        this.expiresAfter = expiresAfter;
    }

    public String getRepositoryId() {
        return this.repositoryId;
    }

    public void setRepositoryId(String repositoryId) {
        this.repositoryId = repositoryId;
    }
}

