/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.views;

import com.google.common.collect.Lists;
import com.xebialabs.xlrelease.dependency.ConflictComputer;
import com.xebialabs.xlrelease.domain.GateTask;
import com.xebialabs.xlrelease.domain.PlanItem;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.repository.UserProfiles;
import com.xebialabs.xlrelease.views.DependencyFullNode;
import java.util.Collection;
import java.util.List;

public class ReleaseDependenciesFullView {
    private List<DependencyFullNode> incomingDependencies = Lists.newArrayList();
    private List<DependencyFullNode> outgoingDependencies = Lists.newArrayList();

    public ReleaseDependenciesFullView(Release release, Collection<GateTask> incomingGates, Collection<PlanItem> outgoingTargets, UserProfiles userProfiles) {
        for (GateTask incomingGate : incomingGates) {
            this.incomingDependencies.add(new DependencyFullNode(incomingGate, userProfiles));
        }
        for (PlanItem outgoingTarget : outgoingTargets) {
            boolean isInConflict = ConflictComputer.hasConflict(release, outgoingTarget.getRelease());
            DependencyFullNode node = new DependencyFullNode(outgoingTarget, userProfiles);
            node.setInConflict(isInConflict);
            this.outgoingDependencies.add(node);
        }
    }

    public List<DependencyFullNode> getIncomingDependencies() {
        return this.incomingDependencies;
    }

    public void setIncomingDependencies(List<DependencyFullNode> incomingDependencies) {
        this.incomingDependencies = incomingDependencies;
    }

    public List<DependencyFullNode> getOutgoingDependencies() {
        return this.outgoingDependencies;
    }

    public void setOutgoingDependencies(List<DependencyFullNode> outgoingDependencies) {
        this.outgoingDependencies = outgoingDependencies;
    }
}

