/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.views;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.plumbing.id.DomainIdDeserializer;
import com.xebialabs.deployit.plumbing.id.DomainIdSerializer;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Variable;
import com.xebialabs.xlrelease.views.PhaseView;
import java.util.List;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;

public class ReleaseView {
    @JsonSerialize(using=DomainIdSerializer.class)
    @JsonDeserialize(using=DomainIdDeserializer.class)
    private String id;
    private String title;
    private List<Variable> variables;
    private List<PhaseView> phases;
    public static final Function<Release, ReleaseView> TO_RELEASE_VIEW = new Function<Release, ReleaseView>(){

        public ReleaseView apply(Release release) {
            return new ReleaseView(release);
        }
    };

    public ReleaseView(Release release) {
        this.id = release.getId();
        this.title = release.getTitle();
        this.phases = Lists.transform(release.getPhases(), PhaseView.TO_PHASE_VIEW);
        this.variables = Variable.mapToList(release.getVariableValues());
    }

    public String getId() {
        return this.id;
    }

    public String getTitle() {
        return this.title;
    }

    public List<Variable> getVariables() {
        return this.variables;
    }

    public List<PhaseView> getPhases() {
        return this.phases;
    }
}

