/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.views;

import com.google.common.collect.Maps;
import com.xebialabs.xlrelease.domain.FlagStatus;
import com.xebialabs.xlrelease.domain.TaskStatus;
import com.xebialabs.xlrelease.views.Flag;
import com.xebialabs.xlrelease.views.TaskFullView;
import com.xebialabs.xlrelease.views.UserView;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class TaskViewBuilder {
    private String id;
    private String title;
    private String description;
    private String type;
    private TaskStatus status;
    private FlagStatus flagStatus = FlagStatus.OK;
    private String flagComment;
    private Date dueDate;
    private Date scheduledStartDate;
    private String owner;
    private String team;
    private String environment;
    private String deploymentPackage;
    private String server;
    private Set<String> addresses = new HashSet<String>();
    private String subject;
    private String body;
    private Map<String, Object> inputProperties = Maps.newHashMap();
    private Map<String, String> outputProperties = Maps.newHashMap();
    private String scriptDefinitionType;
    private String script;
    private String ownerFullName;
    private Long duration;

    private TaskViewBuilder() {
    }

    public static TaskViewBuilder newTaskView() {
        return new TaskViewBuilder();
    }

    public TaskViewBuilder withId(String id) {
        this.id = id;
        return this;
    }

    public TaskViewBuilder withTitle(String title) {
        this.title = title;
        return this;
    }

    public TaskViewBuilder withDescription(String description) {
        this.description = description;
        return this;
    }

    public TaskViewBuilder withType(String type) {
        this.type = type;
        return this;
    }

    public TaskViewBuilder withStatus(TaskStatus status) {
        this.status = status;
        return this;
    }

    public TaskViewBuilder withFlagStatus(FlagStatus flagStatus) {
        this.flagStatus = flagStatus;
        return this;
    }

    public TaskViewBuilder withFlagComment(String flagComment) {
        this.flagComment = flagComment;
        return this;
    }

    public TaskViewBuilder withDueDate(Date dueDate) {
        this.dueDate = dueDate;
        return this;
    }

    public TaskViewBuilder withScheduledStartDate(Date scheduledStartDate) {
        this.scheduledStartDate = scheduledStartDate;
        return this;
    }

    public TaskViewBuilder assignedTo(String owner) {
        this.owner = owner;
        this.ownerFullName = null;
        return this;
    }

    public TaskViewBuilder assignedTo(String owner, String ownerFullName) {
        this.owner = owner;
        this.ownerFullName = ownerFullName;
        return this;
    }

    public TaskViewBuilder withTeam(String team) {
        this.team = team;
        return this;
    }

    public TaskViewBuilder withEnvironment(String environment) {
        this.environment = environment;
        return this;
    }

    public TaskViewBuilder withServer(String server) {
        this.server = server;
        return this;
    }

    public TaskViewBuilder withDeploymentPackage(String deploymentPackage) {
        this.deploymentPackage = deploymentPackage;
        return this;
    }

    public TaskViewBuilder withAddresses(Set<String> addresses) {
        this.addresses = addresses;
        return this;
    }

    public TaskViewBuilder withSubject(String subject) {
        this.subject = subject;
        return this;
    }

    public TaskViewBuilder withBody(String body) {
        this.body = body;
        return this;
    }

    public TaskViewBuilder withScriptDefinitionType(String scriptDefinitionType) {
        this.scriptDefinitionType = scriptDefinitionType;
        return this;
    }

    public TaskViewBuilder withInputProperties(Map<String, Object> inputProperties) {
        this.inputProperties = Maps.newHashMap(inputProperties);
        return this;
    }

    public TaskViewBuilder withOutputProperties(Map<String, String> outputProperties) {
        this.outputProperties = Maps.newHashMap(outputProperties);
        return this;
    }

    public TaskViewBuilder withScript(String script) {
        this.script = script;
        return this;
    }

    public TaskViewBuilder withPlannedDuration(Long duration) {
        this.duration = duration;
        return this;
    }

    public TaskFullView build() {
        TaskFullView taskView = new TaskFullView();
        taskView.setId(this.id);
        taskView.setTitle(this.title);
        taskView.setDescription(this.description);
        taskView.setType(this.type);
        taskView.setStatus(this.status);
        taskView.setFlag(new Flag(this.flagStatus, this.flagComment));
        taskView.setDueDate(this.dueDate);
        taskView.setScheduledStartDate(this.scheduledStartDate);
        if (null != this.owner) {
            taskView.setOwner(new UserView(this.owner, this.ownerFullName));
        }
        taskView.setTeam(this.team);
        taskView.setEnvironment(this.environment);
        taskView.setServer(this.server);
        taskView.setDeploymentPackage(this.deploymentPackage);
        taskView.setAddresses(this.addresses);
        taskView.setSubject(this.subject);
        taskView.setBody(this.body);
        taskView.setScriptDefinitionType(this.scriptDefinitionType);
        taskView.setInputProperties(this.inputProperties);
        taskView.setOutputProperties(this.outputProperties);
        taskView.setScript(this.script);
        taskView.setPlannedDuration(this.duration);
        return taskView;
    }
}

