/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.views;

import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.plumbing.id.DomainIdDeserializer;
import com.xebialabs.deployit.plumbing.id.DomainIdSerializer;
import com.xebialabs.xlrelease.builder.TeamBuilder;
import com.xebialabs.xlrelease.domain.Team;
import com.xebialabs.xlrelease.repository.UserProfiles;
import com.xebialabs.xlrelease.views.TeamMemberView;
import java.util.List;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;

public class TeamView {
    @JsonSerialize(using=DomainIdSerializer.class)
    @JsonDeserialize(using=DomainIdDeserializer.class)
    private String id;
    private String teamName;
    private List<TeamMemberView> members = Lists.newArrayList();
    private List<String> permissions = Lists.newArrayList();
    private boolean systemTeam;
    public static final Function<TeamView, Team> TO_TEAM = new Function<TeamView, Team>(){

        public Team apply(TeamView teamView) {
            return teamView.toTeam();
        }
    };

    public TeamView() {
    }

    public TeamView(Team team, UserProfiles userProfiles) {
        this.id = team.getId();
        this.teamName = team.getTeamName();
        this.members.addAll(Lists.transform(team.getMembers(), TeamMemberView.toTeamMemberView(TeamMemberView.MemberType.PRINCIPAL, userProfiles)));
        this.members.addAll(Lists.transform(team.getRoles(), TeamMemberView.toTeamMemberView(TeamMemberView.MemberType.ROLE, userProfiles)));
        this.permissions = team.getPermissions();
        this.systemTeam = team.isSystemTeam();
    }

    public static Function<Team, TeamView> toTeamView(final UserProfiles userProfiles) {
        return new Function<Team, TeamView>(){

            public TeamView apply(Team team) {
                return new TeamView(team, userProfiles);
            }
        };
    }

    public String getId() {
        return this.id;
    }

    public String getTeamName() {
        return this.teamName;
    }

    public List<TeamMemberView> getMembers() {
        return this.members;
    }

    public List<String> getPermissions() {
        return this.permissions;
    }

    public boolean isSystemTeam() {
        return this.systemTeam;
    }

    public Team toTeam() {
        ImmutableList principals = FluentIterable.from(this.members).filter(TeamMemberView.memberType(TeamMemberView.MemberType.PRINCIPAL)).transform(TeamMemberView.TO_NAME).toList();
        ImmutableList roles = FluentIterable.from(this.members).filter(TeamMemberView.memberType(TeamMemberView.MemberType.ROLE)).transform(TeamMemberView.TO_NAME).toList();
        return TeamBuilder.newTeam().withId(this.id).withTeamName(this.teamName).withMembers((List<String>)principals).withRoles((List<String>)roles).withPermissions(this.permissions).build();
    }
}

