/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.zip;

import de.schlichtherle.truezip.io.DecoratingInputStream;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.IOException;
import java.io.InputStream;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
@DefaultAnnotation(value={NonNull.class})
final class CountingInputStream
extends DecoratingInputStream {
    private long bytesRead;

    CountingInputStream(@Nullable InputStream in) {
        super(in);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int read = this.delegate.read(b, off, len);
        this.bytesRead += read >= 0 ? (long)read : 0L;
        return read;
    }

    public int read() throws IOException {
        int read = this.delegate.read();
        this.bytesRead += -1 != read ? 1L : 0L;
        return read;
    }

    public long skip(long n) throws IOException {
        long skipped = this.delegate.skip(n);
        this.bytesRead += skipped;
        return skipped;
    }

    public long getBytesRead() {
        return this.bytesRead;
    }

    public void resetBytesRead() {
        this.bytesRead = 0L;
    }
}

