/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractPeepholeOptimization;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import com.google.javascript.rhino.head.ScriptRuntime;
import com.google.javascript.rhino.jstype.TernaryValue;

class PeepholeFoldConstants
extends AbstractPeepholeOptimization {
    static final DiagnosticType INVALID_GETELEM_INDEX_ERROR = DiagnosticType.warning("JSC_INVALID_GETELEM_INDEX_ERROR", "Array index not integer: {0}");
    static final DiagnosticType INDEX_OUT_OF_BOUNDS_ERROR = DiagnosticType.warning("JSC_INDEX_OUT_OF_BOUNDS_ERROR", "Array index out of bounds: {0}");
    static final DiagnosticType NEGATING_A_NON_NUMBER_ERROR = DiagnosticType.warning("JSC_NEGATING_A_NON_NUMBER_ERROR", "Can't negate non-numeric value: {0}");
    static final DiagnosticType BITWISE_OPERAND_OUT_OF_RANGE = DiagnosticType.warning("JSC_BITWISE_OPERAND_OUT_OF_RANGE", "Operand out of range, bitwise operation will lose information: {0}");
    static final DiagnosticType SHIFT_AMOUNT_OUT_OF_BOUNDS = DiagnosticType.warning("JSC_SHIFT_AMOUNT_OUT_OF_BOUNDS", "Shift amount out of bounds: {0}");
    static final DiagnosticType FRACTIONAL_BITWISE_OPERAND = DiagnosticType.warning("JSC_FRACTIONAL_BITWISE_OPERAND", "Fractional bitwise operand: {0}");
    private static final double MAX_FOLD_NUMBER = Math.pow(2.0, 53.0);
    private final boolean late;

    PeepholeFoldConstants(boolean late) {
        this.late = late;
    }

    @Override
    Node optimizeSubtree(Node subtree) {
        switch (subtree.getType()) {
            case 30: {
                return this.tryFoldCtorCall(subtree);
            }
            case 32: {
                return this.tryFoldTypeof(subtree);
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                this.tryReduceOperandsForOp(subtree);
                return this.tryFoldUnaryOperator(subtree);
            }
            case 122: {
                return this.tryReduceVoid(subtree);
            }
        }
        this.tryReduceOperandsForOp(subtree);
        return this.tryFoldBinaryOperator(subtree);
    }

    private Node tryFoldBinaryOperator(Node subtree) {
        Node left = subtree.getFirstChild();
        if (left == null) {
            return subtree;
        }
        Node right = left.getNext();
        if (right == null) {
            return subtree;
        }
        switch (subtree.getType()) {
            case 33: {
                return this.tryFoldGetProp(subtree, left, right);
            }
            case 35: {
                return this.tryFoldGetElem(subtree, left, right);
            }
            case 52: {
                return this.tryFoldInstanceof(subtree, left, right);
            }
            case 100: 
            case 101: {
                return this.tryFoldAndOr(subtree, left, right);
            }
            case 18: 
            case 19: 
            case 20: {
                return this.tryFoldShift(subtree, left, right);
            }
            case 86: {
                return this.tryFoldAssign(subtree, left, right);
            }
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: {
                return this.tryUnfoldAssignOp(subtree, left, right);
            }
            case 21: {
                return this.tryFoldAdd(subtree, left, right);
            }
            case 22: 
            case 24: 
            case 25: {
                return this.tryFoldArithmeticOp(subtree, left, right);
            }
            case 9: 
            case 10: 
            case 11: 
            case 23: {
                Node result = this.tryFoldArithmeticOp(subtree, left, right);
                if (result != subtree) {
                    return result;
                }
                return this.tryFoldLeftChildOp(subtree, left, right);
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 45: 
            case 46: {
                return this.tryFoldComparison(subtree, left, right);
            }
        }
        return subtree;
    }

    private Node tryReduceVoid(Node n) {
        Node child = n.getFirstChild();
        if (!(child.isNumber() && child.getDouble() == 0.0 || this.mayHaveSideEffects(n))) {
            n.replaceChild(child, IR.number(0.0));
            this.reportCodeChange();
        }
        return n;
    }

    private void tryReduceOperandsForOp(Node n) {
        switch (n.getType()) {
            case 21: {
                Node left = n.getFirstChild();
                Node right = n.getLastChild();
                if (NodeUtil.mayBeString(left) || NodeUtil.mayBeString(right)) break;
                this.tryConvertOperandsToNumber(n);
                break;
            }
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 94: 
            case 95: 
            case 96: 
            case 97: {
                this.tryConvertToNumber(n.getLastChild());
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 29: {
                this.tryConvertOperandsToNumber(n);
            }
        }
    }

    private void tryConvertOperandsToNumber(Node n) {
        Node c = n.getFirstChild();
        while (c != null) {
            Node next = c.getNext();
            this.tryConvertToNumber(c);
            c = next;
        }
    }

    private void tryConvertToNumber(Node n) {
        switch (n.getType()) {
            case 39: {
                return;
            }
            case 85: 
            case 100: 
            case 101: {
                this.tryConvertToNumber(n.getLastChild());
                return;
            }
            case 98: {
                this.tryConvertToNumber(n.getChildAtIndex(1));
                this.tryConvertToNumber(n.getLastChild());
                return;
            }
            case 38: {
                if (NodeUtil.isUndefined(n)) break;
                return;
            }
        }
        Double result = NodeUtil.getNumberValue(n);
        if (result == null) {
            return;
        }
        double value = result;
        Node replacement = NodeUtil.numberNode(value, n);
        if (replacement.isEquivalentTo(n)) {
            return;
        }
        n.getParent().replaceChild(n, replacement);
        this.reportCodeChange();
    }

    private Node tryFoldTypeof(Node originalTypeofNode) {
        Preconditions.checkArgument((boolean)originalTypeofNode.isTypeOf());
        Node argumentNode = originalTypeofNode.getFirstChild();
        if (argumentNode == null || !NodeUtil.isLiteralValue(argumentNode, true)) {
            return originalTypeofNode;
        }
        String typeNameString = null;
        switch (argumentNode.getType()) {
            case 105: {
                typeNameString = "function";
                break;
            }
            case 40: {
                typeNameString = "string";
                break;
            }
            case 39: {
                typeNameString = "number";
                break;
            }
            case 43: 
            case 44: {
                typeNameString = "boolean";
                break;
            }
            case 41: 
            case 63: 
            case 64: {
                typeNameString = "object";
                break;
            }
            case 122: {
                typeNameString = "undefined";
                break;
            }
            case 38: {
                if (!"undefined".equals(argumentNode.getString())) break;
                typeNameString = "undefined";
            }
        }
        if (typeNameString != null) {
            Node newNode = IR.string(typeNameString);
            originalTypeofNode.getParent().replaceChild(originalTypeofNode, newNode);
            this.reportCodeChange();
            return newNode;
        }
        return originalTypeofNode;
    }

    private Node tryFoldUnaryOperator(Node n) {
        Preconditions.checkState((boolean)n.hasOneChild());
        Node left = n.getFirstChild();
        Node parent = n.getParent();
        if (left == null) {
            return n;
        }
        TernaryValue leftVal = NodeUtil.getPureBooleanValue(left);
        if (leftVal == TernaryValue.UNKNOWN) {
            return n;
        }
        switch (n.getType()) {
            case 26: {
                double numValue;
                if (this.late && left.isNumber() && ((numValue = left.getDouble()) == 0.0 || numValue == 1.0)) {
                    return n;
                }
                Node replacementNode = NodeUtil.booleanNode(!leftVal.toBoolean(true));
                parent.replaceChild(n, replacementNode);
                this.reportCodeChange();
                return replacementNode;
            }
            case 28: {
                if (NodeUtil.isNumericResult(left)) {
                    parent.replaceChild(n, left.detachFromParent());
                    this.reportCodeChange();
                    return left;
                }
                return n;
            }
            case 29: {
                if (left.isName()) {
                    if (left.getString().equals("Infinity")) {
                        return n;
                    }
                    if (left.getString().equals("NaN")) {
                        n.removeChild(left);
                        parent.replaceChild(n, left);
                        this.reportCodeChange();
                        return left;
                    }
                }
                if (left.isNumber()) {
                    double negNum = -left.getDouble();
                    Node negNumNode = IR.number(negNum);
                    parent.replaceChild(n, negNumNode);
                    this.reportCodeChange();
                    return negNumNode;
                }
                this.report(NEGATING_A_NON_NUMBER_ERROR, left);
                return n;
            }
            case 27: {
                try {
                    double val = left.getDouble();
                    if (val >= -2.147483648E9 && val <= 2.147483647E9) {
                        int intVal = (int)val;
                        if ((double)intVal == val) {
                            Node notIntValNode = IR.number(~intVal);
                            parent.replaceChild(n, notIntValNode);
                            this.reportCodeChange();
                            return notIntValNode;
                        }
                        this.report(FRACTIONAL_BITWISE_OPERAND, left);
                        return n;
                    }
                    this.report(BITWISE_OPERAND_OUT_OF_RANGE, left);
                    return n;
                }
                catch (UnsupportedOperationException ex) {
                    this.report(NEGATING_A_NON_NUMBER_ERROR, left);
                    return n;
                }
            }
        }
        return n;
    }

    private Node tryFoldInstanceof(Node n, Node left, Node right) {
        Preconditions.checkArgument((boolean)n.isInstanceOf());
        if (NodeUtil.isLiteralValue(left, true) && !this.mayHaveSideEffects(right)) {
            Node replacementNode = null;
            if (NodeUtil.isImmutableValue(left)) {
                replacementNode = IR.falseNode();
            } else if (right.isName() && "Object".equals(right.getString())) {
                replacementNode = IR.trueNode();
            }
            if (replacementNode != null) {
                n.getParent().replaceChild(n, replacementNode);
                this.reportCodeChange();
                return replacementNode;
            }
        }
        return n;
    }

    private Node tryFoldAssign(Node n, Node left, Node right) {
        Node newRight;
        Preconditions.checkArgument((boolean)n.isAssign());
        if (!this.late) {
            return n;
        }
        if (!right.hasChildren() || right.getFirstChild().getNext() != right.getLastChild()) {
            return n;
        }
        if (this.mayHaveSideEffects(left)) {
            return n;
        }
        if (this.areNodesEqualForInlining(left, right.getFirstChild())) {
            newRight = right.getLastChild();
        } else if (NodeUtil.isCommutative(right.getType()) && this.areNodesEqualForInlining(left, right.getLastChild())) {
            newRight = right.getFirstChild();
        } else {
            return n;
        }
        int newType = -1;
        switch (right.getType()) {
            case 21: {
                newType = 93;
                break;
            }
            case 11: {
                newType = 89;
                break;
            }
            case 9: {
                newType = 87;
                break;
            }
            case 10: {
                newType = 88;
                break;
            }
            case 24: {
                newType = 96;
                break;
            }
            case 18: {
                newType = 90;
                break;
            }
            case 25: {
                newType = 97;
                break;
            }
            case 23: {
                newType = 95;
                break;
            }
            case 19: {
                newType = 91;
                break;
            }
            case 22: {
                newType = 94;
                break;
            }
            case 20: {
                newType = 92;
                break;
            }
            default: {
                return n;
            }
        }
        Node newNode = new Node(newType, left.detachFromParent(), newRight.detachFromParent());
        n.getParent().replaceChild(n, newNode);
        this.reportCodeChange();
        return newNode;
    }

    private Node tryUnfoldAssignOp(Node n, Node left, Node right) {
        if (this.late) {
            return n;
        }
        if (!n.hasChildren() || n.getFirstChild().getNext() != n.getLastChild()) {
            return n;
        }
        if (this.mayHaveSideEffects(left)) {
            return n;
        }
        int op = NodeUtil.getOpFromAssignmentOp(n);
        Node replacement = IR.assign(left.detachFromParent(), new Node(op, left.cloneTree(), right.detachFromParent()).srcref(n));
        n.getParent().replaceChild(n, replacement);
        this.reportCodeChange();
        return replacement;
    }

    private Node tryFoldAndOr(Node n, Node left, Node right) {
        Node parent = n.getParent();
        Node result = null;
        int type = n.getType();
        TernaryValue leftVal = NodeUtil.getImpureBooleanValue(left);
        if (leftVal != TernaryValue.UNKNOWN) {
            boolean lval = leftVal.toBoolean(true);
            if (lval && type == 100 || !lval && type == 101) {
                result = left;
            } else if (!this.mayHaveSideEffects(left)) {
                result = right;
            }
        }
        if (result != null) {
            n.removeChild(result);
            parent.replaceChild(n, result);
            this.reportCodeChange();
            return result;
        }
        return n;
    }

    private Node tryFoldChildAddString(Node n, Node left, Node right) {
        String rightString;
        String leftString;
        Node ll;
        Node lr;
        if (NodeUtil.isLiteralValue(right, false) && left.isAdd() && (lr = (ll = left.getFirstChild()).getNext()).isString()) {
            leftString = NodeUtil.getStringValue(lr);
            rightString = NodeUtil.getStringValue(right);
            if (leftString != null && rightString != null) {
                left.removeChild(ll);
                String result = leftString + rightString;
                n.replaceChild(left, ll);
                n.replaceChild(right, IR.string(result));
                this.reportCodeChange();
                return n;
            }
        }
        if (NodeUtil.isLiteralValue(left, false) && right.isAdd()) {
            Node rl = right.getFirstChild();
            Node rr = right.getLastChild();
            if (rl.isString()) {
                leftString = NodeUtil.getStringValue(left);
                rightString = NodeUtil.getStringValue(rl);
                if (leftString != null && rightString != null) {
                    right.removeChild(rr);
                    String result = leftString + rightString;
                    n.replaceChild(right, rr);
                    n.replaceChild(left, IR.string(result));
                    this.reportCodeChange();
                    return n;
                }
            }
        }
        return n;
    }

    private Node tryFoldAddConstantString(Node n, Node left, Node right) {
        if (left.isString() || right.isString()) {
            String leftString = NodeUtil.getStringValue(left);
            String rightString = NodeUtil.getStringValue(right);
            if (leftString != null && rightString != null) {
                Node newStringNode = IR.string(leftString + rightString);
                n.getParent().replaceChild(n, newStringNode);
                this.reportCodeChange();
                return newStringNode;
            }
        }
        return n;
    }

    private Node tryFoldArithmeticOp(Node n, Node left, Node right) {
        Node result = this.performArithmeticOp(n.getType(), left, right);
        if (result != null) {
            result.copyInformationFromForTree(n);
            n.getParent().replaceChild(n, result);
            this.reportCodeChange();
            return result;
        }
        return n;
    }

    private Node performArithmeticOp(int opType, Node left, Node right) {
        double result;
        if (opType == 21 && (NodeUtil.mayBeString(left, false) || NodeUtil.mayBeString(right, false))) {
            return null;
        }
        Double lValObj = NodeUtil.getNumberValue(left);
        if (lValObj == null) {
            return null;
        }
        Double rValObj = NodeUtil.getNumberValue(right);
        if (rValObj == null) {
            return null;
        }
        double lval = lValObj;
        double rval = rValObj;
        switch (opType) {
            case 11: {
                result = ScriptRuntime.toInt32(lval) & ScriptRuntime.toInt32(rval);
                break;
            }
            case 9: {
                result = ScriptRuntime.toInt32(lval) | ScriptRuntime.toInt32(rval);
                break;
            }
            case 10: {
                result = ScriptRuntime.toInt32(lval) ^ ScriptRuntime.toInt32(rval);
                break;
            }
            case 21: {
                result = lval + rval;
                break;
            }
            case 22: {
                result = lval - rval;
                break;
            }
            case 23: {
                result = lval * rval;
                break;
            }
            case 25: {
                if (rval == 0.0) {
                    return null;
                }
                result = lval % rval;
                break;
            }
            case 24: {
                if (rval == 0.0) {
                    return null;
                }
                result = lval / rval;
                break;
            }
            default: {
                throw new Error("Unexpected arithmetic operator");
            }
        }
        if (String.valueOf(result).length() <= String.valueOf(lval).length() + String.valueOf(rval).length() + 1 && Math.abs(result) <= MAX_FOLD_NUMBER || Double.isNaN(result) || result == Double.POSITIVE_INFINITY || result == Double.NEGATIVE_INFINITY) {
            return NodeUtil.numberNode(result, null);
        }
        return null;
    }

    private Node tryFoldLeftChildOp(Node n, Node left, Node right) {
        int opType = n.getType();
        Preconditions.checkState((NodeUtil.isAssociative(opType) && NodeUtil.isCommutative(opType) || n.isAdd() ? 1 : 0) != 0);
        Preconditions.checkState((!n.isAdd() || !NodeUtil.mayBeString(n) ? 1 : 0) != 0);
        Double rightValObj = NodeUtil.getNumberValue(right);
        if (rightValObj != null && left.getType() == opType) {
            Preconditions.checkState((left.getChildCount() == 2 ? 1 : 0) != 0);
            Node ll = left.getFirstChild();
            Node lr = ll.getNext();
            Node valueToCombine = ll;
            Node replacement = this.performArithmeticOp(opType, valueToCombine, right);
            if (replacement == null) {
                valueToCombine = lr;
                replacement = this.performArithmeticOp(opType, valueToCombine, right);
            }
            if (replacement != null) {
                left.removeChild(valueToCombine);
                n.replaceChild(left, left.removeFirstChild());
                replacement.copyInformationFromForTree(right);
                n.replaceChild(right, replacement);
                this.reportCodeChange();
            }
        }
        return n;
    }

    private Node tryFoldAdd(Node node, Node left, Node right) {
        Preconditions.checkArgument((boolean)node.isAdd());
        if (NodeUtil.mayBeString(node, true)) {
            if (NodeUtil.isLiteralValue(left, false) && NodeUtil.isLiteralValue(right, false)) {
                return this.tryFoldAddConstantString(node, left, right);
            }
            return this.tryFoldChildAddString(node, left, right);
        }
        Node result = this.tryFoldArithmeticOp(node, left, right);
        if (result != node) {
            return result;
        }
        return this.tryFoldLeftChildOp(node, left, right);
    }

    private Node tryFoldShift(Node n, Node left, Node right) {
        if (left.isNumber() && right.isNumber()) {
            double result;
            double lval = left.getDouble();
            double rval = right.getDouble();
            if (!(lval >= -2.147483648E9) || !(lval <= 2.147483647E9)) {
                this.report(BITWISE_OPERAND_OUT_OF_RANGE, left);
                return n;
            }
            if (!(rval >= 0.0) || !(rval < 32.0)) {
                this.report(SHIFT_AMOUNT_OUT_OF_BOUNDS, right);
                return n;
            }
            int lvalInt = (int)lval;
            if ((double)lvalInt != lval) {
                this.report(FRACTIONAL_BITWISE_OPERAND, left);
                return n;
            }
            int rvalInt = (int)rval;
            if ((double)rvalInt != rval) {
                this.report(FRACTIONAL_BITWISE_OPERAND, right);
                return n;
            }
            switch (n.getType()) {
                case 18: {
                    result = lvalInt << rvalInt;
                    break;
                }
                case 19: {
                    result = lvalInt >> rvalInt;
                    break;
                }
                case 20: {
                    long lvalLong = (long)lvalInt & 0xFFFFFFFFL;
                    result = lvalLong >>> rvalInt;
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unknown shift operator: " + Token.name(n.getType())));
                }
            }
            Node newNumber = IR.number(result);
            n.getParent().replaceChild(n, newNumber);
            this.reportCodeChange();
            return newNumber;
        }
        return n;
    }

    private Node tryFoldComparison(Node n, Node left, Node right) {
        TernaryValue result = PeepholeFoldConstants.evaluateComparison(n.getType(), left, right);
        if (result == TernaryValue.UNKNOWN) {
            return n;
        }
        Node newNode = NodeUtil.booleanNode(result.toBoolean(true));
        n.getParent().replaceChild(n, newNode);
        this.reportCodeChange();
        return newNode;
    }

    static TernaryValue evaluateComparison(int op, Node left, Node right) {
        boolean leftLiteral = NodeUtil.isLiteralValue(left, true);
        boolean rightLiteral = NodeUtil.isLiteralValue(right, true);
        if (!(leftLiteral && rightLiteral || op == 16 || op == 14)) {
            return TernaryValue.UNKNOWN;
        }
        boolean undefinedRight = NodeUtil.isUndefined(right) && rightLiteral;
        boolean nullRight = right.isNull();
        int lhType = PeepholeFoldConstants.getNormalizedNodeType(left);
        int rhType = PeepholeFoldConstants.getNormalizedNodeType(right);
        switch (lhType) {
            case 122: {
                if (!leftLiteral) {
                    return TernaryValue.UNKNOWN;
                }
                if (!rightLiteral) {
                    return TernaryValue.UNKNOWN;
                }
                return TernaryValue.forBoolean(PeepholeFoldConstants.compareToUndefined(right, op));
            }
            case 41: {
                if (rightLiteral && PeepholeFoldConstants.isEqualityOp(op)) {
                    return TernaryValue.forBoolean(PeepholeFoldConstants.compareToNull(right, op));
                }
            }
            case 43: 
            case 44: {
                if (undefinedRight) {
                    return TernaryValue.forBoolean(PeepholeFoldConstants.compareToUndefined(left, op));
                }
                if (rhType != 44 && rhType != 43 && rhType != 41) {
                    return TernaryValue.UNKNOWN;
                }
                switch (op) {
                    case 12: 
                    case 45: {
                        return TernaryValue.forBoolean(lhType == rhType);
                    }
                    case 13: 
                    case 46: {
                        return TernaryValue.forBoolean(lhType != rhType);
                    }
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: {
                        return PeepholeFoldConstants.compareAsNumbers(op, left, right);
                    }
                }
                return TernaryValue.UNKNOWN;
            }
            case 42: {
                if (!right.isThis()) {
                    return TernaryValue.UNKNOWN;
                }
                switch (op) {
                    case 12: 
                    case 45: {
                        return TernaryValue.TRUE;
                    }
                    case 13: 
                    case 46: {
                        return TernaryValue.FALSE;
                    }
                }
                return TernaryValue.UNKNOWN;
            }
            case 40: {
                if (undefinedRight) {
                    return TernaryValue.forBoolean(PeepholeFoldConstants.compareToUndefined(left, op));
                }
                if (nullRight && PeepholeFoldConstants.isEqualityOp(op)) {
                    return TernaryValue.forBoolean(PeepholeFoldConstants.compareToNull(left, op));
                }
                if (40 != right.getType()) {
                    return TernaryValue.UNKNOWN;
                }
                switch (op) {
                    case 12: 
                    case 45: {
                        return PeepholeFoldConstants.areStringsEqual(left.getString(), right.getString());
                    }
                    case 13: 
                    case 46: {
                        return PeepholeFoldConstants.areStringsEqual(left.getString(), right.getString()).not();
                    }
                }
                return TernaryValue.UNKNOWN;
            }
            case 39: {
                if (undefinedRight) {
                    return TernaryValue.forBoolean(PeepholeFoldConstants.compareToUndefined(left, op));
                }
                if (nullRight && PeepholeFoldConstants.isEqualityOp(op)) {
                    return TernaryValue.forBoolean(PeepholeFoldConstants.compareToNull(left, op));
                }
                if (39 != right.getType()) {
                    return TernaryValue.UNKNOWN;
                }
                return PeepholeFoldConstants.compareAsNumbers(op, left, right);
            }
            case 38: {
                String rn;
                if (leftLiteral && undefinedRight) {
                    return TernaryValue.forBoolean(PeepholeFoldConstants.compareToUndefined(left, op));
                }
                if (rightLiteral) {
                    boolean undefinedLeft = left.getString().equals("undefined");
                    if (undefinedLeft) {
                        return TernaryValue.forBoolean(PeepholeFoldConstants.compareToUndefined(right, op));
                    }
                    if (leftLiteral && nullRight && PeepholeFoldConstants.isEqualityOp(op)) {
                        return TernaryValue.forBoolean(PeepholeFoldConstants.compareToNull(left, op));
                    }
                }
                if (38 != right.getType()) {
                    return TernaryValue.UNKNOWN;
                }
                String ln = left.getString();
                if (!ln.equals(rn = right.getString())) {
                    return TernaryValue.UNKNOWN;
                }
                switch (op) {
                    case 14: 
                    case 16: {
                        return TernaryValue.FALSE;
                    }
                }
                return TernaryValue.UNKNOWN;
            }
            case 29: {
                if (leftLiteral) {
                    if (undefinedRight) {
                        return TernaryValue.forBoolean(PeepholeFoldConstants.compareToUndefined(left, op));
                    }
                    if (nullRight && PeepholeFoldConstants.isEqualityOp(op)) {
                        return TernaryValue.forBoolean(PeepholeFoldConstants.compareToNull(left, op));
                    }
                }
                return TernaryValue.UNKNOWN;
            }
            case 47: 
            case 63: 
            case 64: 
            case 105: {
                if (leftLiteral) {
                    if (undefinedRight) {
                        return TernaryValue.forBoolean(PeepholeFoldConstants.compareToUndefined(left, op));
                    }
                    if (nullRight && PeepholeFoldConstants.isEqualityOp(op)) {
                        return TernaryValue.forBoolean(PeepholeFoldConstants.compareToNull(left, op));
                    }
                }
                return TernaryValue.UNKNOWN;
            }
        }
        return TernaryValue.UNKNOWN;
    }

    private static TernaryValue areStringsEqual(String a, String b) {
        if (a.indexOf(11) != -1 || b.indexOf(11) != -1) {
            return TernaryValue.UNKNOWN;
        }
        return a.equals(b) ? TernaryValue.TRUE : TernaryValue.FALSE;
    }

    private static int getNormalizedNodeType(Node n) {
        int type = n.getType();
        if (type == 26) {
            TernaryValue value = NodeUtil.getPureBooleanValue(n);
            switch (value) {
                case TRUE: {
                    return 44;
                }
                case FALSE: {
                    return 43;
                }
                case UNKNOWN: {
                    return type;
                }
            }
        }
        return type;
    }

    private static TernaryValue compareAsNumbers(int op, Node left, Node right) {
        Double leftValue = NodeUtil.getNumberValue(left);
        if (leftValue == null) {
            return TernaryValue.UNKNOWN;
        }
        Double rightValue = NodeUtil.getNumberValue(right);
        if (rightValue == null) {
            return TernaryValue.UNKNOWN;
        }
        double lv = leftValue;
        double rv = rightValue;
        switch (op) {
            case 12: 
            case 45: {
                Preconditions.checkState((left.isNumber() && right.isNumber() ? 1 : 0) != 0);
                return TernaryValue.forBoolean(lv == rv);
            }
            case 13: 
            case 46: {
                Preconditions.checkState((left.isNumber() && right.isNumber() ? 1 : 0) != 0);
                return TernaryValue.forBoolean(lv != rv);
            }
            case 15: {
                return TernaryValue.forBoolean(lv <= rv);
            }
            case 14: {
                return TernaryValue.forBoolean(lv < rv);
            }
            case 17: {
                return TernaryValue.forBoolean(lv >= rv);
            }
            case 16: {
                return TernaryValue.forBoolean(lv > rv);
            }
        }
        return TernaryValue.UNKNOWN;
    }

    private static boolean compareToUndefined(Node value, int op) {
        Preconditions.checkState((boolean)NodeUtil.isLiteralValue(value, true));
        boolean valueUndefined = NodeUtil.isUndefined(value);
        boolean valueNull = 41 == value.getType();
        boolean equivalent = valueUndefined || valueNull;
        switch (op) {
            case 12: {
                return equivalent;
            }
            case 13: {
                return !equivalent;
            }
            case 45: {
                return valueUndefined;
            }
            case 46: {
                return !valueUndefined;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                return false;
            }
        }
        throw new IllegalStateException("unexpected.");
    }

    private static boolean isEqualityOp(int op) {
        switch (op) {
            case 12: 
            case 13: 
            case 45: 
            case 46: {
                return true;
            }
        }
        return false;
    }

    private static boolean compareToNull(Node value, int op) {
        boolean valueUndefined = NodeUtil.isUndefined(value);
        boolean valueNull = 41 == value.getType();
        boolean equivalent = valueUndefined || valueNull;
        switch (op) {
            case 12: {
                return equivalent;
            }
            case 13: {
                return !equivalent;
            }
            case 45: {
                return valueNull;
            }
            case 46: {
                return !valueNull;
            }
        }
        throw new IllegalStateException("unexpected.");
    }

    private Node tryFoldCtorCall(Node n) {
        Preconditions.checkArgument((boolean)n.isNew());
        if (this.inForcedStringContext(n)) {
            return this.tryFoldInForcedStringContext(n);
        }
        return n;
    }

    private boolean inForcedStringContext(Node n) {
        if (n.getParent().isGetElem() && n.getParent().getLastChild() == n) {
            return true;
        }
        return n.getParent().isAdd();
    }

    private Node tryFoldInForcedStringContext(Node n) {
        Preconditions.checkArgument((boolean)n.isNew());
        Node objectType = n.getFirstChild();
        if (!objectType.isName()) {
            return n;
        }
        if (objectType.getString().equals("String")) {
            Node value = objectType.getNext();
            String stringValue = null;
            if (value == null) {
                stringValue = "";
            } else {
                if (!NodeUtil.isImmutableValue(value)) {
                    return n;
                }
                stringValue = NodeUtil.getStringValue(value);
            }
            if (stringValue == null) {
                return n;
            }
            Node parent = n.getParent();
            Node newString = IR.string(stringValue);
            parent.replaceChild(n, newString);
            newString.copyInformationFrom(parent);
            this.reportCodeChange();
            return newString;
        }
        return n;
    }

    private Node tryFoldGetElem(Node n, Node left, Node right) {
        Preconditions.checkArgument((boolean)n.isGetElem());
        if (left.isObjectLit()) {
            return this.tryFoldObjectPropAccess(n, left, right);
        }
        if (left.isArrayLit()) {
            return this.tryFoldArrayAccess(n, left, right);
        }
        return n;
    }

    private Node tryFoldGetProp(Node n, Node left, Node right) {
        Preconditions.checkArgument((boolean)n.isGetProp());
        if (left.isObjectLit()) {
            return this.tryFoldObjectPropAccess(n, left, right);
        }
        if (right.isString() && right.getString().equals("length")) {
            int knownLength = -1;
            switch (left.getType()) {
                case 63: {
                    if (this.mayHaveSideEffects(left)) {
                        return n;
                    }
                    knownLength = left.getChildCount();
                    break;
                }
                case 40: {
                    knownLength = left.getString().length();
                    break;
                }
                default: {
                    return n;
                }
            }
            Preconditions.checkState((knownLength != -1 ? 1 : 0) != 0);
            Node lengthNode = IR.number(knownLength);
            n.getParent().replaceChild(n, lengthNode);
            this.reportCodeChange();
            return lengthNode;
        }
        return n;
    }

    private boolean isAssignmentTarget(Node n) {
        Node parent = n.getParent();
        return NodeUtil.isAssignmentOp(parent) && parent.getFirstChild() == n || parent.isInc() || parent.isDec();
    }

    private Node tryFoldArrayAccess(Node n, Node left, Node right) {
        if (this.isAssignmentTarget(n)) {
            return n;
        }
        if (!right.isNumber()) {
            return n;
        }
        double index = right.getDouble();
        int intIndex = (int)index;
        if ((double)intIndex != index) {
            this.report(INVALID_GETELEM_INDEX_ERROR, right);
            return n;
        }
        if (intIndex < 0) {
            this.report(INDEX_OUT_OF_BOUNDS_ERROR, right);
            return n;
        }
        Node current = left.getFirstChild();
        Node elem = null;
        int i = 0;
        while (current != null) {
            if (i != intIndex) {
                if (this.mayHaveSideEffects(current)) {
                    return n;
                }
            } else {
                elem = current;
            }
            current = current.getNext();
            ++i;
        }
        if (elem == null) {
            this.report(INDEX_OUT_OF_BOUNDS_ERROR, right);
            return n;
        }
        if (elem.isEmpty()) {
            elem = NodeUtil.newUndefinedNode(elem);
        } else {
            left.removeChild(elem);
        }
        n.getParent().replaceChild(n, elem);
        this.reportCodeChange();
        return elem;
    }

    private Node tryFoldObjectPropAccess(Node n, Node left, Node right) {
        Preconditions.checkArgument((boolean)NodeUtil.isGet(n));
        if (!left.isObjectLit() || !right.isString()) {
            return n;
        }
        if (this.isAssignmentTarget(n)) {
            return n;
        }
        Node key = null;
        Node value = null;
        block4: for (Node c = left.getFirstChild(); c != null; c = c.getNext()) {
            if (c.getString().equals(right.getString())) {
                switch (c.getType()) {
                    case 148: {
                        continue block4;
                    }
                    case 147: 
                    case 154: {
                        if (value != null && this.mayHaveSideEffects(value)) {
                            return n;
                        }
                        key = c;
                        value = key.getFirstChild();
                        continue block4;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            }
            if (!this.mayHaveSideEffects(c.getFirstChild())) continue;
            return n;
        }
        if (value == null) {
            return n;
        }
        if (value.isFunction() && NodeUtil.referencesThis(value)) {
            return n;
        }
        Node replacement = value.detachFromParent();
        if (key.isGetterDef()) {
            replacement = IR.call(replacement, new Node[0]);
            replacement.putBooleanProp(50, true);
        }
        n.getParent().replaceChild(n, replacement);
        this.reportCodeChange();
        return n;
    }
}

