/*
 * Decompiled with CFR 0.152.
 */
package spray.http;

import java.nio.charset.Charset;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple5;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import spray.http.ErrorInfo;
import spray.http.IllegalUriException;
import spray.http.Rendering;
import spray.http.StringRendering;
import spray.http.Uri;
import spray.http.Uri$Authority$;
import spray.http.Uri$Empty$;
import spray.http.Uri$Host$;
import spray.http.Uri$ParsingMode$Relaxed$;
import spray.http.Uri$Path$;
import spray.http.Uri$Path$Empty$;
import spray.http.Uri$Query$Empty$;
import spray.http.parser.ParserInput;
import spray.http.parser.ParserInput$;
import spray.http.parser.UriParser;
import spray.http.parser.UriParser$;
import spray.util.package$;

public final class Uri$
implements Serializable {
    public static final Uri$ MODULE$;
    private final Uri $div;
    private final Map<String, Object> defaultPorts;

    static {
        new Uri$();
    }

    public Uri $div() {
        return this.$div;
    }

    public Uri apply(String input) {
        return this.apply(ParserInput$.MODULE$.apply(input), package$.MODULE$.UTF8(), Uri$ParsingMode$Relaxed$.MODULE$);
    }

    public Uri apply(ParserInput input) {
        return this.apply(input, package$.MODULE$.UTF8(), Uri$ParsingMode$Relaxed$.MODULE$);
    }

    public Uri apply(ParserInput input, Uri.ParsingMode mode) {
        return this.apply(input, package$.MODULE$.UTF8(), mode);
    }

    public Uri apply(ParserInput input, Charset charset2, Uri.ParsingMode mode) {
        return new UriParser(input, charset2, mode).parseReference();
    }

    public Uri apply(String scheme, Uri.Authority authority, Uri.Path path, Uri.Query query, Option<String> fragment) {
        Uri.Path p = this.verifyPath(path, scheme, authority.host());
        return this.create(this.normalizeScheme(scheme), authority.normalizedFor(scheme), scheme.isEmpty() ? p : this.collapseDotSegments(p), query, fragment);
    }

    public String apply$default$1() {
        return "";
    }

    public Uri.Authority apply$default$2() {
        return Uri$Authority$.MODULE$.Empty();
    }

    public Uri.Path apply$default$3() {
        return Uri$Path$Empty$.MODULE$;
    }

    public Uri.Query apply$default$4() {
        return Uri$Query$Empty$.MODULE$;
    }

    public Option<String> apply$default$5() {
        return None$.MODULE$;
    }

    public Uri from(String scheme, String userinfo, String host, int port, String path, Uri.Query query, Option<String> fragment, Uri.ParsingMode mode) {
        return this.apply(scheme, new Uri.Authority(Uri$Host$.MODULE$.apply(host, package$.MODULE$.UTF8(), mode), this.normalizePort(port, scheme), userinfo), Uri$Path$.MODULE$.apply(path, Uri$Path$.MODULE$.apply$default$2()), query, fragment);
    }

    public String from$default$1() {
        return "";
    }

    public String from$default$2() {
        return "";
    }

    public String from$default$3() {
        return "";
    }

    public int from$default$4() {
        return 0;
    }

    public String from$default$5() {
        return "";
    }

    public Uri.Query from$default$6() {
        return Uri$Query$Empty$.MODULE$;
    }

    public Option<String> from$default$7() {
        return None$.MODULE$;
    }

    public Uri.ParsingMode from$default$8() {
        return Uri$ParsingMode$Relaxed$.MODULE$;
    }

    public Uri parseAbsolute(ParserInput input, Charset charset2, Uri.ParsingMode mode) {
        return new UriParser(input, charset2, mode).parseAbsolute();
    }

    public Charset parseAbsolute$default$2() {
        return package$.MODULE$.UTF8();
    }

    public Uri.ParsingMode parseAbsolute$default$3() {
        return Uri$ParsingMode$Relaxed$.MODULE$;
    }

    public Uri parseAndResolve(ParserInput string, Uri base, Charset charset2, Uri.ParsingMode mode) {
        return new UriParser(string, charset2, mode).parseAndResolveReference(base);
    }

    public Charset parseAndResolve$default$3() {
        return package$.MODULE$.UTF8();
    }

    public Uri.ParsingMode parseAndResolve$default$4() {
        return Uri$ParsingMode$Relaxed$.MODULE$;
    }

    public Uri parseHttpRequestTarget(ParserInput requestTarget, Charset charset2, Uri.ParsingMode mode) {
        return new UriParser(requestTarget, charset2, mode).parseHttpRequestTarget();
    }

    public Charset parseHttpRequestTarget$default$2() {
        return package$.MODULE$.UTF8();
    }

    public Uri.ParsingMode parseHttpRequestTarget$default$3() {
        return Uri$ParsingMode$Relaxed$.MODULE$;
    }

    public String normalize(ParserInput uri, Charset charset2, Uri.ParsingMode mode) {
        return this.apply(uri, charset2, mode).render(new StringRendering(), charset2).get();
    }

    public Charset normalize$default$2() {
        return package$.MODULE$.UTF8();
    }

    public Uri.ParsingMode normalize$default$3() {
        return Uri$ParsingMode$Relaxed$.MODULE$;
    }

    public Uri effectiveHttpRequestUri(String scheme, Uri.Host host, int port, Uri.Path path, Uri.Query query, Option<String> fragment, boolean securedConnection, Uri.Host hostHeaderHost, int hostHeaderPort, Uri.Authority defaultAuthority) {
        String _scheme = scheme;
        Uri.Host _host = host;
        int _port = port;
        if (_scheme.isEmpty()) {
            _scheme = this.httpScheme(securedConnection);
            if (_host.isEmpty()) {
                if (hostHeaderHost.isEmpty()) {
                    _host = defaultAuthority.host();
                    _port = defaultAuthority.port();
                } else {
                    _host = hostHeaderHost;
                    _port = hostHeaderPort;
                }
            }
        }
        return this.create(_scheme, "", _host, _port, this.collapseDotSegments(path), query, fragment);
    }

    public Uri.Authority effectiveHttpRequestUri$default$10() {
        return Uri$Authority$.MODULE$.Empty();
    }

    public String httpScheme(boolean securedConnection) {
        return securedConnection ? "https" : "http";
    }

    public boolean httpScheme$default$1() {
        return false;
    }

    public Map<String, Object> defaultPorts() {
        return this.defaultPorts;
    }

    public Uri resolve(String scheme, String userinfo, Uri.Host host, int port, Uri.Path path, Uri.Query query, Option<String> fragment, Uri base) {
        Uri uri;
        Predef$.MODULE$.require(base.isAbsolute(), (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Resolution base Uri must be absolute";
            }
        });
        if (scheme.isEmpty()) {
            if (host.isEmpty()) {
                if (path.isEmpty()) {
                    Uri.Query q = query.isEmpty() ? base.query() : query;
                    uri = this.create(base.scheme(), base.authority(), base.path(), q, fragment);
                } else {
                    Uri.Path p = path.startsWithSlash() ? path : this.mergePaths$1(base, path);
                    uri = this.create(base.scheme(), base.authority(), this.collapseDotSegments(p), query, fragment);
                }
            } else {
                uri = this.create(base.scheme(), userinfo, host, port, this.collapseDotSegments(path), query, fragment);
            }
        } else {
            uri = this.create(scheme, userinfo, host, port, this.collapseDotSegments(path), query, fragment);
        }
        return uri;
    }

    public Rendering encode(Rendering r, String string, Charset charset2, int keep, boolean replaceSpaces) {
        return this.rec$1(this.rec$default$1$1(), r, string, charset2, keep, replaceSpaces);
    }

    public boolean encode$default$5() {
        return false;
    }

    public String decode(String string, Charset charset2) {
        String string2;
        int ix = string.indexOf(37);
        if (ix >= 0) {
            String x$99 = string;
            Charset x$100 = charset2;
            int x$101 = ix;
            java.lang.StringBuilder x$102 = this.decode$default$4(x$99, x$100, x$101);
            string2 = this.decode(x$99, x$100, x$101, x$102);
        } else {
            string2 = string;
        }
        return string2;
    }

    public String decode(String string, Charset charset2, int ix, java.lang.StringBuilder sb) {
        block3: while (ix < string.length()) {
            java.lang.StringBuilder stringBuilder;
            int lastPercentSignIndexPlus3;
            char c = string.charAt(ix);
            switch (c) {
                default: {
                    sb = sb.append(c);
                    ++ix;
                    continue block3;
                }
                case '%': 
            }
            for (lastPercentSignIndexPlus3 = ix + 3; lastPercentSignIndexPlus3 < string.length() && string.charAt(lastPercentSignIndexPlus3) == '%'; lastPercentSignIndexPlus3 += 3) {
            }
            int bytesCount = (lastPercentSignIndexPlus3 - ix) / 3;
            byte[] bytes = new byte[bytesCount];
            if (this.decodeBytes$1(this.decodeBytes$default$1$1(), this.decodeBytes$default$2$1(), string, ix, bytesCount, bytes) >> 7 != 0) {
                stringBuilder = sb.append(new String(bytes, charset2));
            } else {
                this.appendBytes$1(this.appendBytes$default$1$1(), sb, bytesCount, bytes);
                stringBuilder = BoxedUnit.UNIT;
            }
            ix = lastPercentSignIndexPlus3;
        }
        return sb.toString();
    }

    public java.lang.StringBuilder decode$default$4(String string, Charset charset2, int ix) {
        return new java.lang.StringBuilder(string.length()).append(string, 0, ix);
    }

    public String normalizeScheme(String scheme) {
        String string;
        int n = this.verify$1(this.verify$default$1$1(scheme), this.verify$default$2$1(), this.verify$default$3$1(), scheme);
        switch (n) {
            default: {
                throw this.fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid URI scheme, unexpected character at pos ", " ('", "')"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)n), BoxesRunTime.boxToCharacter((char)scheme.charAt(n))})), this.fail$default$2());
            }
            case -1: {
                string = scheme;
                break;
            }
            case -2: {
                string = scheme.toLowerCase();
            }
        }
        return string;
    }

    public int normalizePort(int port, String scheme) {
        if (port >> 16 == 0) {
            return port != 0 && BoxesRunTime.unboxToInt((Object)this.defaultPorts().apply((Object)scheme)) == port ? 0 : port;
        }
        throw this.fail(new StringBuilder().append((Object)"Invalid port ").append((Object)BoxesRunTime.boxToInteger((int)port)).toString(), this.fail$default$2());
    }

    public Uri.Path verifyPath(Uri.Path path, String scheme, Uri.Host host) {
        if (host.isEmpty()) {
            if (path.startsWithSlash() && path.tail().startsWithSlash()) {
                throw this.fail("The path of an URI without authority must not begin with \"//\"", this.fail$default$2());
            }
        } else if (path.startsWithSegment()) {
            throw this.fail("The path of an URI containing an authority must either be empty or start with a '/' (slash) character", this.fail$default$2());
        }
        return path;
    }

    public Uri.Path collapseDotSegments(Uri.Path path) {
        return this.hasDotOrDotDotSegment$1(path) ? this.process$1(path, this.process$default$2$1()) : path;
    }

    public Nothing$ fail(String summary, String detail) {
        throw new IllegalUriException(new ErrorInfo(summary, detail));
    }

    public String fail$default$2() {
        return "";
    }

    public Uri create(String scheme, String userinfo, Uri.Host host, int port, Uri.Path path, Uri.Query query, Option<String> fragment) {
        return this.create(scheme, new Uri.Authority(host, this.normalizePort(port, scheme), userinfo), path, query, fragment);
    }

    public Uri create(String scheme, Uri.Authority authority, Uri.Path path, Uri.Query query, Option<String> fragment) {
        return path.isEmpty() && scheme.isEmpty() && authority.isEmpty() && query.isEmpty() && fragment.isEmpty() ? Uri$Empty$.MODULE$ : new Uri(scheme, authority, path, query, (Option)fragment){

            public boolean isEmpty() {
                return false;
            }
        };
    }

    public Option<Tuple5<String, Uri.Authority, Uri.Path, Uri.Query, Option<String>>> unapply(Uri x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple5((Object)x$0.scheme(), (Object)x$0.authority(), (Object)x$0.path(), (Object)x$0.query(), x$0.fragment()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    /*
     * Unable to fully structure code
     */
    private final Uri.Path replaceLastSegment$1(Uri.Path p, Uri.Path replacement) {
        block10: {
            block8: {
                block9: {
                    block7: {
                        block6: {
                            block5: {
                                var3_3 = p;
                                v0 = Uri$Path$Empty$.MODULE$;
                                var4_4 = var3_3;
                                if (v0 != null ? v0.equals(var4_4) == false : var4_4 != null) break block5;
                                var5_5 = true;
                                break block6;
                            }
                            if (!(var3_3 instanceof Uri.Path.Segment)) ** GOTO lbl-1000
                            var6_6 = (Uri.Path.Segment)var3_3;
                            var7_7 = var6_6.tail();
                            v1 = Uri$Path$Empty$.MODULE$;
                            var8_8 = var7_7;
                            if (!(v1 != null ? v1.equals(var8_8) == false : var8_8 != null)) {
                                var5_5 = true;
                            } else lbl-1000:
                            // 2 sources

                            {
                                var5_5 = false;
                            }
                        }
                        if (!var5_5) break block7;
                        var9_9 = replacement;
                        break block8;
                    }
                    if (!(var3_3 instanceof Uri.Path.Segment)) break block9;
                    var10_10 = (Uri.Path.Segment)var3_3;
                    string = var10_10.head();
                    tail = var10_10.tail();
                    var13_13 = string;
                    var9_9 = this.replaceLastSegment$1(tail, replacement).$colon$colon(var13_13);
                    break block8;
                }
                if (!(var3_3 instanceof Uri.Path.Slash)) break block10;
                var14_14 = (Uri.Path.Slash)var3_3;
                tail = var14_14.tail();
                var9_9 = new Uri.Path.Slash(this.replaceLastSegment$1(tail, replacement));
            }
            return var9_9;
        }
        throw new MatchError((Object)var3_3);
    }

    private final Uri.Path mergePaths$1(Uri base, Uri.Path path) {
        return !base.authority().isEmpty() && path.isEmpty() ? new Uri.Path.Slash(path) : this.replaceLastSegment$1(base.path(), path);
    }

    public final void spray$http$Uri$$appendEncoded$1(byte by, Rendering r$1) {
        r$1.$tilde$tilde('%').$tilde$tilde(UriParser$.MODULE$.hexDigit(by >>> 4)).$tilde$tilde(UriParser$.MODULE$.hexDigit(by));
    }

    private final Rendering rec$1(int ix, Rendering r$1, String string$1, Charset charset$1, int keep$1, boolean replaceSpaces$1) {
        while (ix < string$1.length()) {
            Rendering rendering;
            char c = string$1.charAt(ix);
            if (UriParser$.MODULE$.is(c, keep$1)) {
                rendering = r$1.$tilde$tilde(c);
            } else if (' ' == c && replaceSpaces$1) {
                rendering = r$1.$tilde$tilde('+');
            } else if (c <= '\u007f') {
                this.spray$http$Uri$$appendEncoded$1((byte)c, r$1);
                rendering = BoxedUnit.UNIT;
            } else {
                Predef$.MODULE$.byteArrayOps(((Object)BoxesRunTime.boxToCharacter((char)c)).toString().getBytes(charset$1)).foreach((Function1)new Serializable(r$1){
                    public static final long serialVersionUID = 0L;
                    private final Rendering r$1;

                    public final void apply(byte by) {
                        Uri$.MODULE$.spray$http$Uri$$appendEncoded$1(by, this.r$1);
                    }
                    {
                        this.r$1 = r$1;
                    }
                });
                rendering = BoxedUnit.UNIT;
            }
            ++ix;
        }
        return r$1;
    }

    private final int rec$default$1$1() {
        return 0;
    }

    private final int intValueOfHexChar$1(int j, String string$3) {
        char c = string$3.charAt(j);
        if (UriParser$.MODULE$.is(c, 124)) {
            return UriParser$.MODULE$.hexValue(c);
        }
        throw new IllegalArgumentException(new StringBuilder().append((Object)"Illegal percent-encoding at pos ").append((Object)BoxesRunTime.boxToInteger((int)j)).toString());
    }

    private final int intValueOfHexWord$1(int i, String string$3) {
        return this.intValueOfHexChar$1(i, string$3) * 16 + this.intValueOfHexChar$1(i + 1, string$3);
    }

    private final int decodeBytes$1(int i, int oredBytes, String string$3, int ix$1, int bytesCount$1, byte[] bytes$1) {
        while (i < bytesCount$1) {
            int n = this.intValueOfHexWord$1(ix$1 + 3 * i + 1, string$3);
            bytes$1[i] = (byte)n;
            oredBytes |= n;
            ++i;
        }
        return oredBytes;
    }

    private final int decodeBytes$default$1$1() {
        return 0;
    }

    private final int decodeBytes$default$2$1() {
        return 0;
    }

    private final void appendBytes$1(int i, java.lang.StringBuilder sb$1, int bytesCount$1, byte[] bytes$1) {
        while (i < bytesCount$1) {
            sb$1.append((char)bytes$1[i]);
            ++i;
        }
    }

    private final int appendBytes$default$1$1() {
        return 0;
    }

    private final int verify$1(int ix, int allowed, boolean allLower, String scheme$2) {
        int n;
        block2: {
            while (ix >= 0) {
                char c = scheme$2.charAt(ix);
                if (UriParser$.MODULE$.is(c, allowed)) {
                    allLower = allLower && !UriParser$.MODULE$.is(c, 2);
                    allowed = 114719;
                    --ix;
                    continue;
                }
                n = ix;
                break block2;
            }
            n = allLower ? -1 : -2;
        }
        return n;
    }

    private final int verify$default$1$1(String scheme$2) {
        return scheme$2.length() - 1;
    }

    private final int verify$default$2$1() {
        return 3;
    }

    private final boolean verify$default$3$1() {
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean hasDotOrDotDotSegment$1(Uri.Path p) {
        while (true) {
            Uri.Path path = p;
            Uri$Path$Empty$ uri$Path$Empty$ = Uri$Path$Empty$.MODULE$;
            Uri.Path path2 = path;
            if (uri$Path$Empty$ == null) {
                if (path2 == null) return false;
            } else if (uri$Path$Empty$.equals(path2)) {
                return false;
            }
            if (path instanceof Uri.Path.Segment) {
                String string;
                Uri.Path.Segment segment = (Uri.Path.Segment)path;
                String string2 = string = segment.head();
                if ("." == null) {
                    if (string2 == null) return true;
                } else if (".".equals(string2)) {
                    return true;
                }
            }
            if (path instanceof Uri.Path.Segment) {
                String string;
                Uri.Path.Segment segment = (Uri.Path.Segment)path;
                String string3 = string = segment.head();
                if (".." == null) {
                    if (string3 == null) return true;
                } else if ("..".equals(string3)) {
                    return true;
                }
            }
            boolean bl = false;
            if (bl) {
                return true;
            }
            p = p.tail();
        }
    }

    private final Uri.Path process$1(Uri.Path input, Uri.Path output) {
        Uri.Path path;
        while (true) {
            Uri.Path path2;
            boolean bl = false;
            Uri.Path.Segment segment = null;
            boolean bl2 = false;
            Uri.Path.Slash slash = null;
            path = input;
            Uri$Path$Empty$ uri$Path$Empty$ = Uri$Path$Empty$.MODULE$;
            Uri.Path path3 = path;
            if (!(uri$Path$Empty$ != null ? !uri$Path$Empty$.equals(path3) : path3 != null)) {
                Uri.Path path4 = output.reverse();
                return path4;
            }
            if (path instanceof Uri.Path.Segment) {
                boolean bl3;
                bl = true;
                segment = (Uri.Path.Segment)path;
                String string = segment.head();
                Uri.Path.SlashOrEmpty slashOrEmpty = segment.tail();
                String string2 = string;
                if (!("." != null ? !".".equals(string2) : string2 != null)) {
                    bl3 = true;
                } else {
                    String string3 = string;
                    bl3 = !(".." != null ? !"..".equals(string3) : string3 != null);
                }
                if (bl3 && slashOrEmpty instanceof Uri.Path.Slash) {
                    Uri.Path tail;
                    Uri.Path.Slash slash2 = (Uri.Path.Slash)slashOrEmpty;
                    input = tail = slash2.tail();
                    continue;
                }
            }
            if (path instanceof Uri.Path.Slash) {
                bl2 = true;
                slash = (Uri.Path.Slash)path;
                Uri.Path path5 = slash.tail();
                if (path5 instanceof Uri.Path.Segment) {
                    Uri.Path.Segment segment2 = (Uri.Path.Segment)path5;
                    String string = segment2.head();
                    Uri.Path.SlashOrEmpty tail = segment2.tail();
                    String string4 = string;
                    if (!("." != null ? !".".equals(string4) : string4 != null)) {
                        input = tail.isEmpty() ? Uri$Path$.MODULE$.$div() : tail;
                        continue;
                    }
                }
            }
            if (bl2 && (path2 = slash.tail()) instanceof Uri.Path.Segment) {
                Uri.Path.Segment segment3 = (Uri.Path.Segment)path2;
                String string = segment3.head();
                Uri.Path.SlashOrEmpty tail = segment3.tail();
                String string5 = string;
                if (!(".." != null ? !"..".equals(string5) : string5 != null)) {
                    output = output.startsWithSegment() ? (output.tail().startsWithSlash() ? output.tail().tail() : tail) : output;
                    input = tail.isEmpty() ? Uri$Path$.MODULE$.$div() : tail;
                    continue;
                }
            }
            if (bl) {
                boolean bl4;
                String string = segment.head();
                Uri.Path.SlashOrEmpty tail = segment.tail();
                String string6 = string;
                if (!("." != null ? !".".equals(string6) : string6 != null)) {
                    bl4 = true;
                } else {
                    String string7 = string;
                    bl4 = !(".." != null ? !"..".equals(string7) : string7 != null);
                }
                if (bl4) {
                    input = tail;
                    continue;
                }
            }
            if (bl2) {
                Uri.Path tail = slash.tail();
                output = new Uri.Path.Slash(output);
                input = tail;
                continue;
            }
            if (!bl) break;
            String string = segment.head();
            Uri.Path.SlashOrEmpty tail = segment.tail();
            String string8 = string;
            output = output.$colon$colon(string8);
            input = tail;
        }
        throw new MatchError((Object)path);
    }

    private final Uri.Path process$default$2$1() {
        return Uri$Path$Empty$.MODULE$;
    }

    private Uri$() {
        MODULE$ = this;
        this.$div = this.apply("/");
        this.defaultPorts = ((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"ftp"), (Object)BoxesRunTime.boxToInteger((int)21)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"ssh"), (Object)BoxesRunTime.boxToInteger((int)22)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"telnet"), (Object)BoxesRunTime.boxToInteger((int)23)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"smtp"), (Object)BoxesRunTime.boxToInteger((int)25)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"domain"), (Object)BoxesRunTime.boxToInteger((int)53)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"tftp"), (Object)BoxesRunTime.boxToInteger((int)69)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"http"), (Object)BoxesRunTime.boxToInteger((int)80)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"pop3"), (Object)BoxesRunTime.boxToInteger((int)110)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"nntp"), (Object)BoxesRunTime.boxToInteger((int)119)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"imap"), (Object)BoxesRunTime.boxToInteger((int)143)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"snmp"), (Object)BoxesRunTime.boxToInteger((int)161)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"ldap"), (Object)BoxesRunTime.boxToInteger((int)389)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"https"), (Object)BoxesRunTime.boxToInteger((int)443)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"imaps"), (Object)BoxesRunTime.boxToInteger((int)993)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"nfs"), (Object)BoxesRunTime.boxToInteger((int)2049))}))).withDefaultValue((Object)BoxesRunTime.boxToInteger((int)-1));
    }
}

