/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.gmaven.feature.support;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.codehaus.gmaven.feature.Configuration;
import org.codehaus.gmaven.feature.Feature;
import org.codehaus.gmaven.feature.FeatureException;
import org.codehaus.gmaven.feature.Provider;
import org.codehaus.gmaven.feature.ProviderException;
import org.codehaus.gmaven.feature.Version;
import org.codehaus.gmaven.feature.support.FeatureSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ProviderSupport
implements Provider {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected final String key;
    protected final Configuration config;
    protected Version version;
    protected Boolean supported;
    protected Map features;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected ProviderSupport(String key, Configuration config) {
        if (!$assertionsDisabled && key == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && config == null) {
            throw new AssertionError();
        }
        this.key = key;
        this.config = config;
    }

    protected ProviderSupport(String key) {
        this(key, new Configuration());
    }

    public String toString() {
        return ProviderSupport.asString(this);
    }

    public int hashCode() {
        return this.key().hashCode();
    }

    public String key() {
        return this.key;
    }

    public String name() {
        return this.key();
    }

    protected abstract Version detectVersion();

    public synchronized Version version() {
        if (this.version == null) {
            this.version = this.detectVersion();
        }
        return this.version;
    }

    protected boolean detectSupported() {
        return true;
    }

    public synchronized boolean supported() {
        if (this.supported == null) {
            this.supported = this.detectSupported();
        }
        return this.supported;
    }

    public void require() {
        if (!this.supported()) {
            throw new ProviderException("Provider not supported: " + this.key());
        }
    }

    public Configuration config() {
        return this.config;
    }

    protected abstract Map detectFeatures();

    public synchronized Collection features() {
        if (this.features == null) {
            Map detected = this.detectFeatures();
            this.log.debug("Detected features:");
            Iterator iter = detected.values().iterator();
            while (iter.hasNext()) {
                Feature feature = (Feature)iter.next();
                this.log.debug("    {}", (Object)feature);
                if (!(feature instanceof FeatureSupport)) continue;
                ((FeatureSupport)feature).register(this);
            }
            this.features = new HashMap(detected);
        }
        return Collections.unmodifiableCollection(this.features.values());
    }

    public synchronized Feature feature(String key) {
        if (!$assertionsDisabled && key == null) {
            throw new AssertionError();
        }
        if (this.features == null) {
            this.features();
        }
        if (!this.features.containsKey(key)) {
            throw new FeatureException("Unknown feature: " + key);
        }
        return (Feature)this.features.get(key);
    }

    public Feature feature(Class key) {
        if (!$assertionsDisabled && key == null) {
            throw new AssertionError();
        }
        return this.feature(key.getName());
    }

    public static String asString(Provider provider) {
        if (!$assertionsDisabled && provider == null) {
            throw new AssertionError();
        }
        StringBuffer buff = new StringBuffer();
        buff.append("[");
        buff.append(provider.key());
        buff.append("]");
        if (provider.key() != provider.name()) {
            buff.append(" '");
            buff.append(provider.name());
            buff.append("'");
        }
        buff.append(" (version: ");
        buff.append(provider.version());
        buff.append(", type: ");
        buff.append(provider.getClass().getName());
        buff.append(")");
        return buff.toString();
    }

    static {
        $assertionsDisabled = !ProviderSupport.class.desiredAssertionStatus();
    }
}

