/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.gshell.io;

import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.PrintStream;
import org.sonatype.gshell.io.Closer;
import org.sonatype.gshell.io.Flusher;

public class StreamSet {
    public final InputStream in;
    public final PrintStream out;
    public final PrintStream err;
    public static final StreamSet SYSTEM = StreamSet.system();
    public static final StreamSet SYSTEM_FD = new StreamSet(new FileInputStream(FileDescriptor.in), new PrintStream(new FileOutputStream(FileDescriptor.out)), new PrintStream(new FileOutputStream(FileDescriptor.err)));

    public StreamSet(InputStream in, PrintStream out, PrintStream err) {
        assert (in != null);
        assert (out != null);
        assert (err != null);
        this.in = in;
        this.out = out;
        this.err = err;
    }

    public StreamSet(InputStream in, PrintStream out) {
        this(in, out, out);
    }

    public boolean isOutputCombined() {
        return this.out == this.err;
    }

    public InputStream getInput() {
        return this.in;
    }

    public PrintStream getOutput(OutputType type) {
        assert (type != null);
        switch (type) {
            case OUT: {
                return this.out;
            }
            case ERR: {
                return this.err;
            }
        }
        throw new InternalError();
    }

    public void flush() {
        Flusher.flush(this.out);
        if (!this.isOutputCombined()) {
            Flusher.flush(this.err);
        }
    }

    public void close() {
        Closer.close(this.in, this.out);
        if (!this.isOutputCombined()) {
            Closer.close(this.err);
        }
    }

    private String objectId(Object obj) {
        assert (obj != null);
        return obj.getClass().getSimpleName() + "@" + System.identityHashCode(obj);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{in=" + this.objectId(this.in) + ", out=" + this.objectId(this.out) + ", err=" + this.objectId(this.err) + "}";
    }

    public static StreamSet system() {
        return new StreamSet(System.in, System.out, System.err);
    }

    public static void system(StreamSet streams) {
        assert (streams != null);
        System.setIn(streams.in);
        System.setOut(streams.out);
        System.setErr(streams.err);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OutputType {
        OUT,
        ERR;

    }
}

