'use strict';var xlrelease=angular.module('xlrelease',['$strap.directives','ngSanitize','ngRoute','ui.sortable']);xlrelease.value('XLRelease',{version:'4.0.2'});xlrelease.config(['$routeProvider',function($routeProvider){$routeProvider.when('/default',{template:'<div></div>',controller:'defaultRouteController'}).when('/login',{templateUrl:'partials/login/login.html',controller:'loginController'}).when('/tasks',{templateUrl:'partials/tasks/tasks.html',controller:'tasksController',resolve:{filterSettings:['Filters',function(Filters){return Filters.getTasksFilterSettings();}]}}).when('/pipeline',{templateUrl:'partials/releases/pipeline.html',controller:'pipelineController',resolve:{filterSettings:['Filters',function(Filters){return Filters.getPipelineFilterSettings();}]}}).when('/releases',{templateUrl:'partials/releases/releases.html',controller:'releasesController',resolve:{filterSettings:['Filters',function(Filters){return Filters.getReleasesFilterSettings()}]}}).when('/releases/create',{templateUrl:'partials/releases/release-properties.html',controller:'releasePropertiesController'}).when('/releases/:releaseId',{templateUrl:'partials/releases/release-editor.html',controller:'releaseEditorController'}).when('/releases/:releaseId/summary',{templateUrl:'partials/releases/summary/release-summary.html',controller:'releaseSummaryController',resolve:{releasePromise:['ReleasesService','$route',function(ReleasesService,$route){return ReleasesService.getRelease($route.current.params.releaseId)}],releaseDependenciesPromise:['ReleasesService','$route',function(ReleasesService,$route){return ReleasesService.getReleaseDependencies($route.current.params.releaseId)}]}}).when('/releases/:releaseId/planner',{templateUrl:'partials/releases/gantt/gantt.html',controller:'ganttController',resolve:{releasePromise:['ReleasesService','$route',function(ReleasesService,$route){return ReleasesService.getRelease($route.current.params.releaseId)}]}}).when('/releases/:releaseId/permissions',{templateUrl:'partials/security/permissions.html',controller:'permissionsController'}).when('/releases/:releaseId/teams',{templateUrl:'partials/releases/teams.html',controller:'teamsController',resolve:{releasePromise:['ReleasesService','$route',function(ReleasesService,$route){return ReleasesService.getRelease($route.current.params.releaseId)}],teamsPromise:['TeamsService','$route',function(TeamsService,$route){return TeamsService.getTeams($route.current.params.releaseId)}],usersPromise:['UsersService',function(UsersService){return UsersService.getAllUsers()}],roleNamesPromise:['RolesService',function(RolesService){return RolesService.getRoleNames()}]}}).when('/releases/:releaseId/logs',{templateUrl:'partials/releases/logs.html',controller:'logsController',resolve:{filterSettings:['Filters','$route',function(Filters,$route){return Filters.getLogsFiltersSettings($route.current.params.releaseId)}]}}).when('/releases/:releaseId/properties',{templateUrl:'partials/releases/release-properties.html',controller:'releasePropertiesController'}).when('/templates',{templateUrl:'partials/templates/templates.html',controller:'templatesController',resolve:{filters:['Filters',function(Filters){return Filters.getTemplatesFilterSettings()}]}}).when('/templates/create',{templateUrl:'partials/templates/template-properties.html',controller:'templatePropertiesController'}).when('/templates/:releaseId',{templateUrl:'partials/releases/release-editor.html',controller:'releaseEditorController'}).when('/templates/:releaseId/permissions',{templateUrl:'partials/security/template-permissions.html',controller:'templatePermissionsController'}).when('/templates/:releaseId/teams',{templateUrl:'partials/releases/teams.html',controller:'teamsController',resolve:{releasePromise:['ReleasesService','$route',function(ReleasesService,$route){return ReleasesService.getRelease($route.current.params.releaseId)}],teamsPromise:['TeamsService','$route',function(TeamsService,$route){return TeamsService.getTeams($route.current.params.releaseId)}],usersPromise:['UsersService',function(UsersService){return UsersService.getAllUsers()}],roleNamesPromise:['RolesService',function(RolesService){return RolesService.getRoleNames()}]}}).when('/templates/:releaseId/logs',{templateUrl:'partials/releases/logs.html',controller:'logsController',resolve:{filterSettings:['Filters','$route',function(Filters,$route){return Filters.getLogsFiltersSettings($route.current.params.releaseId)}]}}).when('/templates/:releaseId/properties',{templateUrl:'partials/templates/template-properties.html',controller:'templatePropertiesController'}).when('/templates/:releaseId/planner',{templateUrl:'partials/releases/gantt/gantt.html',controller:'ganttController',resolve:{releasePromise:['ReleasesService','$route',function(ReleasesService,$route){return ReleasesService.getRelease($route.current.params.releaseId)}]}}).when('/profile',{templateUrl:'partials/profile/profile.html',controller:'profileController'}).when('/users',{templateUrl:'partials/security/users.html',controller:'usersController'}).when('/roles',{templateUrl:'partials/security/roles.html',controller:'rolesController'}).when('/permissions',{templateUrl:'partials/security/permissions.html',controller:'permissionsController'}).when('/reports-settings',{templateUrl:'partials/reports/reports-settings.html',controller:'reportsSettingsController'}).when('/servers',{templateUrl:'partials/deployit/servers.html',controller:'serversController'}).when('/calendar',{templateUrl:'partials/calendar/calendar.html',controller:'calendarController',resolve:{filterSettings:['Filters',function(Filters){return Filters.getCalendarFilterSettings()}],initCurrentDate:['CalendarResolver',function(CalendarResolver){return CalendarResolver.initCurrentDate()}]}}).when('/dashboard',{templateUrl:'partials/reports/dashboard.html',controller:'reportsController',resolve:{filterSettings:['Filters',function(Filters){return Filters.getReportsFiltersSettings()}]}}).when('/release-automation',{templateUrl:'partials/reports/release-automation.html',controller:'reportsController',resolve:{filterSettings:['Filters',function(Filters){return Filters.getReportsFiltersSettings()}]}}).when('/release-value-stream',{templateUrl:'partials/value-stream-mapping/release-value-stream.html',controller:'releaseValueStreamController',resolve:{filterSettings:['Filters',function(Filters){return Filters.getReleaseValueStreamFilterSettings()}]}}).when('/smtp',{templateUrl:'partials/smtp/smtp.html',controller:'smtpController'}).when('/configuration',{templateUrl:'partials/configuration/configuration-list.html',controller:'configurationListController'}).when('/configuration/:configurationInstanceId',{templateUrl:'partials/configuration/configuration-instance.html',controller:'configurationInstanceController'}).when('/configuration/create/:configurationInstanceType',{templateUrl:'partials/configuration/configuration-instance.html',controller:'configurationInstanceController'}).when('/forbidden-access',{templateUrl:'partials/server-error/forbidden-access.html',controller:'forbiddenAccessController'}).when('/invalid-license',{templateUrl:'partials/licenses/invalid-license.html',controller:'licenseController'}).when('/download-ie8',{templateUrl:'partials/download-ie8/download-ie8.html',controller:'downloadIe8Controller'}).otherwise({redirectTo:'/default'});}]);xlrelease.config(['$httpProvider',function($httpProvider){$httpProvider.defaults.headers.post['Content-Type']='application/json';}]);xlrelease.factory('XlReleaseStarter',['Authenticator','UserProfile',function(Authenticator,UserProfile){return{start:function(){Authenticator.init();if(Authenticator.isAuthenticated()){UserProfile.load();}}};}]);var xlreleaseStartup=angular.module('xlreleaseStartup',['xlrelease']);xlreleaseStartup.run(['XlReleaseStarter',function(XlReleaseStarter){XlReleaseStarter.start();}]);'use strict';angular.module('xlrelease').factory('Filters',['$q','$location','ClientSettings',function($q,$location,ClientSettings){function filterDefinition(defaults){var booleans=_.chain(defaults).pick(function(value){return typeof value=="boolean";}).keys().value();var strings=_.chain(defaults).pick(function(value){return typeof value=="string";}).keys().value();var hasEmptyDefaultQueryString=_.chain(defaults).values().all(function(value){return value===false||value==='';}).value();return{defaults:defaults,names:_.keys(defaults),eachBoolean:function(callback){_.each(booleans,callback);},eachString:function(callback){_.each(strings,callback);},hasEmptyDefaultQueryString:hasEmptyDefaultQueryString}}
function generateGetter(defaults,getFromLocalStorage,putInLocalStorage){var definition=filterDefinition(defaults);return function(){var deferred=$q.defer();var queryFilters=getQueryFilters();if(queryFilters){saveFilters(queryFilters);deferred.resolve(queryFilters);}else{useSavedOrDefaultsFilters();deferred.reject();}
return deferred.promise;};function getQueryFilters(){return fromQueryString($location.search(),definition);}
function saveFilters(queryFilters){putInLocalStorage(queryFilters);}
function useSavedOrDefaultsFilters(){var queryString=$location.search();var filters=getSavedOrDefaultsFilters();_.extend(queryString,asQueryString(filters));$location.search(queryString).replace();}
function getSavedOrDefaultsFilters(){return getFromLocalStorage()||definition.defaults;}}
function generateMapItemGetter(defaults,getFromLocalStorage,putInLocalStorage){return function(id){return generateGetter(defaults,_.partial(getFromLocalStorage,id),_.partial(putInLocalStorage,id))();}}
var HAS_FILTER="has_filter";var MUST_NOT_BE_EMPTY=["timeFrame"];function fromQueryString(queryString,definition){if(!queryString[HAS_FILTER]){return null;}
var filter=_.pick(queryString,definition.names);definition.eachBoolean(function(name){filter[name]=!!filter[name];});definition.eachString(function(name){if(!filter[name]){if(MUST_NOT_BE_EMPTY.indexOf(name)!==-1){filter[name]=definition.defaults[name];}else{filter[name]="";}}});return filter;}
function asQueryString(filters){var queryString={};queryString[HAS_FILTER]=true;_.each(filters,function(value,key){if(value===true){queryString[key]=true;}else if(angular.isString(value)&&value.length>0){queryString[key]=value;}else if(angular.isNumber(value)){queryString[key]=value;}});return queryString;}
function dateFromFilter(dateFilter){return(dateFilter)?moment.utc(parseInt(dateFilter,10)).local().toDate():null;}
function dateForFilter(date){return(date)?moment(date).valueOf():null;}
var releasesDefaults={active:true,planned:true,completed:false,onlyMine:false,onlyFlagged:false,filter:'',from:null,to:null};var tasksDefaults={active:true,assignedToMe:true,assignedToMyTeams:true,assignedToOthers:false,notAssigned:false,filter:'',from:null,to:null};var reportsDefaults={timeFrame:'LAST_SIX_MONTHS',tags:'',from:null,to:null};var templatesDefaults={filter:''};var pipelineDefaults={onlyMine:false,onlyFlagged:false,filter:''};var releaseValueStreamDefaults={filter:'',from:null,to:null,timeFrame:'LAST_MONTH'};var logsDefaults={filter:'',from:null,to:null,important:true,releaseEdit:false,taskEdit:false,comments:false,lifecycle:false,reassign:false,security:false,other:false,dateAsc:false};return{getTasksFilterSettings:generateGetter(tasksDefaults,ClientSettings.getTasksFilters,ClientSettings.setTasksFilters),getReleasesFilterSettings:generateGetter(releasesDefaults,ClientSettings.getReleasesListFilters,ClientSettings.setReleasesListFilters),getCalendarFilterSettings:generateGetter(releasesDefaults,ClientSettings.getCalendarFilters,ClientSettings.setCalendarFilters),getReportsFiltersSettings:generateGetter(reportsDefaults,ClientSettings.getReportsFilters,ClientSettings.setReportsFilters),getTemplatesFilterSettings:generateGetter(templatesDefaults,ClientSettings.getTemplatesListFilters,ClientSettings.setTemplatesListFilters),getPipelineFilterSettings:generateGetter(pipelineDefaults,ClientSettings.getPipelineFilters,ClientSettings.setPipelineFilters),getReleaseValueStreamFilterSettings:generateGetter(releaseValueStreamDefaults,ClientSettings.getReleaseValueStreamFilters,ClientSettings.setReleaseValueStreamFilters),getLogsFiltersSettings:generateMapItemGetter(logsDefaults,ClientSettings.getLogsFilters,ClientSettings.setLogsFilters),asQueryString:asQueryString,dateFromFilter:dateFromFilter,dateForFilter:dateForFilter};}]);'use strict';angular.module('xlrelease').controller('filtersController',['$scope','$location','Filters',function($scope,$location,Filters){$scope.currentFilter={search:$scope.filters.filter,from:Filters.dateFromFilter($scope.filters.from),to:Filters.dateFromFilter($scope.filters.to),tags:$scope.filters.tags?$scope.filters.tags.split(','):[]};$scope.updateTags=function(tags){if(tags.length>0){$scope.filters.tags=tags.join(',');}else{$scope.filters.tags='';}};$scope.$watch('filters',function(newFilters,oldFilters){if(!angular.equals(oldFilters,newFilters)){setTimeFilters();$location.search(Filters.asQueryString($scope.filters));}},true);function setTimeFilters(){if($scope.filters.timeFrame){var usingRange=$scope.filters.timeFrame==='ALL_TIME'||$scope.filters.timeFrame==='RANGE';if(usingRange){$scope.filters.timeFrame='RANGE';}else{$scope.filters.from=undefined;$scope.filters.to=undefined;}}}
$scope.delayedWatch(500,'currentFilter.search',function(newFilter){$location.search('filter',newFilter);});$scope.delayedWatch(100,'currentFilter.from',function(from){$location.search('from',Filters.dateForFilter(from));});$scope.delayedWatch(100,'currentFilter.to',function(to){$location.search('to',Filters.dateForFilter(to));});}]);angular.module('xlrelease').factory('Backend',['$http','XLRelease','ClientSettings',function($http,XLRelease,ClientSettings){var DELETE_CONFIG={method:'DELETE',data:null,headers:{'Content-Type':'application/json'}};return{post:function(url,data,config){if(angular.isUndefined(data)){data={};}
return $http.post(url,data,authenticate(config));},get:function(url,config){return $http.get(url,authenticate(this._extendWithVersion(this._extendWithCacheBuster(config))));},put:function(url,data,config){if(angular.isUndefined(data)){data={};}
return $http.put(url,data,authenticate(this._extendWithVersion(config)));},del:function(url,config){var extendedConfig=angular.extend({},config||{},DELETE_CONFIG);extendedConfig.url=url;return $http(authenticate(this._extendWithVersion(extendedConfig)));},_extendWithCacheBuster:function(config){var cacheBuster={cb:new Date().getTime()};return addParams(config,cacheBuster);},_extendWithVersion:function(config){var version={xlrv:XLRelease.version};return addParams(config,version);}};function addParams(config,params){var extendedConfig=config?angular.copy(config):{};extendedConfig.params=angular.extend({},extendedConfig.params||{},params);return extendedConfig;}
function authenticate(config){var extendedConfig=config?angular.copy(config):{};extendedConfig.headers=extendedConfig.headers||{};var authenticationData=ClientSettings.getAuthenticationData();if(authenticationData!==null){extendedConfig.headers.Authorization=extendedConfig.headers.Authorization||authenticationData.credentials;}
return extendedConfig;}}]);angular.module('xlrelease').config(['$httpProvider','Events',function($httpProvider,Events){var INVALID_LICENSE_PAGE='/invalid-license';var SECURITY_ENDPOINT='security';var UNAUTHORIZED=401;var PAYMENT_REQUIRED=402;var FORBIDDEN=403;var VERSION_CHANGED=410;var SERVER_DOWN_CODE=0;var IE8_SERVER_DOWN_CODE=12029;var DELAY_BEFORE_AJAX_SPINNER=1000;var ajaxSpinnerTimers=[];$httpProvider.interceptors.push(['$rootScope','$q','$location','Alerts','VersionEnforcer',function($rootScope,$q,$location,Alerts,VersionEnforcer){return{request:function(request){ajaxSpinnerTimers.push(setTimeout(function(){angular.element('#loading').show();},DELAY_BEFORE_AJAX_SPINNER));VersionEnforcer.addPrefix(request);return request;},response:function(response){hideSpinner();return response;},responseError:function(response){hideSpinner();var status=response.status;var isPermissionsEndpoint=response.config.url===SECURITY_ENDPOINT;if(status===PAYMENT_REQUIRED){$location.url(INVALID_LICENSE_PAGE);return $q.reject(response);}
if(status===UNAUTHORIZED){if(!isPermissionsEndpoint){$rootScope.$emit(Events.permission.unauthorized);}
return $q.reject(response);}
if(status===FORBIDDEN){if(!isPermissionsEndpoint){var contentType=response.headers('Content-Type');var errorMessage=contentType&&contentType.match(/^text\/plain/)?response.data:'';$rootScope.$emit(Events.permission.forbidden,errorMessage);}
return $q.reject(response);}
if(status===VERSION_CHANGED){$rootScope.xlreleaseVersionChanged=true;$rootScope.versionChangedMessage=response.data;}
if(status===SERVER_DOWN_CODE||status===IE8_SERVER_DOWN_CODE){Alerts.serverDownError();return $q.reject(response);}
if(!response.config.hideAlert){Alerts.error(response);}
return $q.reject(response);}}}]);function hideSpinner(){clearTimeout(ajaxSpinnerTimers.pop());if(ajaxSpinnerTimers.length===0){angular.element('#loading').hide();}}}]);'use strict';angular.module('xlrelease').factory('VersionEnforcer',['XLRelease',function(XLRelease){return{addPrefix:function(request){if(request.url.match(/^partials\//)){request.url='static/'+XLRelease.version+'/'+request.url;}}}}]);angular.module('xlrelease').constant('Layout',{mainPageBorder:10});angular.module('xlrelease').factory('Timeout',['$rootScope','$q','$exceptionHandler',function($rootScope,$q,$exceptionHandler){var deferreds={};function timeout(fn,delay){var deferred=timeout._getDeferred();var timeoutId=timeout._registerTimeout(deferred,fn,delay);return buildPromise(deferred,timeoutId);}
timeout.cancel=function(promise){if(promise&&promise.$$timeoutId in deferreds){deferreds[promise.$$timeoutId].reject('canceled');clearTimeout(promise.$$timeoutId);return true;}
return false;};timeout._getDeferred=function(){return $q.defer();};timeout._registerTimeout=function(deferred,fn,delay){var timeoutId=setTimeout(function(){try{deferred.resolve(fn());}catch(e){deferred.reject(e);$exceptionHandler(e);}
$rootScope.$apply();},delay);deferreds[timeoutId]=deferred;return timeoutId;};timeout._cleanup=function(promise){function cleanup(){delete deferreds[promise.$$timeoutId];}
promise.then(cleanup,cleanup);};function buildPromise(deferred,timeoutId){var promise=deferred.promise;promise.$$timeoutId=timeoutId;timeout._cleanup(promise);return promise;}
return timeout;}]);angular.module('xlrelease').directive('modal',['$compile','$parse','Modal',function($compile,$parse,Modal){function initModal(scope,modalElement,templateUrl,initFunction){Modal.open();$parse(initFunction)(scope);scope.showModal=function(){modalElement.modal('show');angular.element(".modal-backdrop").on('click',function(){scope.$apply(scope.dismiss);});};var childScope=scope.$new();$compile(modalElement.html('<div ng-include="'+templateUrl+'" onload="showModal()"></div>'))(childScope);modalElement.on('keyup',function(e){if(e.which===27){scope.$apply(scope.dismiss);}});modalElement.on('shown',function(){modalElement.find('input[autofocus]:first').trigger('focus');});scope.unregisterLocationListener=scope.$on('$locationChangeSuccess',scope.dismiss);return childScope;}
return{scope:true,link:function(scope,element,attrs){var modalElement=angular.element('#modal');var modalScope;scope.dismiss=function(){$parse(attrs.onModalHide)(scope);Modal.close();modalElement.modal('hide');modalElement.off('keyup');modalElement.empty();if(scope.unregisterLocationListener){scope.unregisterLocationListener();}
modalScope.$destroy();};scope.$watch(attrs.openOn,function(triggerCondition){if(angular.isDefined(triggerCondition)&&triggerCondition){modalScope=initModal(scope,modalElement,attrs.modal,attrs.init);}});element.on('click',function(event){event.stopPropagation();scope.$apply(function(){modalScope=initModal(scope,modalElement,attrs.modal,attrs.init);});});}}}]);angular.module('xlrelease').factory('Modal',['$q',function($q){var open=$q.defer();var close=$q.defer();return{open:function(){open.resolve('open');open=$q.defer();},close:function(){close.resolve('close');close=$q.defer();},withScope:function(scope){var nextOpen=initPromise(open.promise,scope);var nextClose=initPromise(close.promise,scope);function initPromise(parentPromise,scope){var defer=$q.defer();parentPromise.then(defer.resolve);scope.$on('$destroy',defer.reject);return defer.promise;}
return{onNextOpen:function(callback){nextOpen.then(callback);return this;},onNextClose:function(callback){nextClose.then(callback);return this;}}}};}]);angular.module('xlrelease').run(['$rootScope','Timeout',function($rootScope,Timeout){$rootScope.delayedWatch=function(delay,watchExp,listener,objectEquality){var timeout;this.$watch(watchExp,function(newValue,oldValue){if(newValue===oldValue)return;if(timeout){Timeout.cancel(timeout);}
timeout=Timeout(_.partial(listener,newValue,oldValue),delay);},objectEquality);};}]);'use strict';angular.module('xlrelease').factory('DateService',['ReleasesStatusService',function(ReleasesStatusService){return{isOverdue:function(date){if(!date)return false;return moment(date).isBefore();},getToday:function(){return this.atMidnight(moment());},getTodayWithTime:function(){return moment();},atMidnight:function(date){return moment(date).hours(0).minutes(0).seconds(0).milliseconds(0);},getDateStatus:function(currentDay){if(currentDay.isBefore(this.getToday())){return'past';}else if(currentDay.isAfter(this.getToday())){return'future';}else{return'today';}},getStartOrScheduledDate:function(planItem){return planItem.startDate||planItem.scheduledStartDate;},getEndOrDueDate:function(planItem){var date=planItem.endDate||planItem.dueDate;if(date&&planItem.type==="xlrelease.Release"&&ReleasesStatusService.isReleaseInProgress(planItem)){date=Math.max(date,this.getTodayWithTime().valueOf());}
return date;},checkDatesValidator:function(form){return function(){if(form){var dueDate=form.dueDate;var scheduledStartDate=form.scheduledStartDate;if(dueDate&&scheduledStartDate){form.hasValidDates=scheduledStartDate<=dueDate;}}}}};}]);angular.module('xlrelease').factory('Browser',[function(){var isIE8=(typeof bowser!=='undefined')&&bowser.msie&&bowser.version==8;var isIE9=(typeof bowser!=='undefined')&&bowser.msie&&bowser.version==9;return{isIE8:isIE8,fixDropdownDimensions:function(parent){if(!isIE8&&!isIE9)return;var elements=parent.find("select");var element;elements.each(function(){element=$(this);element.css("height","auto");if(isIE8){element.data("origWidth",element.outerWidth());}});if(isIE8){elements.mouseenter(function(){$(this).css("width","auto");}).bind("blur change",function(){element=$(this);element.css("width",element.data("origWidth"));});}}}}]);'use strict';angular.module('xlrelease').factory('ColorService',['ReleasesService','PhaseColors',function(ReleasesService,PhaseColors){var pastBackgroundColor='#f1f1f1';function desaturate(color){return chroma.interpolate(color,pastBackgroundColor,0.5).hex();}
return{computeDayColor:function(day){if(!day.color)return null;return day.dateStatus==='past'?desaturate(day.color):day.color;},computePhaseColor:function(release,phase){var color=phase.color||PhaseColors[0].value;return ReleasesService.isReleaseCompleted(release)?desaturate(color):color;}}}]);'use strict';angular.module('xlrelease').factory('SpecialDaysService',['Backend',function(Backend){function enhanceSpecialDay(specialDaysByDate,day){var specialDay=specialDaysByDate[specialDayId(day)];if(specialDay){day.color=specialDay.color;day.label=specialDay.label;}}
function loadSpecialDays(firstDay,lastDay){var range={from:specialDayId(firstDay),to:specialDayId(lastDay)};return Backend.get('calendar/specialDays',{params:range});}
function loadCalendarSpecialDays(weeks){var firstDay=weeks[0].days[0];var lastDay=_.last(_.last(weeks).days);loadSpecialDays(firstDay,lastDay).success(function(specialDays){var specialDaysByDate=_.indexBy(specialDays,'date');_.each(weeks,function(week){_.each(week.days,function(day){enhanceSpecialDay(specialDaysByDate,day);});});});}
function loadTimelineSpecialDays(days){if(days.length>0){var firstDay=days[0];var lastDay=_.last(days);loadSpecialDays(firstDay,lastDay).success(function(specialDays){var specialDaysByDate=_.indexBy(specialDays,'date');_.each(days,function(day){enhanceSpecialDay(specialDaysByDate,day);});});}}
function specialDayId(day){return day.fullDate.format('YYYYMMDD');}
return{loadCalendarSpecialDays:loadCalendarSpecialDays,loadTimelineSpecialDays:loadTimelineSpecialDays,specialDayUrl:function specialDayUrl(day){return'calendar/specialDays/'+specialDayId(day);}}}]);angular.module('xlrelease').constant('Events',{permission:{unauthorized:'UNAUTHORIZED',forbidden:'FORBIDDEN',refresh:'REFRESH-PERMISSIONS'},polling:{stop:'STOP-TASK-POLLING'},timeline:{resize:'RESIZE-TIMELINE',hasBeenResized:'TIMELINE-RESIZED'},gantt:{openTaskDetails:'OPEN-TASK-DETAILS',openPhaseDetails:'OPEN-PHASE-DETAILS',hasBeenRefreshed:'GANTT-REFRESHED'}});angular.module('xlrelease').factory('ClientSettings',['LocalStorageWrapper','DateService',function(LocalStorageWrapper,DateService){var localStorageCache={};var knownItems=[{name:'ReleasesListFilters'},{name:'CalendarFilters'},{name:'TasksFilters'},{name:'ReportsFilters'},{name:'TemplatesListFilters'},{name:'PipelineFilters'},{name:'ReleaseValueStreamFilters'},{name:'LogsFilters',mapItem:true,daysValidity:30},{name:'GanttElementsCollapseState'},{name:'GanttDatesColumnsCollapseState'},{name:'GanttZoomLevel'},{name:'PipelineCollapseState'},{name:'Permissions'},{name:'AuthenticationData'},{name:'ReleaseEditorCollapseState',mapItem:true,daysValidity:30},{name:'ReleaseEditorTaskFilters',mapItem:true,daysValidity:30}];function generateGetter(name){return function(){var data=localStorageCache[name];if(data==null){data=LocalStorageWrapper.getItem(name);localStorageCache[name]=data;}
return data!=null?JSON.parse(data):null;};}
function generateMapItemGetter(name){return function(id){var data,rawMap=localStorageCache[name];if(rawMap){var map=JSON.parse(rawMap);data=map[id];if(data==null){data=fromRefreshedCache(name,id);}}else{data=fromRefreshedCache(name,id);}
return data;};}
function fromRefreshedCache(name,id){var rawMap=LocalStorageWrapper.getItem(name);localStorageCache[name]=rawMap;if(rawMap){var map=JSON.parse(rawMap);return(map)?map[id]:null;}
return null;}
function generateSetter(name){return function(value){localStorageCache[name]=JSON.stringify(value);LocalStorageWrapper.setItem(name,JSON.stringify(value));}}
function generateMapItemSetter(name,daysValidity){return function(id,value){var rawMap=localStorageCache[name];var map=(rawMap)?JSON.parse(rawMap):{validities:{}};map[id]=value;if(daysValidity){storeValidity(map,id);cleanInvalids(map);}
localStorageCache[name]=JSON.stringify(map);LocalStorageWrapper.setItem(name,JSON.stringify(map));};function storeValidity(map,id){map.validities[id]=DateService.getTodayWithTime().add('d',daysValidity).valueOf();}
function cleanInvalids(map){var now=DateService.getTodayWithTime().valueOf();_.forOwn(map.validities,function(timestamp,id){if(parseInt(timestamp,10)<now){delete map[id];delete map.validities[id];}});}}
function generateMapItemRemover(name){return function(id){var rawMap=localStorageCache[name];if(!rawMap){rawMap=LocalStorageWrapper.getItem(name);}
var map=JSON.parse(rawMap);delete map[id];localStorageCache[name]=JSON.stringify(map);LocalStorageWrapper.setItem(name,JSON.stringify(map));};}
function generateRemover(name){return function(){LocalStorageWrapper.removeItem(name);delete localStorageCache[name];}}
var result={clear:function(){_.each(knownItems,function(item){LocalStorageWrapper.removeItem(item.name);delete localStorageCache[item.name];});}};_.each(knownItems,function(item){result['get'+item.name]=(item.mapItem)?generateMapItemGetter(item.name):generateGetter(item.name);result['set'+item.name]=(item.mapItem)?generateMapItemSetter(item.name,item.daysValidity):generateSetter(item.name);result['remove'+item.name]=(item.mapItem)?generateMapItemRemover(item.name):generateRemover(item.name);});return result;}]);angular.module('xlrelease').filter('dateFormatter',['dateFilter',function(dateFilter){return function(inputDate){if(_(inputDate).isUndefined()||_(inputDate).isNull()){return undefined;}
if(moment().isSame(inputDate,'day')){return"Today";}
return dateFilter(inputDate,'shortDate');}}]).filter('timeFormatter',['dateFilter',function(dateFilter){return function(inputDate){if(_(inputDate).isUndefined()||_(inputDate).isNull()){return undefined;}
return dateFilter(inputDate,'shortTime');}}]).filter('statusFormatter',function(){var statuses={"TEMPLATE":"Template","PLANNED":"Planned","IN_PROGRESS":"In progress","COMPLETED":"Completed","FAILED":"Failed"};return function(inputStatus){return statuses[inputStatus];}}).filter('newlines',function(){function repeat(string,times){return new Array(times+1).join(string);}
return function(text){if(_(text).isUndefined()||_(text).isNull()){return text;}
return text.replace(/\t/g,'  ').replace(/^([^\S\n]+)/gm,function(ignored,match){return repeat("&nbsp;",match.length);}).replace(/\n/g,'<br/>');}}).filter('noHTML',function(){return function(text){if(_(text).isUndefined()||_(text).isNull()){return text;}
return text.replace(/&/g,'&amp;').replace(/>/g,'&gt;').replace(/</g,'&lt;');}}).filter('markdown',function(){return function(text){if(!text){return'';}
return marked(text.replace(/</g,'&lt;').replace(/>/g,'&gt;'));};}).filter('userFormatter',function(){return function(user){if(!user||!user.username){return'';}
return user.fullName?user.fullName:user.username;};}).filter('usernameFormatter',function(){return function(user){if(!user||!user.username){return'';}
return user.fullName?user.fullName+' ('+user.username+')':user.username;};}).filter('memberFormatter',function(){return function(member){if(!member||!member.name){return'';}
return member.fullName?member.fullName:member.name;};}).filter('memberNameFormatter',function(){return function(member){if(!member||!member.name){return'';}
return member.fullName?member.fullName+' ('+member.name+')':member.name;};}).filter('configurationTypeFormatter',function(StringService){return function(type){if(!type){return'';}
var prefix=type.substring(0,type.indexOf('.'));var typeName=type.substring(type.indexOf('.')+1);return StringService.capitalizeFirstLetter(prefix)+": "+StringService.capitalizeFirstLetter(StringService.deCamelize(typeName).toLowerCase());};}).filter('shortConfigurationTypeFormatter',function(StringService){return function(type){if(!type){return'';}
var typeName=type.substring(type.indexOf('.')+1);return StringService.capitalizeFirstLetter(StringService.deCamelize(typeName).toLowerCase());};}).filter('toDate',function(){return function(date){return moment.isMoment(date)?date.toDate():date;};});'use strict';angular.module('xlrelease').factory('PhasesService',['TasksService',function(TasksService){return{isPhaseInProgress:function(phase){return'IN_PROGRESS'===phase.status;},isPhaseReadOnly:function(phase){return'COMPLETED'===phase.status||'ABORTED'===phase.status||'SKIPPED'===phase.status;},isPhasePlanned:function(phase){return'PLANNED'===phase.status;},isPhaseActive:function(phase){return'IN_PROGRESS'===phase.status||'FAILED'===phase.status;},isPhase:function(planItem){return planItem.type==="xlrelease.Phase";},getLeafTasks:getLeafTasks};function getLeafTasks(phase){return _.flatten(_.map(phase.tasks,TasksService.getSubTasks));}}]);angular.module('xlrelease').factory('Window',[function(){var windowWrapper=angular.element(window);return{height:function(){return windowWrapper.height()},onResize:function(callback,scope){windowWrapper.resize(callback);scope.$on('$destroy',function(){windowWrapper.off("resize",callback);})}}}]);'use strict';angular.module('xlrelease').factory('Download',['Browser','$location',function(Browser,$location){return{url:null,launch:function(url,dismissOnIe8){this.url=url;if(Browser.isIE8){$location.url('/download-ie8?back='+encodeURIComponent($location.url()));if(dismissOnIe8){dismissOnIe8();}}}}}]);angular.module('xlrelease').directive('downloader',['Download','Browser',function(Download,Browser){return{template:'<iframe ng-if="!Browser.isIE8" ng-src="{{ Download.url }}" style="display: none;"></iframe>',link:function(scope){scope.Download=Download;scope.Browser=Browser;}}}]);angular.module('xlrelease').controller('downloadIe8Controller',['$scope','Download','$location','$routeParams',function($scope,Download,$location,$routeParams){$scope.Download=Download;$scope.isDownloadLinkVisible=function(){return Download.url;};$scope.completeDownload=function(){Download.url=null;$location.url($routeParams.back);};}]);'use strict';angular.module('xlrelease').factory('LocalStorageWrapper',['$window',function($window){return $window.localStorage;}]);'use strict';angular.module('xlrelease').factory('TabsService',['$location','DateService',function($location,DateService){return{withConfig:function(config){return{MAX_DISPLAYED_TABS:config.maxDisplayedTabs,tabs:config.tabs,removeIfPresent:function(tab){var index=this.getIndexOf(tab);if(index!=-1){this.tabs.splice(index,1);}},getNumberOfDisplayedTabs:function(){return _.reduce(this.tabs,function(sum,candidate){return sum+(candidate.displayed?1:0);},0);},getLeastRecentlyUsedTab:function(){var leastRecentlyUsedTab=undefined;_.forEach(this.tabs,function(candidate){if((leastRecentlyUsedTab===undefined||candidate.lastUsed.isBefore(leastRecentlyUsedTab.lastUsed))&&candidate.displayed){leastRecentlyUsedTab=candidate;}});return leastRecentlyUsedTab;},isTabCurrentlyDisplayed:function(tab){return $location.path().indexOf(config.defaultPage+'/'+tab.configurationItem.id)!=-1;},redirectToDefaultPage:function(){$location.url(config.defaultPage);},isTabOpen:function(tab){return this.getIndexOf(tab)!=-1;},getTab:function(tab){var index=this.getIndexOf(tab);return this.tabs[index];},getIndexOf:function(tab){return _.findIndex(this.tabs,function(candidate){return candidate.configurationItem.id===tab.configurationItem.id;});},getFirstHiddenTab:function(){return _.find(this.tabs,function(candidate){return!candidate.displayed});},open:function(configurationItem,page){if(!this.isTabOpen({configurationItem:configurationItem})){this.tabs.unshift({displayed:true,configurationItem:configurationItem,lastUsed:DateService.getTodayWithTime(),page:page});}else{var tab=this.getTab({configurationItem:configurationItem});tab.lastUsed=DateService.getTodayWithTime();tab.configurationItem=configurationItem;tab.page=page;}
if(this.getNumberOfDisplayedTabs()>this.MAX_DISPLAYED_TABS){this.getLeastRecentlyUsedTab().displayed=false;}
if(!this.isTabDisplayed(configurationItem)){this.getLeastRecentlyUsedTab().displayed=false;this.removeIfPresent({configurationItem:configurationItem});this.tabs.unshift({displayed:true,configurationItem:configurationItem,lastUsed:DateService.getTodayWithTime(),page:page});}},close:function(tab){this.removeIfPresent(tab);if(this.getNumberOfDisplayedTabs()<this.MAX_DISPLAYED_TABS){var firstHiddenTab=this.getFirstHiddenTab();if(firstHiddenTab){firstHiddenTab.displayed=true;firstHiddenTab.lastUsed=DateService.getTodayWithTime();}}
if(this.isTabCurrentlyDisplayed(tab)){this.redirectToDefaultPage();}},closeAll:function(){this.tabs.splice(0,this.tabs.length);this.redirectToDefaultPage();},closeOtherTabs:function(){var self=this;var tabsToBeClosed=_.filter(this.tabs,function(tab){return!self.isTabCurrentlyDisplayed(tab);});_.forEach(tabsToBeClosed,function(tab){self.close(tab);});},isTabDisplayed:function(configurationItem){return this.getTab({configurationItem:configurationItem}).displayed;},isCloseOthersButtonDisplayed:function(){var self=this;var hasOneTabCurrentlyDisplayed=_.some(this.tabs,function(tab){return self.isTabCurrentlyDisplayed(tab);});return hasOneTabCurrentlyDisplayed&&this.tabs.length>1;}}}}}]);'use strict';angular.module('xlrelease').factory('StringService',[function(){return{isUpperCase:function(c){return c.toUpperCase()==c;},deCamelize:function(input){var output="";for(var i=0;i<input.length;i++){var c=input.charAt(i);if(i==0){c=c.toUpperCase();}else if(this.isUpperCase(c)){output+=" "}
output+=c;}
return output;},capitalizeFirstLetter:function(input){return input.substring(0,1).toUpperCase()+input.substring(1);}}}]);'use strict';angular.module('xlrelease').factory('ConfigurationItemService',[function(){return{getCIDuration:function(configurationItem){if(!configurationItem.startDate||!configurationItem.endDate){return 0;}
return configurationItem.endDate-configurationItem.startDate;}}}]);angular.module('xlrelease').factory('TopologicalSort',[function(){return{sort:function(graph){var marked={};var ordered=[];var onStack={};var hasCycle=false;function adjacentsOf(vertex){return _.chain(graph.adjacencyList).filter(function(adjacentItem){return adjacentItem.sourceId===vertex;}).pluck('targetId').value();}
function depthFirstSearch(vertex){onStack[vertex]=true;marked[vertex]=true;_.forEach(adjacentsOf(vertex),function(adjacent){if(!marked[adjacent]){depthFirstSearch(adjacent);}else if(onStack[adjacent]){hasCycle=true;return false;}});ordered.unshift(vertex);onStack[vertex]=false;return true;}
_.forEach(graph.vertices,function(vertex){if(!marked[vertex]){depthFirstSearch(vertex);}
if(hasCycle){return false;}});return hasCycle?null:ordered;}}}]);angular.module('xlrelease').directive('expander',function(){return function(scope,element,attrs){element.find(".expander").on('click',function(){angular.element("#"+attrs.expander).toggleClass("hide");element.find(".expand-icon").toggleClass("hide");element.find(".contract-icon").toggleClass("hide");});};});angular.module('xlrelease').factory('inlineEditor',['Browser','Doc',function(Browser,Doc){function leaveEditMode(scope,editable){scope.editMode=false;editable.parents(".modal").focus();}
function isOptionalOrFilled(scope){return!scope.isRequired||(angular.isDefined(scope.draft)&&scope.draft!==null&&scope.draft!=='');}
function validate(scope){var status=scope.validate({'draft':scope.draft});if(typeof status==='undefined')
return true;scope.$apply(function(){scope.validationStatus=status;});return status;}
function canCommit(scope){return isOptionalOrFilled(scope)&&validate(scope);}
function commit(scope,editable,options){if(canCommit(scope)){scope.$apply(function(){scope.model=options.getModelFromDraft(scope.draft,scope.model);leaveEditMode(scope,editable);});scope.$apply(function(){scope.onChange();});}}
function rollback(scope,editable){scope.$apply(function(){scope.draft=scope.model;leaveEditMode(scope,editable);if(typeof scope.validationStatus!='undefined')
scope.validationStatus=true;});}
function edit(scope,editable,options){scope.$apply(function(){scope.editMode=true;scope.draft=options.getDraftFromModel(scope.model);});if(editable.is('select')){editable.focus();}else{editable.select();}}
function commitOnBlur(scope,editable,options){editable.on('blur',function(){if(scope.editMode){commit(scope,editable,options);}});}
function setupAutocomplete(scope,editable,options){scope.$watch('autocompleteData',function(candidates){if(candidates){var autocomplete=editable.autocomplete({autoFocus:true,source:options.filterCandidates(candidates),delay:0,minLength:0,position:{my:"left top",at:"left bottom",collision:"flip",within:".modal-body"},open:function(){if(Browser.isIE8){editable.unbind('blur');}},close:function(){editable.trigger("input");if(Browser.isIE8){commitOnBlur(scope,editable,options);}},select:function(event,ui){scope.$apply(function(){scope.draft=options.getModelFromCandidate(ui.item);});commit(scope,editable,options);}});if(angular.isDefined(options.renderAutocompleteItem)){autocomplete.data('ui-autocomplete')._renderItem=options.renderAutocompleteItem;}}});}
function setupRequired(scope,editable,attrs){scope.isRequired=angular.isDefined(attrs.required);if(scope.isRequired){editable.attr('required','required');editable.attr('placeholder','required');}}
var DEFAULT_OPTIONS={multiline:false,filterCandidates:angular.identity,getModelFromCandidate:function(item){return item.value;},getDraftFromModel:angular.identity,getModelFromDraft:angular.identity};return{directive:function(template,options){options=_.defaults(options||{},DEFAULT_OPTIONS);return{restrict:'A',templateUrl:'partials/inline-editor/'+template,scope:{placeholder:'@',model:'=',onChange:'&',validate:'&',validationStatus:'=',selectOptions:'=',autocompleteData:'='},transclude:true,link:function(scope,element,attrs){scope.editMode=false;var editable=element.find('.editable');element.find('.display').on('click',function(event){if(options.multiline&&!$(event.target).hasClass('edit-icon')){return;}
edit(scope,editable,options);});if(options.multiline){element.find('.ok').on('click',function(){commit(scope,editable,options);});element.find('.cancel').on('click',function(){rollback(scope,editable);});}else{editable.on('keypress',function(e){if(e.which===13&&e.ctrlKey===false){commit(scope,editable,options);}});}
setupAutocomplete(scope,editable,options);setupRequired(scope,editable,attrs);if(!options.multiline){commitOnBlur(scope,editable,options);}
editable.on('keyup',function(e){if(e.which===27){rollback(scope,editable);e.stopPropagation();}});scope.isNumber=angular.isNumber;scope.hasText=function(data){return!_.isEmpty(data);};if(angular.isDefined(attrs.markdown)){scope.helpUrl=Doc.getMarkdownSyntaxURL();}}};}};}]);angular.module('xlrelease').directive('inlineTextEditor',function(inlineEditor){return inlineEditor.directive('text-field.html');});angular.module('xlrelease').directive('inlinePasswordEditor',function(inlineEditor){return inlineEditor.directive('password-field.html');});angular.module('xlrelease').directive('inlineNumberEditor',function(inlineEditor){return inlineEditor.directive('number-field.html');});angular.module('xlrelease').directive('inlineTextareaEditor',function(inlineEditor){return inlineEditor.directive('textarea.html',{multiline:true});});angular.module('xlrelease').directive('inlineSelectEditor',function(inlineEditor){return inlineEditor.directive('select.html');});angular.module('xlrelease').directive('inlineListEditor',function(inlineEditor){return inlineEditor.directive('list.html');});angular.module('xlrelease').directive('inlineUserEditor',['inlineEditor','UserCompletion',function(inlineEditor,UserCompletion){return inlineEditor.directive('user.html',{renderAutocompleteItem:UserCompletion.renderItem,filterCandidates:UserCompletion.completionMatcher,getModelFromCandidate:UserCompletion.getUserFromItem,getDraftFromModel:function(model){var username=model?model.username:'';return{username:username,fullName:''};},getModelFromDraft:function(draft,previousModel){if(previousModel&&previousModel.username===draft.username){return previousModel;}
return _.isEmpty(draft.username)?undefined:draft;}});}]);angular.module('xlrelease').directive('dateEditor',[function(){return{templateUrl:"partials/directives/date-editor.html",restrict:'A',scope:{placeholder:'@',onChange:'&',date:'=',inferredDate:'&',deletable:'&',readonly:'&'},link:function(scope){scope.$watch('date',function(newDate,oldDate){if(angular.isUndefined(oldDate)){return;}
if(newDate!==oldDate){scope.onChange();}});scope.deleteDate=function(){scope.date=null;};scope.displayedDate=function(){return scope.date||scope.inferredDate();};scope.hasNoDate=function(){return!scope.date;};}}}]);angular.module('xlrelease').directive('ganttDateEditor',['GanttElementsEditor',function(GanttElementsEditor){return{scope:true,template:"<div date-editor date='date' inferred-date='inferredDate' on-change='setDate(date)' editable='true' deletable='deletable'></div>",link:function(scope,element){var parent=element.parent();if(!parent.length)return;var timestamp=parent.data('date');var id=parent.data('id');var type=parent.data('type');var date=new Date(parseInt(timestamp,10));if(parent.data('has-own-date')){scope.date=date;}else{scope.inferredDate=date;scope.date=null;}
scope.deletable=parent.data('deletable');scope.$watch('date',function(newValue,oldValue){if(newValue!==oldValue){var ganttElement=gantt.getTask(id);if(type==='start'){GanttElementsEditor.setStartDate(ganttElement,newValue);}else{GanttElementsEditor.setEndDate(ganttElement,newValue);}}});}}}]);angular.module('xlrelease').directive('modalDateEditor',function(){return{templateUrl:"partials/directives/modal-date-editor.html",restrict:'A',scope:{dateModel:'=',readonly:'&',dateTitle:'@',inferredDate:'&',onChange:'&'},link:function(scope){scope.removeDate=function(){scope.dateModel=null;};scope.$watch('dateModel',function(newDate,oldDate){if(!angular.isUndefined(oldDate)&&newDate!==oldDate){scope.onChange();}});scope.displayedDate=function(){return scope.dateModel||scope.inferredDate();}}}});var app=angular.module('xlrelease');app.value('PhaseColors',[{name:"Blue",value:'#009CDB'},{name:"Green",value:'#68b749'},{name:"Orange",value:'#ff9e3b'},{name:"Red",value:'#dd4b39'},{name:"Grey",value:'#707070'},{name:"Purple",value:'#663366'}]);app.value('DayColors',[{name:"None",value:''},{name:"Blue",value:'#c3d4ef'},{name:"Green",value:'#d0efd3'},{name:"Orange",value:'#f7e9d4'},{name:"Light blue",value:'#def1f9'}]);app.directive('colorPickerSwatch',function(){return{templateUrl:'partials/colorpicker/swatch.html',replace:true,scope:{'color':'=cpColor','currentColor':'=cpCurrentColor'},link:function(scope,element){scope.clicked=function(){if(element.hasClass('button')){scope.$parent.selectColor(scope.color.value);}};}};});app.directive('colorPicker',function(){var bootstrapArrowWidth=18,bootstrapArrowHeight=6;return{templateUrl:'partials/colorpicker/main.html',replace:true,scope:{'colors':'=','currentColor':'=','onChange':'&','inline':'='},link:function(scope,element,attrs){if(!scope.currentColor){scope.currentColor=scope.colors[0].value;}
var picker=element.find('.simplecolorpicker');if(attrs.inline){picker.addClass('inline');}else{picker.addClass('popup');}
var toggler=element.find('.toggle-picker');var popup=element.find('.popup');var view=$('.view');var showPicker=function(){var pos=toggler.position();popup.css({left:pos.left+toggler.width()/2-bootstrapArrowWidth+view.scrollLeft(),top:pos.top+toggler.outerHeight()+bootstrapArrowHeight});popup.show();};var hidePicker=function(){popup.hide();};var togglePicker=function(){if(popup.is(':visible')){hidePicker();}else{showPicker();}};var mouseDown=function(e){e.stopPropagation();e.preventDefault();};$(document).on('mousedown',hidePicker);toggler.on('mousedown',togglePicker);element.on('mousedown','.popup, .toggle-picker',mouseDown);element.parents('.phase-header').on('mouseleave',hidePicker);scope.selectColor=function(color){scope.currentColor=color;hidePicker();scope.onChange({'color':color});}}};});angular.module('xlrelease').directive('dateTimePicker',['$parse','$locale','DateFormatDetector','DateService',function($parse,$locale,DateFormatDetector,DateService){var DATE_PICKER_FORMAT=$locale.DATETIME_FORMATS['shortDate'];var isAmPmVisible=DateFormatDetector.isAmPmVisible();function overrideDatePart(oldDate,componentDate){var newDate=new Date(oldDate);newDate.setDate(componentDate.getDate());newDate.setMonth(componentDate.getMonth());newDate.setFullYear(componentDate.getFullYear());return newDate.valueOf();}
function overrideTimePart(oldDate,time){var date=moment(oldDate);var newHoursMinutes=moment(time.value,"hh:mm a");date.hours(newHoursMinutes.hours());date.minutes(newHoursMinutes.minutes());date.seconds(0);date.milliseconds(0);return date.valueOf();}
function saveDateAndClosePicker(scope,dateGetter,dateSetter,date){scope.$apply(function(){dateSetter.assign(scope,overrideDatePart(getTodayIfDateIsEmpty(scope,dateGetter),date));});}
function setupDatePicker(element,scope,dateGetter,dateSetter){var datePickerHolder=element.find('.date-picker-holder');datePickerHolder.datepicker({format:DATE_PICKER_FORMAT.toLowerCase(),language:$locale.id,autoclose:true});element.find('.date').on('click',function(){datePickerHolder.datepicker('show').one('hide',function(){var newDate=datePickerHolder.datepicker('getDate');if(moment(newDate).isValid()){saveDateAndClosePicker(scope,dateGetter,dateSetter,newDate);}else{setDateTime(element,scope,dateGetter);saveDateAndClosePicker(scope,dateGetter,dateSetter,DateService.getToday().toDate());}});});}
function setupTimePicker(element,scope,dateGetter,dateSetter){var timePickerHolder=element.find('.time-picker-holder');timePickerHolder.timepicker({showMeridian:isAmPmVisible});element.find('.time').on('click',function(){timePickerHolder.timepicker('showWidget').one('hide.timepicker',function(event){scope.$apply(function(){dateSetter.assign(scope,overrideTimePart(getTodayIfDateIsEmpty(scope,dateGetter),event.time));});});});}
function getTodayIfDateIsEmpty(scope,dateGetter){if(dateGetter(scope)===null||dateGetter(scope)===undefined){var today=new Date();today.setSeconds(0);today.setMilliseconds(0);return today;}
return dateGetter(scope);}
function setDateTime(element,scope,dateGetter){var date=getTodayIfDateIsEmpty(scope,dateGetter);var timePickerFormat=isAmPmVisible?'hh:mm A':'HH:mm';var formattedTime=moment(date).format(timePickerFormat);var datePickerHolder=element.find('.date-picker-holder');datePickerHolder.datepicker('setDate',DateService.atMidnight(date).toDate());var timePickerHolder=element.find('.time-picker-holder');timePickerHolder.timepicker('setTime',formattedTime);}
return{restrict:'A',link:function(scope,element,attrs){var parentForm=element.inheritedData('$formController');var dateGetter=$parse('displayedDate()');var dateSetter=$parse(attrs['date']);var dateSetterWrapper={assign:function(scope,value){if(parentForm){parentForm.$setDirty();}
dateSetter.assign(scope,value);}};if(!scope.readonly()){setupDatePicker(element,scope,dateGetter,dateSetterWrapper);setupTimePicker(element,scope,dateGetter,dateSetterWrapper);}
scope.$watch('displayedDate()',function(newDate){if(angular.isDefined(newDate)&&!scope.readonly()){setDateTime(element,scope,dateGetter);}});}}}]);angular.module('xlrelease').factory('DateFormatDetector',['dateFilter','$locale',function(dateFilter,$locale){return{isAmPmVisible:function(){var formattedTime=dateFilter(new Date(2013,0,1,14),'shortTime');return!_.contains(formattedTime,'14')},isMonthDisplayedBeforeDay:function(){var shortDate=$locale.DATETIME_FORMATS['shortDate'].toLowerCase();return shortDate.indexOf('m')<shortDate.indexOf('d');}};}]);angular.module('xlrelease').factory('tooltipService',[function(){return{setup:function(element,tooltip,position){if(!position){position='top';}
element.attr('title',tooltip);element.tooltip('destroy');element.tooltip({placement:position,html:true,container:'body'});element.on('$destroy',function(){element.tooltip('destroy');});}}}]);angular.module('xlrelease').directive('tooltip',['tooltipService',function(tooltipService){return{restrict:'A',link:function(scope,element,attrs){scope.$watch(attrs.tooltip,function(value){tooltipService.setup(element,_.escape(value),attrs.tooltipPosition);});}}}]);angular.module('xlrelease').directive('stopClickPropagation',function(){return function(scope,element){element.on('click',function(event){event.stopPropagation();});};});angular.module('xlrelease').factory('onClickOutsideService',[function(){return{setup:function(element,acceptTarget,action){var clickHandler=function(event){if(acceptTarget($(event.target))){action();}};$(document).on('click',clickHandler);element.on('$destroy',function(){$(document).off('click',clickHandler);});}}}]);angular.module('xlrelease').directive('onClickOutside',['onClickOutsideService','$parse',function(onClickOutsideService,$parse){return function(scope,element,attrs){var acceptTarget=function(target){return!target.is(element)&&!target.parents().is(element);};var action=function(){scope.$apply(function(){$parse(attrs['onClickOutside'])(scope);});};onClickOutsideService.setup(element,acceptTarget,action);}}]);angular.module('xlrelease').directive('closeOnBlur',['onClickOutsideService',function(onClickOutsideService){return function(scope,element){var acceptTarget=function(target){return!target.is('.dropdown-button')&&target.parents('.dropdown-button').length!==1&&!target.is('.popover')&&target.parents('.popover').length!==1};var action=function(){$('.popover.in').each(function(){$(this).popover('hide');});};onClickOutsideService.setup(element,acceptTarget,action);};}]);angular.module('xlrelease').directive('hidePopoverOnClick',function(){return function(scope,element){element.on('click',function(){element.parents('.popover.in').each(function(){$(this).popover('hide');});});};});angular.module('xlrelease').factory('TagsInputs',[function(){return{directive:function(options){return{templateUrl:options.templateUrl,scope:{tags:'=',readOnly:'=',completionCandidates:'=',placeholder:'@',onChange:'&'},controller:['$scope','$element',function(scope,element){var ctrl=this;ctrl.add=function(tag){if(!options.tagFormat.isEmpty(tag)){var alreadyExist;scope.$apply(function(){alreadyExist=options.tagFormat.alreadyExist(scope.tags,tag);if(!alreadyExist){scope.tags.push(tag);triggerChange();scope.newTag='';}});if(alreadyExist){highlight(tag);}}};ctrl.remove=function(tag){scope.tags=_.without(scope.tags,tag);triggerChange();};ctrl.initAutocomplete=function(candidates){var input=element.find('.tag-input');var autocomplete=input.autocomplete({source:options.autocomplete.sourceFrom(candidates),delay:0,autoFocus:true,select:function(event,ui){ctrl.add(options.tagFormat.getTagFromAutocomplete(ui.item));},close:function(){input.val(scope.newTag);}});if(angular.isDefined(options.autocomplete.renderItem)){autocomplete.data("ui-autocomplete")._renderItem=options.autocomplete.renderItem;}};function triggerChange(){if(scope.onChange)scope.onChange({'tags':scope.tags});}
function highlight(tag){element.find(".tag-label:contains('"+options.tagFormat.getTagLabel(tag)+"')").parents(".tag").effect('highlight');}}],link:function(scope,element,attributes,ctrl){var hasAutocompletion=angular.isDefined(attributes.completionCandidates);scope.newTag='';scope.remove=ctrl.remove;if('autofocus'in attributes){element.find('.tag-input').focus();}
if(hasAutocompletion){scope.$watch('completionCandidates',function(candidates){if(angular.isDefined(candidates)){ctrl.initAutocomplete(candidates);}});}
element.find('.tag-input').on('keypress',function(event){if(event.which===13){ctrl.add(options.tagFormat.getTagFromInput(scope.newTag));}});}}}}}]);angular.module('xlrelease').directive('tagsInput',['TagsInputs',function(TagsInputs){return TagsInputs.directive({templateUrl:'partials/directives/tags-input.html',tagFormat:{isEmpty:function(tag){return tag=='';},alreadyExist:function(tags,tag){return _.contains(tags,tag);},getTagLabel:angular.identity,getTagFromAutocomplete:function(item){return item.value;},getTagFromInput:angular.identity},autocomplete:{sourceFrom:angular.identity}})}]);angular.module('xlrelease').directive('usersInput',['TagsInputs','UserCompletion',function(TagsInputs,UserCompletion){return TagsInputs.directive({templateUrl:'partials/directives/users-input.html',tagFormat:{isEmpty:function(user){return user.username==='';},alreadyExist:function(users,user){return _.contains(_.pluck(users,'username'),user.username);},getTagLabel:function(user){return user.username},getTagFromAutocomplete:UserCompletion.getUserFromItem,getTagFromInput:function(inputText){return{username:inputText,fullName:''};}},autocomplete:{sourceFrom:UserCompletion.completionMatcher,renderItem:UserCompletion.renderItem}})}]);angular.module('xlrelease').directive('membersInput',['TagsInputs','MemberType','memberNameFormatterFilter',function(TagsInputs,MemberType,memberNameFormatterFilter){return TagsInputs.directive({templateUrl:'partials/directives/members-input.html',tagFormat:{isEmpty:function(member){return member.name=='';},alreadyExist:function(members,member){return _.some(members,{'name':member.name,'type':member.type});},getTagLabel:function(member){return member.name;},getTagFromAutocomplete:function(member){return{name:member.name,type:member.type,fullName:member.fullName};},getTagFromInput:function(value){return{name:value,type:MemberType.PRINCIPAL};}},autocomplete:{sourceFrom:function(members){return function(request,response){var search=request.term.toLowerCase();function matches(name,search){return name?name.toLowerCase().indexOf(search)!==-1:false;}
var filteredMembers=_.filter(members,function(member){return matches(member.name,search)||matches(member.fullName,search);});return response(filteredMembers);}},renderItem:function(ul,member){return $("<li>").append('<a class="'+member.type.toLowerCase()+'"><span class="tag-icon"></span><span class="tag-label">'+memberNameFormatterFilter(member)+'</span></a>').appendTo(ul);}}})}]);angular.module('xlrelease').directive('timeZoneTooltip',['tooltipService','CurrentTimeZone',function(tooltipService,CurrentTimeZone){return{restrict:'A',link:function(scope,element){var text=CurrentTimeZone.timeZone;tooltipService.setup(element,text,'right');}}}]);angular.module('xlrelease').factory('CurrentTimeZone',[function(){var timeZone=jstz.determine().name();timeZone=timeZone.replace(/^.*\//,'').replace(/_/g,' ');return{timeZone:timeZone};}]);angular.module('xlrelease').factory('UserCompletion',['usernameFormatterFilter',function(usernameFormatterFilter){return{completionMatcher:function(users){_.each(users,function(user){user.value=user.username;});return function(request,response){var search=request.term.toLowerCase();function matches(name,search){return name?name.toLowerCase().indexOf(search)!==-1:false;}
var filteredUsers=_.filter(users,function(user){return matches(user.username,search)||matches(user.fullName,search);});return response(filteredUsers);};},getUserFromItem:function(item){return{username:item.username,fullName:item.fullName};},renderItem:function(ul,user){return $('<li>').append('<a>'+usernameFormatterFilter(user)+'</a>').appendTo(ul);}}}]);angular.module('xlrelease').directive('displayUser',['VariablesInterpolator','userFormatterFilter','tooltipService',function(VariablesInterpolator,userFormatterFilter,tooltipService){function render(element,user,variables){var displayedName=userFormatterFilter(user);var username=user?user.username:'';var interpolatedHtml;if(variables){interpolatedHtml=VariablesInterpolator.interpolateInHtml(variables,_.escape(displayedName));}else{interpolatedHtml=_.escape(displayedName);}
element.html(interpolatedHtml);if(displayedName!==username){tooltipService.setup(element,_.escape(username),'bottom');}}
return function(scope,element,attrs){if(attrs.variables){scope.$watch('['+attrs.displayUser+', '+attrs.variables+']',function(watchedValues){render(element,watchedValues[0],watchedValues[1]);},true);}else{scope.$watch(attrs.displayUser,function(user){render(element,user);},true);}};}]);angular.module('xlrelease').directive('displayMember',['memberFormatterFilter','tooltipService',function(memberFormatterFilter,tooltipService){return function(scope,element,attrs){scope.$watch(attrs.displayMember,function(member){var text=memberFormatterFilter(member);var memberName=member?member.name:'';element.text(text);if(text!==memberName){tooltipService.setup(element,memberName,'bottom');}},true);};}]);angular.module('xlrelease').directive('attachmentsList',['Backend','Download',function(Backend,Download){return{templateUrl:"partials/directives/attachments-list.html",restrict:'A',scope:{attachments:'=',readonly:'&',canDeleteAttachments:'&',dismiss:'&',deleteAttachment:'&',uploadUrl:'='},link:function(scope){scope.attachmentAdded=function(result){scope.attachments.push(result[0]);};scope.downloadAttachment=function(attachment){Backend.get('export/attachments/register/'+attachment.id).success(function(downloadToken){Download.launch('export/attachments/download/'+downloadToken,scope.dismiss);});};}};}]);angular.module('xlrelease').directive('dipControl',[function(){return{templateUrl:'partials/directives/dip-control.html',scope:{property:'=',container:'='}};}]);angular.module('xlrelease').factory('Tabs',[function(){return{directive:function(tabsService,linkFn){return{replace:true,transclude:true,templateUrl:"partials/menu/tabs.html",controller:['$scope',function(scope){scope.tabs=tabsService.tabs;scope.closeTab=function(tab){tabsService.close(tab);};scope.closeAllTabs=function(){tabsService.closeAll();};scope.closeOtherTabs=function(){tabsService.closeOtherTabs();};scope.isCloseOthersButtonDisplayed=function(){return tabsService.isCloseOthersButtonDisplayed();};}],link:linkFn}}}}]);angular.module('xlrelease').directive('configurationTabs',['Tabs','ConfigurationTabsService',function(Tabs,ConfigurationTabsService){return Tabs.directive(ConfigurationTabsService,function link(scope){scope.getLink=function(tab){return"#/configuration/"+tab.configurationItem.id;};scope.getTitle=function(tab){return tab.configurationItem.title;};scope.isActive=function(tab){return scope.isPage('/configuration/'+tab.configurationItem.id);}});}]);angular.module('xlrelease').directive('releasesTabs',['Tabs','ReleasesTabsService',function(Tabs,ReleasesTabsService){return Tabs.directive(ReleasesTabsService,function link(scope){scope.getLink=function(tab){var path=(tab.configurationItem.status==='TEMPLATE')?'#/templates/':'#/releases/';return path+tab.configurationItem.id+tab.page;};scope.getTitle=function(tab){return tab.configurationItem.title;};scope.isActive=function(tab){var path=(tab.configurationItem.status==='TEMPLATE')?'/templates/':'/releases/';return scope.isPage(path+tab.configurationItem.id);}});}]);angular.module('xlrelease').directive('durationEditor',['$compile','DurationEditorService',function($compile,DurationEditorService){var ACCEPTED_KEYS=[8,9,46,37,38,39,40];var ENTER_KEYCODE=13;var ESCAPE_KEYCODE=27;function Picker(scope,element,commitAction){this.scope=scope;this.element=element;var parentForm=element.inheritedData('$formController');this.commitAction=function(){if(parentForm){parentForm.$setDirty();}
commitAction.apply()};this.scope.adjustPosition=_.bind(this.adjustPosition,this);this.unregisterEvents=function(){$(window).off('resize',this.resizeHandler);$(document).off('mousedown touchstart',this.mouseHandler);};scope.$on('$destroy',_.bind(function(){this.$picker&&this.$picker.remove();},this));this.removePicker=function(e){if(!(this.element.is(e.target)||this.element.find(e.target).length||this.$picker.is(e.target)||this.$picker.find(e.target).length)){scope.$apply(_.bind(function(){this.closePicker(true);},this));}};}
Picker.prototype.show=function(){if(!this.$picker){this.$picker=$("<div class='datepicker datepicker-dropdown dropdown-menu datepicker-orient-left duration-picker'></div>").show();$compile(this.$picker.html('<div ng-include="\'partials/directives/duration-editor-fields.html\'" onload="adjustPosition()"></div>'))(this.scope);$('body').append(this.$picker);}};Picker.prototype.adjustPosition=function(){this.unregisterEvents();var pickerWidth=this.$picker.outerWidth();var pickerHeight=this.$picker.outerHeight();var visualPadding=10;var windowWidth=$(window).width();var windowHeight=$(window).height();var scrollTop=$(window).scrollTop();var offset=this.element.offset();var height=this.element.outerHeight(false);var yOrient='auto';var topOverflow=-scrollTop+offset.top-pickerHeight;var bottomOverflow=scrollTop+windowHeight-(offset.top+height+pickerHeight);if(Math.max(topOverflow,bottomOverflow)===bottomOverflow){yOrient='top';}else{yOrient='bottom';}
var top=offset.top;if(yOrient==='top'){top+=height;}else{top-=pickerHeight+parseInt(this.$picker.css('padding-top'));}
var left=offset.left;if(offset.left<0)
left-=offset.left-visualPadding;else if(offset.left+pickerWidth>windowWidth)
left=windowWidth-pickerWidth-visualPadding;var zIndex=parseInt(this.element.parents().filter(function(){return $(this).css('z-index')!=='auto';}).first().css('z-index'))+10;this.$picker.removeClass('datepicker-orient-top datepicker-orient-bottom '+'datepicker-orient-right datepicker-orient-left');this.$picker.addClass('datepicker-orient-left '+'datepicker-orient-'+yOrient);this.$picker.css({top:top,left:left,zIndex:zIndex});this.resizeHandler=_.bind(this.adjustPosition,this);this.mouseHandler=_.bind(this.removePicker,this);$(window).on('resize',this.resizeHandler);$(document).on('mousedown touchstart',this.mouseHandler);$('.datepicker .days').focus();};Picker.prototype.closePicker=function(commit){this.unregisterEvents();if(this.$picker){this.$picker.remove();this.$picker=undefined;}
if(commit){this.commitAction();}};return{templateUrl:"partials/directives/duration-editor.html",restrict:'A',scope:{duration:'=',inferredDuration:'&',onChange:'&',editable:'&',done:'&'},link:function(scope,element){scope.$watch('duration',function(newValue,oldValue){if(angular.isUndefined(oldValue)){return;}
if(newValue!==oldValue){scope.onChange();}});var picker=new Picker(scope,element,function(){scope.duration=scope.durationDraft;});scope.showDurationPicker=function(){if(scope.editable()){picker.show();var duration=DurationEditorService.hasDuration(scope.duration)?scope.duration:scope.inferredDuration();scope.durationData=DurationEditorService.getDurationData(duration);}};scope.$watch('durationData',function(durationData){scope.durationDraft=DurationEditorService.getDuration(durationData||{});},true);scope.keyPress=function(event){if(_.contains(ACCEPTED_KEYS,event.keyCode)){return;}
var input=String.fromCharCode(event.charCode||event.which);if(!/[0-9+]/.test(input)){event.stopImmediatePropagation();event.preventDefault()}};scope.keyDown=function(event){if(event.keyCode===ENTER_KEYCODE){picker.closePicker(true);}
if(event.keyCode===ESCAPE_KEYCODE){picker.closePicker(false);}};scope.removeDuration=function(){scope.durationDraft=null;picker.closePicker(true);};scope.hasDuration=DurationEditorService.hasDuration;}};}]);angular.module('xlrelease').constant('Durations',(function(){var ONE_SECOND=1000;var ONE_MINUTE=60*ONE_SECOND;var ONE_HOUR=60*ONE_MINUTE;var ONE_DAY=24*ONE_HOUR;return{ONE_SECOND:ONE_SECOND,ONE_MINUTE:ONE_MINUTE,ONE_HOUR:ONE_HOUR,ONE_DAY:ONE_DAY};})());angular.module('xlrelease').factory('DurationEditorService',['Durations',function(Durations){return{hasDuration:function(duration){return duration!==null;},getDurationData:function(durationInMs){var durationInSec=durationInMs/1000;var durationInMin=Math.round(durationInSec/60);var durationInHour=durationInMin/60;var durationInDay=durationInHour/24;return{days:Math.floor(durationInDay),hours:Math.floor(durationInHour%24),minutes:Math.floor(durationInMin%60)};},getDuration:function(durationData){function toUInt(value){var result=parseFloat(value)||0;return result>=0?result:0;}
var days=toUInt(durationData.days);var hours=toUInt(durationData.hours);var minutes=toUInt(durationData.minutes);return Durations.ONE_DAY*days
+Durations.ONE_HOUR*hours
+Durations.ONE_MINUTE*minutes;}};}]);angular.module('xlrelease').filter('prettyDuration',['DurationEditorService',function(DurationEditorService){function twoDigits(number){return("0"+number).slice(-2);}
return function(input){if(!DurationEditorService.hasDuration(input)){return""}
var durationData=DurationEditorService.getDurationData(input);if(durationData.days===0&&durationData.hours===0&&durationData.minutes===0){return"00:00";}
var result=durationData.days?durationData.days+' days':'';if(durationData.hours||durationData.minutes){result+=' '+twoDigits(durationData.hours)+':'+twoDigits(durationData.minutes);}
return result.replace(/^\s+|\s+$/g,'');}}]);angular.module('xlrelease').directive('ganttDurationEditor',['GanttElementsEditor',function(GanttElementsEditor){function getParameterValue(param,parent){var value=parent.data(param);return value!=='null'?value:null;}
function getParameterBooleanValue(param,parent){var value=parent.data(param);return value===true;}
return{template:"<div duration-editor duration='duration' on-change='setDuration(duration)' editable='editable' inferred-duration='displayDuration' done='done'></div>",restrict:'A',scope:true,link:function(scope,element){var parent=element.parent();if(!parent.length)return;scope.duration=getParameterValue('duration',parent);scope.displayDuration=getParameterValue('display-duration',parent);scope.editable=getParameterBooleanValue('editable',parent);scope.done=getParameterBooleanValue('done',parent);var id=parent.data('id');scope.setDuration=function(duration){var ganttElement=gantt.getTask(id);GanttElementsEditor.setDuration(ganttElement,duration);};}}}]);'use strict';angular.module('xlrelease').factory('Doc',[function(){return{getURL:function(){return'documentation/';},getMarkdownSyntaxURL:function(){return this.getURL()+'markdownsyntax.html';}}}]);angular.module('xlrelease').directive('docIcon',['Doc',function(Doc){return{template:'<a class="doc-icon" ng-href="{{ docURL }}" target="_blank"></a>',restrict:'A',scope:{section:'@docIcon'},link:function(scope){scope.docURL=Doc.getURL()+scope.section;}}}]);angular.module('xlrelease').directive('docLink',['Doc',function(Doc){return{template:'<a class="doc-link" ng-href="{{ docURL }}" target="_blank" ng-transclude></a>',restrict:'A',transclude:true,scope:{section:'@docLink'},link:function(scope){scope.docURL=Doc.getURL()+scope.section;}}}]);angular.module('xlrelease').factory('Base64',function(){var keyStr='ABCDEFGHIJKLMNOP'+'QRSTUVWXYZabcdef'+'ghijklmnopqrstuv'+'wxyz0123456789+/'+'=';return{getBasicAuthorization:function(username,password){return'Basic '+this.encode(username+':'+password);},encode:function(input){var output="";var chr1,chr2,chr3="";var enc1,enc2,enc3,enc4="";var i=0;do{chr1=input.charCodeAt(i++);chr2=input.charCodeAt(i++);chr3=input.charCodeAt(i++);enc1=chr1>>2;enc2=((chr1&3)<<4)|(chr2>>4);enc3=((chr2&15)<<2)|(chr3>>6);enc4=chr3&63;if(isNaN(chr2)){enc3=enc4=64;}else if(isNaN(chr3)){enc4=64;}
output=output+
keyStr.charAt(enc1)+
keyStr.charAt(enc2)+
keyStr.charAt(enc3)+
keyStr.charAt(enc4);chr1=chr2=chr3="";enc1=enc2=enc3=enc4="";}while(i<input.length);return output;}};});angular.module('xlrelease').factory('Authenticator',['Backend','$rootScope','Base64','$location','Events','ForbiddenAccessService','ClientSettings','UserProfile',function(Backend,$rootScope,Base64,$location,Events,ForbiddenAccessService,ClientSettings,UserProfile){var ADMINISTRATOR='admin';var RELEASE_ADMIN_TEAM='Release Admin';var START_PAGE='/tasks';var FORBIDDEN_CONTENT_PAGE='/forbidden-access';function setCredentials(username,password){var credentials=Base64.getBasicAuthorization(username,password);var authenticationData={username:username,credentials:credentials};ClientSettings.setAuthenticationData(authenticationData);}
function setSecurity(security){var permissions=security.global;if(!permissions){permissions=[];}
ClientSettings.setPermissions(permissions);}
$rootScope.$on(Events.permission.unauthorized,function(){authenticationService.logout();});$rootScope.$on(Events.permission.forbidden,function(event,errorMessage){var fallback=$location.search().fallback;if(fallback){$location.url(fallback);}else{ForbiddenAccessService.errorMessage=errorMessage;$location.url(FORBIDDEN_CONTENT_PAGE);}});$rootScope.$on(Events.permission.refresh,function(){Backend.get('security').success(setSecurity);});function isAdmin(permissions){return authenticationService.getUsername()===ADMINISTRATOR||_.contains(permissions,ADMINISTRATOR);}
function hasAppropriatePermission(release,templatePermission,releasePermission){if(release&&release.status==='TEMPLATE'){return authenticationService.hasPermission(templatePermission,release);}
return release&&authenticationService.hasPermission(releasePermission,release);}
var authenticationService={init:function(){$rootScope.security={isAuthenticated:authenticationService.isAuthenticated,getUsername:authenticationService.getUsername,hasPermission:authenticationService.hasPermission,hasViewPermission:authenticationService.hasViewPermission,hasEditPermission:authenticationService.hasEditPermission,hasEditTaskPermission:authenticationService.hasEditTaskPermission,hasReassignTaskPermission:authenticationService.hasReassignTaskPermission,hasEditSecurityPermission:authenticationService.hasEditSecurityPermission,isAdminOr:authenticationService.isAdminOr};},getUsername:function(){var authenticationData=ClientSettings.getAuthenticationData();return authenticationData!==null?authenticationData.username:null;},changePassword:function(password){setCredentials(this.getUsername(),password);},isAuthenticated:function(){return ClientSettings.getAuthenticationData()!==null;},hasPermission:function(permission,release){var permissions=ClientSettings.getPermissions();if(permissions===null){return false;}
if(isAdmin(permissions)){return true;}
if(angular.isUndefined(release)){return _.contains(permissions,permission);}else{return _.contains(release.security.permissions,permission);}},hasViewPermission:function(release){return hasAppropriatePermission(release,"template#view","release#view");},hasEditPermission:function(release){return hasAppropriatePermission(release,"template#edit","release#edit");},hasEditTaskPermission:function(release){return hasAppropriatePermission(release,"template#edit","release#edit_task");},hasReassignTaskPermission:function(release){return hasAppropriatePermission(release,"template#edit","release#reassign_task");},hasEditSecurityPermission:function(release){return this.hasPermission('security#edit')||hasAppropriatePermission(release,"template#edit_security","release#edit_security");},isAdminOr:function(user){var username=user?user.username:undefined;var permissions=ClientSettings.getPermissions();return permissions!=null&&(this.getUsername()===username||isAdmin(permissions));},isMemberOf:function(release,team){var permissions=ClientSettings.getPermissions();if(permissions!==null&&isAdmin(permissions)){return true;}
var releaseTeams=release.security.teams;return releaseTeams!==null&&(_.contains(releaseTeams,RELEASE_ADMIN_TEAM)||_.contains(releaseTeams,team));},login:function(username,password){return Backend.get('security',{headers:{'Authorization':Base64.getBasicAuthorization(username,password)}}).success(function(security){setCredentials(username,password);setSecurity(security);UserProfile.load();$location.url(START_PAGE);});},logout:function(){ClientSettings.removeAuthenticationData();ClientSettings.removePermissions();UserProfile.clear();$location.url('/login');}};return authenticationService;}]);'use strict';angular.module('xlrelease').controller('mainController',['$rootScope','$scope','$location','Authenticator','Events','ClientSettings','XLRelease','Doc','Page',function($rootScope,$scope,$location,Authenticator,Events,ClientSettings,XLRelease,Doc,Page){$scope.version=XLRelease.version;$scope.documentationURL=Doc.getURL();$scope.logout=function(){Authenticator.logout();};$scope.clearClientSettings=function(){ClientSettings.clear();};$scope.getPageTitle=Page.getTitle;$scope.hasTabs=Page.hasTabs;$scope.isReleasesPage=Page.isReleasesPage;$scope.isReportsPage=Page.isReportsPage;$scope.isSettingsPage=Page.isSettingsPage;$scope.isFullPage=Page.isFullPage;$scope.isPage=Page.isOnPage;$scope.refreshPage=Page.refresh}]);'use strict';angular.module('xlrelease').constant('PageTypes',{releases:'releases',reports:'reports',settings:'settings',other:'other'});angular.module('xlrelease').constant('Menu',{tasks:'tasks',releases:'releases',calendar:'calendar',reports:'reports',settings:'settings'});angular.module('xlrelease').factory('Page',['$rootScope','$location','PageTypes','PageConfigurations',function($rootScope,$location,PageTypes,PageConfigurations){var currentPage=PageConfigurations.login,currentTitle='';$rootScope.$on('$locationChangeSuccess',function computeCurrentPage(){var fullPath=$location.path();if(angular.isUndefined(fullPath)||fullPath==='')return;var path=fullPath.substring(1);var isRootPage=path.indexOf('/')==-1;var firstPathSegment=isRootPage?path:path.substring(0,path.indexOf('/'));if(!isRootPage&&firstPathSegment=='releases'){currentPage=PageConfigurations.release;}else if(!isRootPage&&firstPathSegment=='templates'){currentPage=PageConfigurations.template;}else{currentPage=PageConfigurations[firstPathSegment];}
currentTitle=currentPage.title;if(currentPage.menu){$rootScope.activeMenu=currentPage.menu;}});return{getTitle:function(){return currentTitle;},addToTitle:function(subtitle){var separator=' - ';var hasSubtitle=currentTitle.indexOf(separator)!=-1;if(hasSubtitle){currentTitle=currentTitle.substr(0,currentTitle.indexOf(separator));}
currentTitle=currentTitle+separator+subtitle;},hasTabs:function(){return this.isReleasesPage()||this.isReportsPage()||this.isSettingsPage();},isReleasesPage:function(){return currentPage.type==PageTypes.releases;},isReportsPage:function(){return currentPage.type==PageTypes.reports;},isSettingsPage:function(){return currentPage.type==PageTypes.settings;},isOnPage:function(path,isRootPath){var currentPath=$location.path();var firstPathSegment=currentPath.substr(0,path.length);if(!isRootPath){return firstPathSegment==path;}
return firstPathSegment==path&&!currentPath.substr(0,path.length+1).match(/\/$/);},isFullPage:function(){return angular.isDefined(currentPage)&&'full'in currentPage&&currentPage.full;},refresh:function(){document.location.reload(true);}}}]);angular.module('xlrelease').factory('PageConfigurations',['PageTypes','Menu',function(PageTypes,Menu){return{'tasks':{title:'Tasks',type:PageTypes.other,menu:Menu.tasks},'release':{title:'Releases',type:PageTypes.releases,menu:Menu.releases},'releases':{title:'Releases - Overview',type:PageTypes.releases,menu:Menu.releases},'pipeline':{title:'Releases - Pipeline',type:PageTypes.releases,menu:Menu.releases},'template':{title:'Releases',type:PageTypes.releases,menu:Menu.releases},'templates':{title:'Releases - Templates',type:PageTypes.releases,menu:Menu.releases},'calendar':{title:'Calendar',type:PageTypes.other,menu:Menu.calendar},'dashboard':{title:'Reports',type:PageTypes.reports,menu:Menu.reports},'release-automation':{title:'Reports',type:PageTypes.reports,menu:Menu.reports},'release-value-stream':{title:'Reports',type:PageTypes.reports,menu:Menu.reports},'profile':{title:'Settings',type:PageTypes.settings,menu:Menu.settings},'users':{title:'Settings',type:PageTypes.settings,menu:Menu.settings},'roles':{title:'Settings',type:PageTypes.settings,menu:Menu.settings},'permissions':{title:'Settings',type:PageTypes.settings,menu:Menu.settings},'reports-settings':{title:'Settings',type:PageTypes.settings,menu:Menu.settings},'servers':{title:'Settings',type:PageTypes.settings,menu:Menu.settings},'smtp':{title:'Settings',type:PageTypes.settings,menu:Menu.settings},'configuration':{title:'Settings',type:PageTypes.settings,menu:Menu.settings},'default':{title:'',type:PageTypes.other},'login':{title:'',type:PageTypes.other,full:true},'invalid-license':{title:'',type:PageTypes.other,full:true},'forbidden-access':{title:'',type:PageTypes.other},'download-ie8':{title:'',type:PageTypes.other}}}]);'use strict';angular.module('xlrelease').factory('Alerts',['$rootScope','Events',function(){function getAlertMessage(response){var text="<br/><p>";var contentType=response.headers("Content-type");if(contentType&&contentType.indexOf("text/html")==-1){text+=response.data;}
text+="<div class='alert-details'>"
text+="Status code: "+response.status+"<br/>";text+=response.config.method+" ";if(response.headers('X-Path')){text+=response.headers('X-Path')+"<br/>";}else{text+=response.config.url+"<br/>";}
if(response.headers('Date')){text+=response.headers('Date')+" (Server time)<br/>";}
text+="</div>";return text;}
return{error:function(response){$.pnotify({title:'An error occurred',text:getAlertMessage(response),type:'error',history:false,width:"auto",sticker:false,icon:false});},serverDownError:function(){$.pnotify({title:'The XL Release server is not available',type:'error',history:false,width:"400px",sticker:false,icon:false});}}}]);'use strict';angular.module('xlrelease').controller('defaultRouteController',['Authenticator','$location',function(Authenticator,$location){$location.url(Authenticator.isAuthenticated()?'/tasks':'/login');}]);'use strict';angular.module('xlrelease').controller('licenseController',['$scope','Backend','DateService',function($scope,Backend,DateService){var DAYS_BEFORE_EXPIRATION_WARNING=5;var expirationDate;Backend.get('server/license').success(function(license){$scope.license=license;$scope.renewLicenseURL=getRenewLicenseURL(license);expirationDate=moment($scope.license.expiresAfter);});function getRenewLicenseURL(license){var queryParams={};if(license.repositoryId){queryParams["repositoryId"]=license.repositoryId;}
if(license.contact){queryParams["email"]=license.contact;}
var renewLicenseURL="http://go.xebialabs.com/XLRelease_Renewal";var queryString=$.param(queryParams);if(queryString.length>0){renewLicenseURL+="?"+queryString;}
return renewLicenseURL;}
$scope.licenseIsExpired=function(){return expirationDate.isBefore(DateService.getToday());};$scope.licenseIsAlmostExpired=function(){return!$scope.licenseIsExpired()&&expirationDate.isBefore(DateService.getToday().add('days',DAYS_BEFORE_EXPIRATION_WARNING));};$scope.getNbDaysBeforeExpiration=function(){return expirationDate.diff(DateService.getToday(),'days');}}]);'use strict';angular.module('xlrelease').controller('loginController',['$scope','Authenticator',function($scope,Authenticator){$scope.loginInfo={login:"",password:"",failed:false};$scope.login=function(){Authenticator.login($scope.loginInfo.login,$scope.loginInfo.password).success(function(){$scope.loginInfo.failed=false;}).error(function(response,status){$scope.loginInfo.failed=true;$scope.loginInfo.failedStatus=status;$scope.loginInfo.password="";});};}]);'use strict';angular.module('xlrelease').controller('releasesController',['$scope','Timeout','Backend','ReleasesService','TasksService','$location','FlagService','DateService','Events','ClientSettings','Filters','filterSettings',function($scope,Timeout,Backend,ReleasesService,TasksService,$location,FlagService,DateService,Events,ClientSettings,Filters,filterSettings){$scope.filters=filterSettings;loadReleases();function loadReleases(){$scope.$emit(Events.permission.refresh);ReleasesService.getReleases($scope.filters).success(function(releases){var releasesByMonth=_.chain(releases).sortBy(function(release){if(release.startDate){return release.startDate;}else{return release.scheduledStartDate;}}).groupBy(function(release){if(release.startDate){return moment(release.startDate).format('MMMM YYYY');}else if(release.scheduledStartDate){return moment(release.scheduledStartDate).format('MMMM YYYY');}}).value();$scope.groupedReleases=_.map(_.keys(releasesByMonth),function(month){return{month:month,releases:releasesByMonth[month]};});});}
$scope.startRelease=function(release){ReleasesService.startRelease(release).success(loadReleases);};$scope.abortRelease=function(release){ReleasesService.abortRelease(release).success(loadReleases);};$scope.isReleaseCompleted=ReleasesService.isReleaseCompleted;$scope.isReleasePlanned=ReleasesService.isReleasePlanned;$scope.isReleaseFailed=ReleasesService.isReleaseFailed;$scope.isReleaseFailing=ReleasesService.isReleaseFailing;$scope.isReleasePaused=ReleasesService.isReleasePaused;$scope.isReleaseInProgress=ReleasesService.isReleaseInProgress;$scope.isReleaseAborted=ReleasesService.isReleaseAborted;$scope.isReleaseOrSubtaskFlagged=FlagService.isReleaseOrSubtaskFlagged;$scope.isTaskPending=TasksService.isTaskPending;$scope.isTaskFailed=TasksService.isTaskFailed;$scope.isTaskFlagged=FlagService.isTaskFlagged;$scope.isOverdue=DateService.isOverdue;$scope.shouldDisplaySubTask=function(task){return TasksService.isTaskPending(task)||TasksService.isTaskInProgress(task);};$scope.displayReleaseEditor=function(release){$location.url('/releases/'+release.id);};$scope.hasAutomatedTaskInProgress=function(release){return _.some(release.currentSimpleTasks,function(task){return TasksService.isTaskInProgress(task)&&TasksService.isAutomated(task);});};}]);'use strict';angular.module('xlrelease').factory('ReleasesService',['Backend','ReleasesStatusService','TasksService','PhasesService','DateService','$q','Download','$location',function(Backend,ReleasesStatusService,TasksService,PhasesService,DateService,$q,Download,$location){function getLeafTasks(release){return _.flatten(_.map(release.phases,PhasesService.getLeafTasks));}
function getAllTasks(release){return _.flatten(_.map(release.phases,function(phase){return _.map(phase.tasks,TasksService.getAllSubTasks);}));}
function downloadRelease(release,format){Backend.get('releases/'+release.id+'/export',{params:{format:format}}).success(function(downloadToken){Download.launch('export/'+format+'/'+downloadToken);});}
return{getLeafTasks:getLeafTasks,getAllTasks:getAllTasks,isReleaseCompleted:ReleasesStatusService.isReleaseCompleted,isReleaseAborted:ReleasesStatusService.isReleaseAborted,isReleasePlanned:ReleasesStatusService.isReleasePlanned,isReleaseInProgress:ReleasesStatusService.isReleaseInProgress,isReleaseFailed:ReleasesStatusService.isReleaseFailed,isReleaseFailing:ReleasesStatusService.isReleaseFailing,isReleasePaused:ReleasesStatusService.isReleasePaused,startRelease:function(release){return Backend.post('releases/'+release.id+'/start');},abortRelease:function(release){return Backend.post('releases/'+release.id+'/abort');},downloadCalendar:function(release){downloadRelease(release,'calendar');},downloadExcel:function(release){downloadRelease(release,'excel');},exportZip:function(release){downloadRelease(release,'zip');},getReleasesDependencies:function(releases){var params=_.map(releases,function(release){return"releaseId="+release.id;}).join("&");return Backend.get('dependencies?'+params)},getReleaseDependencies:function(releaseId){return Backend.get('dependencies/'+releaseId)},getRelease:function(releaseId){return Backend.get('releases/'+releaseId);},getReleases:function(filters){return Backend.post('releases/search',filters);},cropToReleaseDate:function(phase,release){var phaseStartDate=DateService.getStartOrScheduledDate(phase);var releaseStartDate=DateService.getStartOrScheduledDate(release);var phaseEndDate=DateService.getEndOrDueDate(phase);var releaseEndDate=DateService.getEndOrDueDate(release);return{startDate:moment(phaseStartDate).isBefore(moment(releaseStartDate))?moment(releaseStartDate):moment(phaseStartDate),endDate:moment(phaseEndDate).isAfter(moment(releaseEndDate))?moment(releaseEndDate):moment(phaseEndDate)};},getReleasesDependenciesByReleaseId:function(releases){var deferred=$q.defer();var promise=deferred.promise;if(releases.length===0){deferred.reject();return promise;}
this.getReleasesDependencies(releases).success(function(releasesDependencies){deferred.resolve(_.indexBy(releasesDependencies,'releaseId'));});return promise;},isInConflict:function(releaseId,releasesDependencies){return angular.isDefined(releasesDependencies)&&angular.isDefined(releasesDependencies[releaseId])&&releasesDependencies[releaseId].inConflict;},extendWithProgression:function(release){var flattenedTasks=getLeafTasks(release);var numberOfCompletedTasks=_.filter(flattenedTasks,TasksService.isTaskReadOnly).length;if(flattenedTasks.length>0){release.progression=Math.round((numberOfCompletedTasks*100)/flattenedTasks.length);}else{release.progression=0;}
return release;},countPhasesDone:function(release){return release?_.filter(release.phases,PhasesService.isPhaseReadOnly).length:undefined;},hasAttachments:function(release){if(release.attachments&&release.attachments.length>0){return true;}
return _.flatten(getAllTasks(release),'attachments').length>0;},redirectToSummary:function(release){$location.url('/releases/'+release.id+'/summary');},redirectToEditor:function(release){$location.url('/releases/'+release.id);},isRelease:function(planItem){return planItem.type==="xlrelease.Release";}};}]);'use strict';angular.module('xlrelease').factory('ReleasesStatusService',[function(){return{isReleaseCompleted:function(release){return angular.isDefined(release)&&(release.status==='COMPLETED'||release.status==='ABORTED');},isReleaseAborted:function(release){return angular.isDefined(release)&&release.status==='ABORTED';},isReleasePlanned:function(release){return angular.isDefined(release)&&release.status==='PLANNED';},isReleaseInProgress:function(release){return angular.isDefined(release)&&release.status==='IN_PROGRESS';},isReleaseFailed:function(release){return angular.isDefined(release)&&release.status==='FAILED';},isReleaseFailing:function(release){return angular.isDefined(release)&&release.status==='FAILING';},isReleasePaused:function(release){return angular.isDefined(release)&&release.status==='PAUSED';}}}]);'use strict';angular.module('xlrelease').controller('releaseEditorController',['$scope','$routeParams','Backend','TaskPolling','TasksService','PhaseColors','ReleasesService','Modal','FlagService','Authenticator','Events','PhasesService','TaskDetailsUpdates','PhaseDetailsUpdates','DateService','ReleasesTabsService','Page','ReleaseEditorCollapse','DragAndDrop','ValueStreamMapping','ConfigurationItemService','ReleaseEditorTaskFilterService',function($scope,$routeParams,Backend,TaskPolling,TasksService,PhaseColors,ReleasesService,Modal,FlagService,Authenticator,Events,PhasesService,TaskDetailsUpdates,PhaseDetailsUpdates,DateService,ReleasesTabsService,Page,ReleaseEditorCollapse,DragAndDrop,ValueStreamMapping,ConfigurationItemService,ReleaseEditorTaskFilterService){$scope.init={hasScrolledToCurrentTask:false};$scope.loadRelease=function(){$scope.$emit(Events.permission.refresh);Backend.get('releases/'+$routeParams.releaseId).success(function(release){$scope.release=release;Page.addToTitle($scope.release.title);$scope.allTasks=ReleasesService.getLeafTasks($scope.release);$scope.hasAutomatedTaskInProgress=_.some($scope.allTasks,function(task){return TasksService.isTaskInProgress(task)&&TasksService.isAutomated(task);});initRestartPhases(release);startPolling();ReleasesTabsService.open(release,'/');});};$scope.loadRelease();$scope.loadReleaseAfterTaskUpdate=function(){if(TaskDetailsUpdates.planningDataChanged){$scope.loadRelease();TaskDetailsUpdates.reset();}};$scope.loadReleaseAfterPhaseUpdate=function(){if(PhaseDetailsUpdates.planningDataChanged){$scope.loadRelease();PhaseDetailsUpdates.reset();}};Backend.get('tasks/python-script-definitions').success(function(definitions){$scope.pythonScriptDefinitions=_.groupBy(definitions,'displayGroup');});function startPolling(){TaskPolling.startTaskPolling($scope.allTasks,$scope).onTaskUpdate($scope.loadRelease);Modal.withScope($scope).onNextOpen(stopPolling).onNextClose(startPolling)}
function stopPolling(){$scope.$broadcast(Events.polling.stop);}
$scope.isPhaseInProgress=PhasesService.isPhaseInProgress;$scope.isPhaseReadOnly=PhasesService.isPhaseReadOnly;$scope.isPhasePlanned=PhasesService.isPhasePlanned;$scope.startRelease=function(release){ReleasesService.startRelease(release).success($scope.loadRelease);};$scope.abortRelease=function(release){ReleasesService.abortRelease(release).success($scope.loadRelease);};$scope.showNavigator=false;$scope.movePhase=function(fromIndex,toIndex){var moveInfo={originIndex:fromIndex,targetIndex:toIndex};if($scope.areDonePhasesCollapsed($scope.release)){var offset=$scope.release.phases.length-$scope.displayedIds.length;moveInfo.originIndex+=offset;moveInfo.targetIndex+=offset;}
Backend.post('releases/'+$scope.release.id+'/phases/move',moveInfo).success(function(){var phase=$scope.release.phases.splice(moveInfo.originIndex,1)[0];$scope.release.phases.splice(moveInfo.targetIndex,0,phase);});};function taskHasBeenMoved(moveInfo){return moveInfo.originContainerId!==moveInfo.targetContainerId||moveInfo.originIndex!==moveInfo.targetIndex;}
$scope.moveTask=function(taskId,fromTaskOrPhase,fromIndex,toTaskOrPhase,toIndex){var moveInfo={originContainerId:fromTaskOrPhase.id,originIndex:fromIndex,targetContainerId:toTaskOrPhase.id,targetIndex:toIndex};if(!taskHasBeenMoved(moveInfo)){return;}
DragAndDrop.enabled=false;Backend.post('releases/'+$scope.release.id+'/tasks/move',moveInfo).success(function(movedTask){if(TasksService.isParallelGroup(movedTask)&&taskId!==movedTask.id){ReleaseEditorCollapse.transferParallelGroupCollapseState(movedTask.id,taskId);}
toTaskOrPhase.tasks[toIndex]=movedTask;DragAndDrop.enabled=true;}).error(function(data){$scope.moveTaskError=data;DragAndDrop.enabled=true;});};$scope.resetError=function(){$scope.moveTaskError=false;};$scope.addPhase=function(){Backend.post('releases/'+$scope.release.id+'/phases/add').success(function(phase){$scope.release.phases.push(phase);});};$scope.deletePhase=function(phaseToDelete){Backend.del('phases/'+phaseToDelete.id).success(function(){$scope.release.phases=_.filter($scope.release.phases,function(phase){return phase.id!==phaseToDelete.id;})});};$scope.addTask=function(container,taskForm){Backend.post('tasks/'+container.id,taskForm).success(function(addedTask){if(taskForm.taskType==='xlrelease.ParallelGroup'){addedTask.wasJustAdded=true;}
container.tasks.push(addedTask);});};$scope.deleteTask=function(container,taskToDelete){Backend.del('tasks/'+taskToDelete.id).success(function(){container.tasks=_.filter(container.tasks,function(task){return task.id!==taskToDelete.id;});});};$scope.duplicateTask=function(container,task){Backend.put('releases/'+$scope.release.id+'/tasks/duplicate/'+task.id).success(function(duplicatedTask){_.each(container.tasks,function(aTask,index){if(aTask.id===task.id){container.tasks.splice(index+1,0,duplicatedTask);}});});};$scope.duplicatePhase=function(phase){Backend.put('releases/'+$scope.release.id+'/phases/duplicate/'+phase.id).success(function(duplicatedPhase){_.each($scope.release.phases,function(aPhase,index){if(aPhase.id===phase.id){$scope.release.phases.splice(index+1,0,duplicatedPhase);}});});};$scope.completeTask=function(task,commentText){TasksService.completeTask(task.id,commentText).success($scope.loadRelease);};$scope.skipTask=function(task,commentText){TasksService.skipTask(task.id,commentText).success($scope.loadRelease);};$scope.failTask=function(task,commentText){TasksService.failTask(task.id,commentText).success($scope.loadRelease);};$scope.abortTask=function(task,commentText){TasksService.abortTask(task.id,commentText).success($scope.loadRelease);};$scope.retryTask=function(task,commentText){TasksService.retryTask(task.id,commentText).success($scope.loadRelease);};$scope.cancelTask=function(task,commentText){TasksService.cancelTask(task.id,commentText).success($scope.loadRelease);};$scope.startNow=function(task,commentText){TasksService.startNow(task.id,commentText).success($scope.loadRelease);};$scope.reopenTask=function(task,commentText){TasksService.reopenTask(task.id,commentText).success($scope.loadRelease);};function initRestartPhases(release){$scope.restartPhases={};$scope.restartPhases.restartables=_.reject(release.phases,$scope.isPhasePlanned);$scope.restartPhases.current=_.find($scope.restartPhases.restartables,isPhaseActive);$scope.restartPhases.from=$scope.restartPhases.current;}
function isPhaseActive(phase){return'IN_PROGRESS'===phase.status||'FAILED'===phase.status||'FAILING'===phase.status;}
$scope.canRestartPhases=function(release){return release&&release.status!='TEMPLATE'&&Authenticator.hasPermission('release#edit',release)&&(ReleasesService.isReleaseInProgress(release)||ReleasesService.isReleaseFailed(release)||ReleasesService.isReleaseFailing(release))&&!$scope.hasAutomatedTaskInProgress;};$scope.computePhasesToRestart=function(){$scope.restartPhases.toRestart=$scope.restartPhases.restartables.slice(_.indexOf($scope.restartPhases.restartables,$scope.restartPhases.from),_.indexOf($scope.restartPhases.restartables,$scope.restartPhases.current)+1)};$scope.canResume=function(release){return release&&release.status!='TEMPLATE'&&Authenticator.hasPermission('release#edit',release)&&ReleasesService.isReleasePaused(release);};$scope.resumeRelease=function(release,variables){if(!variables){variables=[];}
Backend.post('releases/'+release.id+'/resume',variables).success($scope.loadRelease);};$scope.filters=ReleaseEditorTaskFilterService.getFilters($routeParams.releaseId);$scope.setFilters=ReleaseEditorTaskFilterService.setFilters;$scope.taskFilter=ReleaseEditorTaskFilterService.getTaskFilter;$scope.isReleaseCompleted=ReleasesService.isReleaseCompleted;$scope.isReleasePlanned=ReleasesService.isReleasePlanned;$scope.countPhasesDone=ReleasesService.countPhasesDone;$scope.hasAttachments=ReleasesService.hasAttachments;$scope.downloadExcel=ReleasesService.downloadExcel;$scope.exportZip=ReleasesService.exportZip;$scope.isPhaseReadOnly=PhasesService.isPhaseReadOnly;$scope.getLeafTasks=PhasesService.getLeafTasks;$scope.isCritical=ValueStreamMapping.isCritical;$scope.getWarningThreshold=ValueStreamMapping.getWarningThreshold;$scope.getErrorThreshold=ValueStreamMapping.getErrorThreshold;$scope.isTaskPlanned=TasksService.isTaskPlanned;$scope.isTaskPending=TasksService.isTaskPending;$scope.isTaskInProgress=TasksService.isTaskInProgress;$scope.isTaskReadOnly=TasksService.isTaskReadOnly;$scope.isTaskSkipped=TasksService.isTaskSkipped;$scope.isTaskFailed=TasksService.isTaskFailed;$scope.isDeployitTask=TasksService.isDeployitTask;$scope.isGateTask=TasksService.isGateTask;$scope.isTaskFlagged=FlagService.isTaskFlagged;$scope.isManualTask=TasksService.isManualTask;$scope.isNotificationTask=TasksService.isNotificationTask;$scope.isParallelGroup=TasksService.isParallelGroup;$scope.isTaskCompleted=TasksService.isTaskCompleted;$scope.isTaskCompletedInAdvance=TasksService.isTaskCompletedInAdvance;$scope.isTaskSkippedInAdvance=TasksService.isTaskSkippedInAdvance;$scope.isTaskDoneInAdvance=TasksService.isTaskDoneInAdvance;$scope.isTaskSortable=TasksService.isTaskSortable;$scope.isParallelGroupInProgress=TasksService.isParallelGroupInProgress;$scope.isAutomated=TasksService.isAutomated;$scope.getSubTasks=TasksService.getSubTasks;$scope.isOverdue=DateService.isOverdue;$scope.isParallelGroupCollapsed=ReleaseEditorCollapse.isParallelGroupCollapsed;$scope.toggleParallelGroupCollapseState=ReleaseEditorCollapse.toggleParallelGroupCollapseState;$scope.isPlannedPhaseCollapsed=ReleaseEditorCollapse.isPlannedPhaseCollapsed;$scope.togglePlannedPhaseCollapseState=ReleaseEditorCollapse.togglePlannedPhaseCollapseState;$scope.areDonePhasesCollapsed=ReleaseEditorCollapse.areDonePhasesCollapsed;$scope.toggleDonePhasesCollapseState=ReleaseEditorCollapse.toggleDonePhasesCollapseState;$scope.collapseFilter=ReleaseEditorCollapse.collapseFilter;$scope.DragAndDrop=DragAndDrop;$scope.PhaseColors=PhaseColors;$scope.getCIDuration=ConfigurationItemService.getCIDuration;$scope.displayedIds=[];$scope.$watchCollection('release.phases | filter:collapseFilter(release)',function(phases){$scope.displayedIds=_.pluck(phases,'id');if($scope.areDonePhasesCollapsed($scope.release)){$scope.displayedIds.unshift('collapsedPhases');}});}]);angular.module('xlrelease').controller('containerController',['$scope',function($scope){$scope.$watch('release',function(){$scope.container=$scope.task||$scope.phase;});}]);'use strict';angular.module('xlrelease').value('Collapse',{enabled:true});angular.module('xlrelease').factory('ReleaseEditorCollapse',['Collapse','ClientSettings','ReleasesService','PhasesService','TasksService','Browser',function(Collapse,ClientSettings,ReleasesService,PhasesService,TasksService,Browser){function isCollapsed(item,collapsedByDefault){if(!Collapse.enabled)return false;var savedState=ClientSettings.getReleaseEditorCollapseState(item.id);if(savedState!==null){return savedState;}else{return collapsedByDefault;}}
return{isParallelGroupCollapsed:function(group){if(group.wasJustAdded||TasksService.isParallelGroupInProgress(group)&&!group.wasToggledSincePageLoad){return false;}
return isCollapsed(group,true);},toggleParallelGroupCollapseState:function(group){ClientSettings.setReleaseEditorCollapseState(group.id,!this.isParallelGroupCollapsed(group));group.wasToggledSincePageLoad=true;delete group.wasJustAdded;},transferParallelGroupCollapseState:function(targetGroupId,fromGroupId){ClientSettings.setReleaseEditorCollapseState(targetGroupId,this.isParallelGroupCollapsed({id:fromGroupId}));},isPlannedPhaseCollapsed:function(phase){if(Browser.isIE8){return phase.isCollapsed==null||phase.isCollapsed;}else{return isCollapsed(phase,false);}},togglePlannedPhaseCollapseState:function(phase){if(Browser.isIE8){phase.isCollapsed=!this.isPlannedPhaseCollapsed(phase);}else{ClientSettings.setReleaseEditorCollapseState(phase.id,!this.isPlannedPhaseCollapsed(phase));}},areDonePhasesCollapsed:function(release){if(!release)return false;if(ReleasesService.isReleaseCompleted(release)){return false;}
return ReleasesService.countPhasesDone(release)>0&&isCollapsed(release,true);},toggleDonePhasesCollapseState:function(release){ClientSettings.setReleaseEditorCollapseState(release.id,!this.areDonePhasesCollapsed(release));},collapseFilter:function(release){var self=this;return function(phase){return!(self.areDonePhasesCollapsed(release)&&PhasesService.isPhaseReadOnly(phase));}}}}]);'use strict';angular.module('xlrelease').value('Collapse',{enabled:true});angular.module('xlrelease').factory('ReleaseEditorTaskFilterService',['ReleasesService','TasksService','ClientSettings',function(ReleasesService,TasksService,ClientSettings){return{getFilters:function(releaseId){var filters=ClientSettings.getReleaseEditorTaskFilters(releaseId);return filters||defaultFilters();},setFilters:function(releaseId,filters){ClientSettings.setReleaseEditorTaskFilters(releaseId,filters);},getTaskFilter:function(release,filters){return function filterTask(task){if(!ReleasesService.isReleaseCompleted(release)){return true;}
if(TasksService.isParallelGroup(task)){var subTasks=_.flatten(TasksService.getSubTasks(task));if(!_.isEmpty(subTasks)){return _.some(subTasks,filterTask);}}
if(filters.flagged&&task.flagsCount>0){return true;}
if(filters.failed&&task.failuresCount>0){return true;}
if(filters.delayed&&task.delaysCount>0){return true;}
if(filters.clean&&task.flagsCount===0&&task.failuresCount===0&&task.delaysCount===0){return true;}
return false;};}};function defaultFilters(){return{flagged:true,failed:true,delayed:true,clean:true};}}]);angular.module('xlrelease').controller('restartPhasesController',['$scope','VariablesService','DeployitService','Backend',function($scope,VariablesService,DeployitService,Backend){$scope.releaseRestored=false;$scope.phaseRestartInProgress=false;$scope.restartPhasesFrom=function(phase){$scope.phaseRestartInProgress=true;$scope.numberOfPhaseRestarted=$scope.restartPhases.restartables.length-_.indexOf($scope.restartPhases.restartables,phase);Backend.post('releases/'+$scope.release.id+'/restartPhasesFrom/'+phase.id).success(function(release){$scope.phaseRestartInProgress=false;$scope.loadRelease();$scope.releaseRestored=true;loadVariables(release.variables);}).error(function(){$scope.phaseRestartInProgress=false;$scope.releaseRestored=false;$scope.dismiss();});};function loadVariables(variables){$scope.variables=VariablesService.collectUsedVariables(variables);DeployitService.getAllEnvironmentsAndPackages($scope.variables,function(packages){$scope.deployitPackages=packages;},function(environments){$scope.deployitEnvironments=environments;});}
$scope.updateVariables=function(variables){Backend.put('releases/'+$scope.release.id+'/variables',variables).success($scope.loadRelease);};}]);'use strict';angular.module('xlrelease').directive('worksheetScrolling',['worksheetService','Scroll','Window',function(worksheetService,Scroll,Window){var INCLUDE_MARGIN=true;var releaseHeaderHeight,navigatorTogglerWidth,wrapper,worksheetWidth,phaseMarginLeft,phaseMarginRight,phaseWidth,allPhasesWidth,scope;function updateOverflowFlag(){var contentWidth=wrapper.parents(".view").width();var wrapperWidth=wrapper.width();scope.hasOverflow=contentWidth<wrapperWidth;if(!scope.hasOverflow){scope.showNavigator=false;}}
function highlightCurrentPhasesLinks(){var phaseLinksConfig=worksheetService.computeWhichPhasesAreHighlighted({phaseWidth:phaseWidth,scrollLeft:wrapper.parents(".view").scrollLeft(),worksheetWidth:worksheetWidth,phaseMarginLeft:phaseMarginLeft,phaseMarginRight:phaseMarginRight});highlightPhasesLinks(phaseLinksConfig.firstPhaseVisibleIndex,phaseLinksConfig.numberOfDisplayedPhase);}
function highlightPhasesLinks(firstPhaseVisibleIndex,numberOfDisplayedPhase){var navigator=wrapper.siblings("#navigator");navigator.find(".phase-link-container").removeClass('highlight');for(var i=firstPhaseVisibleIndex;i<firstPhaseVisibleIndex+numberOfDisplayedPhase;i++){navigator.find(".phase-link-container:nth-child("+(i+1)+")").addClass("highlight");}}
function computeDomElementsDimensions(){var phases=wrapper.find(".phase");phaseMarginLeft=_.parseInt(phases.css("margin-left"));phaseMarginRight=_.parseInt(phases.css("margin-right"));phaseWidth=phases.outerWidth(INCLUDE_MARGIN);allPhasesWidth=phases.length*phaseWidth;navigatorTogglerWidth=_.parseInt(wrapper.siblings("#navigator-toggler").width());releaseHeaderHeight=_.parseInt(wrapper.find("#release-header").outerHeight());}
function computeWorksheetWidth(){worksheetWidth=wrapper.parents(".view").width()-navigatorTogglerWidth;if(scope.showNavigator)worksheetWidth-=wrapper.siblings("#navigator").width();var viewWithOnePhaseWidth=wrapper.parents(".view").width()-navigatorTogglerWidth-phaseWidth;var wrapperWidth=allPhasesWidth+viewWithOnePhaseWidth;wrapper.css({'min-width':wrapperWidth+'px'});}
function scrollingCtrl(){var ctrl=this;ctrl.setupScrollToPhase=function(){wrapper.siblings("#navigator").find(".phase-link").each(function(phaseIndex,item){$(item).unbind('click');$(item).on('click',function(){var phaseLink=$(this);ctrl.scrollTo(wrapper.find(".phase").eq(phaseIndex),null,function(){phaseLink.addClass("scrolled");})});});};ctrl.scrollTo=function(phase,task,callback){var contentMarginLeft=_.parseInt(wrapper.find("#release-content").css("margin-left"));contentMarginLeft=isNaN(contentMarginLeft)?0:contentMarginLeft;var scrollTop=0;if(task!=null){var bottomScrollbarHeight=18;var container=task.parents('.task-container');var isTaskVisible=(container.prop('offsetTop')+container.height())<=(wrapper.parents(".view").height()-bottomScrollbarHeight);scrollTop=!isTaskVisible?container.prop('offsetTop')-releaseHeaderHeight:scrollTop;}
var scrollParams={scrollLeft:phase.prop('offsetLeft')-(navigatorTogglerWidth+contentMarginLeft+phaseMarginLeft),scrollTop:scrollTop};Scroll.animate(wrapper.parents(".view"),scrollParams,callback);};ctrl.scrollUntilLastPhase=function(){var currentScrollLeft=Scroll.getLeftPosition(wrapper.parents(".view"));var phaseOutsideWorksheetWidth=allPhasesWidth-(currentScrollLeft+worksheetWidth);if(phaseOutsideWorksheetWidth>0){Scroll.animate(wrapper.parents(".view"),{scrollLeft:currentScrollLeft+phaseOutsideWorksheetWidth});}};}
return{controller:scrollingCtrl,link:function(currentScope,element,attr,ctrl){wrapper=element;scope=currentScope;Window.onResize(function(){scope.$apply(function(){computeWorksheetWidth();updateOverflowFlag();highlightCurrentPhasesLinks();});},scope);scope.$watch('release.phases | filter:collapseFilter(release)',function(newPhases,oldPhases){scope.$evalAsync(function(){if(angular.isDefined(newPhases)){computeDomElementsDimensions();computeWorksheetWidth();updateOverflowFlag();highlightCurrentPhasesLinks();ctrl.setupScrollToPhase();wrapper.parents(".view").unbind('scroll');wrapper.parents(".view").scroll(function(){highlightCurrentPhasesLinks();});if(angular.isDefined(oldPhases)){if(worksheetService.isAddedPhaseLast(newPhases,oldPhases)){ctrl.scrollUntilLastPhase();}}}});},true);scope.$watch('showNavigator',function(isNavigatorOpen,wasNavigatorOpen){if(isNavigatorOpen===wasNavigatorOpen){return;}
computeWorksheetWidth();highlightCurrentPhasesLinks();});}};}]);angular.module('xlrelease').directive('scrollToMe',function(){return{require:'^worksheetScrolling',link:function(scope,task,attr,scrollingCtrl){if(!scope.init.hasScrolledToCurrentTask){scope.$watch('',function(){scope.$evalAsync(function(){scope.init.hasScrolledToCurrentTask=true;scrollingCtrl.scrollTo(task.parents(".phase"),task);})});}}}});'use strict';angular.module('xlrelease').factory('worksheetService',[function(){return{computeWhichPhasesAreHighlighted:function(worksheetConfig){var hiddenPartOfLeftTruncatedPhase=worksheetConfig.scrollLeft%worksheetConfig.phaseWidth;var phaseWidthWithoutMargin=(worksheetConfig.phaseWidth-worksheetConfig.phaseMarginLeft-worksheetConfig.phaseMarginRight);var firstPhaseStartVisibleOffset;if(hiddenPartOfLeftTruncatedPhase<=worksheetConfig.phaseMarginLeft){firstPhaseStartVisibleOffset=worksheetConfig.phaseMarginLeft-hiddenPartOfLeftTruncatedPhase;}else{firstPhaseStartVisibleOffset=worksheetConfig.phaseWidth-hiddenPartOfLeftTruncatedPhase+worksheetConfig.phaseMarginLeft;}
var worksheetWithEntirePhasesWidth=worksheetConfig.worksheetWidth-firstPhaseStartVisibleOffset;var numberOfDisplayedPhase=0;if(worksheetWithEntirePhasesWidth>=phaseWidthWithoutMargin){numberOfDisplayedPhase=1+Math.floor((worksheetWithEntirePhasesWidth-phaseWidthWithoutMargin)/worksheetConfig.phaseWidth);}
var firstPhaseVisibleIndex=Math.floor(worksheetConfig.scrollLeft/worksheetConfig.phaseWidth);if(hiddenPartOfLeftTruncatedPhase>worksheetConfig.phaseMarginLeft){firstPhaseVisibleIndex++;}
return{firstPhaseVisibleIndex:firstPhaseVisibleIndex,numberOfDisplayedPhase:numberOfDisplayedPhase}},isAddedPhaseLast:function(newPhases,oldPhases){if(newPhases.length===oldPhases.length+1){var lastNew=newPhases[newPhases.length-1];var lastOld=oldPhases[oldPhases.length-1];return oldPhases.length==0||lastNew.id!==lastOld.id;}
return false;}};}]);angular.module('xlrelease').factory('Scroll',[function(){var ANIMATION_DURATION=300;return{animate:function(element,params,callback){element.animate(params,ANIMATION_DURATION,callback);},getLeftPosition:function(jqueryElement){return jqueryElement.scrollLeft();}}}]);angular.module('xlrelease').value('DragAndDrop',{enabled:true});angular.module('xlrelease').directive('phaseSortable',function(){return{template:'<ul ui-sortable="phaseSortableConfig" ng-model="displayedIds" ng-transclude></ul>',replace:true,transclude:true,link:function(scope){scope.phaseSortableConfig={"items":'.phase:not(.sort-disabled)',"handle":'.phase-sort-handle',"cursor":"move","axis":"x","tolerance":"pointer","forcePlaceholderSize":true,"opacity":0.7,"placeholder":'phase-drop-placeholder',start:function(event,ui){ui.item.fromIndex=scope.displayedIds.indexOf(ui.item.scope().phase.id);},update:function(event,ui){scope.$evalAsync(function(){ui.item.toIndex=scope.displayedIds.indexOf(ui.item.scope().phase.id);scope.movePhase(ui.item.fromIndex,ui.item.toIndex);});}};}}});angular.module('xlrelease').directive('taskSortable',['DragAndDrop',function(DragAndDrop){function moveTask(event,ui,scope){scope.$evalAsync(function(){var fromTaskOrPhase=ui.item.fromTaskOrPhase;var fromIndex=ui.item.fromIndex;var toTaskOrPhase=$(event.target).scope().container;var toIndex=_.findIndex(toTaskOrPhase.tasks,{id:ui.item.id});var taskId=ui.item.id;scope.moveTask(taskId,fromTaskOrPhase,fromIndex,toTaskOrPhase,toIndex);});}
function isMovedBetweenContainers(ui){return ui.item.sortable.received;}
return{template:'<ul ui-sortable="taskSortableConfig" ng-transclude></ul>',replace:true,transclude:true,link:function(scope,element){scope.$watch('DragAndDrop.enabled',function(isDragAndDropEnabled){if(isDragAndDropEnabled){element.sortable('enable');}else{element.sortable('disable');}});scope.taskSortableConfig={"items":'.item-sortable:not(.sort-disabled)',"connectWith":'.phase .task-sortable:not(.sort-disabled)',"handle":'.task-sort-handle',"cursor":'move',"tolerance":'intersect',"placeholder":'task-drop-placeholder',"forcePlaceholderSize":true,"start":function(event,ui){ui.item.fromTaskOrPhase=$(event.target).scope().container;ui.item.fromIndex=ui.item.index();ui.item.id=ui.item.scope().task.id;},"update":function(event,ui){if(isMovedBetweenContainers(ui)){moveTask(event,ui,scope);}},"stop":function(event,ui){if(!isMovedBetweenContainers(ui)){moveTask(event,ui,scope);}}};}}}]);'use strict';angular.module('xlrelease').controller('releasePropertiesController',['$scope','$location','Backend','Authenticator','ReleasesService','$routeParams','$window','FlagService','VariablesService','DeployitService','ReleasesTabsService','CurrentTimeZone','Page','UsersService','UserProfile','PlanningDataEditorMixin','DateService',function($scope,$location,Backend,Authenticator,ReleasesService,$routeParams,$window,FlagService,VariablesService,DeployitService,ReleasesTabsService,CurrentTimeZone,Page,UsersService,UserProfile,PlanningDataEditorMixin,DateService){var DEFAULT_START_HOUR=9;var DEFAULT_DUE_HOUR=17;var ICS_ENDPOINT='calendar/subscribe/';angular.extend($scope,PlanningDataEditorMixin.withSaveCallback(_.noop));var defaultNewReleaseForm={title:"",owner:UserProfile.getCurrentUser(),scheduledStartDate:DateService.getToday().hours(DEFAULT_START_HOUR).toDate(),dueDate:DateService.getToday().hours(DEFAULT_DUE_HOUR).toDate(),plannedDuration:null,newRelease:true,tags:[],variables:[],type:"xlrelease.Release",flag:{status:FlagService.NOT_FLAGGED_STATUS}};UsersService.getAllUsers().success(function(allUsers){$scope.allUsers=allUsers;});$scope.initCalendarURL=function(release){Backend.get('server/host').success(function(host){if(!host.match(/\/$/)){host+='/';}
$scope.calendarUrl=host+ICS_ENDPOINT+release.calendarLinkToken;});};$scope.initReleaseForm=function(){Backend.get('releases/'+$routeParams.releaseId).success(function(release){clearForm();$scope.release=release;Page.addToTitle($scope.release.title);var variables=VariablesService.collectUsedVariables(release.variables);initDeployitCompletion(variables);$scope.initCalendarURL(release);ReleasesTabsService.open(release,'/properties');release.variables=variables;$scope.releaseForm={id:release.id,title:release.title,scheduledStartDate:release.scheduledStartDate,startDate:release.startDate,dueDate:release.dueDate,endDate:release.endDate,plannedDuration:release.plannedDuration,description:release.description,owner:release.owner,variables:angular.copy(release.variables),started:!ReleasesService.isReleasePlanned(release),readonly:ReleasesService.isReleaseCompleted(release)||!Authenticator.hasEditPermission(release),tags:release.tags,attachments:release.attachments,flag:release.releaseFlag,done:release.done,calendarLinkToken:release.calendarLinkToken,calendarPublished:release.calendarPublished,hasValidDates:true};$scope.setupDatesWatch();$scope.planning.initPlanningData($scope.releaseForm,release);});};$scope.initNewReleaseForm=function(){var templateId=$routeParams.fromTemplateId;Backend.get('releases/templates').success(function(templates){$scope.templates=templates;if(templateId){$scope.updateFormWithTemplate(templateId);}else{$scope.updateFormWithoutTemplate();}
$scope.setupDatesWatch();$scope.planning.initPlanningData($scope.releaseForm,$scope.releaseForm);});};$scope.updateFormWithTemplate=function(templateId){if(!templateId){$scope.updateFormWithoutTemplate();}else{var fromTemplate=_.find($scope.templates,function(template){return template.id===templateId;});var variables=VariablesService.collectUsedVariables(fromTemplate.variables);initDeployitCompletion(variables);$scope.releaseForm=angular.copy(defaultNewReleaseForm);$scope.releaseForm=angular.extend($scope.releaseForm,{templateId:templateId,description:fromTemplate.description,newRelease:true,variables:variables,tags:fromTemplate.tags});}
$scope.setupDatesWatch();};$scope.updateFormWithoutTemplate=function(){$scope.releaseForm=defaultNewReleaseForm;};if($location.path().match('create$')){$scope.initNewReleaseForm();}else{$scope.initReleaseForm();}
$scope.setupDatesWatch=function(){$scope.$watch('releaseForm.dueDate + releaseForm.scheduledStartDate',DateService.checkDatesValidator($scope.releaseForm));};function clearForm(){delete $scope.releaseForm;delete $scope.releaseUpdatedAt;}
function initDeployitCompletion(variables){$scope.deployitPackages=[];$scope.deployitEnvironments=[];DeployitService.getAllEnvironmentsAndPackages(variables,function(packages){$scope.deployitPackages=packages;},function(environments){$scope.deployitEnvironments=environments;});}
$scope.releasePropertiesUpdated=function(){var release={title:$scope.releaseForm.title,description:$scope.releaseForm.description,owner:$scope.releaseForm.owner,scheduledStartDate:$scope.releaseForm.scheduledStartDate,dueDate:$scope.releaseForm.dueDate,plannedDuration:$scope.releaseForm.plannedDuration,variables:$scope.releaseForm.variables,tags:$scope.releaseForm.tags,flag:$scope.releaseForm.flag,calendarPublished:$scope.releaseForm.calendarPublished};if($scope.releaseForm.newRelease){release.templateId=$scope.releaseForm.templateId;var fallback=release.templateId?'/templates':'/releases';$scope.creationInProgress=true;Backend.post('releases',release).success(function(releaseView){$scope.creationInProgress=false;$location.url('/releases/'+releaseView.id+'?fallback='+fallback);});}else{Backend.put('releases/'+$scope.releaseForm.id,release).success(function(){$scope.release.title=$scope.releaseForm.title;$scope.releaseUpdatedAt=moment().toDate();Page.addToTitle($scope.release.title);});}};$scope.back=function(){$window.history.back();};$scope.flag=function(flag){$scope.releaseForm.flag.status=flag;if(!FlagService.isItemFlagged($scope.releaseForm)){$scope.releaseForm.flag.comment='';}};$scope.downloadCalendar=ReleasesService.downloadCalendar;$scope.CurrentTimeZone=CurrentTimeZone;$scope.deleteAttachment=function(attachment){Backend.del('releases/'+$scope.releaseForm.id+'/attachments/'+attachment.id).success(function(){_.remove($scope.releaseForm.attachments,function(candidate){return candidate.id===attachment.id});});};}]);'use strict';angular.module('xlrelease').controller('teamsController',['$scope','Backend','TeamsService','releasePromise','teamsPromise','usersPromise','roleNamesPromise','ReleasesTabsService','Page',function($scope,Backend,TeamsService,releasePromise,teamsPromise,usersPromise,roleNamesPromise,ReleasesTabsService,Page){var DEFAULT_TEAM_NAME="New team";$scope.teams=extendWithValid(teamsPromise.data);$scope.release=releasePromise.data;Page.addToTitle($scope.release.title);ReleasesTabsService.open($scope.release,'/teams');$scope.allMembers=TeamsService.mergeMembers(usersPromise.data,roleNamesPromise.data);function extendWithValid(teams){_.forEach(teams,function(team){team.valid=true;});return teams;}
function nameAlreadyUsed(teamName,teamToIgnore){return _.any($scope.teams,function(team){return(team.teamName==teamName)&&(team!==teamToIgnore)});}
function uniqueNewTeamName(){var result=DEFAULT_TEAM_NAME,i=2;while(nameAlreadyUsed(result)){result=DEFAULT_TEAM_NAME+' '+i;i+=1;}
return result;}
$scope.addTeam=function(){var newTeam={teamName:uniqueNewTeamName(),members:[]};Backend.post('teams/release/'+$scope.release.id,newTeam).success(function(team){team.valid=true;$scope.teams.push(team);});};$scope.deleteTeam=function(teamToDelete){Backend.del('teams/'+teamToDelete.id).success(function(){$scope.teams=_.filter($scope.teams,function(team){return team.id!==teamToDelete.id;});});};$scope.validate=function(newName,team){return!nameAlreadyUsed(newName,team);};$scope.saveTeamMembers=function(team,members){team.members=members;$scope.saveTeam(team);};$scope.saveTeam=function(team){Backend.put('teams/'+team.id,_.omit(team,'valid')).success(function(serverTeam){team.systemTeam=serverTeam.systemTeam;});};}]);'use strict';angular.module('xlrelease').value('MemberType',{PRINCIPAL:'PRINCIPAL',ROLE:'ROLE'});angular.module('xlrelease').factory('TeamsService',['Backend','MemberType',function(Backend,MemberType){return{getTeams:function(releaseId){return Backend.get('teams/release/'+releaseId)},mergeMembers:function(users,roleNames){var allMembers=[];_.forEach(users,function(user){var member=user.fullName?{name:user.username,type:MemberType.PRINCIPAL,fullName:user.fullName}:{name:user.username,type:MemberType.PRINCIPAL};allMembers.push(member);});_.forEach(roleNames,function(roleName){allMembers.push({name:roleName,type:MemberType.ROLE});});return allMembers;}}}]);'use strict';angular.module('xlrelease').controller('logsController',['$scope','Backend','$routeParams','$location','ReleasesTabsService','CurrentTimeZone','Page','filterSettings','Filters',function($scope,Backend,$routeParams,$location,ReleasesTabsService,CurrentTimeZone,Page,filterSettings,Filters){$scope.releaseId=$routeParams.releaseId;$scope.filters=filterSettings;Backend.post('releases/'+$scope.releaseId+'/logs/search',$scope.filters).success(function(logs){$scope.logs=logs;});Backend.get('releases/'+$routeParams.releaseId).success(function(release){$scope.release=release;Page.addToTitle($scope.release.title);ReleasesTabsService.open(release,'/logs');});$scope.isTemplate=function(){return $location.url().indexOf("/templates")===0;};$scope.CurrentTimeZone=CurrentTimeZone;}]);'use strict';angular.module('xlrelease').controller('releaseSummaryController',['$scope','TasksService','FlagService','ReleasesService','DateService','Timeline','ColorService','SpecialDaysService','releasePromise','releaseDependenciesPromise','ReleaseAlerts','ReleasesTabsService','Page',function($scope,TasksService,FlagService,ReleasesService,DateService,Timeline,ColorService,SpecialDaysService,releasePromise,releaseDependenciesPromise,ReleaseAlerts,ReleasesTabsService,Page){var UNASSIGNED_USER=null;$scope.release=releasePromise.data;Page.addToTitle($scope.release.title);ReleasesTabsService.open($scope.release,'/summary');$scope.outgoingDependencies=releaseDependenciesPromise.data.outgoingDependencies;$scope.incomingDependencies=releaseDependenciesPromise.data.incomingDependencies;$scope.outgoingReleases=_.pluck($scope.outgoingDependencies,'release');$scope.incomingReleases=_.pluck($scope.incomingDependencies,'release');$scope.flattenedTasks=ReleasesService.getLeafTasks($scope.release);$scope.numberOfCompletedTasks=_.filter($scope.flattenedTasks,TasksService.isTaskReadOnly).length;$scope.teams=_.chain($scope.flattenedTasks).filter(TasksService.hasTeam).pluck('team').uniq().value();$scope.owners=_.chain($scope.flattenedTasks).filter(TasksService.hasOwner).pluck('owner').uniq('username').value();$scope.owners.push(UNASSIGNED_USER);var timelineReleases=_.union($scope.outgoingReleases,[$scope.release],$scope.incomingReleases);$scope.timeline=Timeline.init($scope.release,timelineReleases);ReleasesService.getReleasesDependenciesByReleaseId(timelineReleases).then(function(releasesDependencies){$scope.releasesDependencies=releasesDependencies;});$scope.flaggedItems=ReleaseAlerts.computeFlaggedItems($scope.release,$scope.flattenedTasks);$scope.conflicts=ReleaseAlerts.computeConflicts($scope.outgoingDependencies);$scope.delayedTasks=ReleaseAlerts.computeDelayedTasks($scope.flattenedTasks);SpecialDaysService.loadTimelineSpecialDays($scope.timeline.days);$scope.firstDayOfWeek=function(day){return day.fullDate.day()===0;};$scope.firstDayOfMonth=function(day){return day.fullDate.date()===1;};$scope.isInConflict=function(releaseId){return ReleasesService.isInConflict(releaseId,$scope.releasesDependencies);};$scope.isAssignedToUser=function(task,user){return TasksService.isAssignedToUser(task,user)||(!TasksService.hasOwner(task)&&user===UNASSIGNED_USER);};$scope.isTaskPending=TasksService.isTaskPending;$scope.isTaskFailed=TasksService.isTaskFailed;$scope.isTaskInProgress=TasksService.isTaskInProgress;$scope.isTaskFlagged=FlagService.isTaskFlagged;$scope.isTaskDelayed=TasksService.isTaskDelayed;$scope.isReleaseInProgress=ReleasesService.isReleaseInProgress;$scope.isReleaseFailing=ReleasesService.isReleaseFailing;$scope.isReleasePaused=ReleasesService.isReleasePaused;$scope.isReleaseFailed=ReleasesService.isReleaseFailed;$scope.isReleasePlanned=ReleasesService.isReleasePlanned;$scope.isReleaseAborted=ReleasesService.isReleaseAborted;$scope.isAssignedToTeam=TasksService.isAssignedToTeam;$scope.computeDayColor=ColorService.computeDayColor;$scope.computePhaseColor=ColorService.computePhaseColor;}]);angular.module('xlrelease').value('TimelineConstants',{timelineDayHeaderHeight:26,weekModeWidthThreshold:60,monthModeWidthThreshold:10});angular.module('xlrelease').factory('TimelineDisplay',['Browser','CalendarConstants','CalendarDisplay','TimelineConstants',function(Browser,CalendarConstants,CalendarDisplay,TimelineConstants){function resizeTimelineHeight(timelineSectionBody,releasesDisplayed){var height=TimelineConstants.timelineDayHeaderHeight+releasesDisplayed*CalendarConstants.releaseHeight;timelineSectionBody.find('#timeline').height(height);timelineSectionBody.find('.dependencies').height(height);timelineSectionBody.find('.day').css({'height':height});}
function resizeTimelineWidth(timelineSectionBody){var timeline=timelineSectionBody.find('#timeline');var daysWrapper=timelineSectionBody.find('#days-wrapper');var days=timelineSectionBody.find('.day');timeline.css({'margin-left':timelineSectionBody.find('#outgoing-dependencies:visible').width(),'margin-right':timelineSectionBody.find('#incoming-dependencies:visible').width()});var timelineWidth=timeline.width();var idealDayWidth=timelineWidth/days.length;daysWrapper.width(2*timelineWidth);switchTimelineView(idealDayWidth,days);computeDayWidth(days,_.parseInt(idealDayWidth),timelineWidth);}
function switchTimelineView(dayWidth,days){if(dayWidth<TimelineConstants.monthModeWidthThreshold){days.removeClass('day-view').removeClass('week-view').addClass('month-view');}else if(dayWidth<TimelineConstants.weekModeWidthThreshold){days.removeClass('day-view').removeClass('month-view').addClass('week-view');}else{days.removeClass('month-view').removeClass('week-view').addClass('day-view');}}
function computeDayWidth(days,dayWidth,timelineWidth){days.css('width',dayWidth+'px');var extraPixels=timelineWidth-days.length*dayWidth;for(var i=0;i<extraPixels;i++){days.eq(i).css('width',dayWidth+1+'px');}}
function computeOffsetTop(index){return TimelineConstants.timelineDayHeaderHeight+index*CalendarConstants.releaseHeight;}
function computeHzlOffset(element,daysAfterFirst,dayRatio){var offset;var days=element.parents('#timeline').find('.day');if(daysAfterFirst>=0){if(daysAfterFirst<days.length){var day=days.eq(daysAfterFirst);offset=day.prop('offsetLeft')+day.outerWidth(true)*dayRatio;}else{var lastDay=days.eq(days.length-1);offset=lastDay.prop('offsetLeft')+lastDay.outerWidth(true);}}else{offset=days.eq(0).prop('offsetLeft');}
return offset;}
return{resize:function(timelineSectionBody,releasesDisplayed){resizeTimelineHeight(timelineSectionBody,releasesDisplayed);resizeTimelineWidth(timelineSectionBody);},positionPlanItem:function(element,planItem,index,isPhase){var borderSize=isPhase?0:CalendarConstants.border;var phaseOffset=isPhase?CalendarConstants.border:0;var offsetLeft=computeHzlOffset(element,planItem.daysBetweenFirstAndStart,planItem.startRatio)+phaseOffset;var offsetRight=computeHzlOffset(element,planItem.daysBetweenFirstAndEnd,planItem.endRatio);if(offsetLeft!==offsetRight){var width=offsetRight-offsetLeft-2*borderSize-phaseOffset;var sectionBodyOffset=element.parents('.section-body').prop('offsetTop');var offsetTop=sectionBodyOffset+computeOffsetTop(index)+phaseOffset;element.css({top:offsetTop+'px',left:offsetLeft+'px',width:width+'px'});if(!isPhase){CalendarDisplay.resizeReleaseTitle(element);}}else{element.hide();}},positionDependency:function(dependency,index){dependency.css({top:computeOffsetTop(index)+'px',left:0});}};}]);angular.module('xlrelease').directive('resizeTimeline',['TimelineDisplay','Events','Window',function(TimelineDisplay,Events,Window){return function(scope,element){scope.$watch('',function(){scope.$evalAsync(function(){TimelineDisplay.resize(element,scope.timeline.releases.length);scope.$broadcast(Events.timeline.hasBeenResized);});});Window.onResize(function(){scope.$apply(function(){TimelineDisplay.resize(element,scope.timeline.releases.length);scope.$broadcast(Events.timeline.hasBeenResized);});},scope);scope.$on(Events.timeline.resize,function(){TimelineDisplay.resize(element,scope.timeline.releases.length);scope.$broadcast(Events.timeline.hasBeenResized);});};}]);angular.module('xlrelease').directive('positionTimelineRelease',['TimelineDisplay','Events',function(TimelineDisplay,Events){return function(scope,element){scope.$on(Events.timeline.hasBeenResized,function(){scope.$evalAsync(function(){TimelineDisplay.positionPlanItem(element,scope.release,scope.$index);})});}}]);angular.module('xlrelease').directive('positionTimelinePhase',['TimelineDisplay','Events',function(TimelineDisplay,Events){return function(scope,element){scope.$on(Events.timeline.hasBeenResized,function(){scope.$evalAsync(function(){TimelineDisplay.positionPlanItem(element,scope.phase,scope.$parent.$index,true);})});}}]);angular.module('xlrelease').directive('positionOutgoingDependency',['TimelineDisplay','Events',function(TimelineDisplay,Events){return function(scope,element){scope.$on(Events.timeline.hasBeenResized,function(){TimelineDisplay.positionDependency(element,scope.$index);});}}]);angular.module('xlrelease').directive('positionIncomingDependency',['TimelineDisplay','Events',function(TimelineDisplay,Events){return function(scope,element){var incomingDependenciesOffset=scope.outgoingDependencies.length+1;scope.$on(Events.timeline.hasBeenResized,function(){TimelineDisplay.positionDependency(element,scope.$index!==undefined?(incomingDependenciesOffset+scope.$index):-1);});}}]);angular.module('xlrelease').directive('timelineResizer',['Events',function(Events){return function(scope){scope.resizeTimeline=function(){scope.$watch('',function(){scope.$evalAsync(function(){scope.$emit(Events.timeline.resize);})})}}}]);'use strict';angular.module('xlrelease').factory('Timeline',['DateService','ReleasesService','Planner',function(DateService,ReleasesService,Planner){function getDays(firstDay,lastDay){var days=[];var numberOfDays=lastDay.diff(firstDay,'days');for(var i=0;i<numberOfDays;i++){var currentDay=moment(firstDay).add('days',i);days.push({number:currentDay.date(),fullDate:currentDay,dateStatus:DateService.getDateStatus(currentDay)});}
return days;}
function getDaysAfterFirst(firstDay,day){if(day.isAfter(firstDay)){return day.diff(firstDay,'days');}
return-1;}
function getReleases(firstDay,releases){var timelineReleases=[];_.each(releases,function(release){Planner.setRelease(release);var plan=Planner.makePlan();var startDate=moment(plan.elements[0].displayStartDate);var endDate=moment(plan.elements[0].displayEndDate);var enhancedRelease=angular.copy(release);angular.extend(enhancedRelease,{startRatio:startDate.diff(DateService.atMidnight(startDate),'days',true),endRatio:endDate.diff(DateService.atMidnight(endDate),'days',true),daysBetweenFirstAndStart:getDaysAfterFirst(firstDay,startDate),daysBetweenFirstAndEnd:getDaysAfterFirst(firstDay,endDate),displayablePhases:getDisplayablePhases(firstDay,enhancedRelease,plan)});timelineReleases.push(enhancedRelease);});return timelineReleases;}
function getDisplayablePhases(firstDay,release,plan){var enhancedPhases=[];var releasePlanElement=plan.elements[0];_.each(release.phases,function(phase){var phasePlanElement=_.find(plan.elements,{id:phase.id});var startDate=phasePlanElement.displayStartDate.isAfter(releasePlanElement.displayStartDate)?phasePlanElement.displayStartDate:releasePlanElement.displayStartDate;var endDate=phasePlanElement.displayEndDate.isBefore(releasePlanElement.displayEndDate)?phasePlanElement.displayEndDate:releasePlanElement.displayEndDate;angular.extend(phase,{startRatio:startDate.diff(DateService.atMidnight(startDate),'days',true),endRatio:endDate.diff(DateService.atMidnight(endDate),'days',true),daysBetweenFirstAndStart:getDaysAfterFirst(firstDay,startDate),daysBetweenFirstAndEnd:getDaysAfterFirst(firstDay,endDate)});enhancedPhases.push(phase);});return enhancedPhases;}
return{init:function(currentRelease,releases){Planner.setRelease(currentRelease);var plan=Planner.makePlan();var startDate=plan.elements[0].displayStartDate;var endDate=plan.elements[0].displayEndDate;var firstDay=DateService.atMidnight(startDate);var lastDay=DateService.atMidnight(endDate).add('days',1);return{days:getDays(firstDay,lastDay),releases:getReleases(firstDay,releases)};}};}]);'use strict';angular.module('xlrelease').controller('ganttController',['$scope','$route','GanttZoom','releasePromise','Events','ReleasesService','GanttElementsEditor','Backend','TaskDetailsUpdates','PhaseDetailsUpdates','ReleasesTabsService','Page','ClientSettings','Planner',function($scope,$route,GanttZoom,releasePromise,Events,ReleasesService,GanttElementsEditor,Backend,TaskDetailsUpdates,PhaseDetailsUpdates,ReleasesTabsService,Page,ClientSettings,Planner){$scope.release=releasePromise.data;Planner.setRelease($scope.release);Page.addToTitle($scope.release.title);ReleasesTabsService.open($scope.release,'/planner');$scope.inGantt=true;$scope.ganttZoom=GanttZoom;$scope.ganttConfig={isReadOnly:!$scope.security.hasEditPermission($scope.release),isDatesColumnsShown:ClientSettings.getGanttDatesColumnsCollapseState()};function loadGanttAfterUpdate(){ReleasesService.getRelease($scope.release.id).success(function(release){$scope.release=release;Planner.setRelease($scope.release);GanttElementsEditor.updateGanttElements();});}
$scope.endEditTask=function(){$scope.editTask=false;if(TaskDetailsUpdates.planningDataChanged){loadGanttAfterUpdate();TaskDetailsUpdates.reset();}else{GanttElementsEditor.updateGanttElements();}};$scope.$on(Events.gantt.openTaskDetails,function(event,taskId){var tasks=ReleasesService.getAllTasks($scope.release);$scope.task=_.find(tasks,function(task){return task.id===taskId});$scope.editTask=true;});$scope.endEditPhase=function(){$scope.editPhase=false;if(PhaseDetailsUpdates.planningDataChanged){loadGanttAfterUpdate();PhaseDetailsUpdates.reset();}else{GanttElementsEditor.updateGanttElements();}};$scope.$on(Events.gantt.openPhaseDetails,function(event,phaseId){$scope.phase=_.find($scope.release.phases,function(phase){return phase.id===phaseId});$scope.editPhase=true;});$scope.$watch('ganttConfig.isDatesColumnsShown',function(newValue,oldValue){if(newValue!=oldValue){ClientSettings.setGanttDatesColumnsCollapseState($scope.ganttConfig.isDatesColumnsShown);}});}]);'use strict';angular.module('xlrelease').directive('gantt',['Planner','Gantt','$parse','Window','Browser','$compile','Timeout','Events','GanttWrapper','Layout',function(Planner,Gantt,$parse,Window,Browser,$compile,Timeout,Events,GanttWrapper,Layout){function adjustGanttHeight(ganttElement){var extra=2;ganttElement.height(Window.height()-ganttElement.offset().top-Layout.mainPageBorder-extra);}
var dateEditorLink=undefined;var durationEditorLink=undefined;function postProcessGanttDom(scope){if(!dateEditorLink){dateEditorLink=$compile("<div gantt-date-editor></div>");}
if(!durationEditorLink){durationEditorLink=$compile("<div gantt-duration-editor></div>");}
Timeout(function(){$('.gantt-date-editor-container, .gantt-duration-editor-container').each(function(index,item){var editor=$(item).hasClass('gantt-date-editor-container')?dateEditorLink:durationEditorLink;$(item).empty();editor(scope,function(clonedElement){$(item).append(clonedElement);});});},0);}
return function link(scope,element,attrs){Gantt.config(scope.ganttConfig.isDatesColumnsShown);scope.$on(Events.gantt.hasBeenRefreshed,function(){postProcessGanttDom(scope);});Gantt.initReadOnly($parse(attrs.readonly)(scope));adjustGanttHeight(element);element.dhx_gantt({data:{data:Planner.makePlan().elements,links:Planner.getLinks()}});Window.onResize(function(){adjustGanttHeight(element);},scope);scope.$on('$destroy',Gantt.destroy);scope.$watch('ganttConfig.isDatesColumnsShown',function(newValue,oldValue){if(newValue!=oldValue){Gantt.config(newValue);GanttWrapper.render();}});}}]);'use strict';angular.module('xlrelease').factory('GanttElementsEditor',['GanttCssClasses','PhaseColors','TasksService','taskTypeCssClassFilter','Backend','VariablesInterpolator','GanttWrapper','Planner','TopologicalSort','PlanningDataEditor',function(GanttCssClasses,PhaseColors,TasksService,taskTypeCssClassFilter,Backend,VariablesInterpolator,GanttWrapper,Planner,TopologicalSort,PlanningDataEditor){var FROM_END_TO_START='0';function createsCycle(existingEdges,newSource,newTarget){var adjacencyList=[];var vertices={};_.each(existingEdges,function(edge){var sourceId=edge.source,targetId=edge.target;adjacencyList.push({sourceId:sourceId,targetId:targetId});vertices[sourceId]=vertices[targetId]=true;});var sourceId=newSource.id,targetId=newTarget.id;adjacencyList.push({sourceId:sourceId,targetId:targetId});vertices[sourceId]=vertices[targetId]=true;var graph={adjacencyList:adjacencyList,vertices:_.keys(vertices)};return(TopologicalSort.sort(graph)==null);}
function saveAndRefresh(element){updateGanttElements();Backend.put('planning/'+element.id,{scheduledStartDate:element.planItem.scheduledStartDate,dueDate:element.planItem.dueDate,plannedDuration:element.planItem.plannedDuration});}
function updateGanttElements(){var elements=Planner.makePlan().elements;_.each(elements,function(updatedElement){var element=GanttWrapper.getTask(updatedElement.id);angular.extend(element,updatedElement);});GanttWrapper.refreshData();}
return{dragLeft:function(element,date){PlanningDataEditor.dragLeft(element,date);saveAndRefresh(element);},dragRight:function(element,date){PlanningDataEditor.dragRight(element,date);saveAndRefresh(element);},move:function(element,startDate,endDate){PlanningDataEditor.move(element,startDate,endDate);saveAndRefresh(element);},setStartDate:function(element,date){PlanningDataEditor.setStartDate(element,date);saveAndRefresh(element);},setEndDate:function(element,date){PlanningDataEditor.setEndDate(element,date);saveAndRefresh(element);},setDuration:function(element,duration){PlanningDataEditor.setDuration(element,duration);saveAndRefresh(element);},canMove:function(element){return this.canUpdateStartDate(element)&&this.canUpdateEndDate(element);},canUpdateStartDate:function(element){return element.hasBeenStarted===false;},canUpdateEndDate:function(element){return element.isUpdatable;},canCreateLinks:function(container){return container&&TasksService.isParallelGroup(container)&&!container.hasBeenStarted;},canLink:function(source,target,linkType){return linkType===FROM_END_TO_START&&source.parent===target.parent&&!GanttWrapper.isLinkExists(Planner.makeLinkId(source.id,target.id))&&!createsCycle(GanttWrapper._get_links_data(),source,target);},addLink:function(link,container,source,target){var linkForm={sourceId:source.id,targetId:target.id};container.planItem.links.push(linkForm);updateGanttElements();Backend.post('planning/links/'+container.id,linkForm).success(function(newLink){linkForm.id=link.linkId=newLink.id;GanttWrapper.changeLinkId(link.id,Planner.makeLinkId(source.id,target.id));});},removeLink:function(link,container){container.planItem.links=_.reject(container.planItem.links,function(itemLink){return itemLink.id==link.linkId;});updateGanttElements();Backend.del('planning/links/'+link.linkId);},updateGanttElements:updateGanttElements};}]);'use strict';angular.module('xlrelease').value('GanttCssClasses',{DEFAULT:'gantt-cell',RELEASE:'gantt-cell-release',PHASE:'gantt-cell-phase',PHASE_PREFIX:'gantt-cell-phase-',TASK:'gantt-cell-task',TASK_STATUS_PREFIX:'gantt-cell-task-status-'});angular.module('xlrelease').factory('Gantt',['$rootScope','GanttElementsEditor','ClientSettings','GanttZoomSettings','Events','dateFormatterFilter','timeFormatterFilter','$locale','dateFilter','GanttZoom',function($rootScope,GanttElementsEditor,ClientSettings,GanttZoomSettings,Events,dateFormatterFilter,timeFormatterFilter,$locale,dateFilter,GanttZoom){var removeLinkEventId,addLinkEventId,scrollState;var datesColumnsWidth=110;var durationColumnsWidth=100;var titleColumnWidth=250;var RELEASE_TYPE='xlrelease.Release';var UpdateMode={move:'move',updateStartDate:'updateStartDate',updateEndDate:'updateEndDate'};function initStyling(){gantt.templates.task_class=taskClass;gantt.templates.grid_open=gridOpenHtml;gantt.templates.grid_row_class=defaultRowClass;gantt.templates.task_row_class=defaultRowClass;gantt.templates.grid_file=noIconHtml;gantt.templates.grid_folder=noIconHtml;gantt.templates.link_class=linkClass;function taskClass(start,end,task){var classes=[task.cssClass];if(!GanttElementsEditor.canUpdateStartDate(task)){classes.push('gantt-no-left-handle');}
if(!GanttElementsEditor.canUpdateEndDate(task)){classes.push('gantt-no-right-handle');}
var parentTask=task.parent?gantt.getTask(task.parent):null;if(!GanttElementsEditor.canCreateLinks(parentTask)){classes.push('gantt-no-custom-links');}
return classes.join(' ');}
function linkClass(link){return link.readOnly?'readonly-link':'';}
function defaultRowClass(){return'gantt-row';}
function noIconHtml(){return'<span class="no-icon"></span>';}
function gridOpenHtml(item){var classes=['gantt_tree_icon','gantt-folder'];if(item.$open){classes.push('gantt_close','gantt-folder-close');}else{classes.push('gantt_open','gantt-folder-open');}
return"<div class='"+classes.join(' ')+"'>​</div>​";}}
function initLocale(){gantt.locale.date={month_full:$locale.DATETIME_FORMATS['MONTH'],month_short:$locale.DATETIME_FORMATS['SHORTMONTH'],day_full:$locale.DATETIME_FORMATS['DAY'],day_short:$locale.DATETIME_FORMATS['SHORTDAY']};}
function initEvents(){gantt.attachEvent("onBeforeTaskDrag",function(id,mode){scrollState=gantt.getScrollState();var element=gantt.getTask(id);element.previousScheduledStartDate=element.start_date;element.previousDueDate=element.end_date;switch(getUpdateMode(mode)){case UpdateMode.move:return GanttElementsEditor.canMove(element);case UpdateMode.updateStartDate:return GanttElementsEditor.canUpdateStartDate(element);case UpdateMode.updateEndDate:return GanttElementsEditor.canUpdateEndDate(element);}});gantt.attachEvent("onAfterTaskDrag",function(id,mode){var element=gantt.getTask(id);switch(getUpdateMode(mode)){case UpdateMode.move:GanttElementsEditor.move(element,element.start_date,element.end_date);break;case UpdateMode.updateStartDate:GanttElementsEditor.dragLeft(element,element.start_date);break;case UpdateMode.updateEndDate:GanttElementsEditor.dragRight(element,element.end_date);break;}
gantt.scrollTo(scrollState.x,scrollState.y)});function canAddLink(linkId,link){var source=gantt.getTask(link.source);var target=gantt.getTask(link.target);return GanttElementsEditor.canLink(source,target,link.type);}
function saveCollapseState(id,isOpen){var states=ClientSettings.getGanttElementsCollapseState();if(!states)states={};states[id]=isOpen;ClientSettings.setGanttElementsCollapseState(states);}
var canAddLinkWithoutLinkId=_.partial(canAddLink,undefined);gantt.attachEvent("onLinkValidation",canAddLinkWithoutLinkId);gantt.attachEvent("onBeforeLinkAdd",canAddLink);gantt.attachEvent("onTaskClosed",function(id){saveCollapseState(id,false);});gantt.attachEvent("onTaskOpened",function(id){saveCollapseState(id,true);});addLinkEventId=gantt.attachEvent("onAfterLinkAdd",function(linkId,link){var source=gantt.getTask(link.source);var target=gantt.getTask(link.target);var container=gantt.getTask(source.parent);GanttElementsEditor.addLink(link,container,source,target);});gantt.attachEvent("onAfterLinkDelete",function(linkId,link){var source=gantt.getTask(link.source);var container=gantt.getTask(source.parent);GanttElementsEditor.removeLink(link,container);});gantt.attachEvent("onTaskDblClick",function(elementId){var element=gantt.getTask(elementId);if(element.type==="xlrelease.Release"){}else if(element.type==="xlrelease.Phase"){$rootScope.$apply(function(){$rootScope.$broadcast(Events.gantt.openPhaseDetails,elementId);});}else{$rootScope.$apply(function(){$rootScope.$broadcast(Events.gantt.openTaskDetails,elementId);});}
return false;});gantt.attachEvent("onTaskClick",function(){return false;})}
function initRemoveLinkEvent(isReadOnly){removeLinkEventId=gantt.attachEvent("onLinkDblClick",function(linkId){var link=gantt.getLink(linkId);return!link.readOnly&&!isReadOnly;});}
function formatDateAndTime(date){return"<span class='readonly-date'>"+dateFilter(date,'shortDate')+"</span><span class='readonly-time'>"+dateFilter(date,'shortTime')+"</span>";}
function isDateDeletable(element,dateType){if(element.status==="TEMPLATE"&&dateType==="end"){return true;}
return element.type!==RELEASE_TYPE;}
function dateEditorTemplate(date,dateType,hasOwnDate,element){var elementId=element.id;var dateCanBeDeleted=isDateDeletable(element,dateType);return"<div class='gantt-date-editor-container' data-date="+date.getTime()+" data-type='"+dateType+"' data-id='"+elementId+"' data-deletable='"+dateCanBeDeleted+"' data-has-own-date='"+hasOwnDate+"'></div>";}
function durationEditorTemplate(plannedDuration,displayedDuration,elementId,done,editable){function toBoolean(value){return value?'true':'false';}
return"<div class='gantt-duration-editor-container' "+"data-duration='"+plannedDuration+"' "+"data-display-duration='"+displayedDuration+"' d"+"ata-id='"+elementId+"' "+"data-done='"+toBoolean(done)+"' "+"data-editable='"+toBoolean(editable)+"' "+"></div>";}
function getGridWidth(isDatesColumnsShown){var width=20;width+=titleColumnWidth;if(isDatesColumnsShown){width+=(2*datesColumnsWidth)+durationColumnsWidth;}
return width;}
function getColumns(isDatesColumnsShown){var columns=[{name:"text",tree:true,width:titleColumnWidth+"px"}];if(isDatesColumnsShown){columns.push({name:"start_date",align:"left",width:datesColumnsWidth+"px",template:function(element){if(element.hasBeenStarted||gantt.config.readonly){return formatDateAndTime(element.start_date);}else{return dateEditorTemplate(element.start_date,"start",element.hasOwnStartDate,element);}}});columns.push({name:"end_date",align:"left",width:datesColumnsWidth+"px",template:function(element){if(!element.isUpdatable||gantt.config.readonly){return formatDateAndTime(element.end_date);}else{return dateEditorTemplate(element.end_date,"end",element.hasOwnEndDate,element);}}});columns.push({name:"duration",align:"middle",width:durationColumnsWidth+"px",template:function(element){console.log(element);var editable=element.isUpdatable&&!gantt.config.readonly;return durationEditorTemplate(element.planItem.plannedDuration,element.displayDuration,element.id,element.planItem.done,editable);}});}
return columns;}
return{config:function(isDatesColumnsShown){gantt.config.round_dnd_dates=false;gantt.config.fit_tasks=true;GanttZoom.getCurrent().apply();gantt.locale.labels.column_text='Name';if(isDatesColumnsShown){gantt.locale.labels.column_start_date='Start date';gantt.locale.labels.column_end_date='End date';gantt.locale.labels.column_duration='Duration';}
gantt.config.columns=getColumns(isDatesColumnsShown);gantt.config.grid_width=getGridWidth(isDatesColumnsShown);gantt.config.show_progress=false;gantt.config.drag_links=true;gantt.config.min_duration=60*1000;initStyling();initLocale();initEvents();},initReadOnly:function(isReadOnly){gantt.config.readonly=isReadOnly;gantt.config.drag_resize=!isReadOnly;initRemoveLinkEvent(isReadOnly);},destroy:function(){gantt.unselectTask();gantt.clearAll();gantt.detachEvent(removeLinkEventId);gantt.detachEvent(addLinkEventId);}};function getUpdateMode(mode){if(mode===gantt.config.drag_mode.move){return UpdateMode.move;}else if(mode===gantt.config.drag_mode.resize){if(gantt.getState().drag_from_start){return UpdateMode.updateStartDate;}else{return UpdateMode.updateEndDate;}}}}]);'use strict';angular.module('xlrelease').factory('GanttZoom',['GanttZoomSettings','ClientSettings',function(GanttZoomSettings,ClientSettings){var registeredZoomLevel=ClientSettings.getGanttZoomLevel();var current;if(registeredZoomLevel){current=GanttZoomSettings.findByLabel(registeredZoomLevel);}else{current=GanttZoomSettings.defaultZoom;}
var zooms=GanttZoomSettings.zooms;function currentIndex(){return _.indexOf(zooms,current);}
return{zooms:zooms,getCurrent:function(){return current;},isCurrent:function(zoom){return current==zoom;},next:function(){return this.zooms[currentIndex()+1];},previous:function(){return this.zooms[currentIndex()-1];},hasNext:function(){return currentIndex()<this.zooms.length-1;},hasPrevious:function(){return currentIndex()>0;},select:function(zoom){current=zoom;ClientSettings.setGanttZoomLevel(current.label);current.render();}}}]);angular.module('xlrelease').factory('GanttZoomSettings',['DateFormatDetector',function(DateFormatDetector){var Zoom=function(label,applyFn){this.label=label;this.apply=applyFn;};Zoom.prototype.render=function(){this.apply();gantt.render();};var hourFormat=DateFormatDetector.isAmPmVisible()?"%g%a":"%Hh";var hourFormatWithMinutes=DateFormatDetector.isAmPmVisible()?"%g:%i%a":"%Hh%i";var isMonthDisplayedBeforeDay=DateFormatDetector.isMonthDisplayedBeforeDay();var shortDayFormat=isMonthDisplayedBeforeDay?"%M %d":"%d %M";var longDayFormat=isMonthDisplayedBeforeDay?"%F %d":"%d %F";var zooms=[new Zoom('Month',function(){gantt.config.scale_unit="month";gantt.config.date_scale="%M";gantt.config.subscales=[];gantt.config.time_step=60*24;}),new Zoom('Week',function(){gantt.config.scale_unit="week";gantt.config.date_scale="Week %W";gantt.config.subscales=[];gantt.config.time_step=60*24;}),new Zoom('Day',function(){gantt.config.scale_unit="day";gantt.config.date_scale=shortDayFormat;gantt.config.subscales=[];gantt.config.time_step=60;}),new Zoom('8h',function(){gantt.config.scale_unit="day";gantt.config.date_scale=longDayFormat;gantt.config.subscales=[{unit:"hour",step:8,date:hourFormat}];gantt.config.time_step=10;}),new Zoom('4h',function(){gantt.config.scale_unit="day";gantt.config.date_scale=longDayFormat;gantt.config.subscales=[{unit:"hour",step:4,date:hourFormat}];gantt.config.time_step=10;}),new Zoom('2h',function(){gantt.config.scale_unit="day";gantt.config.date_scale=longDayFormat;gantt.config.subscales=[{unit:"hour",step:2,date:hourFormat}];gantt.config.time_step=10;}),new Zoom('1h',function(){gantt.config.scale_unit="day";gantt.config.date_scale=longDayFormat;gantt.config.subscales=[{unit:"hour",step:1,date:hourFormat}];gantt.config.time_step=10;}),new Zoom('30min',function(){gantt.config.scale_unit="day";gantt.config.date_scale=longDayFormat;gantt.config.subscales=[{unit:"minute",step:30,date:hourFormatWithMinutes}];gantt.config.time_step=10;}),new Zoom('15min',function(){gantt.config.scale_unit="day";gantt.config.date_scale=longDayFormat;gantt.config.subscales=[{unit:"minute",step:15,date:hourFormatWithMinutes}];gantt.config.time_step=5;}),new Zoom('5min',function(){gantt.config.scale_unit="day";gantt.config.date_scale=longDayFormat;gantt.config.subscales=[{unit:"minute",step:5,date:hourFormatWithMinutes}];gantt.config.time_step=5;})];return{zooms:zooms,defaultZoom:zooms[2],findByLabel:function(searchedLabel){return _.find(zooms,{label:searchedLabel})||this.defaultZoom;}}}]);'use strict';angular.module('xlrelease').factory('GanttWrapper',['$rootScope','Events',function($rootScope,Events){var oldRender=gantt.render;var oldRefreshData=gantt.refreshData;gantt.render=function(){$rootScope.$broadcast(Events.gantt.hasBeenRefreshed);oldRender.call(gantt);};gantt.refreshData=function(){$rootScope.$broadcast(Events.gantt.hasBeenRefreshed);oldRefreshData.call(gantt);};return gantt;}]);angular.module('xlrelease').factory('Planner',['TasksService','TopologicalSort','VariablesInterpolator','PhaseColors','GanttCssClasses','PhasesService','ClientSettings','ReleasesService','taskTypeCssClassFilter','DateService',function(TasksService,TopologicalSort,VariablesInterpolator,PhaseColors,GanttCssClasses,PhasesService,ClientSettings,ReleasesService,taskTypeCssClassFilter,DateService){var MANUAL_TASK_DURATION=60;var AUTOMATED_TASK_DURATION=1;var PHASE_COLORS=_.indexBy(PhaseColors,'value');var DEFAULT_PHASE_COLOR=PhaseColors[0].name;var FROM_END_TO_START='0';var release;function makeLinkId(sourceId,targetId){return sourceId+'|'+targetId;}
function hasPlannedDuration(planItem){return planItem.plannedDuration!==null&&planItem.plannedDuration!==undefined;}
return{makePlan:function(){var now=DateService.getTodayWithTime();var plan=makePlan(release,now,now);var elements=[];buildElementsFromPlan(plan);return{plan:plan,elements:elements};function makePlan(item,proposedStartDate,now,parent){var plan={id:item.id,type:item.type,displayStartDate:computeStartDate(item,proposedStartDate),children:[]};if(TasksService.isParallelGroup(item)){plan.children=makeSubTaskPlans(item,plan.displayStartDate,now,item);var proposedDate=findMaxDisplayEndDate(plan.children)||plan.displayStartDate;plan.displayEndDate=computeEndDate(item,proposedDate,plan.displayStartDate);}else{var currentDate=plan.displayStartDate;_(getChildren(item)).forEach(function(child){var childPlan=makePlan(child,currentDate,now,item);plan.children.push(childPlan);if(!TasksService.isTaskDoneInAdvance(child)){currentDate=childPlan.displayEndDate;}});plan.displayEndDate=computeEndDate(item,currentDate,plan.displayStartDate,now);}
plan.displayDuration=plan.displayEndDate.diff(plan.displayStartDate,'milliseconds');addAdditionalProperties(plan,item,parent);return plan;}
function buildElementsFromPlan(plan){elements.push(plan);_(plan.children).forEach(function(child){buildElementsFromPlan(child);});}
function addAdditionalProperties(plan,item,parent){plan.hasBeenStarted=item.hasBeenStarted;plan.text=VariablesInterpolator.interpolateInHtml(release.variables,item.title);plan.childrenIds=toIds(plan.children);plan.cssClass=GanttCssClasses.DEFAULT+' '+getCssClass(item);plan.isUpdatable=item.updatable;plan.open=getCollapseState(item);plan.start_date=plan.displayStartDate.toDate();plan.end_date=plan.displayEndDate.toDate();plan.parent=getParentId(parent);plan.planItem=item;plan.hasOwnStartDate=hasOwnStartDate(item);plan.hasOwnEndDate=hasOwnEndDate(item);plan.status=item.status;}
function hasOwnStartDate(planItem){return planItem.scheduledStartDate||planItem.startDate;}
function hasOwnEndDate(planItem){return planItem.dueDate||planItem.endDate;}
function getParentId(parentElement){return parentElement?parentElement.id:undefined;}
function getCssClass(item){if(ReleasesService.isRelease(item)){return GanttCssClasses.RELEASE;}else if(PhasesService.isPhase(item)){return getPhaseCssClass(item);}else{return getTaskCssClass(item);}}
function getPhaseCssClass(phase){var cssClass=GanttCssClasses.PHASE;if(phase.color&&PHASE_COLORS[phase.color]){cssClass+=' '+GanttCssClasses.PHASE_PREFIX+PHASE_COLORS[phase.color].name;}else{cssClass+=' '+GanttCssClasses.PHASE_PREFIX+DEFAULT_PHASE_COLOR;}
return cssClass;}
function getTaskCssClass(task){var cssClasses=GanttCssClasses.TASK+' '+taskTypeCssClassFilter(task.type);if(task.status){cssClasses+=' '+GanttCssClasses.TASK_STATUS_PREFIX+task.status.toLowerCase();}
return cssClasses;}
function getCollapseState(item){var isOpenByDefault=ReleasesService.isRelease(item)||(TasksService.isTask(item)&&!TasksService.isParallelGroup(item));var states=ClientSettings.getGanttElementsCollapseState();if(states==null||states[item.id]==null){return isOpenByDefault}
return states[item.id];}
function toIds(planItems){return _.pluck(planItems,'id');}
function makeSubTaskPlans(item,currentDate,now,parent){var taskIds=toIds(item.tasks);var orderedTaskIds=TopologicalSort.sort({adjacencyList:item.links,vertices:taskIds});var orderedTasks=mapIdsToObjects(orderedTaskIds,item.tasks);var orderedPlans=[];_(orderedTasks).forEach(function(task){var predecessors=mapIdsToObjects(findPredecessorsIds(item.links,task.id),orderedPlans);var startDate=predecessors.length?findMaxDisplayEndDate(predecessors):currentDate;var childPlan=makePlan(task,startDate,now,parent);orderedPlans.push(childPlan);});return mapIdsToObjects(taskIds,orderedPlans);}
function findPredecessorsIds(links,taskId){var directPredecessorsIds=_.chain(links).filter(function(link){return link.targetId==taskId;}).pluck('sourceId').value();var predecessorsIds=[];_.forEach(directPredecessorsIds,function(predecessorId){predecessorsIds=predecessorsIds.concat(findPredecessorsIds(links,predecessorId));});return _.uniq(predecessorsIds.concat(directPredecessorsIds));}
function getChildren(item){return item.phases||item.tasks;}
function computeStartDate(item,proposedDate){if(item.startDate){return moment(item.startDate).startOf('minute');}
if(item.scheduledStartDate){return moment(item.scheduledStartDate).startOf('minute');}
if(item.dueDate&&hasPlannedDuration(item)){return moment(item.dueDate).subtract('milliseconds',item.plannedDuration).startOf('minute');}
return moment(proposedDate).startOf('minute');}
function computeEndDate(item,proposedDate,displayStartDate,now){var endDate;if(item.endDate){endDate=moment(item.endDate);}else if(item.dueDate){endDate=moment(item.dueDate);}else if(hasPlannedDuration(item)){endDate=moment(displayStartDate).add('milliseconds',item.plannedDuration);}else if(isAutomatedTask(item)){endDate=moment(proposedDate).add('minutes',AUTOMATED_TASK_DURATION);}else if(isManualTask(item)){endDate=moment(proposedDate).add('minutes',MANUAL_TASK_DURATION);}else{endDate=moment(proposedDate);}
if(endDate.isBefore(displayStartDate)){endDate=moment(displayStartDate);}
if(isActiveLeafTask(item)&&endDate.isBefore(now)){endDate=moment(now);}
return endDate.startOf('minute');}
function isAutomatedTask(item){return TasksService.isTask(item)&&TasksService.isAutomated(item);}
function isManualTask(item){return!TasksService.isParallelGroup(item)&&TasksService.isTask(item)&&!TasksService.isAutomated(item);}
function isActiveLeafTask(item){return item.active&&TasksService.isTask(item)&&!TasksService.isParallelGroup(item);}
function findMaxDisplayEndDate(items){return _.max(items,function(child){return child.displayEndDate.valueOf()}).displayEndDate}
function mapIdsToObjects(ids,objects){return _.map(ids,function(id){return _.find(objects,{id:id});});}},getLinks:function(){var links=[];addLinksBetweenPhases();addLinksBetweenTasks();addLinksWithinParallelGroups();return links;function addLinksBetweenPhases(){for(var i=0;i<release.phases.length-1;i++){addLink(release.phases[i].id,release.phases[i+1].id,true);}}
function addLinksBetweenTasks(){_.each(release.phases,function(phase) {for(var i=0;i<phase.tasks.length-1;i++){addLink(phase.tasks[i].id,phase.tasks[i+1].id,true);}});}
function addLinksWithinParallelGroups(){_.each(release.phases,function(phase) {_.each(phase.tasks,addLinkWithinParallelGroup);});}
function addLinkWithinParallelGroup(task){_.each(task.links,function(link){var readonly=task.hasBeenStarted?true:false;addLink(link.sourceId,link.targetId,readonly,link.id);});_.each(task.tasks,addLinkWithinParallelGroup);}
function addLink(sourceId,targetId,readOnly,linkId){links.push({id:makeLinkId(sourceId,targetId),source:sourceId,target:targetId,type:FROM_END_TO_START,readOnly:readOnly,linkId:linkId});}},makeLinkId:makeLinkId,setRelease:function(newRelease){release=newRelease;}}}]);angular.module('xlrelease').factory('PlanningDataEditor',['TasksService',function(TasksService){function isContainer(item){return!TasksService.isTask(item)||TasksService.isParallelGroup(item);}
function hasValue(duration){return duration!==null&&duration!==undefined;}
function hasPlannedDuration(planItem){return hasValue(planItem.plannedDuration);}
function positiveOrNull(plannedDuration){return plannedDuration>=0?plannedDuration:null;}
return{dragLeft:function(element,date){if(hasPlannedDuration(element.planItem)){if(element.planItem.dueDate){element.planItem.plannedDuration=moment(element.planItem.dueDate).diff(date,'milliseconds');}else if(element.displayStartDate){element.planItem.plannedDuration+=moment(element.displayStartDate).diff(date,'milliseconds');}}else{if(!element.planItem.dueDate){element.planItem.plannedDuration=moment(element.displayEndDate).diff(date,'milliseconds');}}
element.planItem.scheduledStartDate=date;},dragRight:function(element,date){if(!isContainer(element.planItem)){var plannedDuration=moment(date).diff(element.displayStartDate,'milliseconds');if(element.planItem.dueDate){var previousDuration=moment(element.planItem.dueDate).diff(element.displayStartDate,'milliseconds');element.planItem.dueDate=moment(element.planItem.dueDate).subtract('milliseconds',previousDuration-plannedDuration).valueOf()}
element.planItem.plannedDuration=plannedDuration;}else{if(hasPlannedDuration(element.planItem)){if(element.displayStartDate){element.planItem.plannedDuration=moment(date).diff(element.displayStartDate,'milliseconds');}else if(element.planItem.dueDate){element.planItem.plannedDuration+=moment(date).diff(element.planItem.dueDate,'milliseconds');}}
element.planItem.dueDate=date;}},move:function(element,startDate,endDate){element.planItem.scheduledStartDate=startDate;if(element.planItem.dueDate){element.planItem.dueDate=endDate;}},setStartDate:function(element,date){if(date&&element.planItem.dueDate&&hasPlannedDuration(element.planItem)){var plannedDuration=moment(element.planItem.dueDate).diff(date,'milliseconds');element.planItem.plannedDuration=positiveOrNull(plannedDuration);}
element.planItem.scheduledStartDate=date;},setEndDate:function(element,date){var itemStartDate=element.planItem.startDate||element.planItem.scheduledStartDate;if(date&&itemStartDate&&hasPlannedDuration(element.planItem)){var plannedDuration=moment(date).diff(itemStartDate,'milliseconds');element.planItem.plannedDuration=positiveOrNull(plannedDuration);}
element.planItem.dueDate=date;},setDuration:function(element,duration){if(hasValue(duration)&&element.planItem.dueDate){var previousDuration=moment(element.planItem.dueDate).diff(element.displayStartDate,'milliseconds');element.planItem.dueDate=moment(element.planItem.dueDate).subtract('milliseconds',previousDuration-duration).valueOf()}
element.planItem.plannedDuration=duration;}}}]);angular.module('xlrelease').factory('PlanningDataEditorMixin',['PlanningDataEditor','Planner',function(PlanningDataEditor,Planner){return{withSaveCallback:function(saveCallback){return new function(){var planning={};this.planning=planning;planning.initPlanningData=function(item,release){Planner.setRelease(release);planning.planElement=_.find(Planner.makePlan().elements,{id:item.id});};planning.updateDuration=function(item){PlanningDataEditor.setDuration(planning.planElement,item.plannedDuration);planning.savePlanningData(item);};planning.updateDueDate=function(item){PlanningDataEditor.setEndDate(planning.planElement,item.dueDate);planning.savePlanningData(item);};planning.updateScheduledStartDate=function(item){PlanningDataEditor.setStartDate(planning.planElement,item.scheduledStartDate);planning.savePlanningData(item);};planning.savePlanningData=function(item){item.plannedDuration=planning.planElement.planItem.plannedDuration;item.scheduledStartDate=planning.planElement.planItem.scheduledStartDate;item.dueDate=planning.planElement.planItem.dueDate;planning.planElement=_.find(Planner.makePlan().elements,{id:item.id});saveCallback(item);};};}};}]);'use strict';angular.module('xlrelease').constant('ReleaseSubpages',{summary:{key:'SUMMARY',label:'Release Summary'},editor:{key:'EDITOR',label:'Release Flow'},gantt:{key:'PLANNER',label:'Planner'},properties:{key:'PROPERTIES',label:'Properties'},teams:{key:'TEAMS',label:'Teams'},permissions:{key:'PERMISSIONS',label:'Permissions'},logs:{key:'LOGS',label:'Activity Logs'}});angular.module('xlrelease').controller('releaseHeaderController',['$scope','$location','ReleaseSubpages',function($scope,$location,ReleaseSubpages){var notDefaultPages=_.omit(ReleaseSubpages,'editor');$scope.page=_.find(notDefaultPages,function(aPage){var regexp=new RegExp(aPage.key+'$','i');return $location.path().match(regexp);});$scope.page=$scope.page||ReleaseSubpages.editor;$scope.isEditorPage=function(){return isPage(ReleaseSubpages.editor);};$scope.isGanttPage=function(){return isPage(ReleaseSubpages.gantt);};$scope.isSummaryPage=function(){return isPage(ReleaseSubpages.summary);};$scope.isPropertiesPage=function(){return isPage(ReleaseSubpages.properties);};$scope.isTeamsPage=function(){return isPage(ReleaseSubpages.teams);};$scope.isPermissionsPage=function(){return isPage(ReleaseSubpages.permissions);};$scope.isLogsPage=function(){return isPage(ReleaseSubpages.logs);};function isPage(page){return $scope.page===page;}}]);angular.module('xlrelease').directive('releaseVariablesEditor',function(){return{templateUrl:'partials/releases/release-variables-editor.html',restrict:'A',scope:{form:'=',variables:'=',readonly:'=',deployitEnvironments:'=',deployitPackages:'='}}});'use strict';angular.module('xlrelease').controller('phaseDetailsController',['$scope','Backend','PhasesService','PhaseDetailsUpdates','PlanningDataEditorMixin',function($scope,Backend,PhasesService,PhaseDetailsUpdates,PlanningDataEditorMixin){$scope.$watch('phase.scheduledStartDate + phase.dueDate',validatePhaseDates);angular.extend($scope,PlanningDataEditorMixin.withSaveCallback(function(phase){$scope.updatePhase(phase);PhaseDetailsUpdates.planningDataChanged=true;}));$scope.planning.initPlanningData($scope.phase,$scope.release);function validatePhaseDates(){if(!$scope.phase)return;$scope.warning={displayScheduledStartDateBefore:$scope.phase.scheduledStartDate!==null&&$scope.release.scheduledStartDate!==null&&moment($scope.phase.scheduledStartDate).isBefore(moment($scope.release.scheduledStartDate),'minutes'),displayScheduledStartDateAfter:$scope.phase.scheduledStartDate!==null&&$scope.release.dueDate!==null&&moment($scope.phase.scheduledStartDate).isAfter(moment($scope.release.dueDate),'minutes'),displayDueDateBefore:$scope.phase.dueDate!==null&&$scope.release.scheduledStartDate!==null&&moment($scope.phase.dueDate).isBefore(moment($scope.release.scheduledStartDate),'minutes'),displayDueDateAfter:$scope.phase.dueDate!==null&&$scope.release.dueDate!==null&&moment($scope.phase.dueDate).isAfter(moment($scope.release.dueDate),'minutes')};}
$scope.isEditable=function(){return!$scope.isPhaseReadOnly($scope.phase)&&$scope.security.hasEditPermission($scope.release);};$scope.updatePhaseColor=function(phase,color){phase.color=color;$scope.updatePhase(phase);};$scope.updatePhase=function(phase){var phaseForm={title:phase.title,description:phase.description,scheduledStartDate:phase.scheduledStartDate,dueDate:phase.dueDate,color:phase.color,plannedDuration:phase.plannedDuration};Backend.put('phases/'+phase.id,phaseForm);};$scope.isPhaseInProgress=PhasesService.isPhaseInProgress;$scope.isPhaseReadOnly=PhasesService.isPhaseReadOnly;$scope.isPhasePlanned=PhasesService.isPhasePlanned;}]);angular.module('xlrelease').factory('PhaseDetailsUpdates',[function(){return{planningDataChanged:false,reset:function(){this.planningDataChanged=false;}}}]);'use strict';angular.module('xlrelease').factory('ReleasesTabsService',['TabsService',function(TabsService){return TabsService.withConfig({tabs:[],maxDisplayedTabs:6,defaultPage:"releases"});}]);angular.module('xlrelease').directive('releaseHeader',function(){return{templateUrl:'partials/releases/release-header.html',replace:true,transclude:true}});'use strict';angular.module('xlrelease').controller('templatesController',['$scope','Backend','$location','filters',function($scope,Backend,$location,filters){$scope.filters=filters;$scope.loadTemplates=function(){Backend.get('releases/templates',{params:$scope.filters}).success(function(templates){$scope.templates=templates;});};$scope.loadTemplates();$scope.deleteTemplate=function(template){Backend.del('releases/templates/'+template.id).success(function(){$scope.templates=_.without($scope.templates,template);});};$scope.copyTemplate=function(){Backend.post('releases/templates',$scope.templateForm).success(function(releaseView){$scope.templateForm={};$location.url('/templates/'+releaseView.id);});};$scope.displayTemplateEditor=function(template){$location.url('/templates/'+template.id);};$scope.initTemplateForm=function(template){$scope.templateForm={templateId:template.id,title:template.title,description:template.description,scheduledStartDate:template.scheduledStartDate};};}]);'use strict';angular.module('xlrelease').controller('templatePropertiesController',['$scope','Backend','$location','$routeParams','$window','Authenticator','ReleasesTabsService','Page','DateService','PlanningDataEditorMixin',function($scope,Backend,$location,$routeParams,$window,Authenticator,ReleasesTabsService,Page,DateService,PlanningDataEditorMixin){var DEFAULT_START_HOUR=9;angular.extend($scope,PlanningDataEditorMixin.withSaveCallback(_.noop));$scope.initTemplateForm=function(){delete $scope.templateUpdatedAt;Backend.get('releases/'+$routeParams.releaseId).success(function(template){ReleasesTabsService.open(template,'/properties');$scope.release=template;Page.addToTitle($scope.release.title);$scope.templateForm={id:template.id,attachments:template.attachments,templateId:template.id,title:template.title,scheduledStartDate:template.scheduledStartDate,dueDate:template.dueDate,plannedDuration:template.plannedDuration,description:template.description,tags:template.tags,security:template.security,hasValidDates:true};$scope.planning.initPlanningData($scope.templateForm,template);setupDatesWatch();});};$scope.initNewTemplateForm=function(){$scope.templateForm={title:'',newTemplate:true,tags:[],scheduledStartDate:DateService.getToday().hours(DEFAULT_START_HOUR).toDate(),dueDate:null,plannedDuration:null,type:"xlrelease.Release",hasValidDates:true};$scope.planning.initPlanningData($scope.templateForm,$scope.templateForm);setupDatesWatch();};function setupDatesWatch(){$scope.$watch('templateForm.dueDate + templateForm.scheduledStartDate',DateService.checkDatesValidator($scope.templateForm));}
if($location.path().match('create$')){$scope.initNewTemplateForm();}else{$scope.initTemplateForm();}
$scope.canEditTemplate=function(){if($scope.templateForm&&$scope.templateForm.newTemplate){return Authenticator.hasPermission('template#create');}
if($scope.templateForm&&$scope.templateForm.security){return Authenticator.hasPermission('template#edit',$scope.templateForm);}
return false;};$scope.deleteAttachment=function(attachment){Backend.del('releases/'+$scope.templateForm.templateId+'/attachments/'+attachment.id).success(function(){_.remove($scope.templateForm.attachments,function(candidate){return candidate.id===attachment.id});});};$scope.templatePropertiesUpdated=function(){var template={title:$scope.templateForm.title,description:$scope.templateForm.description,tags:$scope.templateForm.tags,scheduledStartDate:$scope.templateForm.scheduledStartDate,dueDate:$scope.templateForm.dueDate,plannedDuration:$scope.templateForm.plannedDuration};if($scope.templateForm.newTemplate){Backend.post('releases/templates',template).success(function(releaseView){$scope.templateForm={};$location.url('/templates/'+releaseView.id);});}else{Backend.put('releases/templates/'+$scope.templateForm.templateId,template).success(function(){$scope.release.title=$scope.templateForm.title;$scope.templateUpdatedAt=moment().toDate();Page.addToTitle($scope.release.title);});}};$scope.back=function(){$window.history.back();};}]);angular.module('xlrelease').controller('uploadController',['$scope','UploadService',function($scope,UploadService){UploadService.reset();$scope.UploadService=UploadService;}]);angular.module('xlrelease').factory('UploadService',['Backend',function(Backend){var data={};return{data:data,uploadProgressed:function(){data.loading=true;},uploadFailed:function(){data.loading=false;data.error=true;},uploadSuccess:function(result){data.loading=false;data.result=result;data.error=false;},reset:function(){delete data.loading;delete data.result;delete data.error;}}}]);angular.module('xlrelease').directive('upload',['Backend','UploadService','$parse',function(Backend,UploadService,$parse){return{link:function(scope,element,attrs){var dataSubmitter=null;var getTokenUrl,uploadUrl;scope.$watch(attrs.uploadUrl,function(newValue){uploadUrl=newValue;});scope.$watch(attrs.getTokenUrl,function(newValue){getTokenUrl=newValue;});var clientCallback=attrs.onSuccess;var auto='auto'in attrs;$(element).fileupload({replaceFileInput:auto,add:function(e,data){dataSubmitter=data;if(auto){upload();}},progressall:function(){scope.$apply(UploadService.uploadProgressed);},fail:onFailure,done:onSuccess});var upload=function(){Backend.get(getTokenUrl).success(function(token){$(element).fileupload('option','url',uploadUrl+'/'+token);dataSubmitter.submit();});};if(!auto){scope.upload=upload;}
function onFailure(){scope.$apply(UploadService.uploadFailed);}
function onSuccess(e,data){if(_.isUndefined(data.result)){onFailure();return;}
try{var resultText;if(_.contains(data.dataType,'iframe')){resultText=$(data.result).text();}else{resultText=data.result;}
var result=JSON.parse(resultText);}catch(parseError){onFailure();return;}
scope.$apply(function(){UploadService.uploadSuccess(result);$parse(clientCallback)(scope,{uploadResult:result});});}}}}]);angular.module('xlrelease').directive('fileInput',[function(){return{require:'ngModel',link:function(scope,element,attr,ngModel){element.bind('change',function(){scope.$apply(function(){var file=element.val();ngModel.$setValidity(attr['ngModel'],true);ngModel.$setViewValue(file);});});}}}]);angular.module('xlrelease').directive('displayVariables',['newlinesFilter','markdownFilter','VariablesInterpolator',function(newlinesFilter,markdownFilter,VariablesInterpolator){function notNull(value,defaultValue){return value?value:defaultValue;}
return function(scope,element,attrs){scope.$watch('['+attrs.displayVariables+', '+attrs.variables+']',function(watchedValues){var contentIsMarkdown=(attrs.markdown!==undefined);var keepNewLines=(attrs.keepNewLines!==undefined);var content=watchedValues[0];var variables=watchedValues[1];var text=notNull(content,'');if(contentIsMarkdown){text=markdownFilter(text);}else{text=_.escape(text);}
if(keepNewLines){text=newlinesFilter(text);}
var html=VariablesInterpolator.interpolateInHtml(variables,text);element.html(html);},true);};}]);angular.module('xlrelease').factory('VariablesInterpolator',[function(){var VARIABLE_MATCHER=/(\$\{[^}]+\})/g;var ESCAPE_REGEXP_MATCHER=/([.*+?^=!:${}()|\[\]\/\\])/g;function toObject(variableViews){var variables={};_.each(variableViews,function(variableView){variables[variableView.key]=variableView.value;});return variables}
function escapeValues(variablesToEscape){var variables={};_.each(_.keys(variablesToEscape),function(variable){variables[variable]=_.escape(variablesToEscape[variable]);});return variables;}
function escapeRegExp(variableName){return variableName.replace(ESCAPE_REGEXP_MATCHER,'\\$1');}
function interpolate(text,variableValues,quoteReplacement){var variables=_.uniq(text.match(VARIABLE_MATCHER));_.each(variables,function(variable){var replacement=variableValues[variable]?variableValues[variable]:variable;var regExp=new RegExp(escapeRegExp(variable),'g');text=text.replace(regExp,quoteReplacement(replacement));});return text;}
return{interpolateInText:function(variableViews,text){var variableValues=toObject(variableViews);return interpolate(text,variableValues,_.identity);},interpolateInHtml:function(variableViews,text){var variableValues=escapeValues(toObject(variableViews));function quoteHtmlReplacement(replacement){return'<span class="variable">'+replacement+'</span>';}
return interpolate(text,variableValues,quoteHtmlReplacement);}}}]);angular.module('xlrelease').factory('VariablesService',[function(){function hasPackages(variables){return _.any(variables,function(variable){return variable.type==='DEPLOYIT_PACKAGE';});}
function hasEnvironments(variables){return _.any(variables,function(variable){return variable.type==='DEPLOYIT_ENVIRONMENT';});}
function collectUsedVariables(variables){return _.filter(variables,function(variable){return variable.used===true;});}
return{collectUsedVariables:collectUsedVariables,hasPackages:hasPackages,hasEnvironments:hasEnvironments}}]);'use strict';angular.module('xlrelease').factory('FlagService',[function(){var NOT_FLAGGED_STATUS='OK';var ATTENTION_NEEDED_STATUS='ATTENTION_NEEDED';var AT_RISK_STATUS='AT_RISK';function isItemFlagged(item){return item&&item.flag&&item.flag.status!==NOT_FLAGGED_STATUS;}
function isFlaggedAttentionNeeded(item){return isItemFlagged(item)&&item.flag.status===ATTENTION_NEEDED_STATUS;}
function isFlaggedAtRisk(item){return isItemFlagged(item)&&item.flag.status===AT_RISK_STATUS;}
function isReleaseFlagged(release){return release&&release.releaseFlag&&release.releaseFlag.status!==NOT_FLAGGED_STATUS;}
return{NOT_FLAGGED_STATUS:NOT_FLAGGED_STATUS,isReleaseOrSubtaskFlagged:isItemFlagged,isReleaseFlagged:isReleaseFlagged,isTaskFlagged:isItemFlagged,isItemFlagged:isItemFlagged,isFlaggedAttentionNeeded:isFlaggedAttentionNeeded,isFlaggedAtRisk:isFlaggedAtRisk};}]);angular.module('xlrelease').directive('flagLine',['FlagService',function(FlagService){return{templateUrl:'partials/flags/flag-line-directive.html',restrict:'A',scope:{item:'='},transclude:true,link:function(scope){scope.isItemFlagged=FlagService.isItemFlagged;scope.isFlaggedAttentionNeeded=FlagService.isFlaggedAttentionNeeded;scope.isFlaggedAtRisk=FlagService.isFlaggedAtRisk;}}}]);angular.module('xlrelease').directive('conflictLine',[function(){return{templateUrl:'partials/flags/conflict-line-directive.html',restrict:'A',transclude:true,scope:{conflict:'='}}}]);angular.module('xlrelease').directive('delayedLine',[function(){return{templateUrl:'partials/flags/delayed-line-directive.html',restrict:'A',transclude:true,scope:{task:'='}}}]);'use strict';angular.module('xlrelease').factory('ReleaseAlerts',['FlagService','ReleasesService','TasksService','Backend',function(FlagService,ReleasesService,TasksService,Backend){function computeFlaggedItems(release,flattenedTasks){var flaggedItems=[];if(FlagService.isReleaseFlagged(release)){flaggedItems.push({flag:{status:release.releaseFlag.status,comment:release.releaseFlag.comment}});}
_.each(flattenedTasks,function(task){if(FlagService.isTaskFlagged(task)){flaggedItems.push(task);}});return flaggedItems;}
function computeConflicts(outgoingDependencies){var conflicts=[];_.each(outgoingDependencies,function(dependency){if(dependency.inConflict){conflicts.push(dependency);}});return conflicts;}
function computeDelayedTasks(flattenedTasks){var delayedTasks=[];_.each(flattenedTasks,function(task){if(TasksService.isTaskDelayed(task)){delayedTasks.push(task);}});return delayedTasks;}
function computeAlertsByRelease(releases,releasesDependencies){var alertsByRelease={};_.map(releases,function(release){var flattenedTasks=ReleasesService.getLeafTasks(release);var releaseDependencies=releasesDependencies[release.id];var outgoingDependencies=(releaseDependencies)?releaseDependencies['outgoingDependencies']:[];alertsByRelease[release.id]={flaggedItems:computeFlaggedItems(release,flattenedTasks),conflicts:computeConflicts(outgoingDependencies),delayedTasks:computeDelayedTasks(flattenedTasks)}});return alertsByRelease;}
return{computeFlaggedItems:computeFlaggedItems,computeConflicts:computeConflicts,computeDelayedTasks:computeDelayedTasks,computeAlertsByRelease:computeAlertsByRelease,getReleasesAndAlerts:function(filters){return ReleasesService.getReleases(filters).then(function(searchResults){return _.map(searchResults.data,ReleasesService.extendWithProgression);}).then(function(releases){return ReleasesService.getReleasesDependenciesByReleaseId(releases).then(function(releasesDependencies){return{releases:releases,releasesAlerts:computeAlertsByRelease(releases,releasesDependencies)};});});},countAlerts:function(releaseAlerts){return releaseAlerts.flaggedItems.length+releaseAlerts.conflicts.length+releaseAlerts.delayedTasks.length;}};}]);angular.module('xlrelease').factory('DeployitService',['Backend','VariablesService',function(Backend,VariablesService){function getAllPackages(){return Backend.get('deployit/packages');}
function getAllEnvironments(){return Backend.get('deployit/environments');}
function getAllEnvironmentsAndPackages(variables,setPackages,setEnvironments){if(VariablesService.hasPackages(variables)){getAllPackages().success(setPackages);}
if(VariablesService.hasEnvironments(variables)){getAllEnvironments().success(setEnvironments);}}
return{getAllEnvironmentsAndPackages:getAllEnvironmentsAndPackages}}]);'use strict';angular.module('xlrelease').controller('tasksController',['$scope','Backend','Authenticator','TaskPolling','TasksService','ReleasesService','Modal','FlagService','DateService','Events','$location','filterSettings','TaskDetailsUpdates',function($scope,Backend,Authenticator,TaskPolling,TasksService,ReleasesService,Modal,FlagService,DateService,Events,$location,filterSettings,TaskDetailsUpdates){$scope.filters=filterSettings;function loadTasks(){$scope.$emit(Events.permission.refresh);Backend.post('tasks/search',$scope.filters).success(function(releases){$scope.releases=releases;startPolling();});}
loadTasks();function startPolling(){var tasks=_.flatten(_.pluck($scope.releases,'tasks'));TaskPolling.startTaskPolling(tasks,$scope).onTaskUpdate(loadTasks);Modal.withScope($scope).onNextOpen(stopPolling).onNextClose(startPolling);}
function stopPolling(){$scope.$broadcast(Events.polling.stop);}
$scope.isTaskPending=TasksService.isTaskPending;$scope.isTaskInProgress=TasksService.isTaskInProgress;$scope.isTaskPlanned=TasksService.isTaskPlanned;$scope.isTaskSkipped=TasksService.isTaskSkipped;$scope.isTaskFailed=TasksService.isTaskFailed;$scope.isTaskCompleted=TasksService.isTaskCompleted;$scope.isTaskCompletedInAdvance=TasksService.isTaskCompletedInAdvance;$scope.isTaskSkippedInAdvance=TasksService.isTaskSkippedInAdvance;$scope.isDeployitTask=TasksService.isDeployitTask;$scope.isGateTask=TasksService.isGateTask;$scope.isNotificationTask=TasksService.isNotificationTask;$scope.isManualTask=TasksService.isManualTask;$scope.isScriptTask=TasksService.isScriptTask;$scope.isCustomScriptTask=TasksService.isCustomScriptTask;$scope.isStatusUpdatable=TasksService.isStatusUpdatable;$scope.hasOwner=TasksService.hasOwner;$scope.isTaskFlagged=FlagService.isTaskFlagged;$scope.isOverdue=DateService.isOverdue;$scope.completeTask=function(task,commentText){TasksService.completeTask(task.id,commentText).success(loadTasks);};$scope.skipTask=function(task,commentText){TasksService.skipTask(task.id,commentText).success(loadTasks);};$scope.failTask=function(task,commentText){TasksService.failTask(task.id,commentText).success(loadTasks);};$scope.abortTask=function(task,commentText){TasksService.abortTask(task.id,commentText).success(loadTasks);};$scope.cancelTask=function(task,commentText){TasksService.cancelTask(task.id,commentText).success(loadTasks);};$scope.retryTask=function(task,commentText){TasksService.retryTask(task.id,commentText).success(loadTasks);};$scope.startNow=function(task,commentText){TasksService.startNow(task.id,commentText).success(loadTasks);};$scope.canCompleteTask=function(task,release){return(TasksService.canUpdateInProgressStatus(task)||(TasksService.canUpdatePlannedStatus(task)&&ReleasesService.isReleaseInProgress(release)))&&!TasksService.isGateClosed(task);};$scope.canSkipTask=function(task,release){return TasksService.canUpdateInProgressStatus(task)||TasksService.canUpdateFailedStatus(task)||(TasksService.canUpdatePlannedStatus(task)&&ReleasesService.isReleaseInProgress(release));};$scope.loadTasksAfterTaskUpdate=function(){if(TaskDetailsUpdates.assigneeChanged){loadTasks();TaskDetailsUpdates.reset();}};}]);'use strict';angular.module('xlrelease').controller('taskDetailsController',['$scope','Backend','serverTitleFilter','TasksService','ReleasesService','$location','Authenticator','FlagService','TaskDetailsUpdates','UsersService','UserProfile','PlanningDataEditorMixin',function($scope,Backend,serverTitleFilter,TasksService,ReleasesService,$location,Authenticator,FlagService,TaskDetailsUpdates,UsersService,UserProfile,PlanningDataEditorMixin){$scope.data={newComment:'',showCommentForm:false};$scope.saveTask=function(task){var updatedTask=getUpdatedTask(task);Backend.put('tasks/'+updatedTask.id,updatedTask).success(function(savedTask){task.password=savedTask.password;task.outputProperties=savedTask.outputProperties;});};angular.extend($scope,PlanningDataEditorMixin.withSaveCallback(function(task){resetWaitForScheduledStartDate(task);$scope.saveTask(task);TaskDetailsUpdates.planningDataChanged=true;}));function resetWaitForScheduledStartDate(task){if(!task.scheduledStartDate){task.waitForScheduledStartDate=true;}}
$scope.loadReleaseForEditTask=function(task,release){ReleasesService.getRelease(release.id).success(function(fullRelease){$scope.editTask(task,fullRelease);});};$scope.editTask=function(task,release){$scope.planning.initPlanningData(task,release);loadUsernames(release);loadTeams(task.id,release);loadComments(task.id);if(TasksService.isDeployitTask(task)&&!TasksService.isTaskInProgress(task)&&!TasksService.isTaskReadOnly(task)){loadDeployitData(task.server);}
loadCustomType(task);loadConfigurationInstances();};function loadConfigurationInstances(){Backend.get('configurations',{params:{anonymized:true}}).success(function(instances){$scope.configurationInstances=instances;$scope.instancesByType=_.groupBy(instances,'type');});}
$scope.getCITitle=function(ciID){var instance=_($scope.configurationInstances).find(function(item){return item.id===ciID;});if(instance){return instance.title;}};function loadUsernames(release){$scope.allUsers=[];if(Authenticator.hasEditTaskPermission(release)||Authenticator.hasReassignTaskPermission(release)){UsersService.getAllUsers().success(function(users){$scope.allUsers=users;});}}
function loadTeams(taskId,release){$scope.teams=[];if(Authenticator.hasEditTaskPermission(release)||Authenticator.hasReassignTaskPermission(release)){Backend.get('tasks/'+taskId+'/teams/assignable').success(function(teams){$scope.teams=_.map(teams,function(team){return{id:team.teamName,title:team.teamName};});});}}
function loadComments(taskId){$scope.comments=[];Backend.get('tasks/'+taskId+'/comments').success(function(comments){$scope.comments=comments;});}
function loadDeployitData(deployitServerId){loadDeployitServers();$scope.loadDeployitAutocompleteList(deployitServerId);}
$scope.loadDeployitAutocompleteList=function(deployitServerId){if(deployitServerId){Backend.get('deployit/servers/'+deployitServerId+'/packages').success(function(packages){$scope.deployitPackages=packages;});Backend.get('deployit/servers/'+deployitServerId+'/environments').success(function(environments){$scope.deployitEnvironments=environments;});}};function loadDeployitServers(){Backend.get('deployit/servers?anonymized=true').success(function(servers){$scope.deployitServers=_.map(servers,function(server){return{id:server.id,title:serverTitleFilter(server.id)};});});}
function loadCustomType(task){if(task.scriptDefinitionType){Backend.get('tasks/python-script-definitions/'+task.scriptDefinitionType).success(function(definition){$scope.scriptDefinition=definition;});}}
$scope.saveComment=function(comment){Backend.put('comments/'+comment.id,comment).success(function(updatedComment){comment.date=updatedComment.date});};$scope.addComment=function(task,commentText){var newComment={text:commentText};Backend.post('tasks/'+task.id+'/comments',newComment).success(function(comment){$scope.data.newComment='';$scope.comments.push(comment);task.numberOfComments++;$scope.data.showCommentForm=false;});};$scope.flag=function(flagStatus){$scope.task.flag.status=flagStatus;if(!FlagService.isTaskFlagged($scope.task)){$scope.task.flag.comment='';}
$scope.saveTask($scope.task);};$scope.removeOwner=function(){$scope.task.owner=null;Backend.del('tasks/'+$scope.task.id+'/owner');TaskDetailsUpdates.assigneeChanged=true;};$scope.updateOwner=function(task){if(task.owner){Backend.put('tasks/'+task.id+'/owner',getUpdatedTask(task));TaskDetailsUpdates.assigneeChanged=true;}else{$scope.removeOwner();}};$scope.removeTeam=function(){$scope.task.team=null;Backend.del('tasks/'+$scope.task.id+'/team');TaskDetailsUpdates.assigneeChanged=true;};$scope.updateTeam=function(task){Backend.put('tasks/'+task.id+'/team',getUpdatedTask(task));TaskDetailsUpdates.assigneeChanged=true;};$scope.viewTaskInRelease=function(releaseId){$location.url('releases/'+releaseId);};$scope.canWorkOnTask=function(release){if(TasksService.isTaskReadOnly($scope.task)){return false;}
return hasPermissionToWorkOnTask(release);};$scope.canWorkOnReadOnlyTask=function(release){return hasPermissionToWorkOnTask(release);};function hasPermissionToWorkOnTask(release){return Authenticator.hasEditTaskPermission(release)||Authenticator.isAdminOr($scope.task.owner)||Authenticator.isMemberOf(release,$scope.task.team);}
$scope.canEditTask=function(release){return Authenticator.hasEditTaskPermission(release)&&!TasksService.isTaskReadOnly($scope.task);};$scope.canClaimTask=function(task,release){return!$scope.belongsToMe(task)&&$scope.canEditTask(release)&&Authenticator.hasReassignTaskPermission(release);};$scope.switchStartTaskMode=function(){$scope.startTaskMode=!$scope.startTaskMode;};$scope.canTaskBeScheduled=function(task){return TasksService.isTaskPlanned(task)||TasksService.isTaskPending(task);};$scope.assignToMe=function(task){task.owner=UserProfile.getCurrentUser();$scope.updateOwner(task);};$scope.belongsToMe=function(task){return TasksService.isAssignedToUser(task,UserProfile.getCurrentUser());};$scope.deleteAttachment=function(release,task,attachment){Backend.del('releases/'+release.id+'/'+task.id+'/attachments/'+attachment.id).success(function(){_.remove(task.attachments,function(candidate){return candidate.id===attachment.id});});};$scope.isStatusUpdatable=TasksService.isStatusUpdatable;$scope.canUpdateInProgressStatus=TasksService.canUpdateInProgressStatus;$scope.canUpdatePlannedStatus=TasksService.canUpdatePlannedStatus;$scope.canUpdateFailedStatus=TasksService.canUpdateFailedStatus;$scope.isTaskDoneInAdvance=TasksService.isTaskDoneInAdvance;$scope.isStatusUpdatable=TasksService.isStatusUpdatable;$scope.isTaskInProgress=TasksService.isTaskInProgress;$scope.isGateTask=TasksService.isGateTask;$scope.isDeployitTask=TasksService.isDeployitTask;$scope.isNotificationTask=TasksService.isNotificationTask;$scope.isScriptTask=TasksService.isScriptTask;$scope.isParallelGroup=TasksService.isParallelGroup;$scope.isCustomScriptTask=TasksService.isCustomScriptTask;$scope.isInProgressScriptTask=TasksService.isInProgressScriptTask;$scope.isGateClosed=TasksService.isGateClosed;$scope.isTaskReadOnly=TasksService.isTaskReadOnly;$scope.isTaskFailed=TasksService.isTaskFailed;$scope.isTaskPending=TasksService.isTaskPending;$scope.isTaskAborted=TasksService.isTaskAborted;$scope.isTaskCompleted=TasksService.isTaskCompleted;$scope.isTaskCompletedInAdvance=TasksService.isTaskCompletedInAdvance;$scope.isTaskSkippedInAdvance=TasksService.isTaskSkippedInAdvance;$scope.isTaskSkipped=TasksService.isTaskSkipped;$scope.isAutomated=TasksService.isAutomated;$scope.hasOwner=TasksService.hasOwner;$scope.isReleaseInProgress=ReleasesService.isReleaseInProgress;function getUpdatedTask(task){return{id:task.id,title:task.title,description:task.description,dueDate:task.dueDate,scheduledStartDate:task.scheduledStartDate,plannedDuration:task.plannedDuration,team:task.team,owner:task.owner,deploymentPackage:task.deploymentPackage,environment:task.environment,server:task.server,username:task.username,password:task.password,type:task.type,addresses:task.addresses,subject:task.subject,body:task.body,script:task.script,flag:task.flag,scriptDefinitionType:task.scriptDefinitionType,inputProperties:task.inputProperties,outputProperties:task.outputProperties,waitForScheduledStartDate:task.waitForScheduledStartDate};}}]);angular.module('xlrelease').factory('TaskDetailsUpdates',[function(){return{assigneeChanged:false,planningDataChanged:false,reset:function(){this.assigneeChanged=false;this.planningDataChanged=false;}}}]);'use strict';angular.module('xlrelease').controller('gateDetailsController',['$scope','Backend','TasksService','Authenticator','VariablesInterpolator',function($scope,Backend,TasksService,Authenticator,VariablesInterpolator){var CONDITIONS_URL='gates/conditions/';Backend.get('gates/'+$scope.task.id+'/dependency-target-candidates').success(function(dependencyTargetCandidates){$scope.dependencyTargetCandidates=dependencyTargetCandidates;});$scope.addCondition=function(){Backend.post('gates/'+$scope.task.id+'/conditions').success(function(condition){$scope.task.conditions.push(condition);});};$scope.updateCondition=function(condition){Backend.put(CONDITIONS_URL+condition.id,condition).success(function(){if(!TasksService.isGateClosed($scope.task)){$scope.completeTaskMode=true;}})};$scope.removeCondition=function(removedCondition){Backend.del(CONDITIONS_URL+removedCondition.id).success(function(){$scope.task.conditions=_.reject($scope.task.conditions,function(condition){return removedCondition===condition;});})};$scope.addDependency=function(){var dependency={target:{releaseId:$scope.dependencyTargetCandidates[0].id}};$scope.task.dependencies.push(dependency);$scope.editDependency(dependency);};$scope.updateReleaseDropdown=function(dependency){delete dependency.target.phaseId;delete dependency.target.taskId;};$scope.updatePhaseDropdown=function(dependency){delete dependency.target.taskId;};$scope.saveDependency=function(){if(!$scope.editedDependency||!$scope.draftDependency.target){return;}
function updateDependencyInList(updatedDependency){var index=_.indexOf($scope.task.dependencies,$scope.editedDependency);if(index>=0){$scope.task.dependencies[index]=updatedDependency;}
delete $scope.editedDependency;delete $scope.draftDependency;}
if($scope.editedDependency.id){Backend.put('dependencies/'+$scope.editedDependency.id,$scope.draftDependency).success(updateDependencyInList);}else{Backend.post('gates/'+$scope.task.id+'/dependencies',$scope.draftDependency).success(updateDependencyInList);}};$scope.editDependency=function(dependency){$scope.editedDependency=dependency;$scope.draftDependency=_.clone(dependency);};$scope.isEditingDependency=function(dependency){return $scope.editedDependency===dependency;};$scope.cancelDependencyEditing=function(){if(!$scope.editedDependency.id){$scope.task.dependencies=_.without($scope.task.dependencies,$scope.editedDependency);}
delete $scope.editedDependency;delete $scope.draftDependency;};function findById(objects,id){return _.find(objects,function(object){return object.id===id;});}
function isAccessible(target){var release=findById($scope.dependencyTargetCandidates,target.releaseId);if(!release)return false;if(!target.phaseId)return true;var phase=findById(release.phases,target.phaseId);if(!phase)return false;if(!target.taskId)return true;return findById(phase.tasks,target.taskId);}
$scope.canEditDependency=function(dependency){return $scope.canEditTask($scope.release)&&$scope.dependencyTargetCandidates&&isAccessible(dependency.target);};$scope.removeDependency=function(removedDependency){Backend.del('dependencies/'+removedDependency.id).success(function(){$scope.task.dependencies=_.reject($scope.task.dependencies,function(dependency){return removedDependency===dependency;});});};function getRelease(releaseId){if(angular.isUndefined(releaseId)||releaseId===''){return null;}
return _.find($scope.dependencyTargetCandidates,function(candidate){return candidate.id===releaseId;});}
$scope.getPhases=function(releaseId){var release=getRelease(releaseId);return release?release.phases:[];};$scope.getTasks=function(releaseId,phaseId){var phases=$scope.getPhases(releaseId);if(angular.isUndefined(phaseId)||phaseId===''){return[];}
var phase=_.find(phases,function(phase){return phase.id===phaseId;});return phase?phase.tasks:[];};$scope.getVariables=function(releaseId){var release=getRelease(releaseId);return release?release.variables:[];};$scope.getTitle=function(id,objects,variables){if(!objects){return'';}
var object=_.find(objects,function(object){return object.id===id;});var title=object?object.title:'';return $scope.interpolate(title,variables);};$scope.interpolate=function(title,variables){return VariablesInterpolator.interpolateInText(variables,title);};$scope.showConditions=function(){return $scope.task.conditions.length>0;};$scope.showAddCondition=function(){return $scope.canEditTask($scope.release);};$scope.showDependencies=function(){return $scope.task.dependencies.length>0;};$scope.showAddDependency=function(){return!$scope.isTaskInProgress($scope.task)&&$scope.canEditTask($scope.release)&&$scope.dependencyTargetCandidates;};}]);angular.module('xlrelease').directive('quickTaskGenerator',['Browser',function(Browser){function enableForm(scope){scope.$apply(function(){scope.showForm=true;});}
function submitTask(scope){scope.$apply(function(){if(angular.isDefined(scope.title)&&scope.title!==null&&scope.title!==''){var taskForm={title:scope.title,taskType:scope.taskType};scope.addTask({'taskForm':taskForm});scope.title='';}});}
function disableForm(scope){scope.$apply(function(){scope.showForm=false;scope.title='';});}
return{templateUrl:"partials/tasks/quick-task-generator.html",scope:{'addTask':'&','pythonScriptDefinitions':'='},link:function(scope,element){scope.showForm=false;scope.title='';scope.taskType='xlrelease.Task';Browser.fixDropdownDimensions(element);var input=element.find("input");element.find(".add-task").bind('click',function(){enableForm(scope);input.focus()});element.find(".add").bind('click',function(){submitTask(scope);input.focus();});element.find(".cancel").bind('click',function(){disableForm(scope);});input.bind('keyup',function(e){if(e.which===27){disableForm(scope);}
if(e.which==13){submitTask(scope);input.focus();}});}}}]);angular.module('xlrelease').filter('serverTitle',function(){return function(text){if(_(text).isUndefined()||_(text).isNull()){return text;}
return text.replace(/^Configuration\/Deployit\//,'');}});angular.module('xlrelease').directive('assignee',['UserProfile',function(UserProfile){return{templateUrl:"partials/tasks/assignee.html",scope:{owner:'=',team:'=',variables:'='},link:function(scope){scope.loggedUser=UserProfile.getCurrentUser();}}}]);angular.module('xlrelease').factory('TaskPolling',['Timeout','$q','Backend','TasksService','Events',function(Timeout,$q,Backend,TasksService,Events){var POLLING_INTERVAL_IN_MS=1000;var currentRequest=null;return{startTaskPolling:startTaskPolling,waitForPollRequest:waitForPollRequest};function startTaskPolling(tasks,scope){scope.$broadcast(Events.polling.stop);var pollingContext={taskUpdateDeferred:$q.defer(),timeoutPromise:null,cancelled:false};var taskUpdatePromise=initPromise(pollingContext);var pollableTasks=getPollableTasks(tasks);if(pollableTasks.length!==0){registerTimeoutCancellation(scope,pollingContext);poll(pollableTasks,pollingContext);}
return taskUpdatePromise;}
function initPromise(pollingContext){var taskUpdatePromise=pollingContext.taskUpdateDeferred.promise;taskUpdatePromise.onTaskUpdate=function(callback){taskUpdatePromise.then(callback);};return taskUpdatePromise;}
function getPollableTasks(tasks){return _.filter(tasks,function(task){return TasksService.isTaskInProgress(task)||TasksService.isTaskFailed(task)||TasksService.isTaskPending(task);});}
function registerTimeoutCancellation(scope,pollingContext){scope.$on('$destroy',function(){cancel(pollingContext);});scope.$on(Events.polling.stop,function(){cancel(pollingContext);});}
function cancel(pollingContext){Timeout.cancel(pollingContext.timeoutPromise);pollingContext.cancelled=true;}
function poll(tasks,pollingContext){if(pollingContext.cancelled){return;}
pollingContext.timeoutPromise=Timeout(function pollTaskStatus(){currentRequest=Backend.post('tasks/poll?'+getRefreshParams(tasks));currentRequest.success(function(serverTasks){updateTaskInfosFromServer(tasks,serverTasks);if(isAnyServerTaskUpdated(tasks,serverTasks)){pollingContext.taskUpdateDeferred.resolve();}else{poll(tasks,pollingContext);}});registerFinally(currentRequest,function(){currentRequest=null;});},POLLING_INTERVAL_IN_MS);}
function getRefreshParams(tasks){return _.map(tasks,function(task){return'id='+task.id;}).join('&');}
function updateTaskInfosFromServer(tasks,serverTasks){_.map(tasks,function(task){if(TasksService.isDeployitTask(task)){var serverTask=getAssociatedTask(task,serverTasks);task.currentStep=serverTask.currentStep;task.totalStep=serverTask.totalStep;task.currentStepTitle=serverTask.currentStepTitle;task.deploymentStatus=serverTask.status;}})}
function getAssociatedTask(task,serverTasks){return _.find(serverTasks,function(candidate){return task.id===candidate.id;});}
function isAnyServerTaskUpdated(tasks,serverTasks){return _.any(tasks,function(task){var serverTask=getAssociatedTask(task,serverTasks);return task.status!==serverTask.status});}
function waitForPollRequest(){var deferred=$q.defer();if(currentRequest!==null){registerFinally(currentRequest,deferred.resolve);}else{deferred.resolve();}
return deferred.promise;}
function registerFinally(promise,onFinally){promise['finally'](onFinally);}}]);angular.module('xlrelease').factory('DeploymentProgressService',[function(){return{formatProgress:function(task,shortVersion){if(task!=null&&angular.isDefined(task.deploymentStatus)){if(task.deploymentStatus==='COMPLETED'){return'Executed';}
if(task.deploymentStatus==='IN_PROGRESS'&&task.totalStep===0){return(shortVersion)?'Waiting':'Waiting to deploy';}
var prefix=(task.deploymentStatus==='IN_PROGRESS')?'Executing':'Failed at';var title=shortVersion?'step':task.currentStepTitle;return prefix+' '+title+' '+task.currentStep+'/'+task.totalStep;}}}}]);angular.module('xlrelease').filter('deploymentProgress',['DeploymentProgressService',function(DeploymentProgressService){return function(task){return DeploymentProgressService.formatProgress(task,false);};}]);angular.module('xlrelease').filter('shortDeploymentProgress',['DeploymentProgressService',function(DeploymentProgressService){return function(task){return DeploymentProgressService.formatProgress(task,true);};}]);'use strict';angular.module('xlrelease').factory('TasksService',['Backend','DateService',function(Backend,DateService){function isTaskPlanned(task){return'PLANNED'===task.status;}
function isTaskPending(task){return'PENDING'===task.status;}
function isTaskInProgress(task){return'IN_PROGRESS'===task.status;}
function isTaskCompleted(task){return'COMPLETED'===task.status||'ABORTED'===task.status;}
function isTaskCompletedInAdvance(task){return'COMPLETED_IN_ADVANCE'===task.status;}
function isTaskSkippedInAdvance(task){return'SKIPPED_IN_ADVANCE'===task.status;}
function isTaskSortable(task){return isTaskPlanned(task)||isTaskCompletedInAdvance(task)||isTaskSkippedInAdvance(task);}
function isTaskSkipped(task){return'SKIPPED'===task.status;}
function isTaskFailed(task){return'FAILED'===task.status;}
function isTaskDoneInAdvance(task){return isTaskCompletedInAdvance(task)||isTaskSkippedInAdvance(task);}
function isDeployitTask(task){return'xlrelease.DeployitTask'===task.type;}
function isGateTask(task){return'xlrelease.GateTask'===task.type;}
function isNotificationTask(task){return'xlrelease.NotificationTask'===task.type;}
function isScriptTask(task){return'xlrelease.ScriptTask'===task.type;}
function isParallelGroup(task){return'xlrelease.ParallelGroup'===task.type;}
function isManualTask(task){return'xlrelease.Task'===task.type;}
function isCustomScriptTask(task){return'xlrelease.CustomScriptTask'===task.type;}
function isParallelGroupInProgress(task){return isParallelGroup(task)&&isTaskInProgress(task);}
function someGateConditionUnchecked(task){return _.some(task.conditions,function(condition){return condition.checked===false});}
function someGateDependencyUnresolved(task){return _.some(task.dependencies,function(dependency){return dependency.resolved===false});}
function isGateClosed(task){return isGateTask(task)&&(someGateConditionUnchecked(task)||someGateDependencyUnresolved(task));}
function hasOwner(task){return angular.isDefined(task.owner)&&task.owner!==null;}
function hasTeam(task){return angular.isDefined(task.team)&&task.team!==null;}
function updateTaskStatusTo(status,id,commentText){var comment={text:commentText};return Backend.post('tasks/'+id+'/'+status,comment);}
function isAutomated(task){return task.automated;}
function getSubTasks(task){if(isParallelGroup(task)){return _.map(task.tasks,getSubTasks);}else{return[task];}}
function getAllSubTasks(task){var subTasks=[];if(isParallelGroup(task)){subTasks=_.map(task.tasks,getAllSubTasks);}
return[subTasks,task];}
return{hasOwner:hasOwner,hasTeam:hasTeam,isTaskPlanned:isTaskPlanned,isTaskPending:isTaskPending,isTaskInProgress:isTaskInProgress,isTaskCompleted:isTaskCompleted,isTaskCompletedInAdvance:isTaskCompletedInAdvance,isTaskSkippedInAdvance:isTaskSkippedInAdvance,isTaskSortable:isTaskSortable,isTaskSkipped:isTaskSkipped,isTaskFailed:isTaskFailed,isTaskDoneInAdvance:isTaskDoneInAdvance,isDeployitTask:isDeployitTask,isAutomated:isAutomated,isGateTask:isGateTask,isNotificationTask:isNotificationTask,isScriptTask:isScriptTask,isCustomScriptTask:isCustomScriptTask,isManualTask:isManualTask,isParallelGroup:isParallelGroup,isParallelGroupInProgress:isParallelGroupInProgress,isGateClosed:isGateClosed,getSubTasks:getSubTasks,getAllSubTasks:getAllSubTasks,isTaskReadOnly:function(task){return isTaskCompleted(task)||isTaskSkipped(task)||isTaskDoneInAdvance(task);},isTaskAborted:function(task){return'ABORTED'===task.status;},canUpdateInProgressStatus:function(task){return isTaskInProgress(task)&&!isAutomated(task)&&(hasOwner(task)||hasTeam(task))},canUpdatePlannedStatus:function(task){return isTaskPlanned(task)&&(hasOwner(task)||hasTeam(task));},canUpdateFailedStatus:function(task){return isTaskFailed(task)&&(isAutomated(task)||hasOwner(task)||hasTeam(task));},isInProgressScriptTask:function(task){return(isScriptTask(task)||isCustomScriptTask(task))&&isTaskInProgress(task);},isStatusUpdatable:function(task){return isTaskInProgress(task)&&!isAutomated(task)&&(hasOwner(task)||hasTeam(task));},completeTask:function(taskId,commentText){return updateTaskStatusTo('complete',taskId,commentText);},failTask:function(taskId,commentText){return updateTaskStatusTo('fail',taskId,commentText);},abortTask:function(taskId,commentText){return updateTaskStatusTo('abort',taskId,commentText);},skipTask:function(taskId,commentText){return updateTaskStatusTo('skip',taskId,commentText);},retryTask:function(taskId,commentText){return updateTaskStatusTo('retry',taskId,commentText);},cancelTask:function(taskId,commentText){return updateTaskStatusTo('cancel',taskId,commentText);},startNow:function(taskId,commentText){return updateTaskStatusTo('startNow',taskId,commentText);},reopenTask:function(taskId,commentText){return updateTaskStatusTo('reopen',taskId,commentText);},isTaskDelayed:function(task){if(!isTaskPlanned(task))return false;return DateService.isOverdue(task.scheduledStartDate)||DateService.isOverdue(task.dueDate);},isAssignedToUser:function(task,user){return hasOwner(task)&&user&&task.owner.username===user.username;},isAssignedToTeam:function(task,team){return hasTeam(task)&&task.team===team;},isTask:function(item){return item.automated!==undefined;}};}]);angular.module('xlrelease').directive('displayWithSeparators',function(){var DEFAULT_SEPARATOR=' | ';var SEPARATOR_CLASS='separator';var separatorElement;function removeSeparators(element){element.find('.'+SEPARATOR_CLASS).each(function(index,element){angular.element(element).remove();})}
function addSeparatorToVisibles(displayables){var visibles=getVisibles(displayables);for(var i=0;i<visibles.length-1;i++){addSeparator(angular.element(visibles[i].element));}}
function getVisibles(displayables){return _.filter(displayables,function(displayable){return displayable.visible;});}
function addSeparator(element){element.after(separatorElement);}
return{link:function(scope,element,attrs){separatorElement='<span class="'+SEPARATOR_CLASS+'">'+(attrs.displayWithSeparators||DEFAULT_SEPARATOR)+'</span>';},controller:['$scope','$element',function(scope,element){var displayables=[];this.register=function(displayable){displayables.push(displayable);};this.refresh=function(){removeSeparators(element);addSeparatorToVisibles(displayables);}}]}});angular.module('xlrelease').directive('displayWhen',function(){return{require:'^displayWithSeparators',link:function(scope,element,attrs,displayWithSeparator){var displayable={element:element,visible:true};displayWithSeparator.register(displayable);scope.$watch(attrs.displayWhen,function(isVisible){(isVisible)?element.show():element.hide();displayable.visible=isVisible;displayWithSeparator.refresh();})}}});angular.module('xlrelease').directive('scheduledStartDateTooltip',['tooltipService','dateFilter',function(tooltipService,dateFilter){return{restrict:'A',link:function(scope,element,attrs){scope.$watch(attrs['scheduledStartDateTooltip'],function(date){var text='Task will start on '+dateFilter(date,'mediumDate')+' '+dateFilter(date,'shortTime');tooltipService.setup(element,text,'top');},true);}}}]);angular.module('xlrelease').filter('taskTypeCssClass',['lowercaseFilter',function(lowercaseFilter){return function(taskType){taskType=taskType.replace(/^xlrelease\./,'');taskType=taskType.replace(/\./g,'-');taskType=lowercaseFilter(taskType);return'task-type-'+taskType;}}]);'use strict';angular.module('xlrelease').controller('pipelineController',['$scope','$location','Backend','ReleasesService','PhasesService','TasksService','ReleaseAlerts','PipelineCollapsePhases','filterSettings',function($scope,$location,Backend,ReleasesService,PhasesService,TasksService,ReleaseAlerts,PipelineCollapsePhases,filterSettings){$scope.filters=filterSettings;$scope.filters.active=true;ReleaseAlerts.getReleasesAndAlerts($scope.filters).then(function(releasesAndAlerts){$scope.releases=releasesAndAlerts.releases;$scope.releasesAlerts=releasesAndAlerts.releasesAlerts;});$scope.getColor=function(phase){return PhasesService.isPhaseReadOnly(phase)?undefined:phase.color;};$scope.countTasksDone=function(phase){return _.filter($scope.getLeafTasks(phase),TasksService.isTaskReadOnly).length;};$scope.countTaskPlanned=function(phase){return _.filter($scope.getLeafTasks(phase),TasksService.isTaskPlanned).length;};$scope.showFlag=function(releaseAlerts){return releaseAlerts.flaggedItems.length!=0;};$scope.showConflict=function(releaseAlerts){return!$scope.showFlag(releaseAlerts)&&releaseAlerts.conflicts.length!=0;};$scope.showDelayed=function(releaseAlerts){return!$scope.showFlag(releaseAlerts)&&!$scope.showConflict(releaseAlerts)&&releaseAlerts.delayedTasks.length!=0;};$scope.countAlerts=ReleaseAlerts.countAlerts;$scope.isReleaseFailed=ReleasesService.isReleaseFailed;$scope.countPhasesDone=ReleasesService.countPhasesDone;$scope.displayReleaseSummary=ReleasesService.redirectToSummary;$scope.isPhaseActive=PhasesService.isPhaseActive;$scope.isPhaseReadOnly=PhasesService.isPhaseReadOnly;$scope.isPhasePlanned=PhasesService.isPhasePlanned;$scope.getLeafTasks=PhasesService.getLeafTasks;$scope.collapseDonePhases=PipelineCollapsePhases.collapseDonePhases;$scope.expandDonePhases=PipelineCollapsePhases.expandDonePhases;$scope.areDonePhasesCollapsed=PipelineCollapsePhases.areDonePhasesCollapsed;$scope.areDonePhasesCollapsable=PipelineCollapsePhases.areDonePhasesCollapsable;$scope.collapseFilter=PipelineCollapsePhases.collapseFilter;}]);'use strict';angular.module('xlrelease').factory('PipelineCollapsePhases',['PhasesService','ClientSettings',function(PhasesService,ClientSettings){var MIN_DONE_PHASES_FOR_COLLAPSE=3;var releasesWithDonePhasesCollapsed=ClientSettings.getPipelineCollapseState()||[];return{collapseDonePhases:function(release){releasesWithDonePhasesCollapsed.push(release.id);ClientSettings.setPipelineCollapseState(releasesWithDonePhasesCollapsed)},expandDonePhases:function(release){releasesWithDonePhasesCollapsed=_.without(releasesWithDonePhasesCollapsed,release.id);ClientSettings.setPipelineCollapseState(releasesWithDonePhasesCollapsed)},areDonePhasesCollapsed:function(release){return _.indexOf(releasesWithDonePhasesCollapsed,release.id)!=-1;},areDonePhasesCollapsable:function(release){return!this.areDonePhasesCollapsed(release)&&_.filter(release.phases,PhasesService.isPhaseReadOnly).length>MIN_DONE_PHASES_FOR_COLLAPSE;},collapseFilter:function(release){if(!this.areDonePhasesCollapsed(release)){return function(){return true;}}
return function(phase){return!PhasesService.isPhaseReadOnly(phase);}}}}]);'use strict';angular.module('xlrelease').controller('calendarController',['$scope','Timeout','Calendar','DateService','Backend','ReleasesService','VariablesInterpolator','DayColors','$routeParams','$location','CalendarNavigator','ColorService','SpecialDaysService','filterSettings',function($scope,Timeout,Calendar,DateService,Backend,ReleasesService,VariablesInterpolator,DayColors,$routeParams,$location,CalendarNavigator,ColorService,SpecialDaysService,filterSettings){var URL_DATE_FORMAT="MM-YYYY";$scope.filters=filterSettings;$scope.DayColors=DayColors;$scope.currentDate=moment($routeParams.month,URL_DATE_FORMAT).date(1);loadReleases();function loadReleases(){ReleasesService.getReleases($scope.filters).success(function(releases){$scope.releases=_.reject(releases,'tutorial');initCalendar($scope.currentDate);ReleasesService.getReleasesDependenciesByReleaseId(releases).then(function(releasesDependencies){$scope.releasesDependencies=releasesDependencies;});$scope.releasesVariables=_.object(_.map(releases,function(release){return[release.id,release.variables];}));});}
$scope.showNavigator=CalendarNavigator.isNavigatorOpen();function initCalendar(date){var calendar=Calendar.init($scope.releases,date);$scope.weeks=calendar.weeks;$scope.months=calendar.months;$scope.currentDate=date;SpecialDaysService.loadCalendarSpecialDays($scope.weeks);}
$scope.showDate=function(date){$location.search({month:date.format(URL_DATE_FORMAT)});};$scope.showToday=function(){$location.search({month:DateService.getToday().date(1).format(URL_DATE_FORMAT)});};$scope.showPreviousMonth=function(){$location.search({month:$scope.currentDate.subtract("months",1).format(URL_DATE_FORMAT)});};$scope.showNextMonth=function(){$location.search({month:$scope.currentDate.add("months",1).format(URL_DATE_FORMAT)});};$scope.isCurrentMonth=function(month){return month.fullDate.month()===$scope.currentDate.month()&&month.fullDate.year()===$scope.currentDate.year();};$scope.getIncomingDependencies=function(releaseId){return getReleaseDependencies(releaseId,'incomingDependencies');};$scope.getOutgoingDependencies=function(releaseId){return getReleaseDependencies(releaseId,'outgoingDependencies');};function getReleaseDependencies(releaseId,property){var releaseDependencies=$scope.releasesDependencies[releaseId];return releaseDependencies?releaseDependencies[property]:[];}
$scope.interpolate=function(title,releaseId){if(title){return VariablesInterpolator.interpolateInText($scope.releasesVariables[releaseId],title);}};$scope.isInConflict=function(releaseId){return ReleasesService.isInConflict(releaseId,$scope.releasesDependencies);};$scope.editDay=function(day){$scope.editedDay={label:day.label,color:day.color};Backend.get(SpecialDaysService.specialDayUrl(day)).success(function(serverData){$scope.editedDay.label=serverData.label;$scope.editedDay.color=serverData.color;});$scope.editedDayDisplay=day.fullDate.format('MMMM Do');};$scope.saveDay=function(day,dismiss){Backend.put(SpecialDaysService.specialDayUrl(day),{label:$scope.editedDay.label,color:$scope.editedDay.color}).success(function(){day.label=$scope.editedDay.label;day.color=$scope.editedDay.color;dismiss();});};$scope.toggleNavigator=function(){$scope.showNavigator=CalendarNavigator.toggleNavigator();};$scope.isReleaseCompleted=ReleasesService.isReleaseCompleted;$scope.downloadCalendar=ReleasesService.downloadCalendar;$scope.computeDayColor=ColorService.computeDayColor;$scope.computePhaseColor=ColorService.computePhaseColor;}]);'use strict';angular.module('xlrelease').factory('Calendar',['DateService','ReleasesService',function(DateService,ReleasesService){var MINIMUM_MONTHS=12;var EXTRA_MONTHS=5;var TOTAL_WEEKS_DISPLAYED=6;var URL_DATE_FORMAT="MM-YYYY";var calendar={init:function(releases,date){return{weeks:getWeeks(date,releases),months:getMonths(releases)};},currentMonth:function(){return DateService.getToday().date(1).format(URL_DATE_FORMAT);},getNumberOfDaysAfter:function(startDate,firstDayOfWeek){var diff=startDate.diff(firstDayOfWeek,'days',true);return diff<0?0:diff;},getDuration:function(startDate,endDate,firstDay,lastDay){return lastDay.diff(firstDay,'days')-this.getNumberOfDaysAfter(startDate,firstDay)-this.getNumberOfDaysAfter(lastDay,endDate);},isActiveDuringWeek:function(startDate,dueDate,firstDayOfWeek){var lastDayOfWeek=moment(firstDayOfWeek).add('days',7);return startDate&&dueDate&&firstDayOfWeek.isBefore(dueDate)&&lastDayOfWeek.isAfter(startDate);}};function getWeeks(date,releases){var weeks=[];var day=moment(date).day(0);for(var weekIndex=0;weekIndex<TOTAL_WEEKS_DISPLAYED;weekIndex++){var firstDayOfWeek=DateService.atMidnight(moment(day).day(0));var lastDayOfWeek=moment(firstDayOfWeek).add('days',7);weeks.push({days:getDaysOfTheWeek(firstDayOfWeek),releases:getReleasesOfTheWeek(releases,firstDayOfWeek,lastDayOfWeek)});day.add('days',7);}
return weeks;}
function getListOfMonths(numberOfMonths,firstDayOfCalendar){var months=[];var firstDayOfMonth=moment(firstDayOfCalendar);for(var i=0;i<numberOfMonths;i++){months.push({title:firstDayOfMonth.format("MMMM"),year:firstDayOfMonth.format("YYYY"),index:firstDayOfMonth.month(),fullDate:moment(firstDayOfMonth)});firstDayOfMonth.add('months',1);}
return months;}
function getReleasesDate(releases,finder,getDate){if(releases.length>0){var release=finder(releases,function(release){if(getDate(release)){return moment(getDate(release)).valueOf()}});return moment(getDate(release));}else{return DateService.getToday();}}
function getMonths(releases){var firstDayOfReleases=getReleasesDate(releases,_.min,_.bind(DateService.getStartOrScheduledDate,DateService));var lastDayOfReleases=getReleasesDate(releases,_.max,_.bind(DateService.getEndOrDueDate,DateService));var numberOfMonths=lastDayOfReleases.diff(firstDayOfReleases,'months')+EXTRA_MONTHS;numberOfMonths=numberOfMonths<MINIMUM_MONTHS?MINIMUM_MONTHS:numberOfMonths;var firstDayOfCalendar=moment(firstDayOfReleases).date(1).subtract('months',Math.floor(EXTRA_MONTHS/2));return getListOfMonths(numberOfMonths,firstDayOfCalendar);}
function getDisplayablePhases(release,firstDayOfWeek,lastDayOfWeek){var phases=release.phases;var phasesOfTheWeek=[];_.each(phases,function(phase){if(DateService.getStartOrScheduledDate(phase)&&DateService.getEndOrDueDate(phase)){var dates=ReleasesService.cropToReleaseDate(phase,release);var startDate=dates.startDate;var endDate=dates.endDate;if(calendar.isActiveDuringWeek(startDate,endDate,firstDayOfWeek)&&isInsideRelease(release,phase)){phase.leftDayOffset=calendar.getNumberOfDaysAfter(startDate,firstDayOfWeek);phase.numberOfDay=calendar.getDuration(startDate,endDate,firstDayOfWeek,lastDayOfWeek);phasesOfTheWeek.push(phase);}}});return phasesOfTheWeek;}
function isInsideRelease(release,phase){var releaseStartDate=DateService.getStartOrScheduledDate(release);var releaseEndDate=DateService.getEndOrDueDate(release);var phaseStartDate=DateService.getStartOrScheduledDate(phase);var phaseEndDate=DateService.getEndOrDueDate(phase);return moment(phaseStartDate).isBefore(moment(releaseEndDate))&&moment(phaseEndDate).isAfter(moment(releaseStartDate));}
function getReleasesOfTheWeek(releases,firstDayOfWeek,lastDayOfWeek){var releasesOfTheWeek=[];_.each(releases,function(release){var startDate=moment(DateService.getStartOrScheduledDate(release));var endDate=moment(DateService.getEndOrDueDate(release));if(calendar.isActiveDuringWeek(startDate,endDate,firstDayOfWeek)){var enhancedRelease=angular.copy(release);angular.extend(enhancedRelease,{currentTask:release.currentTask?release.currentTask.title:undefined,leftDayOffset:calendar.getNumberOfDaysAfter(startDate,firstDayOfWeek),numberOfDay:calendar.getDuration(startDate,endDate,firstDayOfWeek,lastDayOfWeek),displayablePhases:getDisplayablePhases(enhancedRelease,firstDayOfWeek,lastDayOfWeek)});releasesOfTheWeek.push(enhancedRelease);}});return releasesOfTheWeek;}
function getDaysOfTheWeek(firstDayOfWeek){var dayInWeek=moment(firstDayOfWeek);var days=[];for(var dayIndex=0;dayIndex<7;dayIndex++){days.push({date:dayInWeek.date(),month:dayInWeek.format("MMMM"),dateStatus:DateService.getDateStatus(dayInWeek),fullDate:moment(dayInWeek),year:dayInWeek.format("YYYY")});dayInWeek.add('days',1);}
return days;}
return calendar}]);angular.module('xlrelease').value('CalendarConstants',{dayHeaderHeight:20,releaseHeight:26,border:1});angular.module('xlrelease').factory('CalendarDisplay',['Calendar','DateService','CalendarConstants',function(Calendar,DateService,CalendarConstants){function computeReleaseOffsetTop(day){return CalendarConstants.dayHeaderHeight+_.parseInt(day.css("padding-top"));}
function computeContentWidth(calendarContent){var calendar=calendarContent.parents("#calendar");var navigator=calendar.find("#navigator");var contentWidth=calendar.width()-(_.parseInt(calendarContent.css("padding-right"))+_.parseInt(calendarContent.css("padding-left")));if(navigator.is(":visible")){contentWidth=contentWidth-navigator.width();}
return contentWidth;}
return{positionPlanItem:function(element,planItem,index,isPhase){var borderSize=isPhase?0:CalendarConstants.border;var offset=isPhase?CalendarConstants.border:0;var day=element.parents(".week").find(".day:first");var planItemOffsetTop=computeReleaseOffsetTop(day);var dayWidth=_.parseInt(day.outerWidth());var elementWidth=(planItem.numberOfDay*dayWidth-1-(borderSize*2)-(offset*2))+"px";element.css({top:(index*CalendarConstants.releaseHeight+planItemOffsetTop+offset)+"px",left:(planItem.leftDayOffset*dayWidth+offset)+"px",width:elementWidth});if(!isPhase){this.resizeReleaseTitle(element);}},adjustWeekHeight:function(element,numberOfRelease){var day=element.find(".day:first");var releaseOffsetTop=computeReleaseOffsetTop(day);var heightOfWeek=element.height();var idealHeight=numberOfRelease*CalendarConstants.releaseHeight+releaseOffsetTop;if(idealHeight>heightOfWeek){var dayPadding=_.parseInt(day.css("padding-top"))+_.parseInt(day.css("padding-bottom"));element.height(idealHeight);element.find(".day").height(idealHeight-dayPadding);}},positionCurrentTime:function(element){var dayWidth=element.parents('.day').outerWidth();var midnight=DateService.getToday();var currentTime=DateService.getTodayWithTime();var todayProgressRatio=currentTime.diff(midnight,'days',true);var halfWidth=element.outerWidth()/2.0;element.css('left',todayProgressRatio*dayWidth-halfWidth);},resizeDays:function(calendarContent){var calendarHeader=calendarContent.find("#days-name");var day=calendarContent.find(".day:first");var contentWidth=computeContentWidth(calendarContent);var dayPadding=_.parseInt(day.css("padding-right"))+_.parseInt(day.css("padding-left"));var dayWidth=_.parseInt(contentWidth/7);var dayWidthWithoutPadding=dayWidth-(dayPadding+1);var dayNumberWidth=18;calendarContent.find("#days").css({"width":contentWidth});calendarHeader.css({"width":contentWidth+1});calendarHeader.find("div").css({"width":dayWidth});calendarHeader.find("div:last").css({"width":dayWidth+1});calendarContent.find(".day").css({"width":dayWidthWithoutPadding});calendarContent.find(".day-label").css({"width":dayWidthWithoutPadding-dayNumberWidth});calendarContent.find(".day-number").css({"width":dayNumberWidth});},resizeReleaseTitle:function(element){var title=element.find('.title');var paddingHzl=2*_.parseInt(title.css('left'));title.width(title.parents('.release').width()-paddingHzl);}}}]);angular.module('xlrelease').directive('positionRelease',['CalendarDisplay','Window',function(CalendarDisplay,Window){return function(scope,element,attrs){element.bind("mouseout mouseover",function(){element.parents('#days').find('.'+attrs.positionRelease).toggleClass('release-hover');});scope.$evalAsync(function(){CalendarDisplay.positionPlanItem(element,scope.release,scope.$index);});Window.onResize(function(){CalendarDisplay.positionPlanItem(element,scope.release,scope.$index);},scope);scope.$watch('showNavigator',function(){scope.$evalAsync(function(){CalendarDisplay.positionPlanItem(element,scope.release,scope.$index);});});}}]);angular.module('xlrelease').directive('positionPhase',['CalendarDisplay','Window',function(CalendarDisplay,Window){return function(scope,element){scope.$evalAsync(function(){CalendarDisplay.positionPlanItem(element,scope.phase,scope.$parent.$index,true);});Window.onResize(function(){CalendarDisplay.positionPlanItem(element,scope.phase,scope.$parent.$index,true);},scope);scope.$watch('showNavigator',function(){CalendarDisplay.positionPlanItem(element,scope.phase,scope.$parent.$index,true);});}}]);angular.module('xlrelease').directive('adjustWeekHeight',['CalendarDisplay',function(CalendarDisplay){return function(scope,element){scope.$watch('weeks',function(){CalendarDisplay.adjustWeekHeight(element,scope.week.releases.length);});}}]);angular.module('xlrelease').directive('positionCurrentTime',['CalendarDisplay','Window',function(CalendarDisplay,Window){return function(scope,element){scope.$evalAsync(function(){CalendarDisplay.positionCurrentTime(element);});Window.onResize(function(){CalendarDisplay.positionCurrentTime(element);},scope);scope.$watch('showNavigator',function(){CalendarDisplay.positionCurrentTime(element);});}}]);angular.module('xlrelease').directive('resizeDays',['CalendarDisplay','Window',function(CalendarDisplay,Window){return function(scope,element){scope.$watchCollection('weeks',function(){scope.$evalAsync(function(){CalendarDisplay.resizeDays(element);});});Window.onResize(function(){CalendarDisplay.resizeDays(element);},scope);scope.$watch('showNavigator',function(){CalendarDisplay.resizeDays(element);});};}]);angular.module('xlrelease').directive('calendarTooltip',[function(){return{restrict:'A',link:function(scope,tooltipElement){var releaseElement=tooltipElement.parents('.release');releaseElement.qtip({content:releaseElement.find('.tooltip').contents(),position:{my:'bottom center',at:'top center',target:'mouse',adjust:{mouse:false},viewport:$(window)},show:'click',hide:'unfocus',style:'qtip-bootstrap',events:{toggle:function(){releaseElement.parents('#days').find('.'+scope.release.id).toggleClass('release-selected');}}});releaseElement.on("$destroy",function(){releaseElement.qtip("destroy",true);});}};}]);angular.module('xlrelease').directive('calendarTooltipDependency',['FlagService',function(FlagService){return{restrict:'A',link:function(scope,element,attrs){var dependency=scope[attrs.dependency];var type=attrs.type;var releaseElement=element.parents('.release');element.on('mouseout mouseover',function(){releaseElement.parents('#days').find('.'+dependency.releaseId).toggleClass(type+'-dependency-highlight');});scope.isReleaseOrSubtaskFlagged=FlagService.isReleaseOrSubtaskFlagged;}};}]);angular.module('xlrelease').factory('CalendarNavigator',function(){var showNavigator=false;return{toggleNavigator:function(){showNavigator=!showNavigator;return showNavigator;},isNavigatorOpen:function(){return showNavigator;}}});angular.module('xlrelease').directive('displayReleaseTitle',['FlagService','CalendarDisplay','ReleasesService',function(FlagService,CalendarDisplay,ReleasesService){return{templateUrl:"partials/calendar/release-title.html",restrict:'A',scope:{release:'=',releasesDependencies:'='},link:function(scope,element){scope.isReleaseOrSubtaskFlagged=FlagService.isReleaseOrSubtaskFlagged;scope.isInConflict=function(releaseId){return ReleasesService.isInConflict(releaseId,scope.releasesDependencies);};CalendarDisplay.resizeReleaseTitle(element);}}}]);'use strict';angular.module('xlrelease').factory('CalendarResolver',['$q','$location','$route','Calendar',function($q,$location,$route,Calendar){return{initCurrentDate:function(){var URL_DATE_PATTERN="^[0-9]{2}-[0-9]{4}$";var deferred=$q.defer();if(!$route.current.params.month||!$route.current.params.month.match(URL_DATE_PATTERN)){var searchParams=angular.extend($route.current.params,{month:Calendar.currentMonth()});$location.search(searchParams).replace();deferred.reject();}else{deferred.resolve();}
return deferred.promise;}}}]);angular.module('xlrelease').factory('reportConfigurationService',function(){var ONE_MONTH=30*24*3600*1000;var defaultOptions={title:{text:''},credits:{enabled:false},xAxis:{type:'datetime',labels:{formatter:function(){return moment(this.value).format("D MMMM YYYY");}},minTickInterval:ONE_MONTH},legend:{borderWidth:0},plotOptions:{scatter:{marker:{radius:5,states:{hover:{enabled:true,lineColor:'rgb(100,100,100)'}}},states:{hover:{marker:{enabled:false}}}},spline:{marker:{enabled:false},enableMouseTracking:false,lineWidth:1},areaspline:{fillOpacity:0.3,marker:{enabled:false}},column:{stacking:'normal'}}};return{getHighchartsOptions:function(options){return angular.extend(angular.copy(defaultOptions),options);}}});angular.module('xlrelease').filter('duration',function(){function truncate(durationInDays){if(durationInDays>=10){durationInDays=Math.ceil(durationInDays);}
return durationInDays;}
return function(durationInMs){var durationInSec=Math.floor(durationInMs/1000);if(durationInSec<60){return durationInSec+' sec';}
var durationInMin=Math.floor(durationInSec/60);if(durationInMin<60){return durationInMin+' min';}
var durationInHours=truncate(Math.ceil(durationInMin/6)/10);if(durationInHours<24){return durationInHours+' hours';}
return truncate(Math.ceil(durationInHours/2.4)/10)+' days';}});'use strict';angular.module('xlrelease').directive('releaseAutomationAreaSplineReport',['durationFilter','reportConfigurationService',function(durationFilter,reportConfigurationService){return function(scope,element){scope.$watch('reports.releasesAutomation.data',function(averageAutomationPercentage){if(averageAutomationPercentage){var months=_.pluck(averageAutomationPercentage,'name');element.highcharts(reportConfigurationService.getHighchartsOptions({tooltip:{enabled:false},legend:{enabled:false},xAxis:{categories:months},yAxis:{title:{text:'Automation'},labels:{format:'{value} %'},min:0},series:[{type:'areaspline',data:_.pluck(averageAutomationPercentage,'y')}]}));}});}}]);'use strict';angular.module('xlrelease').directive('releaseDurationAreaSplineReport',['durationFilter','reportConfigurationService',function(durationFilter,reportConfigurationService){return function(scope,element){scope.$watch('reports.releasesDuration.data',function(averageReleaseDuration){if(averageReleaseDuration){var months=_.pluck(averageReleaseDuration,'name');var averageDuration=_.pluck(averageReleaseDuration,'y');element.highcharts(reportConfigurationService.getHighchartsOptions({tooltip:{enabled:false},legend:{enabled:false},xAxis:{categories:months},yAxis:{title:{text:'Duration'},labels:{formatter:function(){return durationFilter(this.value);}},min:0},series:[{type:'areaspline',data:averageDuration,yAxis:0}]}));}});}}]);'use strict';angular.module('xlrelease').factory('MostRecentReleaseCharts',['reportConfigurationService',function(reportConfigurationService){return{stackedBarCharts:function(options){return function link(scope,element){scope.$watch('reports.mostRecentReleases.data',function(data){if(data&&data.length){var releasesTitle=_.pluck(data,'title');var series=options.series(data);var chartDef={colors:['#a52a2a','#68b749'],xAxis:{categories:releasesTitle,labels:{rotation:-90,align:'right'}},yAxis:options.yAxis,series:[{name:'Manual tasks',type:'column',data:series.manualTasksSerie},{name:'Automated tasks',type:'column',data:series.automatedTasksSerie}]};if(options.tooltip){chartDef.tooltip=options.tooltip;}
element.highcharts(reportConfigurationService.getHighchartsOptions(chartDef));}});}}}}]);angular.module('xlrelease').directive('mostRecentReleasesTasksCountReport',['MostRecentReleaseCharts',function(MostRecentReleaseCharts){return MostRecentReleaseCharts.stackedBarCharts({yAxis:{min:0,title:{text:'Tasks'}},series:function(data){var numberOfAutomatedTasks=_.pluck(data,'numberOfAutomatedTasks');var numberOfManualTasks=_.map(data,function(release){return release.numberOfTasks-release.numberOfAutomatedTasks;});return{manualTasksSerie:numberOfManualTasks,automatedTasksSerie:numberOfAutomatedTasks};}});}]);angular.module('xlrelease').directive('mostRecentReleasesTimeSpentReport',['MostRecentReleaseCharts','durationFilter',function(MostRecentReleaseCharts,durationFilter){return MostRecentReleaseCharts.stackedBarCharts({yAxis:{min:0,title:{text:'Time spent'},labels:{formatter:function(){return durationFilter(this.value);}}},tooltip:{hideDelay:0,formatter:function(){var tooltipContent=this.x+'<br>';tooltipContent+='<span style="color: '+this.series.color+'">'+this.series.name+': </span><b>'+durationFilter(this.y)+'</b>';return tooltipContent;}},series:function(data){var timeInAutomatedTasks=_.pluck(data,'automatedDuration');var timeInManualTasks=_.map(data,function(release){return release.totalDuration-release.automatedDuration;});return{manualTasksSerie:timeInManualTasks,automatedTasksSerie:timeInAutomatedTasks};}});}]);angular.module('xlrelease').directive('releaseNumberReport',['reportConfigurationService',function(reportConfigurationService){return function(scope,element){scope.$watch('reports.numberOfReleasesPerMonth.data',function(numberOfReleasesPerMonth){if(numberOfReleasesPerMonth&&numberOfReleasesPerMonth.length){var categories=_.map(_.pluck(numberOfReleasesPerMonth,'x'),function(date){return moment(date).format("MMMM YYYY");});var data=_.pluck(numberOfReleasesPerMonth,'y');element.highcharts(reportConfigurationService.getHighchartsOptions({tooltip:{enabled:false},legend:{enabled:false},xAxis:{categories:categories},yAxis:{title:{text:'Number'},min:0},series:[{type:'column',name:'Number',data:data,dataLabels:{enabled:true,color:'#FFFFFF',align:'center',y:30}}]}));}});}}]);'use strict';angular.module('xlrelease').controller('reportsController',['$scope','Backend','$location','ReportsService','filterSettings',function($scope,Backend,$location,ReportsService,filterSettings){ReportsService.setFilterSettings(filterSettings);$scope.filters=filterSettings;$scope.reportType=$location.path().substring(1);ReportsService.loadReports($scope.reportType);$scope.reports=ReportsService.getReports();$scope.exportReport=ReportsService.exportReport;}]);'use strict';angular.module('xlrelease').directive('releaseDurationWithAutomation',['durationFilter','reportConfigurationService',function(durationFilter,reportConfigurationService){function drawChart(element,releasesDuration,releasesAutomation){if(releasesDuration&&releasesAutomation&&releasesDuration.length&&releasesAutomation.length){var months=_.pluck(releasesDuration,'name');var averageDuration=_.pluck(releasesDuration,'y');element.highcharts(reportConfigurationService.getHighchartsOptions({tooltip:{enabled:false},legend:{enabled:false},xAxis:{categories:months},yAxis:[{title:{text:'Duration'},labels:{formatter:function(){return durationFilter(this.value);}},min:0},{title:{text:'Automation percentage'},labels:{format:'{value} %'},opposite:true,min:0}],series:[{type:'column',data:averageDuration,yAxis:0,dataLabels:{enabled:true,color:'#FFFFFF',align:'center',y:30,formatter:function(){return durationFilter(this.y);}}},{type:'spline',yAxis:1,color:'red',lineWidth:2,data:_.pluck(releasesAutomation,'y')}]}));}}
return function(scope,element){var releasesDuration,releasesAutomation;scope.$watch('reports.averageDurationAndAutomation.releasesDuration',function(data){releasesDuration=data;drawChart(element,releasesDuration,releasesAutomation);});scope.$watch('reports.averageDurationAndAutomation.releasesAutomation',function(data){releasesAutomation=data;drawChart(element,releasesDuration,releasesAutomation);});}}]);angular.module('xlrelease').factory('ReleaseEfficiency',['reportConfigurationService',function(reportConfigurationService){return{pieChart:function(options){return function link(scope,element){scope.$watch('reports.releaseEfficiency.data',function(releaseEfficiency){if(releaseEfficiency){element.highcharts(reportConfigurationService.getHighchartsOptions({colors:['#68b749','#a52a2a'],tooltip:{hideDelay:0,formatter:options.tooltipFormatter},chart:{height:225},plotOptions:{pie:{size:100,showInLegend:true}},series:[{type:'pie',data:options.data(releaseEfficiency),dataLabels:{format:'{point.percentage:.1f} %',distance:-25,color:'white'}}]}));}});}}}}]);angular.module('xlrelease').directive('releaseEfficiencyAutomation',['ReleaseEfficiency',function(ReleaseEfficiency){return ReleaseEfficiency.pieChart({data:function(releaseEfficiency){return[['Automated',releaseEfficiency.totalAutomatedTasks],['Manual',releaseEfficiency.totalManualTasks]];},tooltipFormatter:function(){var tooltipContent='<b>'+this.point.name+'</b><br>';tooltipContent+=this.y+' tasks';return tooltipContent;}});}]);angular.module('xlrelease').directive('releaseEfficiencyTimeSpent',['ReleaseEfficiency','durationFilter',function(ReleaseEfficiency,durationFilter){return ReleaseEfficiency.pieChart({data:function(releaseEfficiency){return[['Automated',releaseEfficiency.totalAutomatedTimeSpent],['Manual',releaseEfficiency.totalManualTimeSpent]];},tooltipFormatter:function(){var tooltipContent='<b>'+this.point.name+'</b><br>';tooltipContent+=durationFilter(this.y);return tooltipContent;}});}]);angular.module('xlrelease').factory('ReportsDefinition',['ReportLoader','Report',function(ReportLoader,Report){return{'release-automation':function(){var MOST_RECENT_RELEASES_NUMBER=20;this.loaders={releasesDuration:new ReportLoader('reports/releases/duration'),releasesAutomation:new ReportLoader('reports/releases/automation'),mostRecentReleases:new ReportLoader('reports/releases/most-recent/'+MOST_RECENT_RELEASES_NUMBER)};this.reports={releasesDuration:new Report().add('data',this.loaders.releasesDuration,function(data){return data.average;}),releasesAutomation:new Report().add('data',this.loaders.releasesAutomation,function(data){return data.averageAutomationPercentage;}),mostRecentReleases:new Report().add('data',this.loaders.mostRecentReleases,function(data){return data.reverse();})};},'dashboard':function(){var TOP_REPORT_SIZE=10;function sliceReport(data){if(data){data=data.slice(0,TOP_REPORT_SIZE-1)}
return data;}
this.loaders={longestTasks:new ReportLoader('reports/longest-tasks'),longestPhases:new ReportLoader('reports/longest-phases'),numberOfReleasesPerMonth:new ReportLoader('reports/releases/number-by-month'),mostInvolvedPeople:new ReportLoader('reports/most-involved-people'),releasesDuration:new ReportLoader('reports/releases/duration'),releasesAutomation:new ReportLoader('reports/releases/automation')};this.reports={releaseEfficiency:new Report().add('data',this.loaders.releasesAutomation,function(data){return data.releaseEfficiency;}),averageDurationAndAutomation:new Report().add('releasesDuration',this.loaders.releasesDuration,function(data){return data.average;}).add('releasesAutomation',this.loaders.releasesAutomation,function(data){return data.averageAutomationPercentage;}),numberOfReleasesPerMonth:new Report().add('data',this.loaders.numberOfReleasesPerMonth),longestReleases:new Report().add('data',this.loaders.releasesDuration,function(data){return sliceReport(data.longestReleases);}),longestPhases:new Report().add('data',this.loaders.longestPhases,sliceReport),longestTasks:new Report().add('data',this.loaders.longestTasks,sliceReport),mostInvolvedPeople:new Report().add('data',this.loaders.mostInvolvedPeople,sliceReport)};}}}]);angular.module('xlrelease').factory('ReportsService',['Backend','Download','ReportsDefinition',function(Backend,Download,ReportsDefinition){var filterSettings=null;var reports=null;return{loadReports:function(reportType){var reportsPage=new ReportsDefinition[reportType]();var params=getReportsParams(filterSettings);_.forEach(reportsPage.loaders,function(loader){loader.startLoading();Backend.get(loader.url,{params:params}).success(loader.loaded).then(loader.endLoading,loader.endLoading);});reports=reportsPage.reports;},exportReport:function(type){var params=getReportsParams(filterSettings);params.report=type;Backend.get('reports/export',{params:params}).success(function(downloadToken){Download.launch('export/report/'+downloadToken);});},setFilterSettings:function(settings){filterSettings=settings;},getFilterSettings:function(){return filterSettings;},getReports:function(){return reports;}};function getReportsParams(filterSettings){var params=angular.copy(filterSettings);if(!params.tags){params.tags=[];}
return params;}}]);angular.module('xlrelease').factory('ReportLoader',function(){return function(url){var self=this;var callbacks=[];this.loading=false;this.url=url;this.startLoading=function(){self.loading=true;};this.endLoading=function(){self.loading=false;};this.loaded=function(data){_.forEach(callbacks,function(callback){callback(data);});};this.whenLoaded=function(callback){callbacks.push(callback);}}});angular.module('xlrelease').factory('Report',function(){return function(){var self=this;var loaders=[];var dataProperties=[];this.add=function(dataProperty,loader,transform){self[dataProperty]=[];dataProperties.push(dataProperty);loaders.push(loader);loader.whenLoaded(function(data){self[dataProperty]=transform?transform(data):data;});return self;};this.loading=function(){var loading=false;_.forEach(loaders,function(loader){loading=loading||loader.loading;});return loading;};this.isEmpty=function(){var empty=dataProperties.length==0;_.forEach(dataProperties,function(dataProperty){empty=empty||self[dataProperty].length==0;});return empty;};}});'use strict';angular.module('xlrelease').controller('releasesAtRiskController',['$scope','Backend','ReleasesService','ReleaseAlerts','ReportsService',function($scope,Backend,ReleasesService,ReleaseAlerts,ReportsService){var filterSettings=ReportsService.getFilterSettings();var tagsFilter=filterSettings.tags.replace(/,/g,' ');$scope.loadingReleases=true;function releasesLoaded(){$scope.loadingReleases=false;}
ReleaseAlerts.getReleasesAndAlerts({onlyFlagged:true,filter:tagsFilter,active:true}).then(function(releasesAndAlerts){$scope.releases=releasesAndAlerts.releases;$scope.releasesAlerts=releasesAndAlerts.releasesAlerts;}).then(releasesLoaded,releasesLoaded);$scope.showFlag=function(releaseAlerts){return releaseAlerts.flaggedItems.length!=0;};$scope.countAlerts=ReleaseAlerts.countAlerts;$scope.isReleaseFailed=ReleasesService.isReleaseFailed;$scope.displayReleaseSummary=ReleasesService.redirectToSummary;}]);angular.module('xlrelease').directive('phaseDuration',['reportConfigurationService',function(reportConfigurationService){return function(scope,element){var phase=scope.phase;var release=scope.release;var getDurationPercentage=scope.getDurationPercentage;var duration=getDurationPercentage(release,phase);var FOREGROUND_COLOR='#aaa';var BACKGROUND_COLOR='#fff';element.highcharts(reportConfigurationService.getHighchartsOptions({exporting:{enabled:false},colors:[FOREGROUND_COLOR,BACKGROUND_COLOR],chart:{spacing:[0,0,0,0],plotBackgroundColor:null,plotBorderWidth:null,plotShadow:null,backgroundColor:null,borderWidth:0,type:'area',margin:[2,0,2,0],width:18,height:18,style:{overflow:'visible'},skipClone:true},legend:{enabled:false},tooltip:{enabled:false},plotOptions:{pie:{borderColor:FOREGROUND_COLOR,allowPointSelect:false,cursor:'default',dataLabels:{enabled:false},size:'13.5'}},series:[{type:'pie',name:'',data:[['Selected',duration],['Unselected',100-duration]]}]}));}}]);angular.module('xlrelease').directive('reportContainer',[function(){return{templateUrl:'partials/reports/report-container.html',transclude:true,scope:{report:'='}}}]);'use strict';angular.module('xlrelease').controller('reportsSettingsController',['$scope','Backend','ValueStreamMapping',function($scope,Backend,ValueStreamMapping){var REPORTS_SETTINGS_DIRECTORY='repository/ci/Configuration/reports';var REPORTS_SETTINGS_URL=REPORTS_SETTINGS_DIRECTORY+'/ReportsSettings';var reportSettingsExists;Backend.get('metadata/type/xlrelease.ReportsSettings').success(function(type){$scope.type=type;});Backend.get(REPORTS_SETTINGS_URL,{hideAlert:true}).success(function(ci){$scope.reportsSettings=ci;reportSettingsExists=true;}).error(function(){$scope.reportsSettings={};});$scope.save=function(){if(reportSettingsExists){Backend.put(REPORTS_SETTINGS_URL,$scope.reportsSettings).success(itemSaved);}else{$scope.reportsSettings.type='xlrelease.ReportsSettings';$scope.reportsSettings.id='Configuration/reports/ReportsSettings';Backend.post(REPORTS_SETTINGS_DIRECTORY,{type:'core.Directory',id:'Configuration/reports'}).success(function(){Backend.post(REPORTS_SETTINGS_URL,$scope.reportsSettings).success(itemSaved);});}};function itemSaved(){reportSettingsExists=true;$scope.lastSavedDate=moment().toDate();ValueStreamMapping.refreshReportsSettings();}}]);'use strict';angular.module('xlrelease').controller('profileController',['$scope','Backend','Authenticator','UsersService','UserProfile',function($scope,Backend,Authenticator,UsersService,UserProfile){UserProfile.load().success(function(profile){$scope.profile=profile;});$scope.saveProfile=function(){var profileForm={email:$scope.profile.email,fullName:$scope.profile.fullName};if($scope.profile.password){profileForm.password=$scope.profile.password;profileForm.previousPassword=$scope.profile.previousPassword;}
UserProfile.save(profileForm).success(function(){$scope.lastSavedDate=moment().toDate();if($scope.profile.password){Authenticator.changePassword($scope.profile.password);delete $scope.profile.password;delete $scope.profile.passwordConfirmation;delete $scope.profile.previousPassword;delete $scope.previousPasswordIsInvalid;}}).error(function(data,errorCode){if($scope.profile.password&&errorCode===400){$scope.previousPasswordIsInvalid=true;}});};$scope.isJcrUser=UsersService.isJcrUser;}]);'use strict';angular.module('xlrelease').factory('UserProfile',['Backend',function(Backend){var userProfile=undefined;return{load:function(){return Backend.get('profile').success(function(profile){userProfile=profile;});},save:function(profile){return Backend.put('profile',profile,{hideAlert:true}).success(function(profile){userProfile=profile;});},getCurrentUser:function(){return userProfile?{username:userProfile.username,fullName:userProfile.fullName}:undefined;},clear:function(){userProfile=null;}};}]);'use strict';angular.module('xlrelease').controller('serversController',['$scope','Backend','serverTitleFilter','Alerts',function($scope,Backend,serverTitleFilter,Alerts){var SERVERS_ENDPOINT='deployit/servers';var loadServers=function(){Backend.get(SERVERS_ENDPOINT).success(function(servers){$scope.servers=servers;});};var getNewServer=function(){return{id:'Configuration/Deployit/'+$scope.currentServer.title,username:$scope.currentServer.username,password:$scope.currentServer.password,url:$scope.currentServer.url,type:'xlrelease.DeployitServerDefinition'};};loadServers();$scope.editNewServer=function(){$scope.currentServer={};$scope.editMode=false;};$scope.save=function(dismissModal){var currentServer=getNewServer();var onServerSaveError=function(data,status){if(status===400){$scope.serverAlreadyExists=true;}};if($scope.editMode){Backend.put(SERVERS_ENDPOINT+"/"+$scope.currentServer.id,currentServer).success(loadServers).success(dismissModal).error(onServerSaveError);}else{Backend.post(SERVERS_ENDPOINT,currentServer).success(loadServers).success(dismissModal).error(onServerSaveError);}};$scope.editServer=function(server){$scope.editMode=true;$scope.currentServer=server;$scope.currentServer.title=serverTitleFilter(server.id);};$scope.deleteServer=function(server){Backend.del(SERVERS_ENDPOINT+'/'+server.id).success(loadServers);};$scope.checkConnection=function(){$scope.checkingConnection=true;Backend.post('deployit/connectionStatus',getNewServer()).success(function(available){$scope.unreachable=available==='false';$scope.checkingConnection=false;});};$scope.resetServerInfo=function(){delete $scope.unreachable;delete $scope.checkingConnection;delete $scope.serverAlreadyExists;};}]);'use strict';angular.module('xlrelease').controller('usersController',['$scope','Backend','Alerts','UsersService',function($scope,Backend,Alerts,UsersService){function loadUsers(){Backend.get('users').success(function(users){$scope.users=users;});}
loadUsers();$scope.editNewUser=function(){$scope.newUser=true;$scope.editedUser={username:'',email:'',fullName:'',external:false,password:'',passwordConfirmation:''};};$scope.editUser=function(user){$scope.newUser=false;$scope.editedUser={username:user.username,email:user.email,fullName:user.fullName,external:user.external,password:'',passwordConfirmation:''};};$scope.saveUser=function(dismiss){$scope.newUser?createUser(dismiss):updateUser(dismiss);};function createUser(dismiss){$scope.conflict=false;var userForm={username:$scope.editedUser.username,email:$scope.editedUser.email,fullName:$scope.editedUser.fullName,password:$scope.editedUser.password};Backend.post('users',userForm,{hideAlert:true}).success(function(){loadUsers();dismiss();}).error(function(data,status,headers,config){if(status==409){$scope.conflict=true;}else{Alerts.error({data:data,status:status,headers:headers,config:config});}});}
function updateUser(dismiss){var userForm={email:$scope.editedUser.email,fullName:$scope.editedUser.fullName};if($scope.editedUser.password){userForm.password=$scope.editedUser.password;}
Backend.put('users/'+$scope.editedUser.username,userForm).success(function(){loadUsers();dismiss();delete $scope.editedUser.password;});}
$scope.isJcrUser=UsersService.isJcrUser;$scope.deleteUser=function(user){Backend.del("users/"+user.username).success(loadUsers);};}]);'use strict';angular.module('xlrelease').controller('rolesController',['$scope','Backend','RolesService','UsersService',function($scope,Backend,RolesService,UsersService){function loadRolePrincipalsList(){RolesService.getRolePrincipalsList().success(function(rolePrincipalsList){$scope.rolePrincipalsList=rolePrincipalsList;});}
loadRolePrincipalsList();UsersService.getAllUsers().success(function(users){$scope.users=users;});$scope.addRole=function(){$scope.rolePrincipalsList.push({role:{name:"new role"},principals:[]});$scope.setDirty();};$scope.deleteRole=function(rolePrincipals){$scope.rolePrincipalsList=_.without($scope.rolePrincipalsList,rolePrincipals);$scope.setDirty();};$scope.save=function(){Backend.put('roles/principals',$scope.rolePrincipalsList).success(function(){$scope.lastSavedDate=moment().toDate();delete $scope.dirty;});};$scope.reset=function(){loadRolePrincipalsList();delete $scope.lastSavedDate;delete $scope.dirty;};$scope.setDirty=function(){$scope.dirty=true;};}]);'use strict';angular.module('xlrelease').controller('permissionsController',['$scope','Backend','$routeParams','ReleasesTabsService','Page','displayPermissionFilter',function($scope,Backend,$routeParams,ReleasesTabsService,Page,displayPermissionFilter){function getPermissionEndpoint(){if($scope.inReleaseContext){return"releases/"+$routeParams.releaseId+"/permissions";}
return"roles/permissions/global";}
function loadPermissions(){if(angular.isDefined($routeParams.releaseId)){$scope.inReleaseContext=true;Backend.get('releases/'+$routeParams.releaseId).success(function(release){$scope.release=release;Page.addToTitle($scope.release.title);ReleasesTabsService.open(release,'/permissions');});Backend.get(getPermissionEndpoint()).success(function(releasePermissionsView){$scope.permissionsContainers=releasePermissionsView.teams;$scope.permissions=releasePermissionsView.permissions;delete $scope.dirty;});}else{Backend.get(getPermissionEndpoint()).success(function(rolePermissionsView){$scope.permissionsContainers=rolePermissionsView.rolePermissions;$scope.permissions=_.filter(rolePermissionsView.permissions,function(permission){return displayPermissionFilter(permission)!==undefined;});delete $scope.dirty;});}}
loadPermissions();$scope.save=function(){Backend.put(getPermissionEndpoint(),$scope.permissionsContainers).success(function(){$scope.lastSavedDate=moment().toDate();delete $scope.dirty;});};$scope.reset=function(){loadPermissions();delete $scope.lastSavedDate;delete $scope.dirty;};$scope.setDirty=function(){$scope.dirty=true;};}]);'use strict';angular.module('xlrelease').controller('templatePermissionsController',['$scope','Backend','$routeParams','ReleasesTabsService','Page',function($scope,Backend,$routeParams,ReleasesTabsService,Page){function loadPermissions(){Backend.get('releases/'+$routeParams.releaseId).success(function(release){$scope.release=release;Page.addToTitle($scope.release.title);ReleasesTabsService.open(release,'/permissions');});Backend.get("releases/"+$routeParams.releaseId+"/permissions").success(function(releasePermissionsView){$scope.permissionsContainers=releasePermissionsView.teams;$scope.templatePermissions=filterPermissions(releasePermissionsView.permissions,'template');$scope.releasePermissions=filterPermissions(releasePermissionsView.permissions,'release');delete $scope.dirty;});}
loadPermissions();function filterPermissions(permissions,type){return _.filter(permissions,function(permission){return permission.indexOf(type)==0;});}
$scope.releasePermissionsContainersFilter=function(candidate){return angular.isDefined(candidate)&&candidate.teamName.indexOf('Template Owner')!=0;};$scope.save=function(){Backend.put("releases/"+$routeParams.releaseId+"/permissions",$scope.permissionsContainers).success(function(){$scope.lastSavedDate=moment().toDate();delete $scope.dirty;});};$scope.reset=function(){loadPermissions();delete $scope.lastSavedDate;delete $scope.dirty;};$scope.setDirty=function(){$scope.dirty=true;};}]);angular.module('xlrelease').filter('displayPermission',function(){var permissionsName={"admin":"Admin","login":"Login","reports#view":"View Reports","release#view":"View Release","release#edit":"Edit Release","release#edit_security":"Edit Security","release#start":"Start Release","release#abort":"Abort Release","release#create":"Create Release","release#reassign_task":"Reassign Task","release#edit_task":"Edit Task","read":"Read","repo#edit":"Edit Repository","security#edit":"Edit Security","import#remove":"Remove Import","template#create":"Create Template","template#create_release":"Create Release","template#view":"View Template","template#edit":"Edit Template","template#edit_security":"Edit Security"};return function(permission){return permissionsName[permission];}});angular.module('xlrelease').controller('forbiddenAccessController',['$scope','ForbiddenAccessService',function($scope,ForbiddenAccessService){$scope.errorMessage=ForbiddenAccessService.errorMessage;}]);'use strict';angular.module('xlrelease').factory('ForbiddenAccessService',[function(){return{errorMessage:''};}]);'use strict';angular.module('xlrelease').factory('UsersService',['Backend',function(Backend){return{isJcrUser:function(user){return user.external===false&&user.username!=='admin';},getAllUsers:function(){return Backend.get('users/names');}};}]);'use strict';angular.module('xlrelease').factory('RolesService',['Backend',function(Backend){return{getRolePrincipalsList:function(){return Backend.get('roles/principals');},getRoleNames:function(){return Backend.get('roles/names');}};}]);'use strict';angular.module('xlrelease').directive('permissionsTable',[function(){return{templateUrl:'partials/security/permissions-table.html',scope:{permissions:'=',permissionsContainers:'=',permissionsContainersFilter:'=',inReleaseContext:'=',setDirty:'&'},link:function(scope){scope.getClass=function(permissionName){return"permission-"+permissionName.replace("#","_");};scope.hasPermission=function(permissions,expected){return _.contains(permissions,expected);};scope.getRoleOrTeamName=function(permissionsContainer){if(scope.inReleaseContext){return permissionsContainer.teamName;}else{return permissionsContainer.role.name;}};scope.togglePermission=function(permissionsContainer,permission){if(scope.hasPermission(permissionsContainer.permissions,permission)){permissionsContainer.permissions=_.without(permissionsContainer.permissions,permission);}else{permissionsContainer.permissions.push(permission);}
scope.setDirty();};}}}]);'use strict';angular.module('xlrelease').controller('smtpController',['$scope','Backend',function($scope,Backend){var MAIL_DIRECTORY='repository/ci/Configuration/mail';var SMTP_SERVER_URL=MAIL_DIRECTORY+'/SmtpServer';var smtpServerExists;Backend.get('metadata/type/xlrelease.SmtpServer').success(function(type){$scope.type=type;});Backend.get(SMTP_SERVER_URL,{hideAlert:true}).success(function(ci){$scope.smtpServer=ci;smtpServerExists=true;}).error(function(){$scope.smtpServer={};});$scope.save=function(){if(smtpServerExists){Backend.put(SMTP_SERVER_URL,$scope.smtpServer).success(itemSaved);}else{$scope.smtpServer.type='xlrelease.SmtpServer';$scope.smtpServer.id='Configuration/mail/SmtpServer';Backend.post(MAIL_DIRECTORY,{type:'core.Directory',id:'Configuration/mail'}).success(function(){Backend.post(SMTP_SERVER_URL,$scope.smtpServer).success(itemSaved);});}};function itemSaved(){smtpServerExists=true;$scope.lastSavedDate=moment().toDate();}}]);'use strict';angular.module('xlrelease').controller('configurationListController',['$scope','$location','Backend','Alerts',function($scope,$location,Backend,Alerts){Backend.get('configurations/descriptors').success(function(descriptors){$scope.descriptors=descriptors;});function loadInstances(){Backend.get('configurations').success(function(instances){$scope.instances=_.groupBy(instances,'type');});}
loadInstances();$scope.deleteInstance=function(instance){Backend.del('configurations/'+instance.id,{hideAlert:true}).success(loadInstances).error(function(data,status,headers,config){if(status==409){$scope.deleteInstanceError=true;}else{Alerts.error({data:data,status:status,headers:headers,config:config});}});};$scope.resetError=function(){$scope.deleteInstanceError=false;};}]);'use strict';angular.module('xlrelease').controller('configurationInstanceController',['$scope','Backend','$routeParams','$location','ConfigurationTabsService',function($scope,Backend,$routeParams,$location,ConfigurationTabsService){var instanceId=$routeParams.configurationInstanceId;var instanceType=$routeParams.configurationInstanceType;$scope.newInstance=angular.isUndefined(instanceId);if($scope.newInstance){initNewInstance()}else{initInstance()}
function getMetadata(instanceType){Backend.get('metadata/type/'+instanceType).success(function(type){$scope.groupedProperties=_.groupBy(type.properties,'category');});}
function initInstance(){Backend.get('configurations/'+instanceId).success(function(instance){$scope.instance=instance;getMetadata(instance.type);ConfigurationTabsService.open(instance);});}
function initNewInstance(){$scope.instance={type:instanceType,properties:{}};getMetadata(instanceType);}
$scope.save=function(){if($scope.newInstance){Backend.post('configurations',$scope.instance).success(function(){$location.url('/configuration');});}else{Backend.put('configurations/'+instanceId,$scope.instance).success(itemSaved);}};function itemSaved(){$scope.lastSavedDate=moment().toDate();}
$scope.isNotCommonCategory=function(category){return category!=='Common';};}]);'use strict';angular.module('xlrelease').factory('ConfigurationTabsService',['TabsService',function(TabsService){return TabsService.withConfig({tabs:[],maxDisplayedTabs:4,defaultPage:"configuration"});}]);'use strict';angular.module('xlrelease').controller('releaseValueStreamController',['$scope','Backend','$location','PhasesService','filterSettings','ValueStreamMapping','ConfigurationItemService','Browser','ReleasesService',function($scope,Backend,$location,PhasesService,filterSettings,ValueStreamMapping,ConfigurationItemService,Browser,ReleasesService){$scope.filters=filterSettings;$scope.filters.completed=true;ReleasesService.getReleases($scope.filters).success(function(releases){$scope.releases=_.sortBy(releases,function(release){return release.endDate;}).reverse();});$scope.getDurationPercentage=function(release,phase){var ciDuration=ConfigurationItemService.getCIDuration(release);if(ciDuration===0){return 0;}
return Math.round((ConfigurationItemService.getCIDuration(phase)*100)/ciDuration);};$scope.displayReleaseEditor=ReleasesService.redirectToEditor;$scope.getLeafTasks=PhasesService.getLeafTasks;$scope.isCritical=ValueStreamMapping.isCritical;$scope.getWarningThreshold=ValueStreamMapping.getWarningThreshold;$scope.getErrorThreshold=ValueStreamMapping.getErrorThreshold;$scope.getCriticalPhasesCount=ValueStreamMapping.getCriticalPhasesCount;$scope.getCIDuration=ConfigurationItemService.getCIDuration;$scope.isIE8=Browser.isIE8;}]);angular.module('xlrelease').factory('ValueStreamMapping',['Backend',function(Backend){var settings={warningThreshold:undefined,errorThreshold:undefined,criticalPhaseThreshold:undefined};function refreshReportsSettings(){Backend.get('reports/settings').success(function(reportsSettings){settings.warningThreshold=reportsSettings.warningThreshold;settings.errorThreshold=reportsSettings.errorThreshold;settings.criticalPhaseThreshold=reportsSettings.criticalPhaseThreshold;});}
refreshReportsSettings();return{getWarningThreshold:function(){return settings.warningThreshold;},getErrorThreshold:function(){return settings.errorThreshold;},isCritical:function(phase){return phase.taskFlaggedCount+phase.taskFailureCount+phase.taskDelayCount>settings.criticalPhaseThreshold;},getCriticalPhasesCount:function(release){return _(release.phases).map(this.isCritical).compact().size();},refreshReportsSettings:refreshReportsSettings};}]);angular.module('xlrelease').directive('taskCounters',['ValueStreamMapping',function(ValueStreamMapping){return{templateUrl:'partials/value-stream-mapping/task-counters-directive.html',restrict:'A',scope:{flagsCount:'=',delaysCount:'=',failuresCount:'='},link:function(scope){scope.getWarningThreshold=ValueStreamMapping.getWarningThreshold;scope.getErrorThreshold=ValueStreamMapping.getErrorThreshold;}}}]);