import sys, string
import com.xhaus.jyson.JysonCodec as json

if jiraServer is None:
    print "No server provided."
    sys.exit(1)

jiraURL = jiraServer['url']
if jiraURL.endswith('/'):
    jiraURL = jiraURL[:len(jiraURL)-1]

restUrl = "/rest/api/2/"
issueUrl = restUrl + "issue/" + issueId

credentials = CredentialsFallback(jiraServer, username, password).getCredentials()

# Check for ticket
response = XLRequest(jiraURL + issueUrl, 'GET', '', credentials['username'], credentials['password'], 'application/json').send()

if response.status != 200:
    print "Error: unable to find issue " + issueId
    response.errorDump()
    sys.exit(1)


if newStatus != "":

    # Find possible transitions
    response = XLRequest(jiraURL + issueUrl + "/transitions", 'GET', '', credentials['username'], credentials['password'], 'application/json').send()

    if response.status != 200:
        print "Error: unable to find transitions for issue " + issueId
        response.errorDump()
        sys.exit(1)

    transitions = json.loads(response.read())['transitions']

    # Find transition

    wantedTransition = -1
    for transition in transitions:
        if transition['to']['name'].lower() == newStatus.lower():
            wantedTransition = transition['id']

    if wantedTransition == -1:
        print "Error: unable to find status " + newStatus + " for issue " + issueId
        sys.exit(1)


    # Perform transition

    transitionData = {
        "transition": {
            "id": wantedTransition
        }
    }

    if comment != "":
        transitionData["update"] = {
            "comment": [
                {
                    "add": {
                        "body": comment
                    }
                }
            ]
        }


    response = XLRequest(jiraURL + issueUrl + "/transitions", 'POST', json.dumps(transitionData), credentials['username'], credentials['password'], 'application/json').send()

    if response.status != 204:
        print "Error: unable to perform transition " + wantedTransition + " for issue " + issueId
        response.errorDump()
        sys.exit(1)


# Post comment

if newStatus == "" and comment != "":
    commentData = {
        "body": comment
    }

    response = XLRequest(jiraURL + issueUrl + "/comment", 'POST', json.dumps(commentData), credentials['username'], credentials['password'], 'application/json').send()

    if response.status != 201:
        print "Error: unable to post comment to issue " + issueId
        response.errorDump()
        sys.exit(1)

print "Updated " + issueId + " in JIRA at " + jiraURL
