@echo off
REM
REM Batch script to start the Deployit Server
REM

setlocal ENABLEDELAYEDEXPANSION

REM Get Java executable
if "%JAVA_HOME%"=="" (
  set JAVACMD=java
) else (
  set JAVACMD="%JAVA_HOME%\bin\java"
)

REM Get JVM options
if "%XL_RELEASE_SERVER_OPTS%"=="" (
  set XL_RELEASE_SERVER_OPTS=-Xmx1024m -XX:MaxPermSize=128m -Djava.awt.headless=true
)

REM Get logging-related options
if "%XL_RELEASE_SERVER_LOG_OPTS%"=="" (
  set XL_RELEASE_SERVER_LOG_OPTS=-Dlogback.configurationFile=conf\logback.xml -Dderby.stream.error.file=log\derby.log
)

REM Get security options
if "%XL_RELEASE_SERVER_SECURITY_OPTS%"=="" (
  set XL_RELEASE_SERVER_SECURITY_OPTS=-Djava.security.manager=java.lang.SecurityManager -Djava.security.policy=conf/xl-release.policy
)

REM Get Deployit server home dir
if "%XL_RELEASE_SERVER_HOME%"=="" (
  cd /d "%~dp0"
  cd ..
  set XL_RELEASE_SERVER_HOME=!CD!
)

cd /d "%XL_RELEASE_SERVER_HOME%"

REM Build Deployit server classpath
set XL_RELEASE_SERVER_CLASSPATH=conf;ext
for %%i in (hotfix\*.jar) do set XL_RELEASE_SERVER_CLASSPATH=!XL_RELEASE_SERVER_CLASSPATH!;%%i
for %%i in (lib\*.jar) do set XL_RELEASE_SERVER_CLASSPATH=!XL_RELEASE_SERVER_CLASSPATH!;%%i
for %%i in (plugins\*.jar) do set XL_RELEASE_SERVER_CLASSPATH=!XL_RELEASE_SERVER_CLASSPATH!;%%i
for /d %%i in (plugins\*) do set XL_RELEASE_SERVER_CLASSPATH=!XL_RELEASE_SERVER_CLASSPATH!;%%i

REM Run Deployit server
%JAVACMD% %XL_RELEASE_SERVER_OPTS% %XL_RELEASE_SERVER_SECURITY_OPTS% %XL_RELEASE_SERVER_LOG_OPTS% -cp "%XL_RELEASE_SERVER_CLASSPATH%" com.xebialabs.xlrelease.XLReleaseBootstrapper %*

:end
endlocal
