/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.auth.oidc.config;

import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.plumbing.authentication.RedirectToUrlSuccessHandler;
import com.xebialabs.deployit.security.UserService;
import com.xebialabs.platform.sso.oidc.authentication.CustomOidcIdTokenDecoderFactory;
import com.xebialabs.platform.sso.oidc.exceptions.UnsupportedOidcConfigurationException;
import com.xebialabs.platform.sso.oidc.policy.ClaimsToGrantedAuthoritiesPolicy;
import com.xebialabs.platform.sso.oidc.policy.impl.DefaultClaimsToGrantedAuthoritiesPolicy;
import com.xebialabs.platform.sso.oidc.policy.impl.GrantedAuthoritiesExtractor;
import com.xebialabs.platform.sso.oidc.web.CustomAuthorizationRequestResolver;
import com.xebialabs.platform.sso.oidc.web.OidcLogoutSuccessHandler;
import com.xebialabs.xlrelease.auth.oidc.policy.UserProfileCreationPolicy;
import com.xebialabs.xlrelease.auth.oidc.policy.impl.DefaultOidcUserProfileCreationPolicy;
import com.xebialabs.xlrelease.auth.oidc.service.XlrOidcUserService;
import com.xebialabs.xlrelease.auth.oidc.web.XlReleaseLoginFormFilter;
import com.xebialabs.xlrelease.auth.oidc.web.authentication.Http401LoginUrlAuthenticationEntryPoint;
import com.xebialabs.xlrelease.auth.oidc.web.handlers.OidcLoginFailureHandler;
import com.xebialabs.xlrelease.auth.oidc.web.handlers.XlReleaseLoginFailureHandler;
import com.xebialabs.xlrelease.security.IdentityProvider;
import com.xebialabs.xlrelease.service.UserProfileService;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URI;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.core.convert.converter.Converter;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.http.converter.FormHttpMessageConverter;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.oauth2.client.InMemoryOAuth2AuthorizedClientService;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientService;
import org.springframework.security.oauth2.client.endpoint.DefaultAuthorizationCodeTokenResponseClient;
import org.springframework.security.oauth2.client.http.OAuth2ErrorResponseErrorHandler;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.client.registration.ClientRegistrations;
import org.springframework.security.oauth2.client.registration.InMemoryClientRegistrationRepository;
import org.springframework.security.oauth2.client.web.AuthenticatedPrincipalOAuth2AuthorizedClientRepository;
import org.springframework.security.oauth2.client.web.OAuth2AuthorizationRequestResolver;
import org.springframework.security.oauth2.client.web.OAuth2AuthorizedClientRepository;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.ClientAuthenticationMethod;
import org.springframework.security.oauth2.core.DelegatingOAuth2TokenValidator;
import org.springframework.security.oauth2.core.OAuth2TokenValidator;
import org.springframework.security.oauth2.core.http.converter.OAuth2AccessTokenResponseHttpMessageConverter;
import org.springframework.security.oauth2.jose.jws.JwsAlgorithm;
import org.springframework.security.oauth2.jose.jws.MacAlgorithm;
import org.springframework.security.oauth2.jose.jws.SignatureAlgorithm;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.jwt.JwtClaimValidator;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.security.oauth2.jwt.JwtDecoderFactory;
import org.springframework.security.oauth2.jwt.JwtIssuerValidator;
import org.springframework.security.oauth2.jwt.JwtTimestampValidator;
import org.springframework.security.oauth2.jwt.NimbusJwtDecoder;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationConverter;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;
import org.springframework.security.web.authentication.session.SessionAuthenticationStrategy;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestOperations;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

@Configuration
@Profile(value={"oidcAuth"})
public class OpenIdConnectConfig {
    public static final String OIDC_LOGIN_PATH_NAME = "oauth2/authorization/xl-release";
    public static final String OIDC_LOGIN = "/".concat("oauth2/authorization/xl-release");
    public static final String OIDC_PROCESSING_URL = "/oidc-login";
    public static final String INTERNAL_USER_LOGIN_SUCCESS_URL = "#/login?reloadUserDetails";
    private static final Logger logger = LoggerFactory.getLogger(OpenIdConnectConfig.class);
    private static final String REGISTRATION_ID = "xl-release";
    @Value(value="${xl.security.auth.providers.oidc.clientId}")
    private String clientId;
    @Value(value="${xl.security.auth.providers.oidc.clientSecret}")
    private String clientSecret;
    @Value(value="${xl.security.auth.providers.oidc.clientAuthMethod:}")
    private String clientAuthMethod;
    @Value(value="${xl.security.auth.providers.oidc.issuer}")
    private String issuer;
    @Value(value="${xl.security.auth.providers.oidc.keyRetrievalUri:}")
    private String keyRetrievalUri;
    @Value(value="${xl.security.auth.providers.oidc.accessTokenUri:}")
    private String accessTokenUri;
    @Value(value="${xl.security.auth.providers.oidc.userAuthorizationUri:}")
    private String userAuthorizationUri;
    @Value(value="${xl.security.auth.providers.oidc.logoutUri:}")
    private String logoutUri;
    @Value(value="${xl.security.auth.providers.oidc.redirectUri}")
    private String redirectUri;
    @Value(value="${xl.security.auth.providers.oidc.postLogoutRedirectUri:}")
    private String postLogoutRedirectUri;
    @Value(value="${xl.security.auth.providers.oidc.rolesClaim}")
    private String rolesClaim;
    @Value(value="${xl.security.auth.providers.oidc.fullNameClaim}")
    private String fullNameClaim;
    @Value(value="${xl.security.auth.providers.oidc.userNameClaim}")
    private String userNameClaim;
    @Value(value="${xl.security.auth.providers.oidc.emailClaim}")
    private String emailClaim;
    @Value(value="${xl.security.auth.providers.oidc.scopes}")
    private String scopes;
    @Value(value="${xl.security.auth.providers.oidc.idTokenJWSAlg:}")
    private String idTokenJWSAlg;
    @Value(value="${xl.security.auth.providers.oidc.access-token.issuer:}")
    private String accessTokenIssuer;
    @Value(value="${xl.security.auth.providers.oidc.access-token.audience:}")
    private String accessTokenAudience;
    @Value(value="${xl.security.auth.providers.oidc.access-token.keyRetrievalUri:}")
    private String accessTokenKeyUri;
    @Value(value="${xl.security.auth.providers.oidc.access-token.jwsAlg:}")
    private String accessTokenJWSAlg;
    @Value(value="${xl.security.auth.providers.oidc.access-token.secretKey:}")
    private String accessTokenSecretKey;
    @Value(value="${xl.security.auth.providers.oidc.proxyHost:}")
    private String proxyHost;
    @Value(value="${xl.security.auth.providers.oidc.proxyPort:}")
    private Integer proxyPort;

    @Bean
    public IdentityProvider identityProvider() {
        return new IdentityProvider("oidc", String.format(".%s", OIDC_LOGIN), "./logout");
    }

    @Bean
    public InMemoryClientRegistrationRepository clientRegistrationRepository() {
        return new InMemoryClientRegistrationRepository(new ClientRegistration[]{this.clientRegistration()});
    }

    @Bean
    @Autowired
    public UserProfileCreationPolicy userProfileCreationPolicy(UserProfileService userProfileService, UserService userService) {
        return new DefaultOidcUserProfileCreationPolicy(userProfileService, userService, this.emailClaim, this.fullNameClaim);
    }

    @Bean
    public ClaimsToGrantedAuthoritiesPolicy claimsToGrantedAuthoritiesPolicy() {
        return new DefaultClaimsToGrantedAuthoritiesPolicy(this.rolesClaim);
    }

    @Bean
    @Autowired
    public OAuth2AuthorizationRequestResolver customAuthorizationRequestResolver(ClientRegistrationRepository clientRegistrationRepository) {
        return new CustomAuthorizationRequestResolver(clientRegistrationRepository, "/oauth2/authorization");
    }

    @Bean
    @Autowired
    public OAuth2AuthorizedClientService authorizedClientService(ClientRegistrationRepository clientRegistrationRepository) {
        return new InMemoryOAuth2AuthorizedClientService(clientRegistrationRepository);
    }

    @Bean
    @Autowired
    public XlrOidcUserService xlrOidcUserService(UserProfileCreationPolicy userProfileCreationPolicy, ClaimsToGrantedAuthoritiesPolicy claimsToGrantedAuthoritiesPolicy) {
        return new XlrOidcUserService(userProfileCreationPolicy, claimsToGrantedAuthoritiesPolicy);
    }

    @Bean
    @Autowired
    public OAuth2AuthorizedClientRepository authorizedClientRepository(OAuth2AuthorizedClientService authorizedClientService) {
        return new AuthenticatedPrincipalOAuth2AuthorizedClientRepository(authorizedClientService);
    }

    @Bean
    public Http401LoginUrlAuthenticationEntryPoint loginUrlAuthenticationEntryPoint() {
        return new Http401LoginUrlAuthenticationEntryPoint(OIDC_LOGIN);
    }

    @Bean
    public JwtDecoderFactory<ClientRegistration> idTokenDecoderFactory() {
        RestTemplate restTemplate = new RestTemplate();
        restTemplate.setRequestFactory(this.getClientHttpRequestFactory());
        JwsAlgorithm jwsAlgorithm = this.getJwsAlgorithm(this.idTokenJWSAlg, "idTokenJWSAlg");
        CustomOidcIdTokenDecoderFactory idTokenDecoderFactory = new CustomOidcIdTokenDecoderFactory();
        idTokenDecoderFactory.setJwsAlgorithmResolver(clientRegistration -> jwsAlgorithm);
        idTokenDecoderFactory.setRestOperations((RestOperations)restTemplate);
        return idTokenDecoderFactory;
    }

    @Bean
    public JwtDecoder jwtDecoder() {
        NimbusJwtDecoder jwtDecoder;
        JwsAlgorithm jwsAlgorithm = this.getJwsAlgorithm(this.accessTokenJWSAlg, "jwsAlg");
        if (SignatureAlgorithm.class.isAssignableFrom(jwsAlgorithm.getClass())) {
            String jwkSetUri = this.clientRegistration().getProviderDetails().getJwkSetUri();
            if (Strings.isNotBlank((String)this.accessTokenKeyUri)) {
                jwkSetUri = this.accessTokenKeyUri;
            }
            jwtDecoder = NimbusJwtDecoder.withJwkSetUri((String)jwkSetUri).jwsAlgorithm((SignatureAlgorithm)jwsAlgorithm).build();
        } else if (MacAlgorithm.class.isAssignableFrom(jwsAlgorithm.getClass())) {
            HashMap<MacAlgorithm, String> mappings = new HashMap<MacAlgorithm, String>();
            mappings.put(MacAlgorithm.HS256, "HmacSHA256");
            mappings.put(MacAlgorithm.HS384, "HmacSHA384");
            mappings.put(MacAlgorithm.HS512, "HmacSHA512");
            Checks.checkArgument((boolean)Strings.isNotBlank((String)this.accessTokenSecretKey), (String)this.getPlaceholderErrorMessage("xl.security.auth.providers.oidc.access-token.secretKey"), (Object[])new Object[0]);
            SecretKeySpec secretKeySpec = new SecretKeySpec(this.accessTokenSecretKey.getBytes(StandardCharsets.UTF_8), (String)mappings.get(jwsAlgorithm));
            jwtDecoder = NimbusJwtDecoder.withSecretKey((SecretKey)secretKeySpec).macAlgorithm((MacAlgorithm)jwsAlgorithm).build();
        } else {
            throw new UnsupportedOidcConfigurationException("Failed to find a Signature Verifier. Ensure you have configured a valid JWS Algorithm.");
        }
        OAuth2TokenValidator<Jwt> jwtValidator = this.getJwtOAuth2TokenValidator();
        jwtDecoder.setJwtValidator(jwtValidator);
        return jwtDecoder;
    }

    @Bean
    public JwtAuthenticationConverter jwtAuthenticationConverter() {
        JwtAuthenticationConverter jwtAuthenticationConverter = new JwtAuthenticationConverter();
        jwtAuthenticationConverter.setPrincipalClaimName(this.userNameClaim);
        jwtAuthenticationConverter.setJwtGrantedAuthoritiesConverter((Converter)new GrantedAuthoritiesExtractor(this.claimsToGrantedAuthoritiesPolicy()));
        return jwtAuthenticationConverter;
    }

    @Bean
    public DefaultAuthorizationCodeTokenResponseClient authorizationCodeTokenResponseClient() {
        RestTemplate restTemplate = new RestTemplate(Arrays.asList(new FormHttpMessageConverter(), new OAuth2AccessTokenResponseHttpMessageConverter()));
        restTemplate.setRequestFactory(this.getClientHttpRequestFactory());
        restTemplate.setErrorHandler((ResponseErrorHandler)new OAuth2ErrorResponseErrorHandler());
        DefaultAuthorizationCodeTokenResponseClient authorizationCodeTokenResponseClient = new DefaultAuthorizationCodeTokenResponseClient();
        authorizationCodeTokenResponseClient.setRestOperations((RestOperations)restTemplate);
        return authorizationCodeTokenResponseClient;
    }

    @Bean
    @Autowired
    public LogoutSuccessHandler xlrOidcLogoutSuccessHandler(ClientRegistrationRepository clientRegistrationRepository) {
        return new OidcLogoutSuccessHandler(clientRegistrationRepository, this.postLogoutRedirectUri, "login");
    }

    @Bean
    public OidcLoginFailureHandler oidcLoginFailureHandler() {
        return new OidcLoginFailureHandler();
    }

    @Bean
    public XlReleaseLoginFailureHandler xlreleaseLoginFailureHandler() {
        return new XlReleaseLoginFailureHandler();
    }

    @Bean
    @Autowired
    public XlReleaseLoginFormFilter xlReleaseLoginFormFilter(AuthenticationManager authenticationManager, SessionAuthenticationStrategy sessionAuthenticationStrategy) {
        XlReleaseLoginFormFilter filter = new XlReleaseLoginFormFilter(this.defaultOidcMustacheTemplateSettings());
        filter.setAuthenticationManager(authenticationManager);
        filter.setSessionAuthenticationStrategy(sessionAuthenticationStrategy);
        filter.setAuthenticationSuccessHandler((AuthenticationSuccessHandler)new RedirectToUrlSuccessHandler(INTERNAL_USER_LOGIN_SUCCESS_URL));
        filter.setAuthenticationFailureHandler(this.xlreleaseLoginFailureHandler());
        return filter;
    }

    public Map<String, String> defaultOidcMustacheTemplateSettings() {
        HashMap<String, String> scope = new HashMap<String, String>();
        scope.put("productLogo", "static/0/styles/img/digital-ai-release.svg");
        scope.put("productColor", "#498500");
        scope.put("productIcon", "static/0/styles/img/favicon.ico");
        scope.put("productName", "Digital.ai Release");
        return scope;
    }

    private ClientRegistration clientRegistration() {
        ClientRegistration.Builder clientRegistrationBuilder = this.getClientRegistrationBuilder();
        clientRegistrationBuilder.clientId(this.clientId).clientSecret(this.clientSecret).clientAuthenticationMethod(this.getClientAuthMethod()).authorizationGrantType(AuthorizationGrantType.AUTHORIZATION_CODE).redirectUriTemplate(this.getEncodedUriString(this.redirectUri)).userInfoUri("").scope((Collection)Stream.of(this.scopes.split(",")).collect(Collectors.toList())).userNameAttributeName(this.userNameClaim);
        if (Strings.isNotBlank((String)this.userAuthorizationUri)) {
            clientRegistrationBuilder.authorizationUri(this.getEncodedUriString(this.userAuthorizationUri));
        }
        if (Strings.isNotBlank((String)this.accessTokenUri)) {
            clientRegistrationBuilder.tokenUri(this.getDecodedUriString(this.accessTokenUri));
        }
        if (Strings.isNotBlank((String)this.keyRetrievalUri)) {
            clientRegistrationBuilder.jwkSetUri(this.getEncodedUriString(this.keyRetrievalUri));
        }
        ClientRegistration clientRegistration = clientRegistrationBuilder.build();
        Map configurationMetadata = clientRegistration.getProviderDetails().getConfigurationMetadata();
        HashMap<String, String> updatedConfigurationMetadata = new HashMap<String, String>(configurationMetadata);
        if (Strings.isNotBlank((String)this.logoutUri)) {
            updatedConfigurationMetadata.put("end_session_endpoint", this.getDecodedUriString(this.logoutUri));
        }
        updatedConfigurationMetadata.put("fullNameClaim", this.fullNameClaim);
        updatedConfigurationMetadata.put("emailClaim", this.emailClaim);
        updatedConfigurationMetadata.put("rolesClaim", this.rolesClaim);
        return ClientRegistration.withClientRegistration((ClientRegistration)clientRegistration).providerConfigurationMetadata(updatedConfigurationMetadata).build();
    }

    private ClientRegistration.Builder getClientRegistrationBuilder() {
        String decodedIssuer = this.getDecodedUriString(this.issuer);
        try {
            if (decodedIssuer.matches("\\S+")) {
                return ClientRegistrations.fromOidcIssuerLocation((String)decodedIssuer).registrationId(REGISTRATION_ID);
            }
            throw new UnsupportedOidcConfigurationException(String.format("Whitespace characters in issuer url [%s] is not supported. Recommendation is to avoid using spaces in URLs, and instead use hyphens to separate words.", decodedIssuer));
        }
        catch (IllegalArgumentException re) {
            logger.warn(String.format("Unable to resolve Configuration with the provided Issuer of [%s]", this.issuer));
            this.validateOidcConfiguration();
            return ClientRegistration.withRegistrationId((String)REGISTRATION_ID);
        }
        catch (UnsupportedOidcConfigurationException e) {
            logger.warn(e.getMessage());
            this.validateOidcConfiguration();
            return ClientRegistration.withRegistrationId((String)REGISTRATION_ID);
        }
    }

    private ClientHttpRequestFactory getClientHttpRequestFactory() {
        SimpleClientHttpRequestFactory requestFactory = new SimpleClientHttpRequestFactory();
        if (Strings.isNotEmpty((String)this.proxyHost)) {
            Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(this.proxyHost, (int)this.proxyPort));
            requestFactory.setProxy(proxy);
        }
        return requestFactory;
    }

    private JwsAlgorithm getJwsAlgorithm(String jwsAlgorithm, String propertyName) {
        HashMap<String, Object> jwsAlgorithms = new HashMap<String, Object>();
        jwsAlgorithms.putAll(EnumSet.allOf(SignatureAlgorithm.class).stream().collect(Collectors.toMap(SignatureAlgorithm::getName, x -> x)));
        jwsAlgorithms.putAll(EnumSet.allOf(MacAlgorithm.class).stream().collect(Collectors.toMap(MacAlgorithm::getName, x -> x)));
        if (Strings.isNotEmpty((String)jwsAlgorithm)) {
            if (jwsAlgorithms.containsKey(jwsAlgorithm)) {
                return (JwsAlgorithm)jwsAlgorithms.get(jwsAlgorithm);
            }
            throw new IllegalArgumentException(String.format("%s value [%s] is not supported. Ensure you have configured a valid JWS Algorithm.", propertyName, jwsAlgorithm));
        }
        return SignatureAlgorithm.RS256;
    }

    private ClientAuthenticationMethod getClientAuthMethod() {
        HashMap<String, ClientAuthenticationMethod> clientAuthMethods = new HashMap<String, ClientAuthenticationMethod>();
        clientAuthMethods.put("client_secret_basic", ClientAuthenticationMethod.BASIC);
        clientAuthMethods.put("client_secret_post", ClientAuthenticationMethod.POST);
        if (Strings.isNotEmpty((String)this.clientAuthMethod)) {
            String authMethod = this.clientAuthMethod.toLowerCase();
            if (clientAuthMethods.containsKey(authMethod)) {
                return (ClientAuthenticationMethod)clientAuthMethods.get(authMethod);
            }
            throw new IllegalArgumentException(String.format("clientAuthMethod value [%s] is not supported. Ensure you have configured a valid client authentication method.", this.clientAuthMethod));
        }
        return ClientAuthenticationMethod.POST;
    }

    private OAuth2TokenValidator<Jwt> getJwtOAuth2TokenValidator() {
        ArrayList<Object> validators = new ArrayList<Object>();
        validators.add(new JwtTimestampValidator());
        validators.add(new JwtIssuerValidator(Strings.isNotBlank((String)this.accessTokenIssuer) ? this.accessTokenIssuer : this.issuer));
        validators.add(new JwtClaimValidator("aud", aud -> aud.contains(Strings.isNotBlank((String)this.accessTokenAudience) ? this.accessTokenAudience : this.clientId)));
        return new DelegatingOAuth2TokenValidator(validators);
    }

    private String getEncodedUriString(String uri) {
        try {
            return URI.create(uri).toASCIIString();
        }
        catch (IllegalArgumentException e) {
            return UriComponentsBuilder.fromUriString((String)uri).build().toUri().toASCIIString();
        }
    }

    private String getDecodedUriString(String uri) {
        try {
            return URLDecoder.decode(uri, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(String.format("Cannot decode value [%s] with 'utf-8' charset", uri));
        }
    }

    private void validateOidcConfiguration() {
        Checks.checkArgument((boolean)Strings.isNotBlank((String)this.userAuthorizationUri), (String)this.getPlaceholderErrorMessage("xl.security.auth.providers.oidc.userAuthorizationUri"), (Object[])new Object[0]);
        Checks.checkArgument((boolean)Strings.isNotBlank((String)this.accessTokenUri), (String)this.getPlaceholderErrorMessage("xl.security.auth.providers.oidc.accessTokenUri"), (Object[])new Object[0]);
        Checks.checkArgument((boolean)Strings.isNotBlank((String)this.keyRetrievalUri), (String)this.getPlaceholderErrorMessage("xl.security.auth.providers.oidc.keyRetrievalUri"), (Object[])new Object[0]);
        Checks.checkArgument((boolean)Strings.isNotBlank((String)this.logoutUri), (String)this.getPlaceholderErrorMessage("xl.security.auth.providers.oidc.logoutUri"), (Object[])new Object[0]);
    }

    private String getPlaceholderErrorMessage(String placeholder) {
        return String.format("Could not resolve placeholder '%s' in value ${%s}", placeholder, placeholder);
    }
}

