/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.auth.oidc.policy.impl;

import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.security.UserService;
import com.xebialabs.xlrelease.auth.oidc.exceptions.InternalUserExistsException;
import com.xebialabs.xlrelease.auth.oidc.policy.UserProfileCreationPolicy;
import com.xebialabs.xlrelease.domain.UserProfile;
import com.xebialabs.xlrelease.service.UserProfileService;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultOidcUserProfileCreationPolicy
implements UserProfileCreationPolicy {
    private static final Logger logger = LoggerFactory.getLogger(DefaultOidcUserProfileCreationPolicy.class);
    private final String emailClaim;
    private final String fullNameClaim;
    private final String externalIdClaim;
    private final UserProfileService userProfileService;
    private final UserService userService;

    public DefaultOidcUserProfileCreationPolicy(UserProfileService userProfileService, UserService userService, String emailClaim, String fullNameClaim, String externalIdClaim) {
        this.userProfileService = userProfileService;
        this.userService = userService;
        this.emailClaim = emailClaim;
        this.fullNameClaim = fullNameClaim;
        this.externalIdClaim = externalIdClaim;
    }

    @Override
    public UserProfile createProfile(String userName, Map<String, Object> claims) throws InternalUserExistsException {
        try {
            this.userService.read(userName);
            throw new InternalUserExistsException(userName);
        }
        catch (NotFoundException e) {
            UserProfile profile = this.userProfileService.findByUsername(userName);
            if (profile != null) {
                return profile;
            }
            profile = Strings.isNotBlank((String)this.externalIdClaim) ? new UserProfile(userName, this.getString(this.emailClaim, claims), this.getString(this.fullNameClaim, claims), true, this.getString(this.externalIdClaim, claims)) : new UserProfile(userName, this.getString(this.emailClaim, claims), this.getString(this.fullNameClaim, claims), true);
            this.userProfileService.save(profile);
            return profile;
        }
    }

    protected String getString(String field, Map<String, Object> data) {
        String v = (String)data.get(field);
        if (v == null) {
            logger.warn("Did not receive {} field from OIDC provider", (Object)field);
            return "";
        }
        return v;
    }
}

