/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.auth.oidc.policy.impl;

import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.security.UserService;
import com.xebialabs.xlrelease.auth.oidc.exceptions.InternalUserExistsException;
import com.xebialabs.xlrelease.auth.oidc.policy.UserProfileCreationPolicy;
import com.xebialabs.xlrelease.domain.UserProfile;
import com.xebialabs.xlrelease.repository.CiCloneHelper;
import com.xebialabs.xlrelease.service.UserProfileService;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultOidcUserProfileCreationPolicy
implements UserProfileCreationPolicy {
    private static final Logger logger = LoggerFactory.getLogger(DefaultOidcUserProfileCreationPolicy.class);
    private final String emailClaim;
    private final String fullNameClaim;
    private final String externalIdClaim;
    private final UserProfileService userProfileService;
    private final UserService userService;

    public DefaultOidcUserProfileCreationPolicy(UserProfileService userProfileService, UserService userService, String emailClaim, String fullNameClaim, String externalIdClaim) {
        this.userProfileService = userProfileService;
        this.userService = userService;
        this.emailClaim = emailClaim;
        this.fullNameClaim = fullNameClaim;
        this.externalIdClaim = externalIdClaim;
    }

    @Override
    public UserProfile createProfile(String userName, Map<String, Object> claims) throws InternalUserExistsException {
        try {
            this.userService.read(userName);
            throw new InternalUserExistsException(userName);
        }
        catch (NotFoundException e) {
            UserProfile profile = this.userProfileService.findByUsername(userName);
            if (profile != null) {
                UserProfile original = (UserProfile)CiCloneHelper.cloneCi((ConfigurationItem)profile);
                this.setUserProfileProperties(profile, claims);
                if (UserProfileService.hasExternalPropertiesChanged((UserProfile)original, (UserProfile)profile)) {
                    this.userProfileService.updateProfile(new UserProfile[]{profile});
                }
            } else {
                profile = new UserProfile(userName);
                profile.setLoginAllowed(true);
                this.setUserProfileProperties(profile, claims);
                this.userProfileService.save(profile);
            }
            return profile;
        }
    }

    protected String getString(String field, Map<String, Object> data) {
        String v = (String)data.get(field);
        if (v == null) {
            logger.warn("Did not receive {} field from OIDC provider", (Object)field);
            return "";
        }
        return v;
    }

    private void setUserProfileProperties(UserProfile userProfile, Map<String, Object> claims) {
        String email = this.getString(this.emailClaim, claims);
        String fullName = this.getString(this.fullNameClaim, claims);
        if (Strings.isNotBlank((String)email)) {
            userProfile.setEmail(email);
        }
        if (Strings.isNotBlank((String)fullName)) {
            userProfile.setFullName(fullName);
        }
        if (Strings.isNotBlank((String)this.externalIdClaim)) {
            userProfile.setExternalId(this.getString(this.externalIdClaim, claims));
        }
    }
}

