package com.xebialabs.xlrelease.auth.oidc.web;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.springframework.http.HttpStatus;
import org.springframework.web.filter.GenericFilterBean;

public class BeforeLicenseCheckFilter extends GenericFilterBean {

	@Override
	public void doFilter(ServletRequest request, ServletResponse response,
	                     FilterChain chain) throws IOException, ServletException {
		if (response instanceof HttpServletResponse) {
			response = new RedirectResponseWrapper((HttpServletRequest)request, (HttpServletResponse)response);
		}
		chain.doFilter(request, response);
	}
	
	/**
	 * HttpServletResponseWrapper that replaces the 403 error response by redirect to product registration page.
	 */
	private class RedirectResponseWrapper extends HttpServletResponseWrapper {

        public static final String PRODUCT_REGISTRATION_PAGE = "productregistration";

        public RedirectResponseWrapper(HttpServletRequest request, HttpServletResponse response) {
            super(response);
		}

		@Override
		public void sendError(int sc, String msg) throws IOException {
            if (HttpStatus.PAYMENT_REQUIRED.value() == sc) {
                super.sendRedirect(PRODUCT_REGISTRATION_PAGE);
            } else {
                super.sendError(sc, msg);
            }
        }
	}
}
