package com.xebialabs.xlrelease.auth.oidc.web.handlers;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;

import static com.xebialabs.xlrelease.auth.oidc.web.XlReleaseLoginFormFilter.ERROR_PARAMETER_NAME;
import static com.xebialabs.xlrelease.auth.oidc.web.XlReleaseLoginFormFilter.LOGIN_PATH_NAME;

public class XlReleaseLoginFailureHandler implements AuthenticationFailureHandler {

    @Override
    public void onAuthenticationFailure(final HttpServletRequest request,
                                        final HttpServletResponse response,
                                        final AuthenticationException exception) throws IOException, ServletException {
        response.sendRedirect(LOGIN_PATH_NAME + "?" + ERROR_PARAMETER_NAME + "=" + exception.getMessage());
    }
}
