/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.internal;

import com.xebialabs.xlrelease.security.SessionService;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Profile;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.client.ClientAuthorizationException;
import org.springframework.security.oauth2.client.OAuth2AuthorizeRequest;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClient;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientManager;
import org.springframework.security.oauth2.core.OAuth2AccessToken;
import org.springframework.stereotype.Controller;

@Path(value="/oidc")
@Profile(value={"oidcAuth"})
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Controller
public class OidcTokenResource {
    private final OAuth2AuthorizedClientManager authorizedClientManager;
    private final SessionService sessionService;

    @Autowired
    public OidcTokenResource(OAuth2AuthorizedClientManager authorizedClientManager, SessionService sessionService) {
        this.authorizedClientManager = authorizedClientManager;
        this.sessionService = sessionService;
    }

    @GET
    @Path(value="token")
    public OAuth2AccessToken token(@Context HttpServletRequest servletRequest, @Context HttpServletResponse servletResponse) throws IOException {
        Authentication principal = SecurityContextHolder.getContextHolderStrategy().getContext().getAuthentication();
        OAuth2AuthorizeRequest authorizeRequest = OAuth2AuthorizeRequest.withClientRegistrationId((String)"xl-release").principal(principal).attribute(HttpServletRequest.class.getName(), (Object)servletRequest).attribute(HttpServletResponse.class.getName(), (Object)servletResponse).build();
        try {
            OAuth2AuthorizedClient authorizedClient = this.authorizedClientManager.authorize(authorizeRequest);
            return authorizedClient.getAccessToken();
        }
        catch (ClientAuthorizationException e) {
            String errorCode = e.getError().getErrorCode();
            if ("invalid_grant".equalsIgnoreCase(errorCode) || "invalid_token".equalsIgnoreCase(errorCode)) {
                this.sessionService.disconnect(principal.getName());
                servletResponse.sendRedirect("oauth2/authorization/xl-release");
            }
            throw e;
        }
    }
}

