/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.auth.oidc.web;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpServletResponseWrapper;
import java.io.IOException;
import org.springframework.http.HttpStatus;
import org.springframework.web.filter.GenericFilterBean;

public class BeforeLicenseCheckFilter
extends GenericFilterBean {
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (response instanceof HttpServletResponse) {
            response = new RedirectResponseWrapper((HttpServletRequest)request, (HttpServletResponse)response);
        }
        chain.doFilter(request, response);
    }

    private class RedirectResponseWrapper
    extends HttpServletResponseWrapper {
        public static final String PRODUCT_REGISTRATION_PAGE = "productregistration";

        public RedirectResponseWrapper(HttpServletRequest request, HttpServletResponse response) {
            super(response);
        }

        public void sendError(int sc, String msg) throws IOException {
            if (HttpStatus.PAYMENT_REQUIRED.value() == sc) {
                super.sendRedirect(PRODUCT_REGISTRATION_PAGE);
            } else {
                super.sendError(sc, msg);
            }
        }
    }
}

