/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.auth.oidc.web;

import com.xebialabs.platform.sso.oidc.policy.ClaimsToGrantedAuthoritiesPolicy;
import com.xebialabs.platform.sso.oidc.policy.ClaimsToUserNamePolicy;
import com.xebialabs.platform.sso.oidc.userdetails.OpenIdConnectUserDetails;
import com.xebialabs.platform.sso.oidc.web.OpenIdConnectFilter;
import com.xebialabs.xlrelease.auth.oidc.exceptions.InternalUserExistsException;
import com.xebialabs.xlrelease.auth.oidc.policy.UserProfileCreationPolicy;
import java.io.IOException;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.jwt.crypto.sign.SignatureVerifier;
import org.springframework.security.oauth2.client.OAuth2RestTemplate;

public class XlReleaseOpenIdConnectFilter
extends OpenIdConnectFilter {
    private static final Logger logger = LoggerFactory.getLogger(XlReleaseOpenIdConnectFilter.class);
    private final UserProfileCreationPolicy userProfileCreationPolicy;

    public XlReleaseOpenIdConnectFilter(String defaultFilterProcessesUrl, String clientId, String tokenIssuer, OAuth2RestTemplate restTemplate, SignatureVerifier signatureVerifier, ClaimsToUserNamePolicy claimsToUserNamePolicy, ClaimsToGrantedAuthoritiesPolicy claimsToGrantedAuthoritiesPolicy, UserProfileCreationPolicy userProfileCreationPolicy) {
        super(defaultFilterProcessesUrl, clientId, tokenIssuer, restTemplate, signatureVerifier, claimsToUserNamePolicy, claimsToGrantedAuthoritiesPolicy);
        this.userProfileCreationPolicy = userProfileCreationPolicy;
    }

    public Authentication attemptAuthentication(HttpServletRequest request, HttpServletResponse response) throws AuthenticationException, IOException, ServletException {
        try {
            Authentication auth = super.attemptAuthentication(request, response);
            String userName = auth.getName();
            OpenIdConnectUserDetails user = (OpenIdConnectUserDetails)auth.getDetails();
            Map claims = user.getClaims();
            logger.debug("Ensuring there is a UserProfile for {}", (Object)userName);
            this.userProfileCreationPolicy.createProfile(userName, claims);
            return auth;
        }
        catch (InternalUserExistsException e) {
            logger.warn("Unable to create profile for user [{}]. A local account exists.", (Object)e.getUserName());
            throw new BadCredentialsException(String.format("A local account exists for user %s", e.getUserName()), (Throwable)e);
        }
    }
}

