/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.auth.oidc.web;

import com.xebialabs.deployit.util.MustacheRenderer;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

public class XlReleaseLoginFormFilter
extends UsernamePasswordAuthenticationFilter {
    private static final String POST = "POST";
    private static final String GET = "GET";
    private static final String BLACKLIST_RESOURCE = "favicon.ico";
    public static final String ERROR_PARAMETER_NAME = "error";
    public static final String LOGIN_PATH_NAME = "login";
    private final RequestMatcher requiresAuthenticationRequestMatcher = new AntPathRequestMatcher("/login");
    private final Map<String, String> settings;
    private final Resource layout = new ClassPathResource("com/xebialabs/platform/sso/oidc/web/modal-layout.mustache");
    private final Resource content = new ClassPathResource("com/xebialabs/xlrelease/auth/oidc/web/login.mustache");

    public XlReleaseLoginFormFilter(Map<String, String> settings) {
        this.settings = settings;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws AuthenticationServiceException, IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        if (this.requiresAuthenticationRequestMatcher.matches(request)) {
            if (request.getMethod().equals(GET)) {
                HashMap<String, Resource> partials = new HashMap<String, Resource>();
                partials.put("content", this.content);
                HashMap<String, String> context = new HashMap<String, String>(this.settings);
                context.put(ERROR_PARAMETER_NAME, request.getParameter(ERROR_PARAMETER_NAME));
                MustacheRenderer mustacheRenderer = new MustacheRenderer(this.layout, partials, context);
                mustacheRenderer.render(response);
                return;
            } else {
                if (!request.getMethod().equals(POST)) throw new AuthenticationServiceException("Authentication method must be a POST or GET got: " + request.getMethod());
                super.doFilter((ServletRequest)request, (ServletResponse)response, chain);
            }
            return;
        } else {
            if (request.getRequestURI().contains(BLACKLIST_RESOURCE)) return;
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }
}

