/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.auth.oidc.config;

import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.plumbing.authentication.RedirectToUrlSuccessHandler;
import com.xebialabs.deployit.security.UserService;
import com.xebialabs.platform.sso.oidc.authentication.CustomOidcIdTokenDecoderFactory;
import com.xebialabs.platform.sso.oidc.policy.ClaimsToGrantedAuthoritiesPolicy;
import com.xebialabs.platform.sso.oidc.policy.impl.DefaultClaimsToGrantedAuthoritiesPolicy;
import com.xebialabs.platform.sso.oidc.web.CustomAuthorizationRequestResolver;
import com.xebialabs.platform.sso.oidc.web.OidcLogoutSuccessHandler;
import com.xebialabs.xlrelease.auth.oidc.policy.UserProfileCreationPolicy;
import com.xebialabs.xlrelease.auth.oidc.policy.impl.DefaultOidcUserProfileCreationPolicy;
import com.xebialabs.xlrelease.auth.oidc.service.XlrOidcUserService;
import com.xebialabs.xlrelease.auth.oidc.web.XlReleaseLoginFormFilter;
import com.xebialabs.xlrelease.auth.oidc.web.handlers.OidcLoginFailureHandler;
import com.xebialabs.xlrelease.auth.oidc.web.handlers.XlReleaseLoginFailureHandler;
import com.xebialabs.xlrelease.security.IdentityProvider;
import com.xebialabs.xlrelease.service.UserProfileService;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URI;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.http.converter.FormHttpMessageConverter;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.oauth2.client.InMemoryOAuth2AuthorizedClientService;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientService;
import org.springframework.security.oauth2.client.endpoint.DefaultAuthorizationCodeTokenResponseClient;
import org.springframework.security.oauth2.client.http.OAuth2ErrorResponseErrorHandler;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.client.registration.InMemoryClientRegistrationRepository;
import org.springframework.security.oauth2.client.web.AuthenticatedPrincipalOAuth2AuthorizedClientRepository;
import org.springframework.security.oauth2.client.web.OAuth2AuthorizationRequestResolver;
import org.springframework.security.oauth2.client.web.OAuth2AuthorizedClientRepository;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.ClientAuthenticationMethod;
import org.springframework.security.oauth2.core.http.converter.OAuth2AccessTokenResponseHttpMessageConverter;
import org.springframework.security.oauth2.jose.jws.JwsAlgorithm;
import org.springframework.security.oauth2.jose.jws.MacAlgorithm;
import org.springframework.security.oauth2.jose.jws.SignatureAlgorithm;
import org.springframework.security.oauth2.jwt.JwtDecoderFactory;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.LoginUrlAuthenticationEntryPoint;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;
import org.springframework.security.web.authentication.session.SessionAuthenticationStrategy;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestOperations;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

@Configuration
public class OpenIdConnectConfig {
    public static final String OIDC_LOGIN = "/oauth2/authorization/xl-release";
    public static final String OIDC_PROCESSING_URL = "/oidc-login";
    public static final String INTERNAL_USER_LOGIN_SUCCESS_URL = "#/login?reloadUserDetails";
    @Value(value="${xl.security.auth.providers.oidc.clientId}")
    private String clientId;
    @Value(value="${xl.security.auth.providers.oidc.clientSecret}")
    private String clientSecret;
    @Value(value="${xl.security.auth.providers.oidc.issuer}")
    private String issuer;
    @Value(value="${xl.security.auth.providers.oidc.keyRetrievalUri}")
    private String keyRetrievalUri;
    @Value(value="${xl.security.auth.providers.oidc.accessTokenUri}")
    private String accessTokenUri;
    @Value(value="${xl.security.auth.providers.oidc.userAuthorizationUri}")
    private String userAuthorizationUri;
    @Value(value="${xl.security.auth.providers.oidc.logoutUri}")
    private String logoutUri;
    @Value(value="${xl.security.auth.providers.oidc.redirectUri}")
    private String redirectUri;
    @Value(value="${xl.security.auth.providers.oidc.postLogoutRedirectUri:}")
    private String postLogoutRedirectUri;
    @Value(value="${xl.security.auth.providers.oidc.rolesClaim}")
    private String rolesClaim;
    @Value(value="${xl.security.auth.providers.oidc.fullNameClaim}")
    private String fullNameClaim;
    @Value(value="${xl.security.auth.providers.oidc.userNameClaim}")
    private String userNameClaim;
    @Value(value="${xl.security.auth.providers.oidc.emailClaim}")
    private String emailClaim;
    @Value(value="${xl.security.auth.providers.oidc.scopes}")
    private String scopes;
    @Value(value="${xl.security.auth.providers.oidc.idTokenJWSAlg:}")
    private String idTokenJWSAlg;
    @Value(value="${xl.security.auth.providers.oidc.proxyHost:}")
    private String proxyHost;
    @Value(value="${xl.security.auth.providers.oidc.proxyPort:}")
    private Integer proxyPort;

    @Bean
    public IdentityProvider identityProvider() {
        return new IdentityProvider("oidc", String.format(".%s", OIDC_LOGIN), "./logout");
    }

    @Bean
    public InMemoryClientRegistrationRepository clientRegistrationRepository() {
        return new InMemoryClientRegistrationRepository(new ClientRegistration[]{this.clientRegistration()});
    }

    @Bean
    @Autowired
    public UserProfileCreationPolicy userProfileCreationPolicy(UserProfileService userProfileService, UserService userService) {
        return new DefaultOidcUserProfileCreationPolicy(userProfileService, userService, this.emailClaim, this.fullNameClaim);
    }

    @Bean
    public ClaimsToGrantedAuthoritiesPolicy claimsToGrantedAuthoritiesPolicy() {
        return new DefaultClaimsToGrantedAuthoritiesPolicy(this.rolesClaim);
    }

    @Bean
    @Autowired
    public OAuth2AuthorizationRequestResolver customAuthorizationRequestResolver(ClientRegistrationRepository clientRegistrationRepository) {
        return new CustomAuthorizationRequestResolver(clientRegistrationRepository, "/oauth2/authorization");
    }

    @Bean
    @Autowired
    public OAuth2AuthorizedClientService authorizedClientService(ClientRegistrationRepository clientRegistrationRepository) {
        return new InMemoryOAuth2AuthorizedClientService(clientRegistrationRepository);
    }

    @Bean
    @Autowired
    public XlrOidcUserService xlrOidcUserService(UserProfileCreationPolicy userProfileCreationPolicy, ClaimsToGrantedAuthoritiesPolicy claimsToGrantedAuthoritiesPolicy) {
        return new XlrOidcUserService(userProfileCreationPolicy, claimsToGrantedAuthoritiesPolicy);
    }

    @Bean
    @Autowired
    public OAuth2AuthorizedClientRepository authorizedClientRepository(OAuth2AuthorizedClientService authorizedClientService) {
        return new AuthenticatedPrincipalOAuth2AuthorizedClientRepository(authorizedClientService);
    }

    @Bean
    public LoginUrlAuthenticationEntryPoint loginUrlAuthenticationEntryPoint() {
        return new LoginUrlAuthenticationEntryPoint(OIDC_LOGIN);
    }

    @Bean
    public JwtDecoderFactory<ClientRegistration> idTokenDecoderFactory() {
        RestTemplate restTemplate = new RestTemplate();
        restTemplate.setRequestFactory(this.getClientHttpRequestFactory());
        JwsAlgorithm jwsAlgorithm = this.getJwsAlgorithm();
        CustomOidcIdTokenDecoderFactory idTokenDecoderFactory = new CustomOidcIdTokenDecoderFactory();
        idTokenDecoderFactory.setJwsAlgorithmResolver(clientRegistration -> jwsAlgorithm);
        idTokenDecoderFactory.setRestOperations((RestOperations)restTemplate);
        return idTokenDecoderFactory;
    }

    @Bean
    public DefaultAuthorizationCodeTokenResponseClient authorizationCodeTokenResponseClient() {
        RestTemplate restTemplate = new RestTemplate(Arrays.asList(new FormHttpMessageConverter(), new OAuth2AccessTokenResponseHttpMessageConverter()));
        restTemplate.setRequestFactory(this.getClientHttpRequestFactory());
        restTemplate.setErrorHandler((ResponseErrorHandler)new OAuth2ErrorResponseErrorHandler());
        DefaultAuthorizationCodeTokenResponseClient authorizationCodeTokenResponseClient = new DefaultAuthorizationCodeTokenResponseClient();
        authorizationCodeTokenResponseClient.setRestOperations((RestOperations)restTemplate);
        return authorizationCodeTokenResponseClient;
    }

    @Bean
    @Autowired
    public LogoutSuccessHandler xlrOidcLogoutSuccessHandler(ClientRegistrationRepository clientRegistrationRepository) {
        return new OidcLogoutSuccessHandler(clientRegistrationRepository, this.postLogoutRedirectUri, "login");
    }

    @Bean
    public OidcLoginFailureHandler oidcLoginFailureHandler() {
        return new OidcLoginFailureHandler();
    }

    @Bean
    public XlReleaseLoginFailureHandler xlreleaseLoginFailureHandler() {
        return new XlReleaseLoginFailureHandler();
    }

    @Bean
    @Autowired
    public XlReleaseLoginFormFilter xlReleaseLoginFormFilter(AuthenticationManager authenticationManager, SessionAuthenticationStrategy sessionAuthenticationStrategy) {
        XlReleaseLoginFormFilter filter = new XlReleaseLoginFormFilter(this.defaultOidcMustacheTemplateSettings());
        filter.setAuthenticationManager(authenticationManager);
        filter.setSessionAuthenticationStrategy(sessionAuthenticationStrategy);
        filter.setAuthenticationSuccessHandler((AuthenticationSuccessHandler)new RedirectToUrlSuccessHandler(INTERNAL_USER_LOGIN_SUCCESS_URL));
        filter.setAuthenticationFailureHandler(this.xlreleaseLoginFailureHandler());
        return filter;
    }

    public Map<String, String> defaultOidcMustacheTemplateSettings() {
        HashMap<String, String> scope = new HashMap<String, String>();
        scope.put("productLogo", "static/0/styles/img/digital-ai-release.svg");
        scope.put("productColor", "#498500");
        scope.put("productIcon", "static/0/styles/img/favicon.ico");
        scope.put("productName", "Digital.ai Release");
        return scope;
    }

    private ClientRegistration clientRegistration() {
        ClientRegistration clientRegistration = ClientRegistration.withRegistrationId((String)"xl-release").clientId(this.clientId).clientSecret(this.clientSecret).clientAuthenticationMethod(ClientAuthenticationMethod.POST).authorizationGrantType(AuthorizationGrantType.AUTHORIZATION_CODE).redirectUriTemplate(this.getEncodedUriString(this.redirectUri)).scope((Collection)Stream.of(this.scopes.split(",")).collect(Collectors.toList())).authorizationUri(this.getEncodedUriString(this.userAuthorizationUri)).tokenUri(this.getDecodedUriString(this.accessTokenUri)).jwkSetUri(this.getEncodedUriString(this.keyRetrievalUri)).userNameAttributeName(this.userNameClaim).build();
        Map configurationMetadata = clientRegistration.getProviderDetails().getConfigurationMetadata();
        HashMap<String, String> updatedConfigurationMetadata = new HashMap<String, String>(configurationMetadata);
        updatedConfigurationMetadata.put("end_session_endpoint", this.getDecodedUriString(this.logoutUri));
        updatedConfigurationMetadata.put("fullNameClaim", this.fullNameClaim);
        updatedConfigurationMetadata.put("emailClaim", this.emailClaim);
        updatedConfigurationMetadata.put("rolesClaim", this.rolesClaim);
        return ClientRegistration.withClientRegistration((ClientRegistration)clientRegistration).providerConfigurationMetadata(updatedConfigurationMetadata).build();
    }

    private ClientHttpRequestFactory getClientHttpRequestFactory() {
        SimpleClientHttpRequestFactory requestFactory = new SimpleClientHttpRequestFactory();
        if (Strings.isNotEmpty((String)this.proxyHost)) {
            Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(this.proxyHost, (int)this.proxyPort));
            requestFactory.setProxy(proxy);
        }
        return requestFactory;
    }

    private JwsAlgorithm getJwsAlgorithm() {
        HashMap<String, Object> jwsAlgorithms = new HashMap<String, Object>();
        jwsAlgorithms.putAll(EnumSet.allOf(SignatureAlgorithm.class).stream().collect(Collectors.toMap(SignatureAlgorithm::getName, x -> x)));
        jwsAlgorithms.putAll(EnumSet.allOf(MacAlgorithm.class).stream().collect(Collectors.toMap(MacAlgorithm::getName, x -> x)));
        if (Strings.isNotEmpty((String)this.idTokenJWSAlg)) {
            if (jwsAlgorithms.containsKey(this.idTokenJWSAlg)) {
                return (JwsAlgorithm)jwsAlgorithms.get(this.idTokenJWSAlg);
            }
            throw new IllegalArgumentException(String.format("idTokenJWSAlg value [%s] is not supported. Ensure you have configured a valid JWS Algorithm.", this.idTokenJWSAlg));
        }
        return SignatureAlgorithm.RS256;
    }

    private String getEncodedUriString(String uri) {
        try {
            return URI.create(uri).toASCIIString();
        }
        catch (IllegalArgumentException e) {
            return UriComponentsBuilder.fromUriString((String)uri).build().toUri().toASCIIString();
        }
    }

    private String getDecodedUriString(String uri) {
        try {
            return URLDecoder.decode(uri, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(String.format("Cannot decode value [%s] with 'utf-8' charset", uri));
        }
    }
}

