/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.auth.oidc.web;

import com.samskivert.mustache.Mustache;
import com.samskivert.mustache.Template;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashMap;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.web.filter.GenericFilterBean;

public class OpenIdConnectRetainAnchorFilter
extends GenericFilterBean {
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (response instanceof HttpServletResponse) {
            response = new RedirectResponseWrapper((HttpServletRequest)request, (HttpServletResponse)response);
        }
        chain.doFilter(request, response);
    }

    private class RedirectResponseWrapper
    extends HttpServletResponseWrapper {
        public static final String OPENID_CONNECT_RETAINED_ANCHOR = "XL_RELEASE_OPENID_CONNECT_RETAINED_ANCHOR";
        private final Resource restoreAnchorRedirectPageResource;
        private final Resource storeAnchorRedirectPageResource;
        private final Mustache.Compiler compiler;
        private final HttpServletRequest request;
        private final AntPathRequestMatcher oidcLoginMatcher;
        private final AntPathRequestMatcher oidcLoginSuccessMatcher;

        public RedirectResponseWrapper(HttpServletRequest request, HttpServletResponse response) {
            super(response);
            this.request = request;
            this.compiler = Mustache.compiler().escapeHTML(false).emptyStringIsFalse(true).defaultValue("");
            this.restoreAnchorRedirectPageResource = new ClassPathResource("com/xebialabs/xlrelease/auth/oidc/web/restore-anchor-redirect-page.mustache");
            this.storeAnchorRedirectPageResource = new ClassPathResource("com/xebialabs/xlrelease/auth/oidc/web/store-anchor-redirect-page.mustache");
            this.oidcLoginMatcher = new AntPathRequestMatcher("/oauth2/authorization/xl-release");
            this.oidcLoginSuccessMatcher = new AntPathRequestMatcher("/oidc-login");
        }

        public void sendRedirect(String location) throws IOException {
            if (this.oidcLoginMatcher.matches(this.request) && !this.requestHasAuthorizationParameters()) {
                this.renderTemplate(location, this.storeAnchorRedirectPageResource);
                return;
            }
            if (this.oidcLoginSuccessMatcher.matches(this.request) && this.requestHasAuthorizationParameters() && this.hasCookie(OPENID_CONNECT_RETAINED_ANCHOR)) {
                this.renderTemplate(location, this.restoreAnchorRedirectPageResource);
                return;
            }
            super.sendRedirect(location);
        }

        private boolean requestHasAuthorizationParameters() {
            return this.request.getParameter("state") != null && this.request.getParameter("code") != null;
        }

        private void renderTemplate(String location, Resource resource) throws IOException {
            HttpServletResponse response = (HttpServletResponse)this.getResponse();
            Template template = this.compiler.compile((Reader)new InputStreamReader(resource.getInputStream()));
            HashMap<String, String> scope = new HashMap<String, String>();
            scope.put("location", location);
            scope.put("cookieName", OPENID_CONNECT_RETAINED_ANCHOR);
            PrintWriter writer = response.getWriter();
            response.setContentType("text/html;charset=UTF-8");
            template.execute(scope, (Writer)writer);
        }

        private boolean hasCookie(String cookieName) {
            if (this.request.getCookies() != null) {
                return !Arrays.stream(this.request.getCookies()).filter(c -> c.getName().equals(cookieName)).findFirst().map(Cookie::getValue).orElse("").isEmpty();
            }
            return false;
        }
    }
}

